/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.type;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.sql.parser.type.ExtendedSqlType;

public class SqlTimestampType
extends SqlIdentifier
implements ExtendedSqlType {
    private final int precision;
    private final boolean withLocalTimeZone;

    public SqlTimestampType(SqlParserPos pos, int precision, boolean withLocalTimeZone) {
        super(SqlTimestampType.getTypeName(withLocalTimeZone), pos);
        this.precision = precision;
        this.withLocalTimeZone = withLocalTimeZone;
    }

    private static String getTypeName(boolean withLocalTimeZone) {
        if (withLocalTimeZone) {
            return SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE.name();
        }
        return SqlTypeName.TIMESTAMP.name();
    }

    public SqlTypeName getSqlTypeName() {
        if (this.withLocalTimeZone) {
            return SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
        }
        return SqlTypeName.TIMESTAMP;
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(SqlTypeName.TIMESTAMP.name());
        if (this.precision >= 0) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
            writer.print(this.precision);
            writer.endList(frame);
        }
        if (this.withLocalTimeZone) {
            writer.keyword("WITH LOCAL TIME ZONE");
        }
    }
}

