/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001=\u0011qc\u0012:pkB\fum\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!b\u0001\n\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0016\u0003m\u0002\"A\u000b\u001f\n\u0005uZ#!H$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d$v]\u000e$\u0018n\u001c8\t\u0011}\u0002!\u0011!Q\u0001\nm\n\u0001cZ3o\u0003\u001e<'/Z4bi&|gn\u001d\u0011\t\u0011\u0005\u0003!Q1A\u0005\n\t\u000bA#Y4he\u0016<\u0017\r^5p]N#\u0018\r^3UsB,W#A\"\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015!\u0003;za\u0016,H/\u001b7t\u0015\tA\u0015*\u0001\u0003kCZ\f'B\u0001&\t\u0003\r\t\u0007/[\u0005\u0003\u0019\u0016\u00131BU8x)f\u0004X-\u00138g_\"Aa\n\u0001B\u0001B\u0003%1)A\u000bbO\u001e\u0014XmZ1uS>t7\u000b^1uKRK\b/\u001a\u0011\t\u0011A\u0003!Q1A\u0005\nE\u000b!cZ3oKJ\fG/\u001a*fiJ\f7\r^5p]V\t!\u000b\u0005\u0002\u001c'&\u0011A\u000b\b\u0002\b\u0005>|G.Z1o\u0011!1\u0006A!A!\u0002\u0013\u0011\u0016aE4f]\u0016\u0014\u0018\r^3SKR\u0014\u0018m\u0019;j_:\u0004\u0003\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011B-\u0002\u0017E,XM]=D_:4\u0017nZ\u000b\u00025B\u00111,X\u0007\u00029*\u0011!JB\u0005\u0003=r\u0013\u0011c\u0015;sK\u0006l\u0017+^3ss\u000e{gNZ5h\u0011!\u0001\u0007A!A!\u0002\u0013Q\u0016\u0001D9vKJL8i\u001c8gS\u001e\u0004\u0003\"\u00022\u0001\t\u0003\u0019\u0017A\u0002\u001fj]&$h\bF\u0003eK\u001a<\u0007\u000eE\u0002\u0013\u0001UAQ!O1A\u0002mBQ!Q1A\u0002\rCQ\u0001U1A\u0002ICQ\u0001W1A\u0002iC\u0011B\u001b\u0001A\u0002\u0003\u0007I\u0011B6\u0002\u0011\u0019,hn\u0019;j_:,\u0012a\f\u0005\n[\u0002\u0001\r\u00111A\u0005\n9\fABZ;oGRLwN\\0%KF$\"a\u001c:\u0011\u0005m\u0001\u0018BA9\u001d\u0005\u0011)f.\u001b;\t\u000fMd\u0017\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\t\rU\u0004\u0001\u0015)\u00030\u0003%1WO\\2uS>t\u0007\u0005C\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\u00061a.Z<S_^,\u0012a\t\u0005\nu\u0002\u0001\r\u00111A\u0005\nm\f!B\\3x%><x\fJ3r)\tyG\u0010C\u0004ts\u0006\u0005\t\u0019A\u0012\t\ry\u0004\u0001\u0015)\u0003$\u0003\u001dqWm\u001e*po\u0002B!\"!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003y\u0003\u001d\u0001(/\u001a<S_^D1\"!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\b\u0005Y\u0001O]3w%><x\fJ3r)\ry\u0017\u0011\u0002\u0005\tg\u0006\r\u0011\u0011!a\u0001G!9\u0011Q\u0002\u0001!B\u0013\u0019\u0013\u0001\u00039sKZ\u0014vn\u001e\u0011\t\u0015\u0005E\u0001\u00011AA\u0002\u0013%\u0011+\u0001\u0005gSJ\u001cHOU8x\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!a\u0006\u0002\u0019\u0019L'o\u001d;S_^|F%Z9\u0015\u0007=\fI\u0002\u0003\u0005t\u0003'\t\t\u00111\u0001S\u0011\u001d\ti\u0002\u0001Q!\nI\u000b\u0011BZ5sgR\u0014vn\u001e\u0011\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013%\u00111E\u0001\u0006gR\fG/Z\u000b\u0003\u0003K\u0001b!a\n\u00020\u0005MRBAA\u0015\u0015\u0011\t\t#a\u000b\u000b\u0007\u00055\u0012*\u0001\u0004d_6lwN\\\u0005\u0005\u0003c\tIC\u0001\u0006WC2,Xm\u0015;bi\u0016\u0004B!!\u000e\u0002:5\u0011\u0011q\u0007\u0006\u0003M!IA!a\u000f\u00028\t\u0019!k\\<\t\u0017\u0005}\u0002\u00011AA\u0002\u0013%\u0011\u0011I\u0001\ngR\fG/Z0%KF$2a\\A\"\u0011%\u0019\u0018QHA\u0001\u0002\u0004\t)\u0003\u0003\u0005\u0002H\u0001\u0001\u000b\u0015BA\u0013\u0003\u0019\u0019H/\u0019;fA!Y\u00111\n\u0001A\u0002\u0003\u0007I\u0011BA'\u0003!\u0019g\u000e^*uCR,WCAA(!\u0019\t9#a\f\u0002RA!\u00111KA.\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013\u0001\u00027b]\u001eT\u0011\u0001S\u0005\u0005\u0003;\n)F\u0001\u0003M_:<\u0007bCA1\u0001\u0001\u0007\t\u0019!C\u0005\u0003G\nAb\u00198u'R\fG/Z0%KF$2a\\A3\u0011%\u0019\u0018qLA\u0001\u0002\u0004\ty\u0005\u0003\u0005\u0002j\u0001\u0001\u000b\u0015BA(\u0003%\u0019g\u000e^*uCR,\u0007\u0005C\u0004\u0002n\u0001!\t%a\u001c\u0002\t=\u0004XM\u001c\u000b\u0004_\u0006E\u0004\u0002CA:\u0003W\u0002\r!!\u001e\u0002\r\r|gNZ5h!\u0011\t9(! \u000e\u0005\u0005e$bAA>\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!a \u0002z\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!a!\u0001\t\u0003\n))\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000f=\f9)a#\u0002(\"9\u0011\u0011RAA\u0001\u0004\u0019\u0013AB5oaV$8\t\u0003\u0005\u0002\u000e\u0006\u0005\u0005\u0019AAH\u0003\r\u0019G\u000f\u001f\t\u0005\u0003#\u000b\u0019\u000bE\u0004\u0002\u0014\u0006}UcI\u0012\u000e\u0005\u0005U%\u0002BAL\u00033\u000b\u0011BZ;oGRLwN\\:\u000b\u0007)\u000bYJC\u0002\u0002\u001e\"\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\t\u0005\u0005\u0016Q\u0013\u0002\u0015\u0017\u0016LX\r\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\n\t\u0005\u0015\u0016q\u0014\u0002\b\u0007>tG/\u001a=u\u0011!\tI+!!A\u0002\u0005-\u0016aA8viB)\u0011QVAYG5\u0011\u0011q\u0016\u0006\u0003k!IA!a-\u00020\nI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0003o\u0003A\u0011IA]\u0003\u001dyg\u000eV5nKJ$ra\\A^\u0003\u0007\fY\r\u0003\u0005\u0002>\u0006U\u0006\u0019AA`\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002\u001c\u0003\u0003L1!!\u0018\u001d\u0011!\ti)!.A\u0002\u0005\u0015\u0007\u0003BAI\u0003\u000fLA!!3\u0002 \nqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b\u0002CAU\u0003k\u0003\r!a+\t\u000f\u0005=\u0007\u0001\"\u0011\u0002R\u0006)1\r\\8tKR\tq\u000e")
public class GroupAggProcessFunction<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final boolean generateRetraction;
    private final StreamQueryConfig queryConfig;
    private GeneratedAggregations function;
    private CRow newRow;
    private CRow prevRow;
    private boolean firstRow;
    private ValueState<Row> state;
    private ValueState<Long> cntState;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        GroupAggProcessFunction groupAggProcessFunction = this;
        synchronized (groupAggProcessFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private RowTypeInfo aggregationStateType() {
        return this.aggregationStateType;
    }

    private boolean generateRetraction() {
        return this.generateRetraction;
    }

    private StreamQueryConfig queryConfig() {
        return this.queryConfig;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    private CRow newRow() {
        return this.newRow;
    }

    private void newRow_$eq(CRow x$1) {
        this.newRow = x$1;
    }

    private CRow prevRow() {
        return this.prevRow;
    }

    private void prevRow_$eq(CRow x$1) {
        this.prevRow = x$1;
    }

    private boolean firstRow() {
        return this.firstRow;
    }

    private void firstRow_$eq(boolean x$1) {
        this.firstRow = x$1;
    }

    private ValueState<Row> state() {
        return this.state;
    }

    private void state_$eq(ValueState<Row> x$1) {
        this.state = x$1;
    }

    private ValueState<Long> cntState() {
        return this.cntState;
    }

    private void cntState_$eq(ValueState<Long> x$1) {
        this.cntState = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.newRow_$eq(new CRow(this.function().createOutputRow(), true));
        this.prevRow_$eq(new CRow(this.function().createOutputRow(), false));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("GroupAggregateState", (TypeInformation)this.aggregationStateType());
        this.state_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        ValueStateDescriptor inputCntDescriptor = new ValueStateDescriptor("GroupAggregateInputCounter", Types.LONG());
        this.cntState_$eq((ValueState<Long>)this.getRuntimeContext().getState(inputCntDescriptor));
        this.initCleanupTimeState("GroupAggregateCleanupTime");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        Row input = inputC.row();
        Row accumulators = (Row)this.state().value();
        Long inputCnt = (Long)this.cntState().value();
        if (accumulators == null) {
            if (!inputC.change()) return;
            this.firstRow_$eq(true);
            accumulators = this.function().createAccumulators();
        } else {
            this.firstRow_$eq(false);
        }
        if (inputCnt == null) {
            inputCnt = Predef$.MODULE$.long2Long(0L);
        }
        this.function().setForwardedFields(input, this.newRow().row());
        this.function().setForwardedFields(input, this.prevRow().row());
        this.function().setAggregationResults(accumulators, this.prevRow().row());
        if (inputC.change()) {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) + 1L);
            this.function().accumulate(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        } else {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) - 1L);
            this.function().retract(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        }
        if (BoxesRunTime.equalsNumObject((Number)inputCnt, (Object)BoxesRunTime.boxToInteger((int)0))) {
            out.collect((Object)this.prevRow());
            this.state().clear();
            this.cntState().clear();
            return;
        } else {
            this.state().update((Object)accumulators);
            this.cntState().update((Object)inputCnt);
            if (!this.firstRow()) {
                if (this.prevRow().row().equals((Object)this.newRow().row()) && !this.stateCleaningEnabled()) {
                    return;
                }
                if (this.generateRetraction()) {
                    out.collect((Object)this.prevRow());
                }
            }
            out.collect((Object)this.newRow());
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.stateCleaningEnabled()) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.state(), this.cntState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        this.function().close();
    }

    public GroupAggProcessFunction(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, boolean generateRetraction, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.generateRetraction = generateRetraction;
        this.queryConfig = queryConfig;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
    }
}

