/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.SimpleTimerService;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.runtime.types.CRow;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Internal
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!B\u0001\u0003\u0003\u0003y!\u0001\f\"bg\u0016$vo\\%oaV$8\u000b\u001e:fC6|\u0005/\u001a:bi>\u0014x+\u001b;i'R\fG/\u001a*fi\u0016tG/[8o\u0015\t\u0019A!\u0001\u0003k_&t'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!\u0001\u001a\u0003cA\t\u001955\t!C\u0003\u0002\u0014)\u0005Iq\u000e]3sCR|'o\u001d\u0006\u0003+Y\t1!\u00199j\u0015\t9\u0002\"A\u0005tiJ,\u0017-\\5oO&\u0011\u0011D\u0005\u0002\u0017\u0003\n\u001cHO]1diN#(/Z1n\u001fB,'/\u0019;peB\u00111DH\u0007\u00029)\u0011Q\u0004B\u0001\u0006if\u0004Xm]\u0005\u0003?q\u0011Aa\u0011*poB)\u0011#\t\u000e\u001b5%\u0011!E\u0005\u0002\u0017)^|\u0017J\u001c9viN#(/Z1n\u001fB,'/\u0019;peB!\u0011\u0003\n\u0014-\u0013\t)#CA\u0006Ue&<w-\u001a:bE2,\u0007CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA!osB\u0011Q&M\u0007\u0002])\u0011q\u0006M\u0001\u0006gR\fG/\u001a\u0006\u0003\u000b!I!A\r\u0018\u0003\u001bY{\u0017\u000e\u001a(b[\u0016\u001c\b/Y2f\u0011!!\u0004A!A!\u0002\u0013)\u0014aC9vKJL8i\u001c8gS\u001e\u0004\"A\u000e\u001d\u000e\u0003]R!!\u0006\u0004\n\u0005e:$!E*ue\u0016\fW.U;fef\u001cuN\u001c4jO\")1\b\u0001C\u0001y\u00051A(\u001b8jiz\"\"!P \u0011\u0005y\u0002Q\"\u0001\u0002\t\u000bQR\u0004\u0019A\u001b\t\u000f\u0005\u0003!\u0019!C\u0005\u0005\u0006\u0001R.\u001b8SKR,g\u000e^5p]RKW.Z\u000b\u0002\u0007B\u0011q\u0005R\u0005\u0003\u000b\"\u0012A\u0001T8oO\"1q\t\u0001Q\u0001\n\r\u000b\u0011#\\5o%\u0016$XM\u001c;j_:$\u0016.\\3!\u0011\u001dI\u0005A1A\u0005\n\t\u000b\u0001#\\1y%\u0016$XM\u001c;j_:$\u0016.\\3\t\r-\u0003\u0001\u0015!\u0003D\u0003Ei\u0017\r\u001f*fi\u0016tG/[8o)&lW\r\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u0003E\u0019E*R!O+B{F+S'F'R\u000bU\nU\u000b\u0002\u001fB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0005Y\u0006twMC\u0001U\u0003\u0011Q\u0017M^1\n\u0005Y\u000b&AB*ue&tw\r\u0003\u0004Y\u0001\u0001\u0006IaT\u0001\u0013\u00072+\u0015IT+Q?RKU*R*U\u00036\u0003\u0006\u0005C\u0004[\u0001\t\u0007I\u0011\u0002(\u0002#QKU*\u0012*T?N#\u0016\tV#`\u001d\u0006kU\t\u0003\u0004]\u0001\u0001\u0006IaT\u0001\u0013)&kUIU*`'R\u000bE+R0O\u00036+\u0005\u0005C\u0005_\u0001\u0001\u0007\t\u0019!C\u0005?\u0006aB.\u0019;fgR\u0014VmZ5ti\u0016\u0014X\rZ\"mK\u0006tW\u000b\u001d+j[\u0016\u0014X#\u00011\u0011\u0007\u00054\u0007.D\u0001c\u0015\ty3M\u0003\u0002eK\u000611m\\7n_:T!!\u0006\u0005\n\u0005\u001d\u0014'A\u0003,bYV,7\u000b^1uKB\u0011\u0001+[\u0005\u0003\u000bFC\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00027\u0002A1\fG/Z:u%\u0016<\u0017n\u001d;fe\u0016$7\t\\3b]V\u0003H+[7fe~#S-\u001d\u000b\u0003[B\u0004\"a\n8\n\u0005=D#\u0001B+oSRDq!\u001d6\u0002\u0002\u0003\u0007\u0001-A\u0002yIEBaa\u001d\u0001!B\u0013\u0001\u0017!\b7bi\u0016\u001cHOU3hSN$XM]3e\u00072,\u0017M\\+q)&lWM\u001d\u0011\t\u000fU\u0004!\u0019!C\tm\u0006!2\u000f^1uK\u000ecW-\u00198j]\u001e,e.\u00192mK\u0012,\u0012a\u001e\t\u0003OaL!!\u001f\u0015\u0003\u000f\t{w\u000e\\3b]\"11\u0010\u0001Q\u0001\n]\fQc\u001d;bi\u0016\u001cE.Z1oS:<WI\\1cY\u0016$\u0007\u0005C\u0005~\u0001\u0001\u0007\t\u0019!C\t}\u0006aA/[7feN+'O^5dKV\tq\u0010\u0005\u0003\u0002\u0002\u0005\rQ\"\u0001\u000b\n\u0007\u0005\u0015AC\u0001\nTS6\u0004H.\u001a+j[\u0016\u00148+\u001a:wS\u000e,\u0007bCA\u0005\u0001\u0001\u0007\t\u0019!C\t\u0003\u0017\t\u0001\u0003^5nKJ\u001cVM\u001d<jG\u0016|F%Z9\u0015\u00075\fi\u0001\u0003\u0005r\u0003\u000f\t\t\u00111\u0001\u0000\u0011\u001d\t\t\u0002\u0001Q!\n}\fQ\u0002^5nKJ\u001cVM\u001d<jG\u0016\u0004\u0003bBA\u000b\u0001\u0011\u0005\u0013qC\u0001\u0005_B,g\u000eF\u0001n\u0011\u001d\tY\u0002\u0001C\u0005\u0003/\ta#\u001b8ji&\fG.\u001b>f)&lWM]*feZL7-\u001a\u0005\b\u0003?\u0001A\u0011CA\f\u0003y\u0011XmZ5ti\u0016\u0014\bK]8dKN\u001c\u0018N\\4DY\u0016\fg.\u00169US6,'\u000fC\u0004\u0002$\u0001!I!!\n\u0002%U\u0004H-\u0019;f\u00072,\u0017M\\+q)&lWM\u001d\u000b\u0006[\u0006\u001d\u00121\u0006\u0005\b\u0003S\t\t\u00031\u0001i\u0003U\u0019WO\u001d:f]R\u0004&o\\2fgNLgn\u001a+j[\u0016D\u0001\"!\f\u0002\"\u0001\u0007\u0011qF\u0001\u0013GV\u0014(/\u001a8u\u00072,\u0017M\\+q)&lW\rE\u0003\u00022\u0005]\u0002.\u0004\u0002\u00024)\u0019\u0011QG*\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003s\t\u0019D\u0001\u0005PaRLwN\\1m\u0011\u001d\ti\u0004\u0001C\t\u0003/\t\u0001c\u00197fC:,\u0006\u000fT1tiRKW.\u001a:\t\u000f\u0005\u0005\u0003\u0001\"\u0012\u0002D\u0005\u0001rN\u001c)s_\u000e,7o]5oORKW.\u001a\u000b\u0004[\u0006\u0015\u0003\u0002CA$\u0003\u007f\u0001\r!!\u0013\u0002\u000bQLW.\u001a:\u0011\u000bE\tYE\n\u0017\n\u0007\u00055#CA\u0007J]R,'O\\1m)&lWM\u001d\u0005\b\u0003#\u0002a\u0011AA*\u00031\u0019G.Z1o+B\u001cF/\u0019;f)\ri\u0017Q\u000b\u0005\b\u0003/\ny\u00051\u0001D\u0003\u0011!\u0018.\\3)\u0007\u0001\tY\u0006\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\t\u0007C\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA3\u0003?\u0012\u0001\"\u00138uKJt\u0017\r\u001c")
public abstract class BaseTwoInputStreamOperatorWithStateRetention
extends AbstractStreamOperator<CRow>
implements TwoInputStreamOperator<CRow, CRow, CRow>,
Triggerable<Object, VoidNamespace> {
    private final long minRetentionTime;
    private final long maxRetentionTime;
    private final String CLEANUP_TIMESTAMP;
    private final String TIMERS_STATE_NAME;
    private ValueState<Long> latestRegisteredCleanUpTimer;
    private final boolean stateCleaningEnabled;
    private SimpleTimerService timerService;

    private long minRetentionTime() {
        return this.minRetentionTime;
    }

    private long maxRetentionTime() {
        return this.maxRetentionTime;
    }

    private String CLEANUP_TIMESTAMP() {
        return this.CLEANUP_TIMESTAMP;
    }

    private String TIMERS_STATE_NAME() {
        return this.TIMERS_STATE_NAME;
    }

    private ValueState<Long> latestRegisteredCleanUpTimer() {
        return this.latestRegisteredCleanUpTimer;
    }

    private void latestRegisteredCleanUpTimer_$eq(ValueState<Long> x$1) {
        this.latestRegisteredCleanUpTimer = x$1;
    }

    public boolean stateCleaningEnabled() {
        return this.stateCleaningEnabled;
    }

    public SimpleTimerService timerService() {
        return this.timerService;
    }

    public void timerService_$eq(SimpleTimerService x$1) {
        this.timerService = x$1;
    }

    public void open() {
        this.initializeTimerService();
        if (this.stateCleaningEnabled()) {
            ValueStateDescriptor cleanUpStateDescriptor = new ValueStateDescriptor(this.CLEANUP_TIMESTAMP(), Types.LONG());
            this.latestRegisteredCleanUpTimer_$eq((ValueState<Long>)this.getRuntimeContext().getState(cleanUpStateDescriptor));
        }
    }

    private void initializeTimerService() {
        InternalTimerService internalTimerService = this.getInternalTimerService(this.TIMERS_STATE_NAME(), (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this);
        this.timerService_$eq(new SimpleTimerService(internalTimerService));
    }

    public void registerProcessingCleanUpTimer() {
        if (this.stateCleaningEnabled()) {
            long currentProcessingTime = this.timerService().currentProcessingTime();
            Optional<Object> currentCleanUpTime = Optional.ofNullable(this.latestRegisteredCleanUpTimer().value());
            if (!currentCleanUpTime.isPresent() || currentProcessingTime + this.minRetentionTime() > Predef$.MODULE$.Long2long((Long)currentCleanUpTime.get())) {
                this.updateCleanUpTimer(Predef$.MODULE$.long2Long(currentProcessingTime), currentCleanUpTime);
            }
        }
    }

    private void updateCleanUpTimer(Long currentProcessingTime, Optional<Long> currentCleanUpTime) {
        if (currentCleanUpTime.isPresent()) {
            this.timerService().deleteProcessingTimeTimer(Predef$.MODULE$.Long2long(currentCleanUpTime.get()));
        }
        Long newCleanUpTime = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(currentProcessingTime) + this.maxRetentionTime());
        this.timerService().registerProcessingTimeTimer(Predef$.MODULE$.Long2long(newCleanUpTime));
        this.latestRegisteredCleanUpTimer().update((Object)newCleanUpTime);
    }

    public void cleanUpLastTimer() {
        Optional<Object> currentCleanUpTime;
        if (this.stateCleaningEnabled() && (currentCleanUpTime = Optional.ofNullable(this.latestRegisteredCleanUpTimer().value())).isPresent()) {
            this.latestRegisteredCleanUpTimer().clear();
            this.timerService().deleteProcessingTimeTimer(Predef$.MODULE$.Long2long((Long)currentCleanUpTime.get()));
        }
    }

    public final void onProcessingTime(InternalTimer<Object, VoidNamespace> timer) {
        if (this.stateCleaningEnabled()) {
            long timerTime = timer.getTimestamp();
            Long cleanupTime = (Long)this.latestRegisteredCleanUpTimer().value();
            if (cleanupTime != null && BoxesRunTime.equalsNumObject((Number)cleanupTime, (Object)BoxesRunTime.boxToLong((long)timerTime))) {
                this.cleanUpState(Predef$.MODULE$.Long2long(cleanupTime));
                this.latestRegisteredCleanUpTimer().clear();
            }
        }
    }

    public abstract void cleanUpState(long var1);

    public BaseTwoInputStreamOperatorWithStateRetention(StreamQueryConfig queryConfig) {
        this.minRetentionTime = queryConfig.getMinIdleStateRetentionTime();
        this.maxRetentionTime = queryConfig.getMaxIdleStateRetentionTime();
        this.CLEANUP_TIMESTAMP = "cleanup-timestamp";
        this.TIMERS_STATE_NAME = "timers";
        this.stateCleaningEnabled = this.minRetentionTime() > 1L;
    }
}

