/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableEnvironmentITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TemporaryOperationListener;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TestGenericUDF;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\r\ra\u0001B\u0001\u0003\u00015\u0011a\u0003V1cY\u0016,eN^5s_:lWM\u001c;J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E1\u0011\u0001B;uS2L!a\u0005\t\u0003\u0015Q+7\u000f\u001e'pO\u001e,'\u000f\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u00031!\u0018M\u00197f\u000b:4h*Y7f!\t9\u0002E\u0004\u0002\u0019=A\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004D\u0001\u0007yI|w\u000e\u001e \u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0002\rA\u0013X\rZ3g\u0013\t\t#E\u0001\u0004TiJLgn\u001a\u0006\u0003?qA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\fSN\u001cFO]3b[&tw\r\u0005\u0002'O5\tA$\u0003\u0002)9\t9!i\\8mK\u0006t\u0007\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-]=\u0002\"!\f\u0001\u000e\u0003\tAQ!F\u0015A\u0002YAQ\u0001J\u0015A\u0002\u0015Bq!\r\u0001C\u0002\u0013\u0005!'A\tfqB,7\r^3e\u000bb\u001cW\r\u001d;j_:,\u0012a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\nQA];mKNT!\u0001\u000f\u0006\u0002\u000b),h.\u001b;\n\u0005i*$!E#ya\u0016\u001cG/\u001a3Fq\u000e,\u0007\u000f^5p]\"1A\b\u0001Q\u0001\nM\n!#\u001a=qK\u000e$X\rZ#yG\u0016\u0004H/[8oA!)a\b\u0001C\u0001e\u00051A\u000f\u001b:po:D#!\u0010!\u0011\u0005\u0005\u0013U\"A\u001c\n\u0005\r;$\u0001\u0002*vY\u0016Dq!\u0012\u0001C\u0002\u0013%a)A\u0006`i\u0016l\u0007OR8mI\u0016\u0014X#A$\u0011\u0005QB\u0015BA%6\u0005=!V-\u001c9pe\u0006\u0014\u0018PR8mI\u0016\u0014\bBB&\u0001A\u0003%q)\u0001\u0007`i\u0016l\u0007OR8mI\u0016\u0014\b\u0005C\u0003N\u0001\u0011\u0005a)\u0001\u0006uK6\u0004hi\u001c7eKJD#\u0001\u0014!\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0003\t\u0016\u0001\u0002;F]Z,\u0012A\u0015\t\u0003[MK!\u0001\u0016\u0002\u0003!Q\u000b'\r\\3F]ZL'o\u001c8nK:$\b\"\u0003,\u0001\u0001\u0004\u0005\r\u0011\"\u0001X\u0003!!XI\u001c<`I\u0015\fHC\u0001-\\!\t1\u0013,\u0003\u0002[9\t!QK\\5u\u0011\u001daV+!AA\u0002I\u000b1\u0001\u001f\u00132\u0011%q\u0006\u00011A\u0001B\u0003&!+A\u0003u\u000b:4\b\u0005C\u0004a\u0001\t\u0007I\u0011B1\u0002\u0011M,G\u000f^5oON,\u0012A\u0019\t\u0003[\rL!\u0001\u001a\u0002\u0003'\u0015sg/\u001b:p]6,g\u000e^*fiRLgnZ:\t\r\u0019\u0004\u0001\u0015!\u0003c\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005C\u0003i\u0001\u0011\u0005\u0011.A\u0003tKR,\b\u000fF\u0001YQ\t97\u000e\u0005\u0002BY&\u0011Qn\u000e\u0002\u0007\u0005\u00164wN]3\t\u000b=\u0004A\u0011\u00019\u0002%Q,7\u000f^*fiBc\u0017M\u001c8feRK\b/Z\u000b\u00021\"\u0012aN\u001d\t\u0003\u0003NL!\u0001^\u001c\u0003\tQ+7\u000f\u001e\u0005\u0006m\u0002!\t![\u0001\u0015i\u0016\u001cHoU3u\u000bb,7-\u001e;j_:lu\u000eZ3)\u0005U\u0014\b\"B=\u0001\t\u0003I\u0017!\t;fgR,\u00050Z2vi\u0016$v/[2f+NLgnZ*b[\u0016$\u0016M\u00197f\u000b:4\bF\u0001=s\u0011\u0015a\b\u0001\"\u0001j\u0003}!Xm\u001d;FqBd\u0017-\u001b8B]\u0012,\u00050Z2vi\u0016\u001c\u0016N\\4mKNKgn\u001b\u0015\u0003wJDQa \u0001\u0005\u0002%\f\u0011\u0005^3ti\u0016C\b\u000f\\1j]\u0006sG-\u0012=fGV$X-T;mi&\u0004H.Z*j].D#A :\t\r\u0005\u0015\u0001\u0001\"\u0001j\u0003A!Xm\u001d;FqBd\u0017-\u001b8Uo&\u001cW\rK\u0002\u0002\u0004IDa!a\u0003\u0001\t\u0003I\u0017\u0001\b;fgR\u001c\u0016\u000f\\+qI\u0006$X-\u00118e)>$\u0015\r^1TiJ,\u0017-\u001c\u0015\u0004\u0003\u0013\u0011\bBBA\t\u0001\u0011\u0005\u0011.\u0001\u000fuKN$Hk\u001c#bi\u0006\u001cFO]3b[\u0006sGmU9m+B$\u0017\r^3)\u0007\u0005=!\u000f\u0003\u0004\u0002\u0018\u0001!\t![\u0001!i\u0016\u001cHO\u0012:p[R{G)\u0019;b'R\u0014X-Y7B]\u0012\u001c\u0016\u000f\\+qI\u0006$X\rK\u0002\u0002\u0016IDa!!\b\u0001\t\u0003I\u0017\u0001\b;fgR,\u00050Z2vi\u0016\u001c\u0016\u000f\\,ji\"Len]3si&sGo\u001c\u0015\u0004\u00037\u0011\bBBA\u0012\u0001\u0011\u0005\u0011.A\u0011uKN$X\t_3dkR,7+\u001d7XSRD\u0017J\\:feR|e/\u001a:xe&$X\rK\u0002\u0002\"IDa!!\u000b\u0001\t\u0003I\u0017A\u0007;fgR,\u00050Z2vi\u0016\u001c\u0016\u000f\\!oIN\u000bH.\u00169eCR,\u0007fAA\u0014e\"1\u0011q\u0006\u0001\u0005\u0002%\fQ\u0004^3ti\u0016CXmY;uKN\u000bH.\u00118e)>$\u0015\r^1TiJ,\u0017-\u001c\u0015\u0004\u0003[\u0011\bBBA\u001b\u0001\u0011\u0005\u0011.A\tuKN$X\t_3dkR,\u0017J\\:feRD3!a\rs\u0011\u0019\tY\u0004\u0001C\u0001S\u0006QB/Z:u\u000bb,7-\u001e;f\u0013:\u001cXM\u001d;Pm\u0016\u0014xO]5uK\"\u001a\u0011\u0011\b:\t\r\u0005\u0005\u0003\u0001\"\u0001j\u0003A!Xm\u001d;UC\ndW\rR'M'ft7\rK\u0002\u0002@IDa!a\u0012\u0001\t\u0003I\u0017\u0001\u0005;fgR\u001cF/\u0019;f[\u0016tGoU3uQ\r\t)E\u001d\u0005\u0007\u0003\u001b\u0002A\u0011A5\u0002;Q,7\u000f^*uCR,W.\u001a8u'\u0016$x+\u001b;i\u001fZ,'o\u001e:ji\u0016D3!a\u0013s\u0011\u0019\t\u0019\u0006\u0001C\u0001S\u00061C/Z:u'R\fG/Z7f]R\u001cV\r^,ji\"\u001c\u0016-\\3TS:\\G+\u00192mK:\u000bW.Z:)\u0007\u0005E#\u000f\u0003\u0004\u0002Z\u0001!\t![\u0001\u0012i\u0016\u001cH/\u0012=fGV$XmU3mK\u000e$\bfAA,e\"1\u0011q\f\u0001\u0005\u0002%\f!\u0005^3ti\u0016CXmY;uKN+G.Z2u/&$\b.\u00169eCR,7\t[1oO\u0016\u001c\bfAA/e\"1\u0011Q\r\u0001\u0005\u0002%\f!\u0005^3ti\u0016CXmY;uKN+G.Z2u/&$\b\u000eV5nK\u0006#HO]5ckR,\u0007fAA2e\"1\u00111\u000e\u0001\u0005\u0002%\f!\u0003^3ti\u000ecW-\u0019:Pa\u0016\u0014\u0018\r^5p]\"\u001a\u0011\u0011\u000e:\t\r\u0005E\u0004\u0001\"\u0001j\u0003y!Xm\u001d;UK6\u0004xN]1ss>\u0003XM]1uS>tG*[:uK:,'\u000fK\u0002\u0002pIDq!a\u001e\u0001\t\u0003\tI(A\u0007hKR\u0004VM]:p]\u0012\u000bG/Y\u000b\u0003\u0003w\u0002b!! \u0002\b\u00065e\u0002BA@\u0003\u0007s1!GAA\u0013\u0005i\u0012bAAC9\u00059\u0001/Y2lC\u001e,\u0017\u0002BAE\u0003\u0017\u0013A\u0001T5ti*\u0019\u0011Q\u0011\u000f\u0011\u0013\u0019\nyIFAJ\u000333\u0012bAAI9\t1A+\u001e9mKR\u00022AJAK\u0013\r\t9\n\b\u0002\u0004\u0013:$\bc\u0001\u0014\u0002\u001c&\u0019\u0011Q\u0014\u000f\u0003\r\u0011{WO\u00197f\u0011\u001d\t\t\u000b\u0001C\u0005\u0003G\u000b\u0011#Y:tKJ$h)\u001b:tiZ\u000bG.^3t)\rA\u0016Q\u0015\u0005\b\u0003O\u000by\n1\u0001\u0017\u0003-\u00197O\u001e$jY\u0016\u0004\u0016\r\u001e5\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\u0006\u0001\u0012m]:feRd\u0015m\u001d;WC2,Xm\u001d\u000b\u00041\u0006=\u0006bBAT\u0003S\u0003\rA\u0006\u0005\b\u0003g\u0003A\u0011BA[\u0003U9W\r^#ya\u0016\u001cG/\u001a3MCN$h+\u00197vKN,\"!a.\u0011\u000b\u0005u\u0014q\u0011\f\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\u0006q1\r[3dW\u0016k\u0007\u000f^=GS2,Gc\u0001-\u0002@\"9\u0011qUA]\u0001\u00041\u0002bBAb\u0001\u0011%\u0011QY\u0001\u000bI\u0016dW\r^3GS2,Gc\u0001-\u0002H\"9\u0011\u0011ZAa\u0001\u00041\u0012\u0001\u00029bi\"Dq!!4\u0001\t\u0013\ty-\u0001\nbgN,'\u000f\u001e$jY\u0016tu\u000e^#ySN$Hc\u0001-\u0002R\"9\u0011\u0011ZAf\u0001\u00041\u0002bBAk\u0001\u0011%\u0011q[\u0001\u0017G\",7m[%og\u0016\u0014H\u000fV1cY\u0016\u0014Vm];miR)\u0001,!7\u0002d\"A\u00111\\Aj\u0001\u0004\ti.A\u0006uC\ndWMU3tk2$\bcA\u0017\u0002`&\u0019\u0011\u0011\u001d\u0002\u0003\u0017Q\u000b'\r\\3SKN,H\u000e\u001e\u0005\t\u0003K\f\u0019\u000e1\u0001\u0002h\u0006Qa-[3mI:\u000bW.Z:\u0011\t\u0019\nIOF\u0005\u0004\u0003Wd\"A\u0003\u001fsKB,\u0017\r^3e}!9\u0011q\u001e\u0001\u0005\n\u0005E\u0018\u0001\u0003:fC\u00124\u0015\u000e\\3\u0015\t\u0005]\u00161\u001f\u0005\b\u0003O\u000bi\u000f1\u0001\u0017\r\u0019\t9\u0010\u0001\u0001\u0002z\nyA*[:uK:,'oQ1uC2|wm\u0005\u0004\u0002v\u0006m(q\u0001\t\u0005\u0003{\u0014\u0019!\u0004\u0002\u0002\u0000*\u0019!\u0011\u0001\u0003\u0002\u000f\r\fG/\u00197pO&!!QAA\u0000\u0005Y9UM\\3sS\u000eLe.T3n_JL8)\u0019;bY><\u0007\u0003BA\u007f\u0005\u0013IAAa\u0003\u0002\u0000\nQB+Z7q_J\f'/_(qKJ\fG/[8o\u0019&\u001cH/\u001a8fe\"Q!qBA{\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t9\fW.\u001a\u0005\bU\u0005UH\u0011\u0001B\n)\u0011\u0011)B!\u0007\u0011\t\t]\u0011Q_\u0007\u0002\u0001!9!q\u0002B\t\u0001\u00041\u0002B\u0003B\u000f\u0003k\u0014\r\u0011\"\u0001\u0003 \u0005aA/\u00192mK\u000e{W.\\3oiV\ta\u0003\u0003\u0005\u0003$\u0005U\b\u0015!\u0003\u0017\u00035!\u0018M\u00197f\u0007>lW.\u001a8uA!Q!qEA{\u0005\u0004%\tAa\b\u0002\u0017\u0019,hnY\"mu:\u000bW.\u001a\u0005\t\u0005W\t)\u0010)A\u0005-\u0005aa-\u001e8d\u00072Th*Y7fA!Q!qFA{\u0001\u0004%\tA!\r\u0002\u00199,X\u000eV3naR\u000b'\r\\3\u0016\u0005\u0005M\u0005B\u0003B\u001b\u0003k\u0004\r\u0011\"\u0001\u00038\u0005\u0001b.^7UK6\u0004H+\u00192mK~#S-\u001d\u000b\u00041\ne\u0002\"\u0003/\u00034\u0005\u0005\t\u0019AAJ\u0011%\u0011i$!>!B\u0013\t\u0019*A\u0007ok6$V-\u001c9UC\ndW\r\t\u0005\u000b\u0005\u0003\n)\u00101A\u0005\u0002\tE\u0012a\u00038v[R+W\u000e\u001d$v]\u000eD!B!\u0012\u0002v\u0002\u0007I\u0011\u0001B$\u0003=qW/\u001c+f[B4UO\\2`I\u0015\fHc\u0001-\u0003J!IALa\u0011\u0002\u0002\u0003\u0007\u00111\u0013\u0005\n\u0005\u001b\n)\u0010)Q\u0005\u0003'\u000bAB\\;n)\u0016l\u0007OR;oG\u0002B\u0001B!\u0015\u0002v\u0012\u0005#1K\u0001\u0017_:\u001c%/Z1uKR+W\u000e]8sCJLH+\u00192mKR1!Q\u000bB.\u0005K\u0002B!!@\u0003X%!!\u0011LA\u0000\u0005A\u0019\u0015\r^1m_\u001e\u0014\u0015m]3UC\ndW\r\u0003\u0005\u0003^\t=\u0003\u0019\u0001B0\u0003%!\u0018M\u00197f!\u0006$\b\u000e\u0005\u0003\u0002~\n\u0005\u0014\u0002\u0002B2\u0003\u007f\u0014!b\u00142kK\u000e$\b+\u0019;i\u0011\u001d)!q\na\u0001\u0005+B\u0001B!\u001b\u0002v\u0012\u0005#1N\u0001\u0015_:$%o\u001c9UK6\u0004xN]1ssR\u000b'\r\\3\u0015\u0007a\u0013i\u0007\u0003\u0005\u0003^\t\u001d\u0004\u0019\u0001B0\u0011!\u0011\t(!>\u0005B\tM\u0014!G8o\u0007J,\u0017\r^3UK6\u0004xN]1ss\u001a+hn\u0019;j_:$bA!\u001e\u0003|\t}\u0004\u0003BA\u007f\u0005oJAA!\u001f\u0002\u0000\ny1)\u0019;bY><g)\u001e8di&|g\u000e\u0003\u0005\u0003~\t=\u0004\u0019\u0001B0\u000311WO\\2uS>t\u0007+\u0019;i\u0011!\u0011\tIa\u001cA\u0002\tU\u0014\u0001\u00034v]\u000e$\u0018n\u001c8\t\u0011\t\u0015\u0015Q\u001fC!\u0005\u000f\u000bqc\u001c8Ee>\u0004H+Z7q_J\f'/\u001f$v]\u000e$\u0018n\u001c8\u0015\u0007a\u0013I\t\u0003\u0005\u0003~\t\r\u0005\u0019\u0001B0Q\u001d\u0001!Q\u0012BM\u00057\u0003BAa$\u0003\u00166\u0011!\u0011\u0013\u0006\u0004\u0005';\u0014A\u0002:v]:,'/\u0003\u0003\u0003\u0018\nE%a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0005;\u0003BAa(\u0003&6\u0011!\u0011\u0015\u0006\u0004\u0005G;\u0014a\u0002:v]:,'o]\u0005\u0005\u0005O\u0013\tKA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\b\u0005W\u0013\u0001\u0012\u0001BW\u0003Y!\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG/\u0013+DCN,\u0007cA\u0017\u00030\u001a1\u0011A\u0001E\u0001\u0005c\u001bBAa,\u00034B\u0019aE!.\n\u0007\t]FD\u0001\u0004B]f\u0014VM\u001a\u0005\bU\t=F\u0011\u0001B^)\t\u0011i\u000b\u0003\u0005\u0003@\n=F\u0011\u0001Ba\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0005\u0007\u0004bA!2\u0003N\nEWB\u0001Bd\u0015\r\t\"\u0011\u001a\u0006\u0003\u0005\u0017\fAA[1wC&!!q\u001aBd\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\u0019\u0005\u0005'\u0014i\u000eE\u0003'\u0005+\u0014I.C\u0002\u0003Xr\u0011Q!\u0011:sCf\u0004BAa7\u0003^2\u0001A\u0001\u0004Bp\u0005{\u000b\t\u0011!A\u0003\u0002\t\u0005(aA0%cE!!1\u001dBu!\r1#Q]\u0005\u0004\u0005Od\"a\u0002(pi\"Lgn\u001a\t\u0004M\t-\u0018b\u0001Bw9\t\u0019\u0011I\\=)\u0011\tu&\u0011\u001fB\b\u0005\u007f\u0004BAa=\u0003z:!!q\u0014B{\u0013\u0011\u00119P!)\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\u0011YP!@\u0003\u0015A\u000b'/Y7fi\u0016\u00148O\u0003\u0003\u0003x\n\u0005\u0016EAB\u0001\u0003AY\b' \u001ejgN#(/Z1n{m\fT\u0010")
public class TableEnvironmentITCase
extends TestLogger {
    private final String tableEnvName;
    private final boolean isStreaming;
    private final ExpectedException expectedException;
    private final TemporaryFolder _tempFolder;
    private TableEnvironment tEnv;
    private final EnvironmentSettings settings;

    @Parameterized.Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableEnvironmentITCase$.MODULE$.parameters();
    }

    public ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    @Before
    public void setup() {
        String string = this.tableEnvName;
        if ("TableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("StreamTableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(26).append("unsupported tableEnvName: ").append(this.tableEnvName).toString());
        }
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
    }

    @Test
    public void testSetPlannerType() {
        this.tEnv().getConfig().getConfiguration().set(TableConfigOptions.TABLE_PLANNER, (Object)PlannerType.OLD);
        TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.thrown().expect(IllegalArgumentException.class);
        this.thrown().expectMessage("Mismatch between configured planner and actual planner. Currently, the 'table.planner' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        this.tEnv().executeSql("insert into MySink1 select first from MyTable");
    }

    @Test
    public void testSetExecutionMode() {
        Configuration configuration = this.isStreaming ? this.tEnv().getConfig().getConfiguration().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH) : this.tEnv().getConfig().getConfiguration().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.STREAMING);
        this.thrown().expect(IllegalArgumentException.class);
        this.thrown().expectMessage("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        this.tEnv().explainSql("select first from MyTable", new ExplainDetail[0]);
    }

    @Test
    public void testExecuteTwiceUsingSameTableEnv() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        this.checkEmptyFile(sink2Path);
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        this.tEnv().insertInto(table1, "MySink1", new String[0]);
        this.tEnv().execute("test1");
        this.assertFirstValues(sink1Path);
        this.checkEmptyFile(sink2Path);
        new File(sink1Path).delete();
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        this.tEnv().insertInto(table2, "MySink2", new String[0]);
        this.tEnv().execute("test2");
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testExplainAndExecuteSingleSink() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        this.tEnv().insertInto(table1, "MySink1", new String[0]);
        this.tEnv().explain(false);
        this.tEnv().execute("test1");
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExplainAndExecuteMultipleSink() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        this.tEnv().insertInto(table1, "MySink1", new String[0]);
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        this.tEnv().insertInto(table2, "MySink2", new String[0]);
        this.tEnv().explain(false);
        this.tEnv().execute("test1");
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testExplainTwice() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        this.tEnv().insertInto(table1, "MySink1", new String[0]);
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        this.tEnv().insertInto(table2, "MySink2", new String[0]);
        String result1 = this.tEnv().explain(false);
        String result2 = this.tEnv().explain(false);
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(result1), (Object)TableTestUtil$.MODULE$.replaceStageId(result2));
    }

    @Test
    public void testSqlUpdateAndToDataStream() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        streamTableEnv.sqlUpdate("insert into MySink1 select first from MyTable");
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toAppendStream(table, Row.class);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        String explain = streamTableEnv.explain(false);
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStream.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain));
        streamTableEnv.execute("test1");
        this.assertFirstValues(sink1Path);
        Assert.assertFalse((boolean)sink.isInitialized());
        this.deleteFile(sink1Path);
        streamEnv.execute("test2");
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        this.assertFileNotExist(sink1Path);
    }

    @Test
    public void testToDataStreamAndSqlUpdate() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toAppendStream(table, Row.class);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        streamTableEnv.sqlUpdate("insert into MySink1 select first from MyTable");
        String explain = streamTableEnv.explain(false);
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStream.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain));
        streamEnv.execute("test2");
        this.checkEmptyFile(sink1Path);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        streamTableEnv.execute("test1");
        this.assertFirstValues(sink1Path);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testFromToDataStreamAndSqlUpdate() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        StreamExecutionEnvironment streamEnv = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        org.apache.flink.table.api.bridge.scala.StreamTableEnvironment streamTableEnv = StreamTableEnvironment$.MODULE$.create(streamEnv, this.settings());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(streamEnv.fromCollection(this.getPersonData(), (TypeInformation)new CaseClassTypeInfo<Tuple4<String, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.TableEnvironmentITCase$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(streamTableEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "first")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "last"))}));
        streamTableEnv.registerTable("MyTable", t);
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        org.apache.flink.streaming.api.scala.DataStream resultSet = streamTableEnv.toAppendStream(table, TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        streamTableEnv.sqlUpdate("insert into MySink1 select first from MyTable");
        String explain = streamTableEnv.explain(false);
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testFromToDataStreamAndSqlUpdate.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain));
        streamEnv.execute("test2");
        this.checkEmptyFile(sink1Path);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        streamTableEnv.execute("test1");
        this.assertFirstValues(sink1Path);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testExecuteSqlWithInsertInto() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteSqlWithInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
        TableResult tableResult2 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteSqlAndSqlUpdate() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        this.checkEmptyFile(sink2Path);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sink1Path);
        this.checkEmptyFile(sink2Path);
        new File(sink1Path).delete();
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        this.tEnv().insertInto(table2, "MySink2", new String[0]);
        this.tEnv().execute("test2");
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testExecuteSqlAndToDataStream() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toAppendStream(table, Row.class);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        TableResult tableResult = streamTableEnv.executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sink1Path);
        Assert.assertFalse((boolean)sink.isInitialized());
        this.deleteFile(sink1Path);
        streamEnv.execute("test2");
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        this.assertFileNotExist(sink1Path);
    }

    @Test
    public void testExecuteInsert() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        Table table = this.tEnv().sqlQuery("select first from MyTable");
        TableResult tableResult = table.executeInsert("MySink");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
        TableResult tableResult2 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testTableDMLSync() {
        this.tEnv().getConfig().getConfiguration().set(TableConfigOptions.TABLE_DML_SYNC, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sink1Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n         |create table MySink1 (\n         |  first string,\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink1Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink2Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n         |create table MySink2 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink2Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink3Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink3 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink3Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first, last from MyTable").executeInsert("MySink1", false);
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO MySink2 select first from MySink1");
        stmtSet.addInsertSql("INSERT INTO MySink3 select last from MySink1");
        TableResult tableResult2 = stmtSet.execute();
        this.assertFirstValues(sink2Path);
        this.assertLastValues(sink3Path);
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink2", "default_catalog.default_database.MySink3"}));
        tableResult1.await();
        tableResult2.await();
    }

    @Test
    public void testStatementSet() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable")).addInsertSql("insert into MySink2 select last from MyTable");
        String actual = stmtSet.explain(new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testStatementSet.out");
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testStatementSetWithOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sink1Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n         |create table MySink1 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink1Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink2Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink2 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink2Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult1 = stmtSet.execute();
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true).addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult2 = stmtSet.execute();
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testStatementSetWithSameSinkTableNames() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink select last from MyTable");
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink_1", "default_catalog.default_database.MySink_2"}));
    }

    @Test
    public void testExecuteSelect() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        TableResult tableResult = this.tEnv().executeSql(query);
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        actual.sort(new Comparator<Row>(null){

            public Comparator<Row> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Row> thenComparing(Comparator<? super Row> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Row> thenComparingInt(ToIntFunction<? super Row> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Row> thenComparingLong(ToLongFunction<? super Row> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Row> thenComparingDouble(ToDoubleFunction<? super Row> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testExecuteSelectWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = this.isStreaming ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testExecuteSelectWithTimeAttribute() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary"}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"name", "pt"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.LOCAL_DATE_TIME()}));
        TypeInformation sourceType = Types.STRING();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(true, schema, sourceType, data, null, "pt", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", tableSource);
        TableResult tableResult = this.tEnv().executeSql("select * from T");
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"pt", (DataType)DataTypes.TIMESTAMP_LTZ((int)3))}), (Object)tableResult.getResolvedSchema());
        CloseableIterator it = tableResult.collect();
        Assert.assertTrue((boolean)it.hasNext());
        Row row = (Row)it.next();
        Assert.assertEquals((long)2L, (long)row.getArity());
        Assert.assertEquals((Object)"Mary", (Object)row.getField(0));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testClearOperation() {
        TestCollectionTableFactory$.MODULE$.reset();
        TableEnvironmentImpl tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
        tableEnv.executeSql("create table dest1(x map<int,bigint>) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table dest2(x int) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table src(x int) with('connector' = 'COLLECTION')");
        try {
            tableEnv.executeSql("insert into dest1 select count(*) from src");
            Assert.fail((String)"insert is expected to fail due to type mismatch");
        }
        catch (Exception exception) {}
        tableEnv.executeSql("drop table dest1");
        tableEnv.executeSql("insert into dest2 select x from src").await();
    }

    @Test
    public void testTemporaryOperationListener() {
        ListenerCatalog listener = new ListenerCatalog("listener_cat");
        String currentCat = this.tEnv().getCurrentCatalog();
        this.tEnv().registerCatalog(listener.getName(), (Catalog)listener);
        this.tEnv().executeSql("create temporary table tbl1 (x int)");
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().executeSql(new StringBuilder(46).append("create temporary table ").append(listener.getName()).append(".`default`.tbl1 (x int)").toString());
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        Optional tableResult = ((TableEnvironmentInternal)this.tEnv()).getCatalogManager().getTable(ObjectIdentifier.of((String)listener.getName(), (String)"default", (String)"tbl1"));
        Assert.assertTrue((boolean)tableResult.isPresent());
        Assert.assertEquals((Object)listener.tableComment(), (Object)((CatalogManager.TableLookupResult)tableResult.get()).getTable().getComment());
        this.tEnv().executeSql("drop temporary table tbl1");
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        this.tEnv().executeSql(new StringBuilder(36).append("drop temporary table ").append(listener.getName()).append(".`default`.tbl1").toString());
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().useCatalog(listener.getName());
        this.tEnv().executeSql("create temporary table tbl1 (x int)");
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        this.tEnv().executeSql("drop temporary table tbl1");
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().useCatalog(currentCat);
        this.tEnv().executeSql("create temporary view v1 as select 1");
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().executeSql(new StringBuilder(47).append("create temporary view ").append(listener.getName()).append(".`default`.v1 as select 1").toString());
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        Optional viewResult = ((TableEnvironmentInternal)this.tEnv()).getCatalogManager().getTable(ObjectIdentifier.of((String)listener.getName(), (String)"default", (String)"v1"));
        Assert.assertTrue((boolean)viewResult.isPresent());
        Assert.assertEquals((Object)listener.tableComment(), (Object)((CatalogManager.TableLookupResult)viewResult.get()).getTable().getComment());
        this.tEnv().executeSql("drop temporary view v1");
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        this.tEnv().executeSql(new StringBuilder(33).append("drop temporary view ").append(listener.getName()).append(".`default`.v1").toString());
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().useCatalog(listener.getName());
        this.tEnv().executeSql("create temporary view v1 as select 1");
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        this.tEnv().executeSql("drop temporary view  v1");
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().useCatalog(currentCat);
        String clzName = "foo.class.name";
        try {
            this.tEnv().executeSql(new StringBuilder(37).append("create temporary function func1 as '").append(clzName).append("'").toString());
            Assert.fail((String)"Creating a temporary function with invalid class should fail");
        }
        catch (Exception exception) {}
        Assert.assertEquals((long)0L, (long)listener.numTempFunc());
        this.tEnv().executeSql(new StringBuilder(48).append("create temporary function ").append(listener.getName()).append(".`default`.func1 as '").append(clzName).append("'").toString());
        Assert.assertEquals((long)1L, (long)listener.numTempFunc());
        this.tEnv().executeSql("drop temporary function if exists func1");
        Assert.assertEquals((long)1L, (long)listener.numTempFunc());
        this.tEnv().executeSql(new StringBuilder(40).append("drop temporary function ").append(listener.getName()).append(".`default`.func1").toString());
        Assert.assertEquals((long)0L, (long)listener.numTempFunc());
        this.tEnv().useCatalog(listener.getName());
        this.tEnv().executeSql(new StringBuilder(37).append("create temporary function func1 as '").append(clzName).append("'").toString());
        Assert.assertEquals((long)1L, (long)listener.numTempFunc());
        this.tEnv().executeSql("drop temporary function func1");
        Assert.assertEquals((long)0L, (long)listener.numTempFunc());
        this.tEnv().useCatalog(currentCat);
        listener.close();
    }

    public List<Tuple4<String, Object, Object, String>> getPersonData() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"Mike", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToDouble((double)12.3), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Bob", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)45.6), (Object)"Taylor"));
        data.$plus$eq((Object)new Tuple4((Object)"Sam", (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToDouble((double)7.89), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Peter", (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToDouble((double)0.12), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Liz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToDouble((double)34.5), (Object)"Williams"));
        data.$plus$eq((Object)new Tuple4((Object)"Sally", (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToDouble((double)6.78), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Alice", (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToDouble((double)90.1), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Kelly", (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToDouble((double)2.34), (Object)"Williams"));
        return data.toList();
    }

    private void assertFirstValues(String csvFilePath) {
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mike", "Bob", "Sam", "Peter", "Liz", "Sally", "Alice", "Kelly"}));
        List<String> actual = this.readFile(csvFilePath);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void assertLastValues(String csvFilePath) {
        List<String> actual = this.readFile(csvFilePath);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private List<String> getExpectedLastValues() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Smith", "Taylor", "Miller", "Smith", "Williams", "Miller", "Smith", "Williams"}));
    }

    private void checkEmptyFile(String csvFilePath) {
        Assert.assertTrue((boolean)FileUtils.readFileUtf8((File)new File(csvFilePath)).isEmpty());
    }

    private void deleteFile(String path) {
        new File(path).delete();
        Assert.assertFalse((boolean)new File(path).exists());
    }

    private void assertFileNotExist(String path) {
        Assert.assertFalse((boolean)new File(path).exists());
    }

    private void checkInsertTableResult(TableResult tableResult, Seq<String> fieldNames) {
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals(Arrays.asList((Object[])fieldNames.toArray(ClassTag$.MODULE$.apply(String.class))), (Object)tableResult.getResolvedSchema().getColumnNames());
        CloseableIterator it = tableResult.collect();
        Assert.assertTrue((boolean)it.hasNext());
        Seq affectedRowCounts = (Seq)fieldNames.map((Function1 & Serializable & scala.Serializable)x$1 -> -1L, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Row.of((Object[])((Object[])affectedRowCounts.toArray(ClassTag$.MODULE$.apply(Long.class)))), (Object)it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    private List<String> readFile(String csvFilePath) {
        File file = new File(csvFilePath);
        return file.isDirectory() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles(new FileFilter(null){

            public boolean accept(File f) {
                return f.isFile();
            }
        }))).map((Function1 & Serializable & scala.Serializable)x$1 -> FileUtils.readFileUtf8((File)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split("\n"))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileUtils.readFileUtf8((File)file).split("\n"))).toList();
    }

    public TableEnvironmentITCase(String tableEnvName, boolean isStreaming) {
        this.tableEnvName = tableEnvName;
        this.isStreaming = isStreaming;
        this.expectedException = ExpectedException.none();
        this._tempFolder = new TemporaryFolder();
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
    }

    public class ListenerCatalog
    extends GenericInMemoryCatalog
    implements TemporaryOperationListener {
        private final String tableComment;
        private final String funcClzName;
        private int numTempTable;
        private int numTempFunc;

        public String tableComment() {
            return this.tableComment;
        }

        public String funcClzName() {
            return this.funcClzName;
        }

        public int numTempTable() {
            return this.numTempTable;
        }

        public void numTempTable_$eq(int x$1) {
            this.numTempTable = x$1;
        }

        public int numTempFunc() {
            return this.numTempFunc;
        }

        public void numTempFunc_$eq(int x$1) {
            this.numTempFunc = x$1;
        }

        public CatalogBaseTable onCreateTemporaryTable(ObjectPath tablePath, CatalogBaseTable table) {
            CatalogTableImpl catalogTableImpl;
            this.numTempTable_$eq(this.numTempTable() + 1);
            if (table instanceof CatalogTable) {
                catalogTableImpl = new CatalogTableImpl(table.getSchema(), table.getOptions(), this.tableComment());
            } else {
                CatalogView view = (CatalogView)table;
                catalogTableImpl = new CatalogViewImpl(view.getOriginalQuery(), view.getExpandedQuery(), view.getSchema(), view.getOptions(), this.tableComment());
            }
            return catalogTableImpl;
        }

        public void onDropTemporaryTable(ObjectPath tablePath) {
            this.numTempTable_$eq(this.numTempTable() - 1);
        }

        public CatalogFunction onCreateTemporaryFunction(ObjectPath functionPath, CatalogFunction function) {
            this.numTempFunc_$eq(this.numTempFunc() + 1);
            return new CatalogFunctionImpl(this.funcClzName(), function.getFunctionLanguage());
        }

        public void onDropTemporaryFunction(ObjectPath functionPath) {
            this.numTempFunc_$eq(this.numTempFunc() - 1);
        }

        public /* synthetic */ TableEnvironmentITCase org$apache$flink$table$api$TableEnvironmentITCase$ListenerCatalog$$$outer() {
            return TableEnvironmentITCase.this;
        }

        public ListenerCatalog(String name) {
            if (TableEnvironmentITCase.this == null) {
                throw null;
            }
            super(name);
            this.tableComment = "listener_comment";
            this.funcClzName = TestGenericUDF.class.getName();
            this.numTempTable = 0;
            this.numTempFunc = 0;
        }
    }
}

