/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0004\u0002\tU$\u0018\u000e\\\u0005\u0003'A\u0011!\u0002V3ti2{wmZ3s\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001\u0004;bE2,WI\u001c<OC6,\u0007CA\f!\u001d\tAb\u0004\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\u0019\u00051AH]8pizR\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\ta\u0001\u0015:fI\u00164\u0017BA\u0011#\u0005\u0019\u0019FO]5oO*\u0011q\u0004\b\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005Y\u0011n]*ue\u0016\fW.\u001b8h!\t1s%D\u0001\u001d\u0013\tACDA\u0004C_>dW-\u00198\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\racf\f\t\u0003[\u0001i\u0011A\u0001\u0005\u0006+%\u0002\rA\u0006\u0005\u0006I%\u0002\r!\n\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0003E)\u0007\u0010]3di\u0016$W\t_2faRLwN\\\u000b\u0002gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006eVdWm\u001d\u0006\u0003q)\tQA[;oSRL!AO\u001b\u0003#\u0015C\b/Z2uK\u0012,\u0005pY3qi&|g\u000e\u0003\u0004=\u0001\u0001\u0006IaM\u0001\u0013Kb\u0004Xm\u0019;fI\u0016C8-\u001a9uS>t\u0007\u0005C\u0003?\u0001\u0011\u0005!'\u0001\u0004uQJ|wO\u001c\u0015\u0003{\u0001\u0003\"!\u0011\"\u000e\u0003]J!aQ\u001c\u0003\tI+H.\u001a\u0005\b\u000b\u0002\u0011\r\u0011\"\u0003G\u0003-yF/Z7q\r>dG-\u001a:\u0016\u0003\u001d\u0003\"\u0001\u000e%\n\u0005%+$a\u0004+f[B|'/\u0019:z\r>dG-\u001a:\t\r-\u0003\u0001\u0015!\u0003H\u00031yF/Z7q\r>dG-\u001a:!\u0011\u0015i\u0005\u0001\"\u0001G\u0003)!X-\u001c9G_2$WM\u001d\u0015\u0003\u0019\u0002C\u0011\u0002\u0015\u0001A\u0002\u0003\u0007I\u0011A)\u0002\tQ,eN^\u000b\u0002%B\u0011QfU\u0005\u0003)\n\u0011\u0001\u0003V1cY\u0016,eN^5s_:lWM\u001c;\t\u0013Y\u0003\u0001\u0019!a\u0001\n\u00039\u0016\u0001\u0003;F]Z|F%Z9\u0015\u0005a[\u0006C\u0001\u0014Z\u0013\tQFD\u0001\u0003V]&$\bb\u0002/V\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0004\"\u00030\u0001\u0001\u0004\u0005\t\u0015)\u0003S\u0003\u0015!XI\u001c<!\u0011\u001d\u0001\u0007A1A\u0005\n\u0005\f\u0001b]3ui&twm]\u000b\u0002EB\u0011QfY\u0005\u0003I\n\u00111#\u00128wSJ|g.\\3oiN+G\u000f^5oONDaA\u001a\u0001!\u0002\u0013\u0011\u0017!C:fiRLgnZ:!\u0011\u0015A\u0007\u0001\"\u0001j\u0003\u0015\u0019X\r^;q)\u0005A\u0006FA4l!\t\tE.\u0003\u0002no\t1!)\u001a4pe\u0016DQa\u001c\u0001\u0005\u0002%\f1\u0002^3ti\u0016CXmY;uK\"\u0012a.\u001d\t\u0003\u0003JL!a]\u001c\u0003\tQ+7\u000f\u001e\u0005\u0006k\u0002!\t![\u0001\u0015i\u0016\u001cHoQ8mY\u0016\u001cGoV5uQ\u000ecwn]3)\u0005Q\f\b\"\u0002=\u0001\t\u0003I\u0017\u0001\b;fgR,\u00050Z2vi\u0016<\u0016\u000e\u001e5Va\u0012\fG/Z\"iC:<Wm\u001d\u0015\u0003oFDc\u0001A>\u0002\u0004\u0005\u0015\u0001C\u0001?\u0000\u001b\u0005i(B\u0001@8\u0003\u0019\u0011XO\u001c8fe&\u0019\u0011\u0011A?\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\u001c\u0002\u000fI,hN\\3sg&!\u0011\u0011CA\u0006\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e9\u0011Q\u0003\u0002\t\u0002\u0005]\u0011a\u0003+bE2,\u0017\nV\"bg\u0016\u00042!LA\r\r\u0019\t!\u0001#\u0001\u0002\u001cM!\u0011\u0011DA\u000f!\r1\u0013qD\u0005\u0004\u0003Ca\"AB!osJ+g\rC\u0004+\u00033!\t!!\n\u0015\u0005\u0005]\u0001\u0002CA\u0015\u00033!\t!a\u000b\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002.A1\u0011qFA\u001c\u0003wi!!!\r\u000b\u0007E\t\u0019D\u0003\u0002\u00026\u0005!!.\u0019<b\u0013\u0011\tI$!\r\u0003\u0015\r{G\u000e\\3di&|g\u000e\r\u0003\u0002>\u0005\u001d\u0003#\u0002\u0014\u0002@\u0005\r\u0013bAA!9\t)\u0011I\u001d:bsB!\u0011QIA$\u0019\u0001!A\"!\u0013\u0002(\u0005\u0005\t\u0011!B\u0001\u0003\u0017\u00121a\u0018\u00132#\u0011\ti%a\u0015\u0011\u0007\u0019\ny%C\u0002\u0002Rq\u0011qAT8uQ&tw\rE\u0002'\u0003+J1!a\u0016\u001d\u0005\r\te.\u001f\u0015\t\u0003O\tY&!\u001b\u0002lA!\u0011QLA2\u001d\u0011\tI!a\u0018\n\t\u0005\u0005\u00141B\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\u0005\u0015\u0014q\r\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(\u0002BA1\u0003\u0017\tAA\\1nK\u0006\u0012\u0011QN\u0001\u0011wBj(([:TiJ,\u0017-\\\u001f|cu\u0004")
public class TableITCase
extends TestLogger {
    private final String tableEnvName;
    private final boolean isStreaming;
    private final ExpectedException expectedException;
    private final TemporaryFolder _tempFolder;
    private TableEnvironment tEnv;
    private final EnvironmentSettings settings;

    @Parameterized.Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableITCase$.MODULE$.parameters();
    }

    public ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    @Before
    public void setup() {
        String string = this.tableEnvName;
        if ("TableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("StreamTableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(26).append("unsupported tableEnvName: ").append(this.tableEnvName).toString());
        }
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
    }

    @Test
    public void testExecute() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        Table table = this.tEnv().sqlQuery(query);
        TableResult tableResult = table.execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        tableResult.await();
        CloseableIterator it = tableResult.collect();
        List actual = CollectionUtil.iteratorToList((Iterator)it);
        it.close();
        actual.sort(new Comparator<Row>(null){

            public Comparator<Row> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Row> thenComparing(Comparator<? super Row> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Row> thenComparingInt(ToIntFunction<? super Row> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Row> thenComparingLong(ToLongFunction<? super Row> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Row> thenComparingDouble(ToDoubleFunction<? super Row> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCollectWithClose() {
        block2: {
            Some jobStatus;
            Some some;
            String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
            Table table = this.tEnv().sqlQuery(query);
            TableResult tableResult = table.execute();
            Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
            Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
            CloseableIterator it = tableResult.collect();
            it.close();
            try {
                some = new Some(((JobClient)tableResult.getJobClient().get()).getJobStatus().get());
            }
            catch (Throwable throwable) {
                some = jobStatus = None$.MODULE$;
            }
            if (!jobStatus.isDefined()) break block2;
            Assert.assertNotEquals((Object)JobStatus.RUNNING, (Object)jobStatus.get());
        }
    }

    @Test
    public void testExecuteWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = this.isStreaming ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assert.assertEquals(expected, (Object)actual);
    }

    public TableITCase(String tableEnvName, boolean isStreaming) {
        this.tableEnvName = tableEnvName;
        this.isStreaming = isStreaming;
        this.expectedException = ExpectedException.none();
        this._tempFolder = new TemporaryFolder();
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
    }
}

