/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.planner.catalog.CatalogViewITCase$;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001=\u0011\u0011cQ1uC2|wMV5fo&#6)Y:f\u0015\t\u0019A!A\u0004dCR\fGn\\4\u000b\u0005\u00151\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!Q\u000f^5m\u0015\t)\u0002\"\u0001\u0003uKN$\u0018BA\f\u0013\u0005A\t%m\u001d;sC\u000e$H+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003=I7o\u0015;sK\u0006l\u0017N\\4N_\u0012,\u0007CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r*\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001\"B\r!\u0001\u0004Q\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\tg\u0016$H/\u001b8hgV\t\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-\r\u0005\u0019\u0011\r]5\n\u00059Z#aE#om&\u0014xN\\7f]R\u001cV\r\u001e;j]\u001e\u001c\bB\u0002\u0019\u0001A\u0003%\u0011&A\u0005tKR$\u0018N\\4tA!9!\u0007\u0001b\u0001\n\u0013\u0019\u0014\u0001\u0003;bE2,WI\u001c<\u0016\u0003Q\u0002\"AK\u001b\n\u0005YZ#\u0001\u0005+bE2,WI\u001c<je>tW.\u001a8u\u0011\u0019A\u0004\u0001)A\u0005i\u0005IA/\u00192mK\u0016sg\u000f\t\u0005\bu\u0001\u0001\r\u0011\"\u0001<\u0003-yV\r\u001f9fGR,G-\u0012=\u0016\u0003q\u0002\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u000bI,H.Z:\u000b\u0005\u0005c\u0011!\u00026v]&$\u0018BA\"?\u0005E)\u0005\u0010]3di\u0016$W\t_2faRLwN\u001c\u0005\b\u000b\u0002\u0001\r\u0011\"\u0001G\u0003=yV\r\u001f9fGR,G-\u0012=`I\u0015\fHCA$K!\tY\u0002*\u0003\u0002J9\t!QK\\5u\u0011\u001dYE)!AA\u0002q\n1\u0001\u001f\u00132\u0011\u0019i\u0005\u0001)Q\u0005y\u0005aq,\u001a=qK\u000e$X\rZ#yA!)q\n\u0001C\u0001w\u0005QQ\r\u001f9fGR,G-\u0012=)\u00059\u000b\u0006C\u0001*T\u001b\u0005\u0001\u0015B\u0001+A\u0005\u0011\u0011V\u000f\\3\t\u000bY\u0003A\u0011A,\u0002\r\t,gm\u001c:f)\u00059\u0005FA+Z!\t\u0011&,\u0003\u0002\\\u0001\n1!)\u001a4pe\u0016DQ!\u0018\u0001\u0005\u0004y\u000b1B]8x\u001fJ$WM]5oOV\tq\fE\u0002aQ.t!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011t\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0013\t9G$A\u0004qC\u000e\\\u0017mZ3\n\u0005%T'\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0005\u001dd\u0002C\u00017p\u001b\u0005i'B\u00018\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001XNA\u0002S_^DQA\u001d\u0001\u0005\u0002M\fQ\u0001^8S_^$\"a\u001b;\t\u000bU\f\b\u0019\u0001<\u0002\t\u0005\u0014xm\u001d\t\u00047]L\u0018B\u0001=\u001d\u0005)a$/\u001a9fCR,GM\u0010\t\u00037iL!a\u001f\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003~\u0001\u0011\u0005q+\u0001\u0010uKN$8I]3bi\u00164\u0016.Z<JM:{G/\u0012=jgR\u001cHk^5dK\"\u0012Ap \t\u0004%\u0006\u0005\u0011bAA\u0002\u0001\n!A+Z:u\u0011\u0019\t9\u0001\u0001C\u0001/\u0006IC/Z:u\u0007J,\u0017\r^3WS\u0016<x+\u001b;i_V$h)[3mI2K7\u000f^!oI^KG\u000f[*uCJD3!!\u0002\u0000\u0011\u0019\ti\u0001\u0001C\u0001/\u00069B/Z:u\u0007J,\u0017\r^3UK6\u0004xN]1ssZKWm\u001e\u0015\u0004\u0003\u0017y\bBBA\n\u0001\u0011\u0005q+\u0001\u0018uKN$H+Z7q_J\f'/\u001f,jK^l\u0015m]6QKJl\u0017M\\3oiZKWm^,ji\"\u001c\u0016-\\3OC6,\u0007fAA\t\u007f\":\u0001!!\u0007\u0002&\u0005\u001d\u0002\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}\u0001)\u0001\u0004sk:tWM]\u0005\u0005\u0003G\tiBA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0002)A\u0004sk:tWM]:\n\t\u0005M\u0012Q\u0006\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\u0005]\"\u0001#\u0001\u0002:\u0005\t2)\u0019;bY><g+[3x\u0013R\u001b\u0015m]3\u0011\u0007\u0011\nYD\u0002\u0004\u0002\u0005!\u0005\u0011QH\n\u0005\u0003w\ty\u0004E\u0002\u001c\u0003\u0003J1!a\u0011\u001d\u0005\u0019\te.\u001f*fM\"9\u0011%a\u000f\u0005\u0002\u0005\u001dCCAA\u001d\u0011!\tY%a\u000f\u0005\u0002\u00055\u0013A\u00039be\u0006lW\r^3sgR\u0011\u0011q\n\t\u0006\u0003#\nIFG\u0007\u0003\u0003'R1aEA+\u0015\t\t9&\u0001\u0003kCZ\f\u0017\u0002BA.\u0003'\u0012!bQ8mY\u0016\u001cG/[8oQ!\tI%a\u0018\u0002n\u0005=\u0004\u0003BA1\u0003OrA!a\u000b\u0002d%!\u0011QMA\u0017\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011\u0011NA6\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0005\u0003K\ni#\u0001\u0003oC6,\u0017EAA9\u0003\rY\b' ")
public class CatalogViewITCase
extends AbstractTestBase {
    private final EnvironmentSettings settings;
    private final TableEnvironment tableEnv;
    private ExpectedException _expectedEx;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return CatalogViewITCase$.MODULE$.parameters();
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    public ExpectedException _expectedEx() {
        return this._expectedEx;
    }

    public void _expectedEx_$eq(ExpectedException x$1) {
        this._expectedEx = x$1;
    }

    @Rule
    public ExpectedException expectedEx() {
        return this._expectedEx();
    }

    @Before
    public void before() {
        this.tableEnv().getConfig().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, 1);
        TestCollectionTableFactory$.MODULE$.reset();
    }

    public Ordering<Row> rowOrdering() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> {
            StringBuilder builder = new StringBuilder();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r.getArity()).foreach((Function1 & Serializable & scala.Serializable)idx -> builder.append(r.getField(BoxesRunTime.unboxToInt((Object)idx))));
            return builder.toString();
        }, (Ordering)Ordering.String$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public Row toRow(Seq<Object> args) {
        void var2_2;
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return var2_2;
    }

    @Test
    public void testCreateViewIfNotExistsTwice() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewWith3ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String viewWith2ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3(d, e) AS SELECT a, b FROM T1\n      ")).stripMargin();
        String query = "SELECT d, e, f FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewWith3ColumnDDL);
        this.tableEnv().executeSql(viewWith2ColumnDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testCreateViewWithoutFieldListAndWithStar() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3 AS SELECT * FROM T1\n      ")).stripMargin();
        String query = "SELECT * FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testCreateTemporaryView() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW T3(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String query = "SELECT d, e, f FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testTemporaryViewMaskPermanentViewWithSameName() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String permanentView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3 AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        .colon.colon permanentViewData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String temporaryView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW IF NOT EXISTS T3 AS SELECT a, b, c+1 FROM T1\n      ")).stripMargin();
        .colon.colon temporaryViewData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(permanentView);
        this.tableEnv().executeSql(temporaryView);
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String query = "SELECT * FROM T3";
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)temporaryViewData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String dropTemporaryView = new StringOps(Predef$.MODULE$.augmentString("\n        |DROP TEMPORARY VIEW IF EXISTS T3\n      ")).stripMargin();
        this.tableEnv().executeSql(dropTemporaryView);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)permanentViewData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    public CatalogViewITCase(boolean isStreamingMode) {
        this.settings = isStreamingMode ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
        this._expectedEx = ExpectedException.none();
    }
}

