/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.sort.IndexedSortable;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.data.util.DataFormatTestUtil;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.planner.codegen.sort.SortCodeGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.runtime.generated.GeneratedNormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.sort.BinaryInMemorySortBuffer;
import org.apache.flink.table.runtime.operators.sort.ListMemorySegmentPool;
import org.apache.flink.table.runtime.operators.sort.SortUtil;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.RawValueDataAsserter;
import org.apache.flink.types.Row;
import org.apache.flink.util.MutableObjectIterator;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SortCodeGeneratorTest {
    private static final int RECORD_NUM = 3000;
    private final LogicalType[] types = new LogicalType[]{new BooleanType(), new TinyIntType(), new SmallIntType(), new IntType(), new BigIntType(), new FloatType(), new DoubleType(), new VarCharType(Integer.MAX_VALUE), new DecimalType(18, 2), new DecimalType(38, 18), new VarBinaryType(Integer.MAX_VALUE), new ArrayType((LogicalType)new TinyIntType()), RowType.of((LogicalType[])new LogicalType[]{new IntType()}), RowType.of((LogicalType[])new LogicalType[]{RowType.of((LogicalType[])new LogicalType[]{new IntType()})}), new TypeInformationRawType(Types.INT), new TimestampType(3), new TimestampType(9)};
    private RowType inputType;
    private SortSpec sortSpec;
    private static final DataType INT_ROW_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())}).bridgedTo(Row.class);
    private static final DataFormatConverters.DataFormatConverter INT_ROW_CONV = DataFormatConverters.getConverterForDataType((DataType)INT_ROW_TYPE);
    private static final TypeComparator INT_ROW_COMP = new RowTypeInfo(new TypeInformation[]{Types.INT}).createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
    private static final DataFormatConverters.DataFormatConverter NEST_ROW_CONV = DataFormatConverters.getConverterForDataType((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)INT_ROW_TYPE)}).bridgedTo(Row.class)));
    private static final TypeComparator NEST_ROW_COMP = new RowTypeInfo(new TypeInformation[]{new RowTypeInfo(new TypeInformation[]{Types.INT})}).createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());

    @Test
    public void testMultiKeys() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.randomKeysAndOrders();
            this.testInner();
        }
    }

    @Test
    public void testOneKey() throws Exception {
        for (int time = 0; time < 100; ++time) {
            Random rnd = new Random();
            LogicalType[] fields = new LogicalType[rnd.nextInt(9) + 1];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = this.types[rnd.nextInt(this.types.length)];
            }
            this.inputType = RowType.of((LogicalType[])fields);
            SortSpec.SortSpecBuilder builder = SortSpec.builder();
            boolean order = rnd.nextBoolean();
            builder.addField(0, order, org.apache.flink.table.planner.plan.utils.SortUtil.getNullDefaultOrder((boolean)order));
            this.sortSpec = builder.build();
            this.testInner();
        }
    }

    private void randomKeysAndOrders() {
        Random rnd = new Random();
        LogicalType[] fields = new LogicalType[rnd.nextInt(9) + 1];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.types[rnd.nextInt(this.types.length)];
        }
        this.inputType = RowType.of((LogicalType[])fields);
        int keyCount = rnd.nextInt(fields.length) + 1;
        LinkedList<Integer> indexQueue = new LinkedList<Integer>();
        for (int i = 0; i < keyCount; ++i) {
            indexQueue.add(i);
        }
        Collections.shuffle(indexQueue);
        SortSpec.SortSpecBuilder builder = SortSpec.builder();
        for (int i = 0; i < keyCount; ++i) {
            boolean order = rnd.nextBoolean();
            builder.addField(((Integer)indexQueue.poll()).intValue(), order, org.apache.flink.table.planner.plan.utils.SortUtil.getNullDefaultOrder((boolean)order));
        }
        this.sortSpec = builder.build();
    }

    private Object[] shuffle(Object[] objects) {
        Collections.shuffle(Arrays.asList(objects));
        return objects;
    }

    private BinaryRowData row(int i, Object[][] values) {
        BinaryRowData row = new BinaryRowData(this.inputType.getFieldCount());
        BinaryRowWriter writer = new BinaryRowWriter(row);
        for (int j = 0; j < this.inputType.getFieldCount(); ++j) {
            Object value = values[j][i];
            if (value == null) {
                writer.setNullAt(j);
                continue;
            }
            BinaryWriter.write((BinaryWriter)writer, (int)j, (Object)value, (LogicalType)this.inputType.getTypeAt(j), (TypeSerializer)InternalSerializers.create((LogicalType)this.inputType.getTypeAt(j)));
        }
        writer.complete();
        return row;
    }

    private BinaryRowData[] getTestData() {
        int i;
        BinaryRowData[] result = new BinaryRowData[3000];
        Object[][] values = new Object[this.inputType.getFieldCount()][];
        for (i = 0; i < this.inputType.getFieldCount(); ++i) {
            values[i] = this.shuffle(this.generateValues(this.inputType.getTypeAt(i)));
        }
        for (i = 0; i < 3000; ++i) {
            result[i] = this.row(i, values);
        }
        return result;
    }

    private Object[] generateValues(LogicalType type) {
        Random rnd = new Random();
        int seedNum = 600;
        Object[] seeds = new Object[seedNum];
        seeds[0] = null;
        seeds[1] = this.value1(type, rnd);
        seeds[2] = this.value2(type, rnd);
        seeds[3] = this.value3(type, rnd);
        block15: for (int i = 4; i < seeds.length; ++i) {
            switch (type.getTypeRoot()) {
                case BOOLEAN: {
                    seeds[i] = rnd.nextBoolean();
                    continue block15;
                }
                case TINYINT: {
                    seeds[i] = (byte)rnd.nextLong();
                    continue block15;
                }
                case SMALLINT: {
                    seeds[i] = (short)rnd.nextLong();
                    continue block15;
                }
                case INTEGER: {
                    seeds[i] = rnd.nextInt();
                    continue block15;
                }
                case BIGINT: {
                    seeds[i] = rnd.nextLong();
                    continue block15;
                }
                case FLOAT: {
                    seeds[i] = Float.valueOf(rnd.nextFloat() * (float)rnd.nextLong());
                    continue block15;
                }
                case DOUBLE: {
                    seeds[i] = rnd.nextDouble() * (double)rnd.nextLong();
                    continue block15;
                }
                case VARCHAR: {
                    seeds[i] = StringData.fromString((String)RandomStringUtils.random((int)rnd.nextInt(20)));
                    continue block15;
                }
                case DECIMAL: {
                    DecimalType decimalType = (DecimalType)type;
                    BigDecimal decimal = new BigDecimal(rnd.nextInt()).divide(new BigDecimal(ThreadLocalRandom.current().nextInt(1, 256)), ThreadLocalRandom.current().nextInt(1, 30), 6);
                    seeds[i] = DecimalData.fromBigDecimal((BigDecimal)decimal, (int)decimalType.getPrecision(), (int)decimalType.getScale());
                    continue block15;
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    TimestampType timestampType = (TimestampType)type;
                    if (timestampType.getPrecision() <= 3) {
                        seeds[i] = TimestampData.fromEpochMillis((long)rnd.nextLong());
                        continue block15;
                    }
                    seeds[i] = TimestampData.fromEpochMillis((long)rnd.nextLong(), (int)rnd.nextInt(1000000));
                    continue block15;
                }
                case ARRAY: 
                case VARBINARY: {
                    byte[] bytes = new byte[rnd.nextInt(16) + 1];
                    rnd.nextBytes(bytes);
                    seeds[i] = type instanceof VarBinaryType ? bytes : (byte[])BinaryArrayData.fromPrimitiveArray((byte[])bytes);
                    continue block15;
                }
                case ROW: {
                    RowType rowType = (RowType)type;
                    if (((RowType.RowField)rowType.getFields().get(0)).getType().getTypeRoot() == LogicalTypeRoot.INTEGER) {
                        seeds[i] = GenericRowData.of((Object[])new Object[]{rnd.nextInt()});
                        continue block15;
                    }
                    seeds[i] = GenericRowData.of((Object[])new Object[]{GenericRowData.of((Object[])new Object[]{rnd.nextInt()})});
                    continue block15;
                }
                case RAW: {
                    seeds[i] = RawValueData.fromObject((Object)rnd.nextInt());
                    continue block15;
                }
                default: {
                    throw new RuntimeException("Not support!");
                }
            }
        }
        Object[] results = new Object[3000];
        for (int i = 0; i < 3000; ++i) {
            results[i] = seeds[rnd.nextInt(seedNum)];
        }
        return results;
    }

    private Object value1(LogicalType type, Random rnd) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return false;
            }
            case TINYINT: {
                return (byte)-128;
            }
            case SMALLINT: {
                return (short)Short.MIN_VALUE;
            }
            case INTEGER: {
                return Integer.MIN_VALUE;
            }
            case BIGINT: {
                return Long.MIN_VALUE;
            }
            case FLOAT: {
                return Float.valueOf(Float.MIN_VALUE);
            }
            case DOUBLE: {
                return Double.MIN_VALUE;
            }
            case VARCHAR: {
                return StringData.fromString((String)"");
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(Integer.MIN_VALUE), (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TimestampData.fromEpochMillis((long)Long.MIN_VALUE);
            }
            case ARRAY: {
                byte[] bytes = new byte[rnd.nextInt(7) + 1];
                rnd.nextBytes(bytes);
                BinaryArrayData array = BinaryArrayData.fromPrimitiveArray((byte[])bytes);
                for (int i = 0; i < bytes.length; ++i) {
                    array.setNullByte(i);
                }
                return array;
            }
            case VARBINARY: {
                byte[] bytes2 = new byte[rnd.nextInt(7) + 1];
                rnd.nextBytes(bytes2);
                return bytes2;
            }
            case ROW: {
                return GenericRowData.of((Object[])new Object[]{null});
            }
            case RAW: {
                return RawValueData.fromObject((Object)rnd.nextInt());
            }
        }
        throw new RuntimeException("Not support!");
    }

    private Object value2(LogicalType type, Random rnd) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return false;
            }
            case TINYINT: {
                return (byte)0;
            }
            case SMALLINT: {
                return (short)0;
            }
            case INTEGER: {
                return 0;
            }
            case BIGINT: {
                return 0L;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                return 0.0;
            }
            case VARCHAR: {
                return StringData.fromString((String)"0");
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(0), (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TimestampData.fromEpochMillis((long)0L);
            }
            case ARRAY: 
            case VARBINARY: {
                byte[] bytes = new byte[rnd.nextInt(7) + 10];
                rnd.nextBytes(bytes);
                return type instanceof VarBinaryType ? bytes : (byte[])BinaryArrayData.fromPrimitiveArray((byte[])bytes);
            }
            case ROW: {
                RowType rowType = (RowType)type;
                if (((RowType.RowField)rowType.getFields().get(0)).getType().getTypeRoot() == LogicalTypeRoot.INTEGER) {
                    return GenericRowData.of((Object[])new Object[]{rnd.nextInt()});
                }
                return GenericRowData.of((Object[])new Object[]{GenericRowData.of((Object[])new Object[]{null})});
            }
            case RAW: {
                return RawValueData.fromObject((Object)rnd.nextInt());
            }
        }
        throw new RuntimeException("Not support!");
    }

    private Object value3(LogicalType type, Random rnd) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return true;
            }
            case TINYINT: {
                return (byte)127;
            }
            case SMALLINT: {
                return (short)Short.MAX_VALUE;
            }
            case INTEGER: {
                return Integer.MAX_VALUE;
            }
            case BIGINT: {
                return Long.MAX_VALUE;
            }
            case FLOAT: {
                return Float.valueOf(Float.MAX_VALUE);
            }
            case DOUBLE: {
                return Double.MAX_VALUE;
            }
            case VARCHAR: {
                return StringData.fromString((String)RandomStringUtils.random((int)100));
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(Integer.MAX_VALUE), (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TimestampData.fromEpochMillis((long)Long.MAX_VALUE, (int)999999);
            }
            case ARRAY: 
            case VARBINARY: {
                byte[] bytes = new byte[rnd.nextInt(100) + 100];
                rnd.nextBytes(bytes);
                return type instanceof VarBinaryType ? bytes : (byte[])BinaryArrayData.fromPrimitiveArray((byte[])bytes);
            }
            case ROW: {
                RowType rowType = (RowType)type;
                if (((RowType.RowField)rowType.getFields().get(0)).getType().getTypeRoot() == LogicalTypeRoot.INTEGER) {
                    return GenericRowData.of((Object[])new Object[]{rnd.nextInt()});
                }
                return GenericRowData.of((Object[])new Object[]{GenericRowData.of((Object[])new Object[]{rnd.nextInt()})});
            }
            case RAW: {
                return RawValueData.fromObject((Object)rnd.nextInt());
            }
        }
        throw new RuntimeException("Not support!");
    }

    private void testInner() throws Exception {
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>();
        for (int i = 0; i < 100; ++i) {
            segments.add(MemorySegmentFactory.wrap((byte[])new byte[32768]));
        }
        Tuple2<NormalizedKeyComputer, RecordComparator> tuple2 = SortCodeGeneratorTest.getSortBaseWithNulls(this.getClass().getSimpleName(), this.inputType, this.sortSpec);
        BinaryRowDataSerializer serializer = new BinaryRowDataSerializer(this.inputType.getFieldCount());
        BinaryInMemorySortBuffer sortBuffer = BinaryInMemorySortBuffer.createBuffer((NormalizedKeyComputer)((NormalizedKeyComputer)tuple2.f0), (AbstractRowDataSerializer)serializer, (BinaryRowDataSerializer)serializer, (RecordComparator)((RecordComparator)tuple2.f1), (MemorySegmentPool)new ListMemorySegmentPool(segments));
        BinaryRowData[] dataArray = this.getTestData();
        List<Object> data = Arrays.asList((Object[])dataArray.clone());
        List<Object> binaryRows = Arrays.asList((Object[])dataArray.clone());
        Collections.shuffle(binaryRows);
        for (BinaryRowData binaryRowData : binaryRows) {
            if (sortBuffer.write((RowData)binaryRowData)) continue;
            throw new RuntimeException();
        }
        new QuickSort().sort((IndexedSortable)sortBuffer);
        MutableObjectIterator iter = sortBuffer.getIterator();
        ArrayList<BinaryRowData> arrayList = new ArrayList<BinaryRowData>();
        BinaryRowData row = serializer.createInstance();
        while ((row = (BinaryRowData)iter.next((Object)row)) != null) {
            arrayList.add(row.copy());
        }
        int[] keys = this.sortSpec.getFieldIndices();
        LogicalType[] keyTypes = this.sortSpec.getFieldTypes(this.inputType);
        boolean[] orders = this.sortSpec.getAscendingOrders();
        data.sort((o1, o2) -> {
            for (int i = 0; i < keys.length; ++i) {
                LogicalType t = this.inputType.getTypeAt(keys[i]);
                boolean order = orders[i];
                Object first = null;
                Object second = null;
                RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)keyTypes[i], (int)keys[i]);
                if (!o1.isNullAt(keys[i])) {
                    first = fieldGetter.getFieldOrNull((RowData)o1);
                }
                if (!o2.isNullAt(keys[i])) {
                    second = fieldGetter.getFieldOrNull((RowData)o2);
                }
                if (first == null && second == null) continue;
                if (first == null) {
                    return order ? -1 : 1;
                }
                if (second == null) {
                    return order ? 1 : -1;
                }
                if (first instanceof Comparable) {
                    int ret = ((Comparable)first).compareTo(second);
                    if (ret == 0) continue;
                    return order ? ret : -ret;
                }
                if (t.getTypeRoot() == LogicalTypeRoot.ARRAY) {
                    BinaryArrayData leftArray = (BinaryArrayData)first;
                    BinaryArrayData rightArray = (BinaryArrayData)second;
                    int minLength = Math.min(leftArray.size(), rightArray.size());
                    for (int j = 0; j < minLength; ++j) {
                        boolean isNullLeft = leftArray.isNullAt(j);
                        boolean isNullRight = rightArray.isNullAt(j);
                        if (isNullLeft && isNullRight) continue;
                        if (isNullLeft) {
                            return order ? -1 : 1;
                        }
                        if (isNullRight) {
                            return order ? 1 : -1;
                        }
                        int comp = Byte.compare(leftArray.getByte(j), rightArray.getByte(j));
                        if (comp == 0) continue;
                        return order ? comp : -comp;
                    }
                    if (leftArray.size() < rightArray.size()) {
                        return order ? -1 : 1;
                    }
                    if (leftArray.size() <= rightArray.size()) continue;
                    return order ? 1 : -1;
                }
                if (t.getTypeRoot() == LogicalTypeRoot.VARBINARY) {
                    int comp = SortUtil.compareBinary((byte[])((byte[])first), (byte[])((byte[])second));
                    if (comp == 0) continue;
                    return order ? comp : -comp;
                }
                if (t.getTypeRoot() == LogicalTypeRoot.ROW) {
                    RowType rowType = (RowType)t;
                    int comp = ((RowType.RowField)rowType.getFields().get(0)).getType() instanceof IntType ? INT_ROW_COMP.compare(INT_ROW_CONV.toExternal(first), INT_ROW_CONV.toExternal(second)) : NEST_ROW_COMP.compare(NEST_ROW_CONV.toExternal(first), NEST_ROW_CONV.toExternal(second));
                    if (comp == 0) continue;
                    return order ? comp : -comp;
                }
                if (t.getTypeRoot() == LogicalTypeRoot.RAW) {
                    Integer i1 = (Integer)((RawValueData)first).toObject((TypeSerializer)IntSerializer.INSTANCE);
                    Integer i2 = (Integer)((RawValueData)second).toObject((TypeSerializer)IntSerializer.INSTANCE);
                    int comp = Integer.compare(i1, i2);
                    if (comp == 0) continue;
                    return order ? comp : -comp;
                }
                throw new RuntimeException();
            }
            return 0;
        });
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            builder.append("\n").append("expect: ").append(DataFormatTestUtil.rowDataToString((RowData)((RowData)data.get(i)), (RowType)this.inputType)).append("; actual: ").append(DataFormatTestUtil.rowDataToString((RowData)((RowData)arrayList.get(i)), (RowType)this.inputType));
        }
        builder.append("\n").append("types: ").append(Arrays.asList(this.inputType.getChildren()));
        builder.append("\n").append("keys: ").append(Arrays.toString(keys));
        String msg = builder.toString();
        for (int i = 0; i < data.size(); ++i) {
            for (int j = 0; j < keys.length; ++j) {
                boolean isNull1 = ((BinaryRowData)data.get(i)).isNullAt(keys[j]);
                boolean isNull2 = ((BinaryRowData)arrayList.get(i)).isNullAt(keys[j]);
                Assert.assertEquals((String)msg, (Object)isNull1, (Object)isNull2);
                if (isNull1 && isNull2) continue;
                RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)keyTypes[j], (int)keys[j]);
                Object o12 = fieldGetter.getFieldOrNull((RowData)data.get(i));
                Object o22 = fieldGetter.getFieldOrNull((RowData)arrayList.get(i));
                if (keyTypes[j] instanceof VarBinaryType) {
                    Assert.assertArrayEquals((String)msg, (byte[])((byte[])o12), (byte[])((byte[])o22));
                    continue;
                }
                if (keyTypes[j] instanceof TypeInformationRawType) {
                    Assert.assertThat((String)msg, (Object)((RawValueData)o12), (Matcher)RawValueDataAsserter.equivalent((RawValueData)((RawValueData)o22), (RawValueDataSerializer)new RawValueDataSerializer((TypeSerializer)IntSerializer.INSTANCE)));
                    continue;
                }
                Assert.assertEquals((String)msg, (Object)o12, (Object)o22);
            }
        }
    }

    public static Tuple2<NormalizedKeyComputer, RecordComparator> getSortBaseWithNulls(String namePrefix, RowType inputType, SortSpec sortSpec) {
        SortCodeGenerator generator = new SortCodeGenerator(new TableConfig(), inputType, sortSpec);
        GeneratedNormalizedKeyComputer computer = generator.generateNormalizedKeyComputer(namePrefix + "Computer");
        GeneratedRecordComparator comparator = generator.generateRecordComparator(namePrefix + "Comparator");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new Tuple2(computer.newInstance(cl), comparator.newInstance(cl));
    }
}

