/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverter;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenTest$;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator$;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.generated.WatermarkGenerator;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001=\u0011QdV1uKJl\u0017M]6HK:,'/\u0019;pe\u000e{G-Z$f]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tqaY8eK\u001e,gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002+U\u001cX\rR3gS:,GmQ8ogR\u0014Xo\u0019;peB\u0011\u0011#G\u0005\u00035I\u0011qAQ8pY\u0016\fg\u000eC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0003=\u0001\u0002\"a\b\u0001\u000e\u0003\tAQaF\u000eA\u0002aAqA\t\u0001C\u0002\u0013\u00051%\u0001\u0004d_:4\u0017nZ\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\u0011qEB\u0001\u0004CBL\u0017BA\u0015'\u0005-!\u0016M\u00197f\u0007>tg-[4\t\r-\u0002\u0001\u0015!\u0003%\u0003\u001d\u0019wN\u001c4jO\u0002Bq!\f\u0001C\u0002\u0013\u0005a&\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0004\u0002\u000f\r\fG/\u00197pO&\u0011A'\r\u0002\u000f\u0007\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s\u0011\u00191\u0004\u0001)A\u0005_\u0005y1-\u0019;bY><W*\u00198bO\u0016\u0014\b\u0005C\u00049\u0001\t\u0007I\u0011A\u001d\u0002\u001f\u0019,hn\u0019;j_:\u001c\u0015\r^1m_\u001e,\u0012A\u000f\t\u0003amJ!\u0001P\u0019\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eDaA\u0010\u0001!\u0002\u0013Q\u0014\u0001\u00054v]\u000e$\u0018n\u001c8DCR\fGn\\4!\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005\u000ba\u0002\u001d7b]:,'oQ8oi\u0016DH/F\u0001C!\t\u0019e)D\u0001E\u0015\t)E!\u0001\u0006eK2,w-\u0019;j_:L!a\u0012#\u0003\u001dAc\u0017M\u001c8fe\u000e{g\u000e^3yi\"1\u0011\n\u0001Q\u0001\n\t\u000bq\u0002\u001d7b]:,'oQ8oi\u0016DH\u000f\t\u0005\b\u000b\u0001\u0011\r\u0011\"\u0001L+\u0005a\u0005CA'Q\u001b\u0005q%BA(\u0005\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!\u0015(\u0003!\u0019c\u0017N\\6QY\u0006tg.\u001a:J[Bd\u0007BB*\u0001A\u0003%A*\u0001\u0005qY\u0006tg.\u001a:!\u0011\u0015)\u0006\u0001\"\u0001L\u0003)9W\r\u001e)mC:tWM\u001d\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0003\u0011!\u0017\r^1\u0016\u0003e\u00032AW0b\u001b\u0005Y&B\u0001/^\u0003%IW.\\;uC\ndWM\u0003\u0002_%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001\\&\u0001\u0002'jgR\u0004\"A\u00193\u000e\u0003\rT!a\u0016\u0004\n\u0005\u0015\u001c'AD$f]\u0016\u0014\u0018n\u0019*po\u0012\u000bG/\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B-\u0002\u000b\u0011\fG/\u0019\u0011\t\u000b%\u0004A\u0011\u00016\u0002-Q,7\u000f^!tG\u0016tG-\u001b8h/\u0006$XM]7be.$\u0012a\u001b\t\u0003#1L!!\u001c\n\u0003\tUs\u0017\u000e\u001e\u0015\u0003Q>\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0007\u0002\u000b),h.\u001b;\n\u0005Q\f(\u0001\u0002+fgRDQA\u001e\u0001\u0005\u0002)\fa\u0004^3ti\n{WO\u001c3fI>+Ho\u00144Pe\u0012,'oV1uKJl\u0017M]6)\u0005U|\u0007\"B=\u0001\t\u0003Q\u0017!\b;fgRdUmZ1ds\u000e+8\u000f^8nSj,GmV1uKJl\u0017M]6)\u0005a|\u0007\"\u0002?\u0001\t\u0003Q\u0017a\u0006;fgR\u001cUo\u001d;p[&TX\rZ,bi\u0016\u0014X.\u0019:lQ\tYx\u000eC\u0003}\u0001\u0011%q\u0010F\u0002l\u0003\u0003Aa!a\u0001\u007f\u0001\u0004A\u0012\u0001C5t\u0019\u0016<\u0017mY=\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n\u0005Qr-\u001a8fe\u0006$XmV1uKJl\u0017M]6HK:,'/\u0019;peR1\u00111BA\u000e\u0003k\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005hK:,'/\u0019;fI*\u0019\u0011Q\u0003\u0004\u0002\u000fI,h\u000e^5nK&!\u0011\u0011DA\b\u0005I9\u0016\r^3s[\u0006\u00148nR3oKJ\fGo\u001c:\t\u0011\u0005u\u0011Q\u0001a\u0001\u0003?\tA!\u001a=qeB!\u0011\u0011EA\u0018\u001d\u0011\t\u0019#a\u000b\u0011\u0007\u0005\u0015\"#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\b\u0002\rq\u0012xn\u001c;?\u0013\r\tiCE\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00121\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055\"\u0003\u0003\u0004\u0018\u0003\u000b\u0001\r\u0001\u0007\u0015\b\u0001\u0005e\u0012QIA$!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA c\u00061!/\u001e8oKJLA!a\u0011\u0002>\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA%!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(c\u00069!/\u001e8oKJ\u001c\u0018\u0002BA*\u0003\u001b\u0012Q\u0002U1sC6,G/\u001a:ju\u0016$waBA,\u0005!\u0005\u0011\u0011L\u0001\u001e/\u0006$XM]7be.<UM\\3sCR|'oQ8eK\u001e+g\u000eV3tiB\u0019q$a\u0017\u0007\r\u0005\u0011\u0001\u0012AA/'\r\tY\u0006\u0005\u0005\b9\u0005mC\u0011AA1)\t\tI\u0006\u0003\u0005\u0002f\u0005mC\u0011AA4\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003S\u0002R!a\u001b\u0002vai!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\u0005kRLGN\u0003\u0002\u0002t\u0005!!.\u0019<b\u0013\u0011\t9(!\u001c\u0003\u0015\r{G\u000e\\3di&|g\u000e\u000b\u0005\u0002d\u0005m\u0014\u0011RAF!\u0011\ti(a!\u000f\t\u0005-\u0013qP\u0005\u0005\u0003\u0003\u000bi%A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0003\u000b\u000b9I\u0001\u0006QCJ\fW.\u001a;feNTA!!!\u0002N\u0005!a.Y7fC\t\ti)A\rvg\u0016$UMZ5oK\u0012\u001cuN\\:ueV\u001cGo\u001c:>wBj\b")
public class WatermarkGeneratorCodeGenTest {
    private final boolean useDefinedConstructor;
    private final TableConfig config;
    private final CatalogManager catalogManager;
    private final FunctionCatalog functionCatalog;
    private final PlannerContext plannerContext;
    private final FlinkPlannerImpl planner;
    private final List<GenericRowData> data;

    @Parameterized.Parameters(name="useDefinedConstructor={0}")
    public static Collection<Object> parameters() {
        return WatermarkGeneratorCodeGenTest$.MODULE$.parameters();
    }

    public TableConfig config() {
        return this.config;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    public PlannerContext plannerContext() {
        return this.plannerContext;
    }

    public FlinkPlannerImpl planner() {
        return this.planner;
    }

    public FlinkPlannerImpl getPlanner() {
        return this.planner();
    }

    public List<GenericRowData> data() {
        return this.data;
    }

    @Test
    public void testAscendingWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '0.001' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)999L, (List)new .colon.colon(null, (List)new .colon.colon((Object)2999L, (List)new .colon.colon((Object)4999L, (List)new .colon.colon((Object)3999L, (List)new .colon.colon((Object)5999L, (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected, (Object)results);
    }

    @Test
    public void testBoundedOutOfOrderWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '5' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)-4000L, (List)new .colon.colon(null, (List)new .colon.colon((Object)-2000L, (List)new .colon.colon((Object)0L, (List)new .colon.colon((Object)-1000L, (List)new .colon.colon((Object)1000L, (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected, (Object)results);
    }

    @Test
    public void testLegacyCustomizedWatermark() {
        this.testCustomizedWatermark(true);
    }

    @Test
    public void testCustomizedWatermark() {
        this.testCustomizedWatermark(false);
    }

    private void testCustomizedWatermark(boolean isLegacy) {
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        if (isLegacy) {
            this.functionCatalog().registerTempCatalogScalarFunction(ObjectIdentifier.of((String)"default_catalog", (String)"default_database", (String)"myFunc"), (ScalarFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        } else {
            this.functionCatalog().registerTemporaryCatalogFunction(UnresolvedIdentifier.of((String[])new String[]{"default_catalog", "default_database", "myFunc"}), (FunctionDefinition)new JavaUserDefinedScalarFunctions.JavaFunc5(), false);
        }
        WatermarkGenerator generator = this.generateWatermarkGenerator("myFunc(ts, `offset`)", this.useDefinedConstructor);
        if (!this.useDefinedConstructor) {
            generator.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 1));
        }
        generator.open(new Configuration());
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        generator.close();
        .colon.colon expected = new .colon.colon((Object)995L, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)4997L, (List)new .colon.colon((Object)3990L, (List)new .colon.colon((Object)5992L, (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected, (Object)results);
        Assert.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.openCalled);
        Assert.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled);
    }

    private WatermarkGenerator generateWatermarkGenerator(String expr, boolean useDefinedConstructor) {
        WatermarkGenerator watermarkGenerator;
        RelDataType tableRowType = this.plannerContext().getTypeFactory().buildRelNodeRowType((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "offset"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalType[]{new TimestampType(3), new IntType()})));
        RowType rowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(tableRowType);
        SqlExprToRexConverter converter = ((FlinkContext)this.planner().createToRelContext().getCluster().getPlanner().getContext().unwrap(FlinkContext.class)).getSqlExprToRexConverterFactory().create(tableRowType, null);
        RexNode rexNode = converter.convertToRexNode(expr);
        if (useDefinedConstructor) {
            GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator(new TableConfig(), rowType, rexNode, Option$.MODULE$.apply((Object)"context"));
            Object[] newReferences = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(generated.getReferences())).$colon$plus((Object)new WatermarkGeneratorSupplier.Context(null){

                public MetricGroup getMetricGroup() {
                    return null;
                }
            }, ClassTag$.MODULE$.Object());
            watermarkGenerator = (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader(), new Object[]{newReferences});
        } else {
            GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator(new TableConfig(), rowType, rexNode, WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator$default$4());
            watermarkGenerator = (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader());
        }
        return watermarkGenerator;
    }

    public WatermarkGeneratorCodeGenTest(boolean useDefinedConstructor) {
        this.useDefinedConstructor = useDefinedConstructor;
        this.config = new TableConfig();
        this.catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        this.functionCatalog = new FunctionCatalog(this.config(), this.catalogManager(), new ModuleManager());
        this.plannerContext = new PlannerContext(false, this.config(), this.functionCatalog(), this.catalogManager(), CalciteSchemaBuilder.asRootSchema((Schema)new CatalogManagerCalciteSchema(this.catalogManager(), false)), Collections.singletonList(ConventionTraitDef.INSTANCE));
        this.planner = this.plannerContext().createFlinkPlanner(this.catalogManager().getCurrentCatalog(), this.catalogManager().getCurrentDatabase());
        this.data = new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)1000L), 5}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{null, 4}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)3000L), null}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)5000L), 3}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)4000L), 10}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)6000L), 8}), (List)Nil$.MODULE$))))));
    }
}

