/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.graph.GlobalStreamExchangeMode;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.junit.Assert;
import org.junit.Test;

public class DefaultExecutorTest {
    @Test
    public void testJobName() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DefaultExecutor executor = new DefaultExecutor(env);
        List<Transformation> dummyTransformations = Collections.singletonList(env.fromElements((Object[])new Integer[]{1, 2, 3}).addSink((SinkFunction)new DiscardingSink()).getTransformation());
        Configuration configuration = new Configuration();
        configuration.set(PipelineOptions.NAME, (Object)"Custom Name");
        this.testJobName(executor.createPipeline(dummyTransformations, (ReadableConfig)new Configuration(), "Default Name"), "Default Name");
        this.testJobName(executor.createPipeline(dummyTransformations, (ReadableConfig)configuration, "Default Name"), "Custom Name");
        env.configure((ReadableConfig)configuration);
        this.testJobName(executor.createPipeline(dummyTransformations, (ReadableConfig)new Configuration(), "Default Name"), "Custom Name");
    }

    @Test
    public void testDefaultBatchProperties() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DefaultExecutor executor = new DefaultExecutor(env);
        List<Transformation> dummyTransformations = Collections.singletonList(env.fromElements((Object[])new Integer[]{1, 2, 3}).addSink((SinkFunction)new DiscardingSink()).getTransformation());
        Configuration configuration = new Configuration();
        configuration.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        StreamGraph streamGraph = (StreamGraph)executor.createPipeline(dummyTransformations, (ReadableConfig)configuration, "Default Name");
        Assert.assertTrue((boolean)streamGraph.getExecutionConfig().isObjectReuseEnabled());
        Assert.assertEquals((long)0L, (long)streamGraph.getExecutionConfig().getLatencyTrackingInterval());
        Assert.assertTrue((boolean)streamGraph.isChainingEnabled());
        Assert.assertFalse((boolean)streamGraph.isAllVerticesInSameSlotSharingGroupByDefault());
        Assert.assertFalse((boolean)streamGraph.getCheckpointConfig().isCheckpointingEnabled());
        Assert.assertEquals((Object)GlobalStreamExchangeMode.ALL_EDGES_BLOCKING, (Object)streamGraph.getGlobalStreamExchangeMode());
    }

    private void testJobName(Pipeline pipeline, String expectedJobName) {
        Assert.assertEquals((Object)expectedJobName, (Object)((StreamGraph)pipeline).getJobName());
    }
}

