/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ArrayTypeTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.types.DataType;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001\u001f\ti\u0011I\u001d:bsRK\b/\u001a+fgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"BA\n\u0003\u0003\u0015)H/\u001b7t\u0013\t)\"CA\tBeJ\f\u0017\u0010V=qKR+7\u000f\u001e\"bg\u0016DQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u000bq\u0001A\u0011A\u000f\u00027Q,7\u000f^%oaV$H+\u001f9f\u000f\u0016tWM]1mSj\fG/[8o)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRD#aG\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!b\u0011!\u00026v]&$\u0018B\u0001\u0016(\u0005\u0011!Vm\u001d;\t\u000b1\u0002A\u0011A\u000f\u0002#Q,7\u000f^!se\u0006LH*\u001b;fe\u0006d7\u000f\u000b\u0002,K!)q\u0006\u0001C\u0001;\u0005qA/Z:u\u0003J\u0014\u0018-\u001f$jK2$\u0007F\u0001\u0018&\u0011\u0015\u0011\u0004\u0001\"\u0001\u001e\u0003M!Xm\u001d;BeJ\f\u0017p\u00149fe\u0006$\u0018n\u001c8tQ\t\tT\u0005C\u00036\u0001\u0011\u0005Q$\u0001\u000buKN$\u0018I\u001d:bsRK\b/Z\"bgRLgn\u001a\u0015\u0003i\u0015BQ\u0001\u000f\u0001\u0005\u0002u\t\u0011\u0005^3ti\u0006\u0013(/Y=J]\u0012,\u0007p\u0015;bi&\u001c7\t[3dW\u001a{'\u000fV1cY\u0016D#aN\u0013\t\u000bm\u0002A\u0011A\u000f\u0002?Q,7\u000f^!se\u0006L\u0018J\u001c3fqN#\u0018\r^5d\u0007\",7m\u001b$peN\u000bH\u000e\u000b\u0002;K!)a\b\u0001C\u0001;\u00059C/Z:u%\u0016$XO\u001d8Ok2dw\u000b[3o\u0003J\u0014\u0018-_%oI\u0016Dx*\u001e;PM\n{WO\u001c3tQ\tiT\u0005")
public class ArrayTypeTest
extends ArrayTypeTestBase {
    @Test
    public void testInputTypeGeneralization() {
        this.testAllApis(package$.MODULE$.array(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.double2Literal(2.0), package$.MODULE$.double2Literal(3.0)})), "array(1, 2.0, 3.0)", "ARRAY[1, cast(2.0 AS DOUBLE), cast(3.0 AS DOUBLE)]", "[1.0, 2.0, 3.0]");
    }

    @Test
    public void testArrayLiterals() {
        this.testAllApis(package$.MODULE$.array(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(2), package$.MODULE$.int2Literal(3)})), "array(1, 2, 3)", "ARRAY[1, 2, 3]", "[1, 2, 3]");
        this.testAllApis(package$.MODULE$.array(package$.MODULE$.boolean2Literal(true), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.boolean2Literal(true), package$.MODULE$.boolean2Literal(true)})), "array(true, true, true)", "ARRAY[TRUE, TRUE, TRUE]", "[true, true, true]");
        this.testTableApi(package$.MODULE$.array(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1))})), "array(1p, 1p)", "[1, 1]");
        this.testAllApis(package$.MODULE$.array(package$.MODULE$.array(package$.MODULE$.array(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.array(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "array(array(array(1), array(1)))", "ARRAY[ARRAY[ARRAY[1], ARRAY[1]]]", "[[[1], [1]]]");
        this.testAllApis(package$.MODULE$.array(package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(9)})), "array(1 + 1, 3 * 3)", "ARRAY[1 + 1, 3 * 3]", "[2, 9]");
        this.testAllApis(package$.MODULE$.array(package$.MODULE$.nullOf(DataTypes.INT()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(1)})), "array(Null(INT), 1)", "ARRAY[NULLIF(1,1), 1]", "[null, 1]");
        this.testAllApis(package$.MODULE$.array(package$.MODULE$.array(package$.MODULE$.nullOf(DataTypes.INT()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(1)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "array(array(Null(INT), 1))", "ARRAY[ARRAY[NULLIF(1,1), 1]]", "[[null, 1]]");
        this.testTableApi(package$.MODULE$.array2ArrayConstructor((Object)new int[]{1, 2, 3}), "array(1, 2, 3)", "[1, 2, 3]");
        this.testTableApi(package$.MODULE$.array2ArrayConstructor((Object)new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}), "array(1, 2, 3)", "[1, 2, 3]");
        this.testAllApis(package$.MODULE$.array2ArrayConstructor((Object)new LocalDate[]{DateTimeTestUtil$.MODULE$.localDate("1985-04-11"), DateTimeTestUtil$.MODULE$.localDate("2018-07-26")}), "array('1985-04-11'.toDate, '2018-07-26'.toDate)", "ARRAY[DATE '1985-04-11', DATE '2018-07-26']", "[1985-04-11, 2018-07-26]");
        this.testAllApis(package$.MODULE$.array2ArrayConstructor((Object)new LocalTime[]{DateTimeTestUtil$.MODULE$.localTime("14:15:16"), DateTimeTestUtil$.MODULE$.localTime("17:18:19")}), "array('14:15:16'.toTime, '17:18:19'.toTime)", "ARRAY[TIME '14:15:16', TIME '17:18:19']", "[14:15:16, 17:18:19]");
        this.testTableApi(package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{DateTimeTestUtil$.MODULE$.localDateTime("1985-04-11 14:15:16"), DateTimeTestUtil$.MODULE$.localDateTime("2018-07-26 17:18:19")}), "[1985-04-11 14:15:16, 2018-07-26 17:18:19]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16', TIMESTAMP '2018-07-26 17:18:19']", "[1985-04-11 14:15:16, 2018-07-26 17:18:19]");
        this.testTableApi(package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123456789), LocalDateTime.of(2018, 7, 26, 17, 18, 19, 123456789)}), "[1985-04-11 14:15:16.123456789, 2018-07-26 17:18:19.123456789]");
        this.testTableApi(package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123456700), LocalDateTime.of(2018, 7, 26, 17, 18, 19, 123456700)}), "[1985-04-11 14:15:16.1234567, 2018-07-26 17:18:19.1234567]");
        this.testTableApi(package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123456000), LocalDateTime.of(2018, 7, 26, 17, 18, 19, 123456000)}), "[1985-04-11 14:15:16.123456, 2018-07-26 17:18:19.123456]");
        this.testTableApi(package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123400000), LocalDateTime.of(2018, 7, 26, 17, 18, 19, 123400000)}), "[1985-04-11 14:15:16.1234, 2018-07-26 17:18:19.1234]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16.123456789', TIMESTAMP '2018-07-26 17:18:19.123456789']", "[1985-04-11 14:15:16.123456789, 2018-07-26 17:18:19.123456789]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16.1234567', TIMESTAMP '2018-07-26 17:18:19.1234567']", "[1985-04-11 14:15:16.1234567, 2018-07-26 17:18:19.1234567]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16.123456', TIMESTAMP '2018-07-26 17:18:19.123456']", "[1985-04-11 14:15:16.123456, 2018-07-26 17:18:19.123456]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16.1234', TIMESTAMP '2018-07-26 17:18:19.1234']", "[1985-04-11 14:15:16.1234, 2018-07-26 17:18:19.1234]");
        this.testAllApis(package$.MODULE$.array2ArrayConstructor((Object)new BigDecimal[]{scala.package$.MODULE$.BigDecimal().apply(2.0002), scala.package$.MODULE$.BigDecimal().apply(2.0003)}), "Array(2.0002p, 2.0003p)", "ARRAY[CAST(2.0002 AS DECIMAL(10,4)), CAST(2.0003 AS DECIMAL(10,4))]", "[2.0002, 2.0003]");
        this.testAllApis(package$.MODULE$.array2ArrayConstructor((Object)((Object[])new boolean[][]{{true}})), "Array(Array(true))", "ARRAY[ARRAY[TRUE]]", "[[true]]");
        this.testAllApis(package$.MODULE$.array2ArrayConstructor((Object)((Object[])new int[][]{{1, 2, 3}, {3, 2, 1}})), "Array(Array(1, 2, 3), Array(3, 2, 1))", "ARRAY[ARRAY[1, 2, 3], ARRAY[3, 2, 1]]", "[[1, 2, 3], [3, 2, 1]]");
        this.testSqlApi("ARRAY[CAST(1 AS DOUBLE), CAST(2 AS FLOAT)]", "[1.0, 2.0]");
    }

    @Test
    public void testArrayField() {
        this.testAllApis(package$.MODULE$.array(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))})), "array(f0, f1)", "ARRAY[f0, f1]", "[null, 42]");
        this.testAllApis(package$.MODULE$.array(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))})), "array(f0, f1)", "ARRAY[f0, f1]", "[null, 42]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "f2", "[1, 2, 3]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), "f3", "f3", "[1984-03-12, 1984-02-10]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")), "f5", "f5", "[[1, 2, 3], null]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")), "f6", "f6", "[1, null, null, 4]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "f2", "[1, 2, 3]");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.int2Literal(1)), "f2.at(1)", "f2[1]", "1");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at((Object)package$.MODULE$.int2Literal(1)), "f3.at(1)", "f3[1]", "1984-03-12");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at((Object)package$.MODULE$.int2Literal(2)), "f3.at(2)", "f3[2]", "1984-02-10");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at((Object)package$.MODULE$.int2Literal(1))).at((Object)package$.MODULE$.int2Literal(2)), "f5.at(1).at(2)", "f5[1][2]", "2");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at((Object)package$.MODULE$.int2Literal(2))).at((Object)package$.MODULE$.int2Literal(2)), "f5.at(2).at(2)", "f5[2][2]", "null");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).at((Object)package$.MODULE$.int2Literal(2))).at((Object)package$.MODULE$.int2Literal(2)), "f4.at(2).at(2)", "f4[2][2]", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).at((Object)package$.MODULE$.int2Literal(1)), "f11.at(1)", "f11[1]", "1");
    }

    @Test
    public void testArrayOperations() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cardinality(), "f2.cardinality()", "CARDINALITY(f2)", "3");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cardinality(), "f4.cardinality()", "CARDINALITY(f4)", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).cardinality(), "f11.cardinality()", "CARDINALITY(f11)", "1");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")).element(), "f9.element()", "ELEMENT(f9)", "1");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).element(), "f8.element()", "ELEMENT(f8)", "4.0");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).element(), "f10.element()", "ELEMENT(f10)", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).element(), "f4.element()", "ELEMENT(f4)", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).element(), "f11.element()", "ELEMENT(f11)", "1");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$eq$eq$eq((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at((Object)package$.MODULE$.int2Literal(1))), "f2 === f5.at(1)", "f2 = f5[1]", "true");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$eq$eq$eq(package$.MODULE$.array(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(2), package$.MODULE$.int2Literal(3)}))), "f6 === array(1, 2, 3)", "f6 = ARRAY[1, 2, 3]", "false");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$bang$eq$eq((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at((Object)package$.MODULE$.int2Literal(1))), "f2 !== f5.at(1)", "f2 <> f5[1]", "false");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f2 === f7", "f2 = f7", "false");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f2 !== f7", "f2 <> f7", "true");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11"))), "f11 === f11", "f11 = f11", "true");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9"))), "f11 === f9", "f11 = f9", "true");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11"))), "f11 !== f11", "f11 <> f11", "false");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9"))), "f11 !== f9", "f11 <> f9", "false");
    }

    @Test
    public void testArrayTypeCasting() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cast(DataTypes.ARRAY((DataType)DataTypes.DATE())), "f3.cast(OBJECT_ARRAY(SQL_DATE))", "[1984-03-12, 1984-02-10]");
    }

    @Test
    public void testArrayIndexStaticCheckForTable() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Array element access needs an index starting at 1 but was 0.");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.int2Literal(0)), "1");
    }

    @Test
    public void testArrayIndexStaticCheckForSql() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Array element access needs an index starting at 1 but was 0.");
        this.testSqlApi("f2[0]", "1");
    }

    @Test
    public void testReturnNullWhenArrayIndexOutOfBounds() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.int2Literal(4)), "f2.at(4)", "f2[4]", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).at((Object)package$.MODULE$.int2Literal(3)), "f11.at(3)", "f11[4]", "null");
    }
}

