/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Double$;
import scala.Float$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001=\u0011q\u0002R3dS6\fGnQ1tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\ba2\fgN\\3s\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0005M\u0011\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005I)\u0005\u0010\u001d:fgNLwN\u001c+fgR\u0014\u0015m]3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\u0004e:$W#\u0001\u0010\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013\u0001B;uS2T\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\u0001\u0012aAU1oI>l\u0007BB\u0014\u0001A\u0003%a$\u0001\u0003s]\u0012\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013a\u0005;fgR\u001c\u0015m\u001d;Ge>lg*^7fe&\u001cG#A\u0016\u0011\u00051jS\"\u0001\u0012\n\u00059\u0012#\u0001B+oSRD#\u0001\u000b\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005Mb\u0011!\u00026v]&$\u0018BA\u001b3\u0005\u0011!Vm\u001d;\t\u000b]\u0002A\u0011\u0001\u0016\u0002#Q,7\u000f^\"bgR4%o\\7GY>\fG\u000f\u000b\u00027a!)!\b\u0001C\u0001U\u0005\u0011B/Z:u\u0007\u0006\u001cHO\u0012:p[N#(/\u001b8hQ\tI\u0004\u0007C\u0003>\u0001\u0011\u0005!&A\nuKN$8)Y:u\rJ|WNQ8pY\u0016\fg\u000e\u000b\u0002=a!)\u0001\t\u0001C\u0001U\u0005\tB/Z:u\u0007\u0006\u001cH\u000fV8Ok6,'/[2)\u0005}\u0002\u0004\"B\"\u0001\t\u0003Q\u0013a\u0004;fgR\u001c\u0015m\u001d;U_\u001acw.\u0019;)\u0005\t\u0003\u0004\"\u0002$\u0001\t\u0003Q\u0013\u0001\u0005;fgR\u001c\u0015m\u001d;U_N#(/\u001b8hQ\t)\u0005\u0007C\u0003J\u0001\u0011\u0005!&A\tuKN$8)Y:u)>\u0014un\u001c7fC:D#\u0001\u0013\u0019\t\u000b1\u0003A\u0011\u0001\u0016\u0002#Q,7\u000f^\"bgR$v\u000eR3dS6\fG\u000e\u000b\u0002La!)q\n\u0001C\u0005!\u0006)B/Z:u+:\u001cX\u000f\u001d9peR,GmQ1tiR{GCA\u0016R\u0011\u0015\u0011f\n1\u0001T\u0003\u0005!\bC\u0001+\\\u001d\t)\u0016\f\u0005\u0002WE5\tqK\u0003\u0002Y\u001d\u00051AH]8pizJ!A\u0017\u0012\u0002\rA\u0013X\rZ3g\u0013\taVL\u0001\u0004TiJLgn\u001a\u0006\u00035\nBQa\u0018\u0001\u0005\u0002)\n\u0001\u0003^3ti\u000e\u000b7\u000f\u001e+p\u0005&t\u0017M]=)\u0005y\u0003\u0004\"\u00022\u0001\t\u0003Q\u0013a\u0005;fgR\u001c\u0015m\u001d;U_Z\u000b'OQ5oCJL\bFA11\u0011\u0015)\u0007\u0001\"\u0001+\u00039!Xm\u001d;DCN$Hk\u001c#bi\u0016D#\u0001\u001a\u0019\t\u000b!\u0004A\u0011\u0001\u0016\u0002\u001dQ,7\u000f^\"bgR$v\u000eV5nK\"\u0012q\r\r\u0005\u0006W\u0002!\tAK\u0001\u0014i\u0016\u001cHoQ1tiR{G+[7fgR\fW\u000e\u001d\u0015\u0003UBBQA\u001c\u0001\u0005\u0002)\nQ\u0003^3ti\u000e\u000b7\u000f\u001e+p)&lWm\u001d;b[Bd%\u0010\u000b\u0002na!)\u0011\u000f\u0001C\u0001U\u0005yA/Z:u\u0007\u0006\u001cH\u000fV8BeJ\f\u0017\u0010\u000b\u0002qa!)A\u000f\u0001C\u0001U\u0005\u0011B/Z:u\u0007\u0006\u001cH\u000fV8Nk2$\u0018nU3uQ\t\u0019\b\u0007C\u0003x\u0001\u0011\u0005!&A\u0007uKN$8)Y:u)>l\u0015\r\u001d\u0015\u0003mBBQA\u001f\u0001\u0005\u0002)\nQ\u0002^3ti\u000e\u000b7\u000f\u001e+p%><\bFA=1\u0011\u0015i\b\u0001\"\u0003\u007f\u0003]!Xm\u001d;V]N,\b\u000f]8si\u0016$7)Y:u\rJ|W\u000e\u0006\u0002,\u007f\")!\u000b a\u0001'\"1\u00111\u0001\u0001\u0005\u0002)\n!\u0003^3ti\u000e\u000b7\u000f\u001e$s_6\u0014\u0015N\\1ss\"\u001a\u0011\u0011\u0001\u0019\t\r\u0005%\u0001\u0001\"\u0001+\u0003U!Xm\u001d;DCN$hI]8n-\u0006\u0014()\u001b8befD3!a\u00021\u0011\u0019\ty\u0001\u0001C\u0001U\u0005\u0001B/Z:u\u0007\u0006\u001cHO\u0012:p[\u0012\u000bG/\u001a\u0015\u0004\u0003\u001b\u0001\u0004BBA\u000b\u0001\u0011\u0005!&\u0001\tuKN$8)Y:u\rJ|W\u000eV5nK\"\u001a\u00111\u0003\u0019\t\r\u0005m\u0001\u0001\"\u0001+\u0003U!Xm\u001d;DCN$hI]8n)&lWm\u001d;b[BD3!!\u00071\u0011\u0019\t\t\u0003\u0001C\u0001U\u00059B/Z:u\u0007\u0006\u001cHO\u0012:p[RKW.Z:uC6\u0004HJ\u001f\u0015\u0004\u0003?\u0001\u0004BBA\u0014\u0001\u0011\u0005!&A\tuKN$8)Y:u\rJ|W.\u0011:sCfD3!!\n1\u0011\u0019\ti\u0003\u0001C\u0001U\u0005!B/Z:u\u0007\u0006\u001cHO\u0012:p[6+H\u000e^5TKRD3!a\u000b1\u0011\u0019\t\u0019\u0004\u0001C\u0001U\u0005yA/Z:u\u0007\u0006\u001cHO\u0012:p[6\u000b\u0007\u000fK\u0002\u00022ABa!!\u000f\u0001\t\u0003Q\u0013a\u0004;fgR\u001c\u0015m\u001d;Ge>l'k\\<)\u0007\u0005]\u0002\u0007C\u0004\u0002@\u0001!\t!!\u0011\u0002\u001b\u0011,7-[7bY~\u001b\u0004hX\u00199)\r\u0019\u00161\t\u0005\t\u0003\u000b\ni\u00041\u0001\u0002H\u0005\t\u0011\u000eE\u0002-\u0003\u0013J1!a\u0013#\u0005\r\te.\u001f\u0005\b\u0003\u001f\u0002A\u0011AA)\u00031!WmY5nC2|6\u0007O03)\r\u0019\u00161\u000b\u0005\t\u0003\u000b\ni\u00051\u0001\u0002H!9\u0011q\u000b\u0001\u0005B\u0005e\u0013\u0001\u0003;fgR$\u0015\r^1\u0016\u0005\u0005m\u0003\u0003BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u0005\u0004\"A\u0003usB,7/\u0003\u0003\u0002f\u0005}#a\u0001*po\"9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0014\u0001\u0003;za\u0016LeNZ8\u0016\u0005\u00055\u0004\u0003BA8\u0003{j!!!\u001d\u000b\t\u0005M\u0014QO\u0001\nif\u0004X-\u001e;jYNTA!a\u001e\u0002z\u0005!!.\u0019<b\u0015\r\tY\bC\u0001\u0004CBL\u0017\u0002BA@\u0003c\u00121BU8x)f\u0004X-\u00138g_\u0002")
public class DecimalCastTest
extends ExpressionTestBase {
    private final Random rnd = new Random();

    public Random rnd() {
        return this.rnd;
    }

    @Test
    public void testCastFromNumeric() {
        this.test$1("TINYINT", BoxesRunTime.boxToByte((byte)127), BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToByte((byte)((byte)this.rnd().nextInt())));
        this.test$1("SMALLINT", BoxesRunTime.boxToShort((short)Short.MAX_VALUE), BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToShort((short)((short)this.rnd().nextInt())));
        this.test$1("INT", BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)this.rnd().nextInt()));
        this.test$1("BIGINT", BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToLong((long)this.rnd().nextLong()));
    }

    @Test
    public void testCastFromFloat() {
        this.test$2("FLOAT", BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), BoxesRunTime.boxToFloat((float)Float$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)this.rnd().nextInt()));
        this.test$2("DOUBLE", BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)this.rnd().nextInt()));
    }

    @Test
    public void testCastFromString() {
        this.testSqlApi("CAST(CAST(null AS VARCHAR) AS DECIMAL)", "null");
        this.testSqlApi("CAST(CAST(null AS CHAR) AS DECIMAL)", "null");
        this.testSqlApi("CAST('0' AS DECIMAL)", "0");
        this.testSqlApi("CAST(CAST('12.2' AS VARCHAR) AS DECIMAL)", "12");
        this.testSqlApi("CAST('-12.2' AS DECIMAL)", "-12");
        int rV = this.rnd().nextInt();
        this.testSqlApi(new StringBuilder(26).append("CAST('").append(rV).append("' AS DECIMAL(38, 0))").toString(), ((Object)BoxesRunTime.boxToInteger((int)rV)).toString());
        this.testSqlApi("CAST('100' AS DECIMAL(2, 0))", "null");
        this.testSqlApi("CAST('x100' AS DECIMAL(2, 0))", "null");
        this.testSqlApi("CAST('100x' AS DECIMAL(2, 0))", "null");
    }

    @Test
    public void testCastFromBoolean() {
        this.testSqlApi("CAST(CAST(null AS BOOLEAN) AS DECIMAL)", "null");
        this.testSqlApi("CAST(true AS DECIMAL)", "1");
        this.testSqlApi("CAST(false AS DECIMAL)", "0");
    }

    @Test
    public void testCastToNumeric() {
        this.test$3("TINYINT", BoxesRunTime.boxToByte((byte)127), BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToByte((byte)((byte)this.rnd().nextInt())));
        this.test$3("SMALLINT", BoxesRunTime.boxToShort((short)Short.MAX_VALUE), BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToShort((short)((short)this.rnd().nextInt())));
        this.test$3("INT", BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)this.rnd().nextInt()));
        this.test$3("BIGINT", BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToLong((long)this.rnd().nextLong()));
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToInteger((int)128))).append(" AS TINYINT)").toString(), "-128");
        this.testSqlApi(new StringBuilder(18).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToInteger((int)32768))).append(" AS SMALLINT)").toString(), "-32768");
        this.testSqlApi(new StringBuilder(13).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToLong((long)0x80000000L))).append(" AS INT)").toString(), "-2147483648");
        this.testSqlApi(new StringBuilder(16).append("CAST(").append(this.decimal_38_18(package$.MODULE$.BigDecimal().apply(Long.MAX_VALUE).$plus(BigDecimal$.MODULE$.int2bigDecimal(1)))).append(" AS BIGINT)").toString(), "-9223372036854775808");
    }

    @Test
    public void testCastToFloat() {
        this.test$4("FLOAT");
        this.test$4("DOUBLE");
    }

    @Test
    public void testCastToString() {
        this.test$5("VARCHAR");
        this.test$5("CHAR");
    }

    @Test
    public void testCastToBoolean() {
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(this.decimal_38_2(null)).append(" AS BOOLEAN)").toString(), "null");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToInteger((int)0))).append(" AS BOOLEAN)").toString(), "false");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToInteger((int)1))).append(" AS BOOLEAN)").toString(), "true");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)12.2))).append(" AS BOOLEAN)").toString(), "true");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)-12.2))).append(" AS BOOLEAN)").toString(), "true");
    }

    @Test
    public void testCastToDecimal() {
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(this.decimal_38_2(null)).append(" AS DECIMAL)").toString(), "null");
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToInteger((int)0))).append(" AS DECIMAL(1, 1))").toString(), "0.0");
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)6.32))).append(" AS DECIMAL(3, 2))").toString(), "6.32");
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)236.2))).append(" AS DECIMAL(2, 1))").toString(), "null");
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.22))).append(" AS DECIMAL(2, 1))").toString(), "5.2");
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.26))).append(" AS DECIMAL(2, 1))").toString(), "5.3");
    }

    private void testUnsupportedCastTo(String t) {
        this.expectedException().expectMessage("Cast function cannot convert value of type DECIMAL(38, 2) to type");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.22))).append(" AS ").append(t).append(")").toString(), "");
    }

    @Test
    public void testCastToBinary() {
        this.testUnsupportedCastTo("BINARY(4)");
    }

    @Test
    public void testCastToVarBinary() {
        this.testUnsupportedCastTo("VARBINARY");
    }

    @Test
    public void testCastToDate() {
        this.testUnsupportedCastTo("DATE");
    }

    @Test
    public void testCastToTime() {
        this.testUnsupportedCastTo("TIME");
    }

    @Test
    public void testCastToTimestamp() {
        this.expectedException().expectMessage("The cast conversion from NUMERIC type to TIMESTAMP type is not allowed, it's recommended to use TO_TIMESTAMP(FROM_UNIXTIME(numeric_col)) instead, note the numeric is in seconds");
        this.testSqlApi(new StringBuilder(19).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.22))).append(" AS TIMESTAMP)").toString(), "");
    }

    @Test
    public void testCastToTimestampLz() {
        this.expectedException().expectMessage("The cast conversion from NUMERIC type to TIMESTAMP_LTZ type is not allowed, it's recommended to use TO_TIMESTAMP_LTZ(numeric_col, precision) instead");
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.22))).append(" AS TIMESTAMP_LTZ)").toString(), "");
    }

    @Test
    public void testCastToArray() {
        this.testUnsupportedCastTo("ARRAY<INT>");
    }

    @Test
    public void testCastToMultiSet() {
        this.testUnsupportedCastTo("MULTISET<INT>");
    }

    @Test
    public void testCastToMap() {
        this.testUnsupportedCastTo("MAP<INT, INT>");
    }

    @Test
    public void testCastToRow() {
        this.testUnsupportedCastTo("ROW<i INT, j INT>");
    }

    private void testUnsupportedCastFrom(String t) {
        this.expectedException().expectMessage("Cast function cannot convert value of type");
        this.testSqlApi(new StringBuilder(38).append("CAST(CAST(NULL AS ").append(t).append(") AS DECIMAL(38, 2))").toString(), "");
    }

    @Test
    public void testCastFromBinary() {
        this.testUnsupportedCastFrom("BINARY(4)");
    }

    @Test
    public void testCastFromVarBinary() {
        this.testUnsupportedCastFrom("VARBINARY");
    }

    @Test
    public void testCastFromDate() {
        this.testUnsupportedCastFrom("DATE");
    }

    @Test
    public void testCastFromTime() {
        this.testUnsupportedCastFrom("TIME");
    }

    @Test
    public void testCastFromTimestamp() {
        this.expectedException().expectMessage("The cast conversion from TIMESTAMP type to NUMERIC type is not allowed, it's recommended to use UNIX_TIMESTAMP(CAST(timestamp_col AS STRING)) instead");
        this.testSqlApi("CAST(TIMESTAMP '2020-02-02' AS DECIMAL(38, 2))", "");
    }

    @Test
    public void testCastFromTimestampLz() {
        this.expectedException().expectMessage("The cast conversion from TIMESTAMP_LTZ type to NUMERIC type is not allowed.");
        this.testSqlApi("CAST(CAST('2020-02-02' AS TIMESTAMP_LTZ) AS DECIMAL(38, 2))", "");
    }

    @Test
    public void testCastFromArray() {
        this.testUnsupportedCastFrom("ARRAY<INT>");
    }

    @Test
    public void testCastFromMultiSet() {
        this.testUnsupportedCastFrom("MULTISET<INT>");
    }

    @Test
    public void testCastFromMap() {
        this.testUnsupportedCastFrom("MAP<INT, INT>");
    }

    @Test
    public void testCastFromRow() {
        this.testUnsupportedCastFrom("ROW<i INT, j INT>");
    }

    public String decimal_38_18(Object i) {
        return new StringBuilder(27).append("CAST('").append(i).append("' AS DECIMAL(38, 18))").toString();
    }

    public String decimal_38_2(Object i) {
        return new StringBuilder(26).append("CAST('").append(i).append("' AS DECIMAL(38, 2))").toString();
    }

    @Override
    public Row testData() {
        return new Row(0);
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo(new TypeInformation[0]);
    }

    private static final String value$1(Object i, String t$1) {
        return new StringBuilder(10).append("CAST(").append(i).append(" AS ").append(t$1).append(")").toString();
    }

    private final void test$1(String t, Object max, Object min, Object rV) {
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(DecimalCastTest.value$1(null, t)).append(" AS DECIMAL)").toString(), "null");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(DecimalCastTest.value$1(BoxesRunTime.boxToInteger((int)0), t)).append(" AS DECIMAL)").toString(), "0");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(DecimalCastTest.value$1(BoxesRunTime.boxToInteger((int)12), t)).append(" AS DECIMAL)").toString(), "12");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(DecimalCastTest.value$1(BoxesRunTime.boxToInteger((int)-12), t)).append(" AS DECIMAL)").toString(), "-12");
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$1(max, t)).append(" AS DECIMAL(20, 0))").toString(), max.toString());
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$1(min, t)).append(" AS DECIMAL(20, 0))").toString(), min.toString());
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$1(rV, t)).append(" AS DECIMAL(20, 0))").toString(), rV.toString());
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(DecimalCastTest.value$1(BoxesRunTime.boxToInteger((int)100), t)).append(" AS DECIMAL(2, 0))").toString(), "null");
    }

    private static final String value$2(Object i, String t$2) {
        return new StringBuilder(10).append("CAST(").append(i).append(" AS ").append(t$2).append(")").toString();
    }

    private final void test$2(String t, Object max, Object min, Object rV) {
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(DecimalCastTest.value$2(null, t)).append(" AS DECIMAL)").toString(), "null");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToInteger((int)0), t)).append(" AS DECIMAL)").toString(), "0");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToDouble((double)12.2), t)).append(" AS DECIMAL)").toString(), "12");
        this.testSqlApi(new StringBuilder(17).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToDouble((double)-12.2), t)).append(" AS DECIMAL)").toString(), "-12");
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$2(max, t)).append(" AS DECIMAL(38, 0))").toString(), "null");
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$2(min, t)).append(" AS DECIMAL(38, 0))").toString(), "null");
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$2(rV, t)).append(" AS DECIMAL(38, 0))").toString(), rV.toString());
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToInteger((int)100), t)).append(" AS DECIMAL(2, 0))").toString(), "null");
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToFloat((float)6.8242f), t)).append(" AS DECIMAL(10, 4))").toString(), "6.8242");
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToFloat((float)6.8242f), t)).append(" AS DECIMAL(10, 3))").toString(), "6.824");
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToFloat((float)6.8247f), t)).append(" AS DECIMAL(10, 3))").toString(), "6.825");
        this.testSqlApi(new StringBuilder(24).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToFloat((float)6.82f), t)).append(" AS DECIMAL(10, 5))").toString(), "6.82000");
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToFloat((float)6.82f), t)).append(" AS DECIMAL(5, 5))").toString(), "null");
        this.testSqlApi(new StringBuilder(23).append("CAST(").append(DecimalCastTest.value$2(BoxesRunTime.boxToFloat((float)66.82f), t)).append(" AS DECIMAL(5, 4))").toString(), "null");
    }

    private final void test$3(String t, Object max, Object min, Object rV) {
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(null)).append(" AS ").append(t).append(")").toString(), "null");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToInteger((int)0))).append(" AS ").append(t).append(")").toString(), "0");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToInteger((int)12))).append(" AS ").append(t).append(")").toString(), "12");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToInteger((int)-12))).append(" AS ").append(t).append(")").toString(), "-12");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(max)).append(" AS ").append(t).append(")").toString(), max.toString());
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(min)).append(" AS ").append(t).append(")").toString(), min.toString());
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(rV)).append(" AS ").append(t).append(")").toString(), rV.toString());
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToDouble((double)5.26))).append(" AS ").append(t).append(")").toString(), "5");
    }

    private final void test$4(String t) {
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(null)).append(" AS ").append(t).append(")").toString(), "null");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToInteger((int)0))).append(" AS ").append(t).append(")").toString(), "0.0");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToDouble((double)12.2))).append(" AS ").append(t).append(")").toString(), "12.2");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToDouble((double)-12.2))).append(" AS ").append(t).append(")").toString(), "-12.2");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_18(BoxesRunTime.boxToDouble((double)5.26))).append(" AS ").append(t).append(")").toString(), "5.26");
    }

    private final void test$5(String t) {
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_2(null)).append(" AS ").append(t).append(")").toString(), "null");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToInteger((int)0))).append(" AS ").append(t).append(")").toString(), "0.00");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)12.2))).append(" AS ").append(t).append(")").toString(), "12.20");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)-12.2))).append(" AS ").append(t).append(")").toString(), "-12.20");
        this.testSqlApi(new StringBuilder(10).append("CAST(").append(this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.26))).append(" AS ").append(t).append(")").toString(), "5.26");
    }
}

