/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.RowTypeTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001f\tY!k\\<UsB,G+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\u001d\u0001H.\u00198oKJT!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\u00111CA\u0001\u0006kRLGn]\u0005\u0003+I\u0011qBU8x)f\u0004X\rV3ti\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\ta\u0002^3tiJ{w\u000fT5uKJ\fG\u000eF\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0011)f.\u001b;)\u0005m)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\r\u0003\u0015QWO\\5u\u0013\tQsE\u0001\u0003UKN$\b\"\u0002\u0017\u0001\t\u0003i\u0012\u0001\u0004;fgR\u0014vn\u001e$jK2$\u0007FA\u0016&\u0011\u0015y\u0003\u0001\"\u0001\u001e\u0003E!Xm\u001d;S_^|\u0005/\u001a:bi&|gn\u001d\u0015\u0003]\u0015BQA\r\u0001\u0005\u0002u\t1\u0004^3tiVs7/\u001e9q_J$X\rZ\"bgR$\u0016M\u00197f\u0003BL\u0007FA\u0019&\u0011\u0015)\u0004\u0001\"\u0001\u001e\u0003e!Xm\u001d;V]N,\b\u000f]8si\u0016$7)Y:u'Fd\u0017\t]5)\u0005Q*\u0003")
public class RowTypeTest
extends RowTypeTestBase {
    @Test
    public void testRowLiteral() {
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("foo"), package$.MODULE$.boolean2Literal(true)})), "row(1, 'foo', true)", "ROW(1, 'foo', true)", "(1,foo,true)");
        this.testTableApi(package$.MODULE$.row(package$.MODULE$.localDate2Literal(DateTimeTestUtil$.MODULE$.localDate("1985-04-11")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.localTime2Literal(DateTimeTestUtil$.MODULE$.localTime("14:15:16")), package$.MODULE$.localDateTime2Literal(DateTimeTestUtil$.MODULE$.localDateTime("1985-04-11 14:15:16")), package$.MODULE$.javaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("0.1").bigDecimal()), package$.MODULE$.array(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(2), package$.MODULE$.int2Literal(3)})), package$.MODULE$.map(package$.MODULE$.string2Literal("foo"), package$.MODULE$.string2Literal("bar"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), package$.MODULE$.row(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.boolean2Literal(true)}))})), "(1985-04-11,14:15:16,1985-04-11 14:15:16,0.1,[1, 2, 3],{foo=bar},(1,true))");
        this.testSqlApi("ROW(DATE '1985-04-11', TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16', CAST(0.1 AS DECIMAL(2, 1)), ARRAY[1, 2, 3], MAP['foo', 'bar'], row(1, true))", "(1985-04-11,14:15:16,1985-04-11 14:15:16,0.1,[1, 2, 3],{foo=bar},(1,true))");
        this.testSqlApi("ROW(DATE '1985-04-11', TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16.123456', CAST(0.1 AS DECIMAL(2, 1)), ARRAY[1, 2, 3], MAP['foo', 'bar'], row(1, true))", "(1985-04-11,14:15:16,1985-04-11 14:15:16.123456,0.1,[1, 2, 3],{foo=bar},(1,true))");
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(6), package$.MODULE$.nullOf(DataTypes.STRING())})), "row(1 + 1, 2 * 3, Null(STRING))", "ROW(1 + 1, 2 * 3, NULLIF(1, 1))", "(2,6,null)");
        this.testSqlApi("(1, 'foo', true)", "(1,foo,true)");
    }

    @Test
    public void testRowField() {
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))})), "row(f0, f1)", "(f0, f1)", "(null,1)");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "f2", "(2,foo,true)");
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))})), "row(f2, f5)", "(f2, f5)", "((2,foo,true),(foo,null))");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), "f4", "f4", "(1984-03-12,0.00000000,[1, 2, 3])");
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("foo"), package$.MODULE$.boolean2Literal(true)})), "row(f1, 'foo', true)", "(f1, 'foo',true)", "(1,foo,true)");
    }

    @Test
    public void testRowOperations() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).get("f0"), "f5.get('f0')", "f5.f0", "foo");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).get("f1")).get("f2"), "f3.get('f1').get('f2')", "f3.f1.f2", "true");
        this.testTableApi((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.row(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))}))).get("f1")).get("f1"), "row(f1, f6, f2).get('f1').get('f1')", "null");
    }

    @Test
    public void testUnsupportedCastTableApi() {
        this.expectedException().expect(ValidationException.class);
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).cast(DataTypes.BIGINT()), "");
    }

    @Test
    public void testUnsupportedCastSqlApi() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Cast function cannot convert value");
        this.testSqlApi("CAST(f5 AS BIGINT)", "");
    }
}

