/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionParser;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqOptimized;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0011Mf!B\u0001\u0003\u0003\u0003\t\"AE#yaJ,7o]5p]R+7\u000f\u001e\"bg\u0016T!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u00151\u0011aC3yaJ,7o]5p]NT!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0019\u0019wN\u001c4jOV\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$\u0011\u0005\u0019\u0011\r]5\n\u0005\u0015\u0012#a\u0003+bE2,7i\u001c8gS\u001eDaa\n\u0001!\u0002\u0013\u0001\u0013aB2p]\u001aLw\r\t\u0005\bS\u0001\u0011\r\u0011\"\u0003+\u0003)1\u0018\r\\5e\u000bb\u0004(o]\u000b\u0002WA\u0019A&M\u001a\u000e\u00035R!AL\u0018\u0002\u000f5,H/\u00192mK*\u0011\u0001\u0007F\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001a.\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u000bM!d'\u0011\u001c\n\u0005U\"\"A\u0002+va2,7\u0007\u0005\u00028}9\u0011\u0001\b\u0010\t\u0003sQi\u0011A\u000f\u0006\u0003wA\ta\u0001\u0010:p_Rt\u0014BA\u001f\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\"\u0002C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\r\u0011X\r\u001f\u0006\u0003\r2\tqaY1mG&$X-\u0003\u0002I\u0007\n9!+\u001a=O_\u0012,\u0007B\u0002&\u0001A\u0003%1&A\u0006wC2LG-\u0012=qeN\u0004\u0003b\u0002'\u0001\u0005\u0004%I!T\u0001\u0010S:4\u0018\r\\5e'FdW\t\u001f9sgV\ta\nE\u0002-c=\u0003Ra\u0005\u001bQ!^\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\t1\fgn\u001a\u0006\u0002+\u0006!!.\u0019<b\u0013\ty$\u000b\r\u0002Y;B\u0019\u0011+W.\n\u0005i\u0013&!B\"mCN\u001c\bC\u0001/^\u0019\u0001!\u0011BX0\u0002\u0002\u0003\u0005)\u0011A1\u0003\u0007}#\u0013\u0007\u0003\u0004a\u0001\u0001\u0006IAT\u0001\u0011S:4\u0018\r\\5e'FdW\t\u001f9sg\u0002\n\"AY3\u0011\u0005M\u0019\u0017B\u00013\u0015\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u00154\n\u0005\u001d\u0014&!\u0003+ie><\u0018M\u00197f\u0011\u001dI\u0007A1A\u0005\n)\fA#\u001b8wC2LG\rV1cY\u0016\f\u0005/[#yaJ\u001cX#A6\u0011\u00071\nD\u000eE\u0003\u0014i5\u0004&\u000f\u0005\u0002oa6\tqN\u0003\u0002\u0006\u0011%\u0011\u0011o\u001c\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007GA:v!\r\t\u0016\f\u001e\t\u00039V$\u0011B^<\u0002\u0002\u0003\u0005)\u0011A1\u0003\u0007}##\u0007\u0003\u0004y\u0001\u0001\u0006Ia[\u0001\u0016S:4\u0018\r\\5e)\u0006\u0014G.Z!qS\u0016C\bO]:!\u0011\u001dQ\bA1A\u0005\nm\f1!\u001a8w+\u0005a\bcA?\u0002\b5\taPC\u0002\u0000\u0003\u0003\t1\"\u001a8wSJ|g.\\3oi*\u00191%a\u0001\u000b\u0007\u0005\u0015!\"A\u0005tiJ,\u0017-\\5oO&\u0019\u0011\u0011\u0002@\u0003-1{7-\u00197TiJ,\u0017-\\#om&\u0014xN\\7f]RDq!!\u0004\u0001A\u0003%A0\u0001\u0003f]Z\u0004\u0003\"CA\t\u0001\t\u0007I\u0011BA\n\u0003\u001d\u0019X\r\u001e;j]\u001e,\"!!\u0006\u0011\u0007\u0005\n9\"C\u0002\u0002\u001a\t\u00121#\u00128wSJ|g.\\3oiN+G\u000f^5oOND\u0001\"!\b\u0001A\u0003%\u0011QC\u0001\tg\u0016$H/\u001b8hA!I\u0011\u0011\u0005\u0001C\u0002\u0013%\u00111E\u0001\u0005i\u0016sg/\u0006\u0002\u0002&A!\u0011qEA\u001a\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0007U\u000byCC\u0002\u00022\t\naA\u0019:jI\u001e,\u0017\u0002BA\u001b\u0003S\u0011!d\u0015;sK\u0006lG+\u00192mK\u0016sg/\u001b:p]6,g\u000e^%na2D\u0001\"!\u000f\u0001A\u0003%\u0011QE\u0001\u0006i\u0016sg\u000f\t\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007f\t\u0001C]3t_24X\r\u001a#bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d\u0003\"A\u0003usB,7/\u0003\u0003\u0002L\u0005\u0015#\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0003\n\u0011C]3t_24X\r\u001a#bi\u0006$\u0016\u0010]3!\u0011!9\u0001A1A\u0005\n\u0005MSCAA+!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\r\u0005QA-\u001a7fO\u0006$\u0018n\u001c8\n\t\u0005}\u0013\u0011\f\u0002\f!2\fgN\\3s\u0005\u0006\u001cX\r\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA+\u0003!\u0001H.\u00198oKJ\u0004\u0003\"CA4\u0001\t\u0007I\u0011BA5\u0003)\u0011X\r\u001c\"vS2$WM]\u000b\u0003\u0003W\u0002B!!\u001c\u0002r5\u0011\u0011q\u000e\u0006\u0003\r\u001aIA!a\u001d\u0002p\tya\t\\5oWJ+GNQ;jY\u0012,'\u000f\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA6\u0003-\u0011X\r\u001c\"vS2$WM\u001d\u0011\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0014AD2bY\u000eLG/\u001a)mC:tWM]\u000b\u0003\u0003\u007f\u0002B!!\u001c\u0002\u0002&!\u00111QA8\u0005A1E.\u001b8l!2\fgN\\3s\u00136\u0004H\u000e\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BA@\u0003=\u0019\u0017\r\\2ji\u0016\u0004F.\u00198oKJ\u0004\u0003\"CAF\u0001\t\u0007I\u0011BAG\u0003\u0019\u0001\u0018M]:feV\u0011\u0011q\u0012\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013\u0004\u0002\u000bA\f'o]3\n\t\u0005e\u00151\u0013\u0002\u000e\u0007\u0006d7-\u001b;f!\u0006\u00148/\u001a:\t\u0011\u0005u\u0005\u0001)A\u0005\u0003\u001f\u000bq\u0001]1sg\u0016\u0014\b\u0005C\u0005\u0002\"\u0002\u0011\r\u0011\"\u0003\u0002$\u0006IA/\u00192mK:\u000bW.Z\u000b\u0002!\"9\u0011q\u0015\u0001!\u0002\u0013\u0001\u0016A\u0003;bE2,g*Y7fA!I\u00111\u0016\u0001C\u0002\u0013E\u00111U\u0001\t]VdG.\u00192mK\"9\u0011q\u0016\u0001!\u0002\u0013\u0001\u0016!\u00038vY2\f'\r\\3!\u0011%\t\u0019\f\u0001b\u0001\n#\t\u0019+A\u0006o_RtU\u000f\u001c7bE2,\u0007bBA\\\u0001\u0001\u0006I\u0001U\u0001\r]>$h*\u001e7mC\ndW\r\t\u0005\n\u0003w\u0003!\u0019!C\u0001\u0003{\u000b\u0011#\u001a=qK\u000e$X\rZ#yG\u0016\u0004H/[8o+\t\ty\f\u0005\u0003\u0002B\u0006-WBAAb\u0015\u0011\t)-a2\u0002\u000bI,H.Z:\u000b\u0007\u0005%g\"A\u0003kk:LG/\u0003\u0003\u0002N\u0006\r'!E#ya\u0016\u001cG/\u001a3Fq\u000e,\u0007\u000f^5p]\"A\u0011\u0011\u001b\u0001!\u0002\u0013\ty,\u0001\nfqB,7\r^3e\u000bb\u001cW\r\u001d;j_:\u0004\u0003bBAk\u0001\u0011\u0005\u0011QX\u0001\u0007i\"\u0014xn\u001e8)\t\u0005M\u0017\u0011\u001c\t\u0005\u00037\fi.\u0004\u0002\u0002H&!\u0011q\\Ad\u0005\u0011\u0011V\u000f\\3\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\u00069\u0001O]3qCJ,GCAAt!\r\u0019\u0012\u0011^\u0005\u0004\u0003W$\"\u0001B+oSRDC!!9\u0002pB!\u00111\\Ay\u0013\u0011\t\u00190a2\u0003\r\t+gm\u001c:f\u0011\u001d\t9\u0010\u0001C\u0001\u0003K\fQ\"\u001a<bYV\fG/Z#yaJ\u001c\b\u0006BA{\u0003w\u0004B!a7\u0002~&!\u0011q`Ad\u0005\u0015\te\r^3s\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000b\t1\u0002^3ti\u0006cG.\u00119jgRA\u0011q\u001dB\u0004\u0005\u0017\u0011y\u0001C\u0004\u0003\n\t\u0005\u0001\u0019A7\u0002\t\u0015D\bO\u001d\u0005\b\u0005\u001b\u0011\t\u00011\u00017\u0003\u001d\u0019\u0018\u000f\\#yaJDqA!\u0005\u0003\u0002\u0001\u0007a'\u0001\u0005fqB,7\r^3e\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/\tA\u0002^3tiR\u000b'\r\\3Ba&$b!a:\u0003\u001a\tm\u0001b\u0002B\u0005\u0005'\u0001\r!\u001c\u0005\b\u0005#\u0011\u0019\u00021\u00017\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005C\t!\u0002^3tiN\u000bH.\u00119j)\u0019\t9Oa\t\u0003&!9!Q\u0002B\u000f\u0001\u00041\u0004b\u0002B\t\u0005;\u0001\rA\u000e\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0003q!Xm\u001d;FqB,7\r^3e\u00032d\u0017\t]5t\u000bb\u001cW\r\u001d;j_:$\"\"a:\u0003.\t=\"\u0011\u0007B\u001b\u0011\u001d\u0011IAa\nA\u00025DqA!\u0004\u0003(\u0001\u0007a\u0007C\u0004\u00034\t\u001d\u0002\u0019\u0001\u001c\u0002\u0011-,\u0017p^8sIND!Ba\u000e\u0003(A\u0005\t\u0019\u0001B\u001d\u0003\u0015\u0019G.\u0019>{a\u0011\u0011YD!\u0011\u0011\u000b]\u0012iDa\u0010\n\u0005i\u0003\u0005c\u0001/\u0003B\u0011a!1\tB\u001b\u0003\u0003\u0005\tQ!\u0001\u0003F\t\u0019q\fJ\u001a\u0012\u0007\t\u00149\u0005\u0005\u0003\u0003J\tMc\u0002\u0002B&\u0005\u001fr1!\u000fB'\u0013\u0005)\u0012b\u0001B))\u00059\u0001/Y2lC\u001e,\u0017bA4\u0003V)\u0019!\u0011\u000b\u000b\t\u000f\te\u0003\u0001\"\u0001\u0003\\\u0005AB/Z:u\u000bb\u0004Xm\u0019;fIN\u000bH.\u0012=dKB$\u0018n\u001c8\u0015\u0011\u0005\u001d(Q\fB0\u0005CBqA!\u0004\u0003X\u0001\u0007a\u0007C\u0004\u00034\t]\u0003\u0019\u0001\u001c\t\u0015\t]\"q\u000bI\u0001\u0002\u0004\u0011\u0019\u0007\r\u0003\u0003f\t%\u0004#B\u001c\u0003>\t\u001d\u0004c\u0001/\u0003j\u0011a!1\u000eB1\u0003\u0003\u0005\tQ!\u0001\u0003F\t\u0019q\f\n\u001b\t\u000f\t=\u0004\u0001\"\u0001\u0003r\u0005iB/Z:u\u000bb\u0004Xm\u0019;fIR\u000b'\r\\3Ba&,\u0005pY3qi&|g\u000e\u0006\u0005\u0002h\nM$Q\u000fB<\u0011\u001d\u0011IA!\u001cA\u00025DqAa\r\u0003n\u0001\u0007a\u0007\u0003\u0006\u00038\t5\u0004\u0013!a\u0001\u0005s\u0002DAa\u001f\u0003\u0000A)qG!\u0010\u0003~A\u0019ALa \u0005\u0019\t\u0005%qOA\u0001\u0002\u0003\u0015\tA!\u0012\u0003\u0007}#S\u0007C\u0004\u0003\u0006\u0002!\tAa\"\u0002'\u001d,GoQ8eK\u001e+gNR;oGRLwN\\:\u0015\t\t%%1\u0017\t\t\u0005\u0017\u00139Ja'\u0003(6\u0011!Q\u0012\u0006\u0005\u0005\u001f\u0013\t*A\u0005gk:\u001cG/[8og*!!1\u0013BK\u0003\u0019\u0019w.\\7p]*\u00111EC\u0005\u0005\u00053\u0013iIA\u0006NCB4UO\\2uS>t\u0007\u0003\u0002BO\u0005Gk!Aa(\u000b\u0007\t\u0005\u0006\"\u0001\u0003eCR\f\u0017\u0002\u0002BS\u0005?\u0013qAU8x\t\u0006$\u0018\r\u0005\u0003\u0003*\n=VB\u0001BV\u0015\u0011\u0011iKa(\u0002\r\tLg.\u0019:z\u0013\u0011\u0011\tLa+\u0003\u001b\tKg.\u0019:z%><H)\u0019;b\u0011!\u0011)La!A\u0002\t]\u0016\u0001C:rY\u0016C\bO]:\u0011\u000b\t%#\u0011\u0018\u001c\n\t\tm&Q\u000b\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0003@\u0002!\tA!1\u0002-\u00154\u0018\r\\;bi\u00164UO\\2uS>t'+Z:vYR$BAa.\u0003D\"A!Q\u0019B_\u0001\u0004\u0011I)\u0001\u0004nCB\u0004XM\u001d\u0005\b\u0005\u0013\u0004A\u0011\u0002Bf\u0003Q!Xm\u001d;UC\ndW-\u00119j)\u0016\u001cH/\u0012=qeR1\u0011q\u001dBg\u0005#DqAa4\u0003H\u0002\u0007a'\u0001\buC\ndW-\u00119j'R\u0014\u0018N\\4\t\u000f\tE!q\u0019a\u0001m!9!Q\u001b\u0001\u0005\n\t]\u0017AD1eIN\u000bH\u000eV3ti\u0016C\bO\u001d\u000b\u000b\u0003O\u0014INa7\u0003^\nM\bb\u0002B\u0007\u0005'\u0004\rA\u000e\u0005\b\u0005#\u0011\u0019\u000e1\u00017\u0011!\u0011yNa5A\u0002\t\u0005\u0018AD3yaJ\u001c8i\u001c8uC&tWM\u001d\u0019\u0005\u0005G\u00149\u000f\u0005\u0003-c\t\u0015\bc\u0001/\u0003h\u0012a!\u0011\u001eBo\u0003\u0003\u0005\tQ!\u0001\u0003l\n!q\fJ\u00191#\r\u0011'Q\u001e\t\u0004'\t=\u0018b\u0001By)\t\u0019\u0011I\\=\t\u0015\tU(1\u001bI\u0001\u0002\u0004\u001190\u0001\bfq\u000e,\u0007\u000f^5p]\u000ec\u0017m]:1\t\te(Q \t\u0006o\tu\"1 \t\u00049\nuH\u0001\u0004B\u0000\u0005g\f\t\u0011!A\u0003\u0002\t\u0015#\u0001B0%cEBqaa\u0001\u0001\t\u0013\u0019)!A\nbI\u0012$\u0016M\u00197f\u0003BLG+Z:u\u000bb\u0004(\u000f\u0006\u0006\u0002h\u000e\u001d11BB\u0007\u00073Aqa!\u0003\u0004\u0002\u0001\u0007Q.\u0001\u0007uC\ndW-\u00119j\u000bb\u0004(\u000fC\u0004\u0003\u0012\r\u0005\u0001\u0019\u0001\u001c\t\u0011\t}7\u0011\u0001a\u0001\u0007\u001f\u0001Da!\u0005\u0004\u0016A!A&MB\n!\ra6Q\u0003\u0003\r\u0007/\u0019i!!A\u0001\u0002\u000b\u0005!1\u001e\u0002\u0005?\u0012\n$\u0007\u0003\u0006\u0003v\u000e\u0005\u0001\u0013!a\u0001\u00077\u0001Da!\b\u0004\"A)qG!\u0010\u0004 A\u0019Al!\t\u0005\u0019\r\r2\u0011DA\u0001\u0002\u0003\u0015\tA!\u0012\u0003\t}#\u0013g\r\u0005\b\u0007O\u0001A\u0011BB\u0015\u0003-\tG\r\u001a+fgR,\u0005\u0010\u001d:\u0015\u0019\u0005\u001d81FB\u001e\u0007{\u0019\te!\u0014\t\u0011\r52Q\u0005a\u0001\u0007_\tqA]3m\u001d>$W\r\u0005\u0003\u00042\r]RBAB\u001a\u0015\r\u0019)$R\u0001\u0004e\u0016d\u0017\u0002BB\u001d\u0007g\u0011qAU3m\u001d>$W\rC\u0004\u0003\u0012\r\u0015\u0002\u0019\u0001\u001c\t\u000f\r}2Q\u0005a\u0001m\u0005i1/^7nCJL8\u000b\u001e:j]\u001eD\u0001B!>\u0004&\u0001\u000711\t\u0019\u0005\u0007\u000b\u001aI\u0005E\u00038\u0005{\u00199\u0005E\u0002]\u0007\u0013\"Aba\u0013\u0004B\u0005\u0005\t\u0011!B\u0001\u0005\u000b\u0012Aa\u0018\u00132i!A1qJB\u0013\u0001\u0004\u0019\t&A\u0003fqB\u00148\u000f\r\u0003\u0004T\r]\u0003\u0003\u0002\u00172\u0007+\u00022\u0001XB,\t1\u0019If!\u0014\u0002\u0002\u0003\u0005)\u0011\u0001Bv\u0005\u0011yF%M\u001b\t\u000f\ru\u0003\u0001\"\u0003\u0004`\u0005qQ\r\u001f;sC\u000e$(+\u001a=O_\u0012,GcA!\u0004b!A11MB.\u0001\u0004\u0019y#\u0001\u0003o_\u0012,\u0007bBB4\u0001\u0011%1\u0011N\u0001\u0013KZ\fG.^1uK\u001eKg/\u001a8FqB\u00148\u000f\u0006\u0003\u0002h\u000e-\u0004bBB7\u0007K\u0002\raK\u0001\nKb\u0004(/\u0011:sCfDqa!\u001d\u0001\t\u0013\u0019\u0019(\u0001\nhKR\u001cu\u000eZ3HK:4UO\\2uS>tG\u0003\u0002BE\u0007kB\u0001ba\u001e\u0004p\u0001\u00071\u0011P\u0001\te\u0016Dhj\u001c3fgB)!\u0011\nB]\u0003\"91Q\u0010\u0001\u0007\u0002\r}\u0014\u0001\u0003;fgR$\u0015\r^1\u0016\u0005\r\u0005\u0005\u0003BBB\u0007\u000fk!a!\"\u000b\u0007\u0005\u001d#\"\u0003\u0003\u0004\n\u000e\u0015%a\u0001*po\"91Q\u0012\u0001\u0005\u0002\r=\u0015\u0001\u0004;fgR$\u0015\r^1UsB,WCABIa\u0011\u0019\u0019ja'\u0011\r\u0005\r3QSBM\u0013\u0011\u00199*!\u0012\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007c\u0001/\u0004\u001c\u0012a1QTBF\u0003\u0003\u0005\tQ!\u0001\u0003l\n!q\fJ\u00197\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0007G\u000b1\u0003^3tiNK8\u000f^3n\rVt7\r^5p]N,\"a!*\u0011\u000f\r\u001d6Q\u0016\u001c\u000426\u00111\u0011\u0016\u0006\u0004\u0007W#\u0016\u0001B;uS2LAaa,\u0004*\n\u0019Q*\u00199\u0011\t\rM6qW\u0007\u0003\u0007kS1Aa$\t\u0013\u0011\u0019Il!.\u0003\u001dM\u001b\u0017\r\\1s\rVt7\r^5p]\"91Q\u0018\u0001\u0005\u0002\r}\u0016aE2p]R\f\u0017N\\:MK\u001e\f7-\u001f+za\u0016\u001cXCABa!\r\u001921Y\u0005\u0004\u0007\u000b$\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u001f\u0003A\u0011ABe+\t\u0019Y\r\u0005\u00048\u0007\u001b44\u0011W\u0005\u0004\u0007_\u0003\u0005\u0006CBd\u0007#\u001c9na;\u0011\u0007M\u0019\u0019.C\u0002\u0004VR\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3ec!\u0019cg!7\u0004b\u000em\u0017\u0002BBn\u0007;\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bABp)\u0005QA-\u001a9sK\u000e\fG/\u001a32\u0013\r\u001a\u0019o!:\u0004h\u000e}gbA\n\u0004f&\u00191q\u001c\u000b2\u000b\t\u001aBc!;\u0003\u000bM\u001c\u0017\r\\12\u0011\r24Q^By\u0007_LAaa<\u0004^\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n\u0014bIBr\u0007K\u001c\u0019pa82\u000b\t\u001aBc!;\t\u000f\r]\b\u0001\"\u0001\u0004z\u0006AA/\u001f9f\u0013:4w.\u0006\u0002\u0004|B!1Q C\u0003\u001b\t\u0019yP\u0003\u0003\u0005\u0002\u0011\r\u0011!\u0003;za\u0016,H/\u001b7t\u0015\r)&QS\u0005\u0005\t\u000f\u0019yPA\u0006S_^$\u0016\u0010]3J]\u001a|\u0007\u0006CB{\u0007#$Y\u0001\"\u00052\u0011\r24\u0011\u001cC\u0007\u00077\f\u0014bIBr\u0007K$yaa82\u000b\t\u001aBc!;2\u0011\r24Q\u001eC\n\u0007_\f\u0014bIBr\u0007K$)ba82\u000b\t\u001aBc!;\t\u000f\t\r\u0001\u0001\"\u0001\u0005\u001aQQ\u0011q\u001dC\u000e\t;!\t\u0003b\t\t\u000f\t%Aq\u0003a\u0001[\"9Aq\u0004C\f\u0001\u00041\u0014AC3yaJ\u001cFO]5oO\"9!Q\u0002C\f\u0001\u00041\u0004b\u0002B\t\t/\u0001\rA\u000e\u0015\t\t/\u0019\t\u000eb\n\u0005.EB1ENBm\tS\u0019Y.M\u0005$\u0007G\u001c)\u000fb\u000b\u0004`F*!e\u0005\u000b\u0004jFB1ENBw\t_\u0019y/M\u0005$\u0007G\u001c)\u000f\"\r\u0004`F*!e\u0005\u000b\u0004j\"9!Q\u0003\u0001\u0005\u0002\u0011UB\u0003CAt\to!I\u0004b\u000f\t\u000f\t%A1\u0007a\u0001[\"9Aq\u0004C\u001a\u0001\u00041\u0004b\u0002B\t\tg\u0001\rA\u000e\u0015\t\tg\u0019\t\u000eb\u0010\u0005FEB1ENBm\t\u0003\u001aY.M\u0005$\u0007G\u001c)\u000fb\u0011\u0004`F*!e\u0005\u000b\u0004jFB1ENBw\t\u000f\u001ay/M\u0005$\u0007G\u001c)\u000f\"\u0013\u0004`F*!e\u0005\u000b\u0004j\"9AQ\n\u0001\u0005\u0002\u0011=\u0013\u0001\u0004;j[\u0016\u001cH/Y7q\u0019RTHc\u0001\u001c\u0005R!9A1\u000bC&\u0001\u00041\u0014aA:ue\"9AQ\n\u0001\u0005\u0002\u0011]C#\u0002\u001c\u0005Z\u0011m\u0003b\u0002C*\t+\u0002\rA\u000e\u0005\t\t;\")\u00061\u0001\u0005`\u0005I\u0001O]3dSNLwN\u001c\t\u0004'\u0011\u0005\u0014b\u0001C2)\t\u0019\u0011J\u001c;\t\u000f\u0011\u001d\u0004\u0001\"\u0003\u0005j\u0005\u0001R\r\u001f;sC\u000e$\bK]3dSNLwN\u001c\u000b\u0005\t?\"Y\u0007C\u0004\u0005T\u0011\u0015\u0004\u0019\u0001\u001c\t\u0013\u0011=\u0004!%A\u0005\u0002\u0011E\u0014A\t;fgR,\u0005\u0010]3di\u0016$7+\u001d7Fq\u000e,\u0007\u000f^5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u0005tA\"AQ\u000fC=!\u00159$Q\bC<!\raF\u0011\u0010\u0003\r\u0005W\"i'!A\u0001\u0002\u000b\u0005!Q\t\u0005\n\t{\u0002\u0011\u0013!C\u0001\t\u007f\na\u0005^3ti\u0016C\b/Z2uK\u0012\fE\u000e\\!qSN,\u0005pY3qi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t!\t\t\r\u0003\u0005\u0004\u0012\u001d\u0005#B\u001c\u0003>\u0011\u0015\u0005c\u0001/\u0005\b\u0012a!1\tC>\u0003\u0003\u0005\tQ!\u0001\u0003F!IA1\u0012\u0001\u0012\u0002\u0013\u0005AQR\u0001(i\u0016\u001cH/\u0012=qK\u000e$X\r\u001a+bE2,\u0017\t]5Fq\u000e,\u0007\u000f^5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u0005\u0010B\"A\u0011\u0013CK!\u00159$Q\bCJ!\raFQ\u0013\u0003\r\u0005\u0003#I)!A\u0001\u0002\u000b\u0005!Q\t\u0005\n\t3\u0003\u0011\u0013!C\u0005\t7\u000b\u0001$\u00193e'FdG+Z:u\u000bb\u0004(\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t!i\n\r\u0003\u0005 \u0012\r\u0006#B\u001c\u0003>\u0011\u0005\u0006c\u0001/\u0005$\u0012a!q CL\u0003\u0003\u0005\tQ!\u0001\u0003F!IAq\u0015\u0001\u0012\u0002\u0013%A\u0011V\u0001\u001eC\u0012$G+\u00192mK\u0006\u0003\u0018\u000eV3ti\u0016C\bO\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011A1\u0016\u0019\u0005\t[#\t\fE\u00038\u0005{!y\u000bE\u0002]\tc#Aba\t\u0005&\u0006\u0005\t\u0011!B\u0001\u0005\u000b\u0002")
public abstract class ExpressionTestBase {
    private final TableConfig config = new TableConfig();
    private final ArrayBuffer<Tuple3<String, RexNode, String>> validExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final ArrayBuffer<Tuple3<String, String, Class<? extends Throwable>>> invalidSqlExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final ArrayBuffer<Tuple3<Expression, String, Class<? extends Throwable>>> invalidTableApiExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment((int)4);
    private final EnvironmentSettings setting = EnvironmentSettings.newInstance().inStreamingMode().build();
    private final StreamTableEnvironmentImpl tEnv = (StreamTableEnvironmentImpl)StreamTableEnvironmentImpl.create((StreamExecutionEnvironment)this.env(), (EnvironmentSettings)this.setting(), (TableConfig)this.config());
    private final DataType resolvedDataType = this.containsLegacyTypes() ? TypeConversions.fromLegacyInfoToDataType((TypeInformation)this.typeInfo()) : this.tEnv().getCatalogManager().getDataTypeFactory().createDataType(this.testDataType());
    private final PlannerBase planner = (PlannerBase)this.tEnv().getPlanner();
    private final FlinkRelBuilder relBuilder = this.planner().getRelBuilder();
    private final FlinkPlannerImpl calcitePlanner = this.planner().createFlinkPlanner();
    private final CalciteParser parser = this.planner().plannerContext().createCalciteParser();
    private final String tableName;
    private final String nullable;
    private final String notNullable;
    private final ExpectedException expectedException = ExpectedException.none();

    public TableConfig config() {
        return this.config;
    }

    private ArrayBuffer<Tuple3<String, RexNode, String>> validExprs() {
        return this.validExprs;
    }

    private ArrayBuffer<Tuple3<String, String, Class<? extends Throwable>>> invalidSqlExprs() {
        return this.invalidSqlExprs;
    }

    private ArrayBuffer<Tuple3<Expression, String, Class<? extends Throwable>>> invalidTableApiExprs() {
        return this.invalidTableApiExprs;
    }

    private LocalStreamEnvironment env() {
        return this.env;
    }

    private EnvironmentSettings setting() {
        return this.setting;
    }

    private StreamTableEnvironmentImpl tEnv() {
        return this.tEnv;
    }

    private DataType resolvedDataType() {
        return this.resolvedDataType;
    }

    private PlannerBase planner() {
        return this.planner;
    }

    private FlinkRelBuilder relBuilder() {
        return this.relBuilder;
    }

    private FlinkPlannerImpl calcitePlanner() {
        return this.calcitePlanner;
    }

    private CalciteParser parser() {
        return this.parser;
    }

    private String tableName() {
        return this.tableName;
    }

    public String nullable() {
        return this.nullable;
    }

    public String notNullable() {
        return this.notNullable;
    }

    public ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    @Before
    public void prepare() {
        if (this.containsLegacyTypes()) {
            DataStreamSource ds = this.env().fromCollection(Collections.emptyList(), (TypeInformation)this.typeInfo());
            this.tEnv().createTemporaryView(this.tableName(), (DataStream)ds, (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.typeInfo().getFieldNames())).map((Function1 & Serializable & scala.Serializable)name -> package$.MODULE$.$(name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))));
            this.functions().foreach((Function1 & Serializable & scala.Serializable)f -> {
                ExpressionTestBase.$anonfun$prepare$2(this, f);
                return BoxedUnit.UNIT;
            });
        } else {
            this.tEnv().createTemporaryView(this.tableName(), this.tEnv().fromValues((AbstractDataType)this.resolvedDataType(), new Expression[0]));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.testSystemFunctions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> {
                ExpressionTestBase.$anonfun$prepare$3(this, e);
                return BoxedUnit.UNIT;
            });
        }
        this.relBuilder().scan(new String[]{this.tableName()});
        this.validExprs().clear();
        this.invalidSqlExprs().clear();
        this.invalidTableApiExprs().clear();
    }

    @After
    public void evaluateExprs() {
        this.evaluateGivenExprs(this.validExprs());
        this.invalidSqlExprs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExpressionTestBase.$anonfun$evaluateExprs$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.invalidTableApiExprs().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExpressionTestBase.$anonfun$evaluateExprs$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void testAllApis(Expression expr, String sqlExpr, String expected) {
        this.addTableApiTestExpr(expr, expected, this.validExprs(), this.addTableApiTestExpr$default$4());
        this.addSqlTestExpr(sqlExpr, expected, this.validExprs(), this.addSqlTestExpr$default$4());
    }

    public void testTableApi(Expression expr, String expected) {
        this.addTableApiTestExpr(expr, expected, this.validExprs(), this.addTableApiTestExpr$default$4());
    }

    public void testSqlApi(String sqlExpr, String expected) {
        this.addSqlTestExpr(sqlExpr, expected, this.validExprs(), this.addSqlTestExpr$default$4());
    }

    public void testExpectedAllApisException(Expression expr, String sqlExpr, String keywords, Class<? extends Throwable> clazz) {
        this.invalidTableApiExprs().$plus$eq((Object)new Tuple3((Object)expr, (Object)keywords, clazz));
        this.invalidSqlExprs().$plus$eq((Object)new Tuple3((Object)sqlExpr, (Object)keywords, clazz));
    }

    public Class<? extends Throwable> testExpectedAllApisException$default$4() {
        return ValidationException.class;
    }

    public void testExpectedSqlException(String sqlExpr, String keywords, Class<? extends Throwable> clazz) {
        this.invalidSqlExprs().$plus$eq((Object)new Tuple3((Object)sqlExpr, (Object)keywords, clazz));
    }

    public Class<? extends Throwable> testExpectedSqlException$default$3() {
        return ValidationException.class;
    }

    public void testExpectedTableApiException(Expression expr, String keywords, Class<? extends Throwable> clazz) {
        this.invalidTableApiExprs().$plus$eq((Object)new Tuple3((Object)expr, (Object)keywords, clazz));
    }

    public Class<? extends Throwable> testExpectedTableApiException$default$3() {
        return ValidationException.class;
    }

    public MapFunction<RowData, BinaryRowData> getCodeGenFunctions(List<String> sqlExprs) {
        ArrayBuffer testSqlExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        sqlExprs.foreach((Function1 & Serializable & scala.Serializable)exp -> {
            this.addSqlTestExpr(exp, null, testSqlExprs, null);
            return BoxedUnit.UNIT;
        });
        return this.getCodeGenFunction((List<RexNode>)((IndexedSeqOptimized)testSqlExprs.map((Function1 & Serializable & scala.Serializable)r -> (RexNode)r._2(), ArrayBuffer$.MODULE$.canBuildFrom())).toList());
    }

    public List<String> evaluateFunctionResult(MapFunction<RowData, BinaryRowData> mapper) {
        RowData rowData;
        boolean isRichFunction = mapper instanceof RichFunction;
        if (isRichFunction) {
            RichMapFunction richMapper = (RichMapFunction)mapper;
            RuntimeUDFContext t = new RuntimeUDFContext(new TaskInfo("ExpressionTest", 1, 0, 1, 1), ExpressionTestBase.class.getClassLoader(), this.env().getConfig(), Collections.emptyMap(), Collections.emptyMap(), null);
            richMapper.setRuntimeContext((RuntimeContext)t);
            richMapper.open(new Configuration());
        }
        if (this.containsLegacyTypes()) {
            DataFormatConverters.DataFormatConverter converter = DataFormatConverters.getConverterForDataType((DataType)this.resolvedDataType());
            rowData = (RowData)converter.toInternal((Object)this.testData());
        } else {
            DataStructureConverter converter = DataStructureConverters.getConverter((DataType)this.resolvedDataType());
            rowData = (RowData)converter.toInternalOrNull((Object)this.testData());
        }
        RowData testRow = rowData;
        BinaryRowData result = (BinaryRowData)mapper.map((Object)testRow);
        if (isRichFunction) {
            ((RichMapFunction)mapper).close();
        }
        ListBuffer resultList = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), result.getArity()).foreach((Function1 & Serializable & scala.Serializable)index -> ExpressionTestBase.$anonfun$evaluateFunctionResult$1(result, resultList, BoxesRunTime.unboxToInt((Object)index)));
        return resultList.toList();
    }

    private void testTableApiTestExpr(String tableApiString, String expected) {
        this.addTableApiTestExpr(ExpressionParser.parseExpression((String)tableApiString), expected, this.validExprs(), this.addTableApiTestExpr$default$4());
    }

    private void addSqlTestExpr(String sqlExpr, String expected, ArrayBuffer<?> exprsContainer, Class<? extends Throwable> exceptionClass) {
        SqlNode parsed = this.parser().parse(new StringBuilder(13).append("SELECT ").append(sqlExpr).append(" FROM ").append(this.tableName()).toString());
        SqlNode validated = this.calcitePlanner().validate(parsed);
        RelNode converted = this.calcitePlanner().rel((SqlNode)validated).rel;
        this.addTestExpr(converted, expected, sqlExpr, exceptionClass, exprsContainer);
    }

    private Class<? extends Throwable> addSqlTestExpr$default$4() {
        return null;
    }

    private void addTableApiTestExpr(Expression tableApiExpr, String expected, ArrayBuffer<?> exprsContainer, Class<? extends Throwable> exceptionClass) {
        RelNode relNode = this.relBuilder().queryOperation(this.tEnv().from(this.tableName()).select(new Expression[]{tableApiExpr}).getQueryOperation()).build();
        this.addTestExpr(relNode, expected, tableApiExpr.asSummaryString(), null, exprsContainer);
    }

    private Class<? extends Throwable> addTableApiTestExpr$default$4() {
        return null;
    }

    private void addTestExpr(RelNode relNode, String expected, String summaryString, Class<? extends Throwable> exceptionClass, ArrayBuffer<?> exprs) {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleInstance((RelOptRule)CoreRules.PROJECT_REDUCE_EXPRESSIONS);
        builder.addRuleInstance((RelOptRule)CoreRules.PROJECT_TO_CALC);
        HepPlanner hep = new HepPlanner(builder.build());
        hep.setRoot(relNode);
        RelNode optimized = hep.findBestExp();
        if (!optimized.getInput(0).getInputs().isEmpty()) {
            Assert.fail((String)"Expression is converted into more than a Calc operation. Use a different test method.");
        }
        exprs.$plus$eq((Object)new Tuple3((Object)summaryString, (Object)this.extractRexNode(optimized), (Object)expected));
    }

    private RexNode extractRexNode(RelNode node) {
        RexProgram calcProgram = ((LogicalCalc)node).getProgram();
        return calcProgram.expandLocalRef((RexLocalRef)calcProgram.getProjectList().get(0));
    }

    private void evaluateGivenExprs(ArrayBuffer<Tuple3<String, RexNode, String>> exprArray) {
        MapFunction<RowData, BinaryRowData> genFunc = this.getCodeGenFunction((List<RexNode>)((IndexedSeqOptimized)exprArray.map((Function1 & Serializable & scala.Serializable)exp -> (RexNode)exp._2(), ArrayBuffer$.MODULE$.canBuildFrom())).toList());
        List<String> result = this.evaluateFunctionResult(genFunc);
        ((ResizableArray)exprArray.zip(result, ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ExpressionTestBase.$anonfun$evaluateGivenExprs$2(x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private MapFunction<RowData, BinaryRowData> getCodeGenFunction(List<RexNode> rexNodes) {
        CodeGeneratorContext ctx = CodeGeneratorContext$.MODULE$.apply(this.config());
        LogicalType inputType = this.containsLegacyTypes() ? TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)this.typeInfo()) : this.resolvedDataType().getLogicalType();
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        LogicalType x$1 = inputType;
        String x$2 = qual$1.bindInput$default$2();
        Option x$3 = qual$1.bindInput$default$3();
        ExprCodeGenerator exprGenerator = qual$1.bindInput(x$1, x$2, x$3);
        List stringTestExprs = (List)rexNodes.map((Function1 & Serializable & scala.Serializable)expr -> this.relBuilder().cast(expr, SqlTypeName.VARCHAR), List$.MODULE$.canBuildFrom());
        RowType resultType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)Seq$.MODULE$.fill(rexNodes.size(), (Function0 & Serializable & scala.Serializable)() -> new VarCharType(Integer.MAX_VALUE))).toArray(ClassTag$.MODULE$.apply(VarCharType.class))));
        List exprs = (List)stringTestExprs.map((Function1 & Serializable & scala.Serializable)rex -> exprGenerator.generateExpression(rex), List$.MODULE$.canBuildFrom());
        GeneratedExpression genExpr = exprGenerator.generateResultExpression((Seq)exprs, resultType, BinaryRowData.class, exprGenerator.generateResultExpression$default$4(), exprGenerator.generateResultExpression$default$5(), exprGenerator.generateResultExpression$default$6(), exprGenerator.generateResultExpression$default$7());
        String bodyCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(39).append("\n         |").append(genExpr.code()).append("\n         |return ").append(genExpr.resultTerm()).append(";\n        ").toString())).stripMargin();
        GeneratedFunction genFunc = FunctionCodeGenerator$.MODULE$.generateFunction(ctx, "TestFunction", MapFunction.class, bodyCode, (LogicalType)resultType, inputType, FunctionCodeGenerator$.MODULE$.generateFunction$default$7(), FunctionCodeGenerator$.MODULE$.generateFunction$default$8(), FunctionCodeGenerator$.MODULE$.generateFunction$default$9(), FunctionCodeGenerator$.MODULE$.generateFunction$default$10(), FunctionCodeGenerator$.MODULE$.generateFunction$default$11());
        return (MapFunction)genFunc.newInstance(this.getClass().getClassLoader());
    }

    public abstract Row testData();

    public AbstractDataType<?> testDataType() {
        throw new IllegalArgumentException("Implement this if no legacy types are expected.");
    }

    public Map<String, ScalarFunction> testSystemFunctions() {
        return Collections.emptyMap();
    }

    public boolean containsLegacyTypes() {
        return true;
    }

    public scala.collection.immutable.Map<String, ScalarFunction> functions() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public RowTypeInfo typeInfo() {
        throw new IllegalArgumentException("Implement this if legacy types are expected.");
    }

    public void testAllApis(Expression expr, String exprString, String sqlExpr, String expected) {
        this.testTableApi(expr, expected);
        this.testTableApiTestExpr(exprString, expected);
        this.testSqlApi(sqlExpr, expected);
    }

    public void testTableApi(Expression expr, String exprString, String expected) {
        this.testTableApi(expr, expected);
        this.testTableApiTestExpr(exprString, expected);
    }

    public String timestampLtz(String str) {
        int precision = this.extractPrecision(str);
        return this.timestampLtz(str, precision);
    }

    public String timestampLtz(String str, int precision) {
        return new StringBuilder(37).append("CAST(TIMESTAMP '").append(str).append("' AS TIMESTAMP_LTZ(").append(precision).append("))").toString();
    }

    private int extractPrecision(String str) {
        int dot = str.indexOf(46);
        return dot == -1 ? 0 : str.length() - dot - 1;
    }

    public static final /* synthetic */ void $anonfun$prepare$2(ExpressionTestBase $this, Tuple2 f) {
        $this.tEnv().registerFunction((String)f._1(), (ScalarFunction)f._2());
    }

    public static final /* synthetic */ void $anonfun$prepare$3(ExpressionTestBase $this, Tuple2 e) {
        $this.tEnv().createTemporarySystemFunction((String)e._1(), (UserDefinedFunction)e._2());
    }

    public static final /* synthetic */ void $anonfun$evaluateExprs$1(ExpressionTestBase $this, Tuple3 x0$1) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            String sqlExpr = (String)tuple3._1();
            String keywords = (String)tuple3._2();
            Class clazz = (Class)tuple3._3();
            try {
                ArrayBuffer invalidExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                $this.addSqlTestExpr(sqlExpr, keywords, invalidExprs, clazz);
                $this.evaluateGivenExprs((ArrayBuffer<Tuple3<String, RexNode, String>>)invalidExprs);
                Assert.fail((String)new StringBuilder(40).append("Expected a ").append(clazz).append(", but no exception is thrown.").toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Class<?> clazz2 = throwable2.getClass();
                Class clazz3 = clazz;
                if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                    BoxedUnit boxedUnit2;
                    if (keywords != null) {
                        Assert.assertTrue((String)new StringBuilder(31).append("The actual exception message \n").append(throwable2.getMessage()).append("\n").append(new StringBuilder(35).append("doesn't contain expected keyword \n").append(keywords).append("\n").toString()).toString(), (boolean)throwable2.getMessage().contains(keywords));
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                } else if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    throwable3.printStackTrace();
                    Assert.fail((String)new StringBuilder(25).append("Expected throw ").append(clazz.getSimpleName()).append(", but is ").append(throwable3).append(".").toString());
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit5 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$evaluateExprs$2(ExpressionTestBase $this, Tuple3 x0$2) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x0$2;
        if (tuple3 != null) {
            Expression tableExpr = (Expression)tuple3._1();
            String keywords = (String)tuple3._2();
            Class clazz = (Class)tuple3._3();
            try {
                ArrayBuffer invalidExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                $this.addTableApiTestExpr(tableExpr, keywords, invalidExprs, clazz);
                $this.evaluateGivenExprs((ArrayBuffer<Tuple3<String, RexNode, String>>)invalidExprs);
                Assert.fail((String)new StringBuilder(40).append("Expected a ").append(clazz).append(", but no exception is thrown.").toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Class<?> clazz2 = throwable2.getClass();
                Class clazz3 = clazz;
                if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                    BoxedUnit boxedUnit2;
                    if (keywords != null) {
                        Assert.assertTrue((String)new StringBuilder(31).append("The actual exception message \n").append(throwable2.getMessage()).append("\n").append(new StringBuilder(35).append("doesn't contain expected keyword \n").append(keywords).append("\n").toString()).toString(), (boolean)throwable2.getMessage().contains(keywords));
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                } else if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    throwable3.printStackTrace();
                    Assert.fail((String)new StringBuilder(25).append("Expected throw ").append(clazz.getSimpleName()).append(", but is ").append(throwable3).append(".").toString());
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit5 = boxedUnit;
    }

    public static final /* synthetic */ ListBuffer $anonfun$evaluateFunctionResult$1(BinaryRowData result$1, ListBuffer resultList$1, int index) {
        String item = !result$1.isNullAt(index) ? result$1.getString(index).toString() : null;
        return resultList$1.$plus$eq((Object)item);
    }

    public static final /* synthetic */ void $anonfun$evaluateGivenExprs$2(Tuple2 x0$3) {
        String actual;
        Tuple3 tuple3;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$3;
                if (tuple2 == null) break block2;
                tuple3 = (Tuple3)tuple2._1();
                actual = (String)tuple2._2();
                if (tuple3 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String originalExpr = (String)tuple3._1();
        RexNode optimizedExpr = (RexNode)tuple3._2();
        String expected = (String)tuple3._3();
        String original = originalExpr == null ? "" : new StringBuilder(7).append("for: [").append(originalExpr).append("]").toString();
        Assert.assertEquals((String)new StringBuilder(30).append("Wrong result ").append(original).append(" optimized to: [").append(optimizedExpr).append("]").toString(), (Object)expected, (Object)(actual == null ? "null" : actual));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ExpressionTestBase() {
        this.tableName = "testTable";
        this.nullable = "null";
        this.notNullable = "not null";
    }
}

