/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.JsonExistsOnError;
import org.apache.flink.table.api.JsonValueOnEmptyOrError;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.junit.runners.Parameterized;

public class JsonFunctionsITCase
extends BuiltInFunctionTestBase {
    @Parameterized.Parameters(name="{index}: {0}")
    public static List<BuiltInFunctionTestBase.TestSpec> testData() throws Exception {
        ArrayList<BuiltInFunctionTestBase.TestSpec> testCases = new ArrayList<BuiltInFunctionTestBase.TestSpec>();
        testCases.add(JsonFunctionsITCase.jsonExists());
        testCases.add(JsonFunctionsITCase.jsonValue());
        return testCases;
    }

    private static BuiltInFunctionTestBase.TestSpec jsonExists() throws Exception {
        InputStream jsonResource = JsonFunctionsITCase.class.getResourceAsStream("/json/json-exists.json");
        if (jsonResource == null) {
            throw new IllegalStateException(String.format("%s: Missing test data.", JsonFunctionsITCase.class.getName()));
        }
        String jsonValue = IOUtils.toString((InputStream)jsonResource, (Charset)Charset.defaultCharset());
        return BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.JSON_EXISTS).onFieldsWithData(jsonValue).andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.nullOf((DataType)DataTypes.STRING()).jsonExists("lax $"), "JSON_EXISTS(CAST(NULL AS STRING), 'lax $')", null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $"), "JSON_EXISTS(f0, 'lax $')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.type"), "JSON_EXISTS(f0, 'lax $.type')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.author.address.city"), "JSON_EXISTS(f0, 'lax $.author.address.city')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.metadata.tags[0]"), "JSON_EXISTS(f0, 'lax $.metadata.tags[0]')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.metadata.tags[3]"), "JSON_EXISTS(f0, 'lax $.metadata.tags[3]')", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.metadata.references[0].url"), "JSON_EXISTS(f0, 'lax $.metadata.references[0].url')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.metadata.references[0].invalid"), "JSON_EXISTS(f0, 'lax $.metadata.references[0].invalid')", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("strict $.invalid", JsonExistsOnError.TRUE), "JSON_EXISTS(f0, 'strict $.invalid' TRUE ON ERROR)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("strict $.invalid", JsonExistsOnError.FALSE), "JSON_EXISTS(f0, 'strict $.invalid' FALSE ON ERROR)", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("strict $.invalid", JsonExistsOnError.UNKNOWN), "JSON_EXISTS(f0, 'strict $.invalid' UNKNOWN ON ERROR)", null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testSqlRuntimeError("JSON_EXISTS(f0, 'strict $.invalid' ERROR ON ERROR)", "No results for path: $['invalid']").testTableApiRuntimeError((Expression)Expressions.$((String)"f0").jsonExists("strict $.invalid", JsonExistsOnError.ERROR), "No results for path: $['invalid']");
    }

    private static BuiltInFunctionTestBase.TestSpec jsonValue() throws Exception {
        InputStream jsonResource = JsonFunctionsITCase.class.getResourceAsStream("/json/json-value.json");
        if (jsonResource == null) {
            throw new IllegalStateException(String.format("%s: Missing test data.", JsonFunctionsITCase.class.getName()));
        }
        String jsonValue = IOUtils.toString((InputStream)jsonResource, (Charset)Charset.defaultCharset());
        return BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.JSON_VALUE).onFieldsWithData(jsonValue).andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.lit(null, (DataType)DataTypes.STRING()).jsonValue("lax $"), "JSON_VALUE(CAST(NULL AS STRING), 'lax $')", null, (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.VARCHAR((int)2000)).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.type"), "JSON_VALUE(f0, '$.type')", "account", (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.VARCHAR((int)2000)).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.activated", DataTypes.BOOLEAN()), "JSON_VALUE(f0, '$.activated' RETURNING BOOLEAN)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.age", DataTypes.INT()), "JSON_VALUE(f0, '$.age' RETURNING INT)", 42, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.balance", DataTypes.DOUBLE()), "JSON_VALUE(f0, '$.balance' RETURNING DOUBLE)", 13.37, (AbstractDataType<?>)DataTypes.DOUBLE()).testResult((Expression)Expressions.$((String)"f0").jsonValue("lax $.invalid", DataTypes.STRING(), JsonValueOnEmptyOrError.NULL, null, JsonValueOnEmptyOrError.ERROR, null), "JSON_VALUE(f0, 'lax $.invalid' NULL ON EMPTY ERROR ON ERROR)", null, (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.VARCHAR((int)2000)).testResult((Expression)Expressions.$((String)"f0").jsonValue("lax $.invalid", DataTypes.INT(), JsonValueOnEmptyOrError.DEFAULT, (Object)42, JsonValueOnEmptyOrError.ERROR, null), "JSON_VALUE(f0, 'lax $.invalid' RETURNING INTEGER DEFAULT 42 ON EMPTY ERROR ON ERROR)", 42, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f0").jsonValue("strict $.invalid", DataTypes.STRING(), JsonValueOnEmptyOrError.ERROR, null, JsonValueOnEmptyOrError.NULL, null), "JSON_VALUE(f0, 'strict $.invalid' ERROR ON EMPTY NULL ON ERROR)", null, (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.VARCHAR((int)2000)).testResult((Expression)Expressions.$((String)"f0").jsonValue("strict $.invalid", DataTypes.INT(), JsonValueOnEmptyOrError.NULL, null, JsonValueOnEmptyOrError.DEFAULT, (Object)42), "JSON_VALUE(f0, 'strict $.invalid' RETURNING INTEGER NULL ON EMPTY DEFAULT 42 ON ERROR)", 42, (AbstractDataType<?>)DataTypes.INT());
    }
}

