/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.dql.SqlRichExplain;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.BeginStatementSetOperation;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.EndStatementSetOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.LoadModuleOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowModulesOperation;
import org.apache.flink.table.operations.UnloadModuleOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.UseModulesOperation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterTableAddConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableDropConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableOptionsOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.expressions.utils.Func8$;
import org.apache.flink.table.planner.operations.SqlToOperationConverter;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.OperationMatchers;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.table.utils.ExpressionResolverMocks;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SqlToOperationConverterTest {
    private final boolean isStreamingMode = false;
    private final TableConfig tableConfig = new TableConfig();
    private final Catalog catalog = new GenericInMemoryCatalog("MockCatalog", "default");
    private final CatalogManager catalogManager = CatalogManagerMocks.preparedCatalogManager().defaultCatalog("builtin", this.catalog).build();
    private final ModuleManager moduleManager = new ModuleManager();
    private final FunctionCatalog functionCatalog = new FunctionCatalog(this.tableConfig, this.catalogManager, this.moduleManager);
    private final Supplier<FlinkPlannerImpl> plannerSupplier = () -> this.getPlannerContext().createFlinkPlanner(this.catalogManager.getCurrentCatalog(), this.catalogManager.getCurrentDatabase());
    private final PlannerContext plannerContext = new PlannerContext(false, this.tableConfig, this.functionCatalog, this.catalogManager, CalciteSchemaBuilder.asRootSchema((Schema)new CatalogManagerCalciteSchema(this.catalogManager, false)), Collections.emptyList());
    private final Parser parser = new ParserImpl(this.catalogManager, this.plannerSupplier, () -> this.plannerSupplier.get().parser(), this.getPlannerContext().getSqlExprToRexConverterFactory());
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    @Before
    public void before() throws TableAlreadyExistException, DatabaseNotExistException {
        this.catalogManager.initSchemaResolver(false, ExpressionResolverMocks.basicResolver((CatalogManager)this.catalogManager, (FunctionCatalog)this.functionCatalog, (Parser)this.parser));
        ObjectPath path1 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t1");
        ObjectPath path2 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t2");
        TableSchema tableSchema = TableSchema.builder().field("a", DataTypes.BIGINT()).field("b", DataTypes.VARCHAR((int)Integer.MAX_VALUE)).field("c", DataTypes.INT()).field("d", DataTypes.VARCHAR((int)Integer.MAX_VALUE)).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "COLLECTION");
        CatalogTableImpl catalogTable = new CatalogTableImpl(tableSchema, options, "");
        this.catalog.createTable(path1, (CatalogBaseTable)catalogTable, true);
        this.catalog.createTable(path2, (CatalogBaseTable)catalogTable, true);
    }

    @After
    public void after() throws TableNotExistException {
        ObjectPath path1 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t1");
        ObjectPath path2 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t2");
        this.catalog.dropTable(path1, true);
        this.catalog.dropTable(path2, true);
    }

    @Test
    public void testUseCatalog() {
        String sql = "USE CATALOG cat1";
        Operation operation = this.parse("USE CATALOG cat1", SqlDialect.DEFAULT);
        assert (operation instanceof UseCatalogOperation);
        Assert.assertEquals((Object)"cat1", (Object)((UseCatalogOperation)operation).getCatalogName());
    }

    @Test
    public void testUseDatabase() {
        String sql1 = "USE db1";
        Operation operation1 = this.parse("USE db1", SqlDialect.DEFAULT);
        assert (operation1 instanceof UseDatabaseOperation);
        Assert.assertEquals((Object)"builtin", (Object)((UseDatabaseOperation)operation1).getCatalogName());
        Assert.assertEquals((Object)"db1", (Object)((UseDatabaseOperation)operation1).getDatabaseName());
        String sql2 = "USE cat1.db1";
        Operation operation2 = this.parse("USE cat1.db1", SqlDialect.DEFAULT);
        assert (operation2 instanceof UseDatabaseOperation);
        Assert.assertEquals((Object)"cat1", (Object)((UseDatabaseOperation)operation2).getCatalogName());
        Assert.assertEquals((Object)"db1", (Object)((UseDatabaseOperation)operation2).getDatabaseName());
    }

    @Test(expected=ValidationException.class)
    public void testUseDatabaseWithException() {
        String sql = "USE cat1.db1.tbl1";
        Operation operation = this.parse("USE cat1.db1.tbl1", SqlDialect.DEFAULT);
    }

    @Test
    public void testCreateDatabase() {
        String[] createDatabaseSqls = new String[]{"create database db1", "create database if not exists cat1.db1", "create database cat1.db1 comment 'db1_comment'", "create database cat1.db1 comment 'db1_comment' with ('k1' = 'v1', 'K2' = 'V2')"};
        String[] expectedCatalogs = new String[]{"builtin", "cat1", "cat1", "cat1"};
        String expectedDatabase = "db1";
        String[] expectedComments = new String[]{null, null, "db1_comment", "db1_comment"};
        boolean[] expectedIgnoreIfExists = new boolean[]{false, true, false, false};
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("k1", "v1");
        properties.put("K2", "V2");
        Map[] expectedProperties = new Map[]{new HashMap(), new HashMap(), new HashMap(), new HashMap(properties)};
        for (int i = 0; i < createDatabaseSqls.length; ++i) {
            Operation operation = this.parse(createDatabaseSqls[i], SqlDialect.DEFAULT);
            assert (operation instanceof CreateDatabaseOperation);
            CreateDatabaseOperation createDatabaseOperation = (CreateDatabaseOperation)operation;
            Assert.assertEquals((Object)expectedCatalogs[i], (Object)createDatabaseOperation.getCatalogName());
            Assert.assertEquals((Object)"db1", (Object)createDatabaseOperation.getDatabaseName());
            Assert.assertEquals((Object)expectedComments[i], (Object)createDatabaseOperation.getCatalogDatabase().getComment());
            Assert.assertEquals((Object)expectedIgnoreIfExists[i], (Object)createDatabaseOperation.isIgnoreIfExists());
            Assert.assertEquals((Object)expectedProperties[i], (Object)createDatabaseOperation.getCatalogDatabase().getProperties());
        }
    }

    @Test
    public void testDropDatabase() {
        String[] dropDatabaseSqls = new String[]{"drop database db1", "drop database if exists db1", "drop database if exists cat1.db1 CASCADE", "drop database if exists cat1.db1 RESTRICT"};
        String[] expectedCatalogs = new String[]{"builtin", "builtin", "cat1", "cat1"};
        String expectedDatabase = "db1";
        boolean[] expectedIfExists = new boolean[]{false, true, true, true};
        boolean[] expectedIsCascades = new boolean[]{false, false, true, false};
        for (int i = 0; i < dropDatabaseSqls.length; ++i) {
            Operation operation = this.parse(dropDatabaseSqls[i], SqlDialect.DEFAULT);
            assert (operation instanceof DropDatabaseOperation);
            DropDatabaseOperation dropDatabaseOperation = (DropDatabaseOperation)operation;
            Assert.assertEquals((Object)expectedCatalogs[i], (Object)dropDatabaseOperation.getCatalogName());
            Assert.assertEquals((Object)"db1", (Object)dropDatabaseOperation.getDatabaseName());
            Assert.assertEquals((Object)expectedIfExists[i], (Object)dropDatabaseOperation.isIfExists());
            Assert.assertEquals((Object)expectedIsCascades[i], (Object)dropDatabaseOperation.isCascade());
        }
    }

    @Test
    public void testAlterDatabase() throws Exception {
        this.catalogManager.registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default", "default"));
        ((Catalog)this.catalogManager.getCatalog("cat1").get()).createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), "db1_comment"), true);
        String sql = "alter database cat1.db1 set ('k1'='v1', 'K2'='V2')";
        Operation operation = this.parse("alter database cat1.db1 set ('k1'='v1', 'K2'='V2')", SqlDialect.DEFAULT);
        assert (operation instanceof AlterDatabaseOperation);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("k1", "v1");
        properties.put("K2", "V2");
        Assert.assertEquals((Object)"db1", (Object)((AlterDatabaseOperation)operation).getDatabaseName());
        Assert.assertEquals((Object)"cat1", (Object)((AlterDatabaseOperation)operation).getCatalogName());
        Assert.assertEquals((Object)"db1_comment", (Object)((AlterDatabaseOperation)operation).getCatalogDatabase().getComment());
        Assert.assertEquals(properties, (Object)((AlterDatabaseOperation)operation).getCatalogDatabase().getProperties());
    }

    @Test
    public void testLoadModule() {
        String sql = "LOAD MODULE dummy WITH ('k1' = 'v1', 'k2' = 'v2')";
        String expectedModuleName = "dummy";
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("k1", "v1");
        expectedOptions.put("k2", "v2");
        Operation operation = this.parse("LOAD MODULE dummy WITH ('k1' = 'v1', 'k2' = 'v2')", SqlDialect.DEFAULT);
        assert (operation instanceof LoadModuleOperation);
        LoadModuleOperation loadModuleOperation = (LoadModuleOperation)operation;
        Assert.assertEquals((Object)"dummy", (Object)loadModuleOperation.getModuleName());
        Assert.assertEquals(expectedOptions, (Object)loadModuleOperation.getOptions());
    }

    @Test
    public void testUnloadModule() {
        String sql = "UNLOAD MODULE dummy";
        String expectedModuleName = "dummy";
        Operation operation = this.parse("UNLOAD MODULE dummy", SqlDialect.DEFAULT);
        assert (operation instanceof UnloadModuleOperation);
        UnloadModuleOperation unloadModuleOperation = (UnloadModuleOperation)operation;
        Assert.assertEquals((Object)"dummy", (Object)unloadModuleOperation.getModuleName());
    }

    @Test
    public void testUseOneModule() {
        String sql = "USE MODULES dummy";
        List<String> expectedModuleNames = Collections.singletonList("dummy");
        Operation operation = this.parse("USE MODULES dummy", SqlDialect.DEFAULT);
        assert (operation instanceof UseModulesOperation);
        UseModulesOperation useModulesOperation = (UseModulesOperation)operation;
        Assert.assertEquals(expectedModuleNames, (Object)useModulesOperation.getModuleNames());
        Assert.assertEquals((Object)"USE MODULES: [dummy]", (Object)useModulesOperation.asSummaryString());
    }

    @Test
    public void testUseMultipleModules() {
        String sql = "USE MODULES x, y, z";
        List<String> expectedModuleNames = Arrays.asList("x", "y", "z");
        Operation operation = this.parse("USE MODULES x, y, z", SqlDialect.DEFAULT);
        assert (operation instanceof UseModulesOperation);
        UseModulesOperation useModulesOperation = (UseModulesOperation)operation;
        Assert.assertEquals(expectedModuleNames, (Object)useModulesOperation.getModuleNames());
        Assert.assertEquals((Object)"USE MODULES: [x, y, z]", (Object)useModulesOperation.asSummaryString());
    }

    @Test
    public void testShowModules() {
        String sql = "SHOW MODULES";
        Operation operation = this.parse("SHOW MODULES", SqlDialect.DEFAULT);
        assert (operation instanceof ShowModulesOperation);
        ShowModulesOperation showModulesOperation = (ShowModulesOperation)operation;
        Assert.assertFalse((boolean)showModulesOperation.requireFull());
        Assert.assertEquals((Object)"SHOW MODULES", (Object)showModulesOperation.asSummaryString());
    }

    @Test
    public void testShowFullModules() {
        String sql = "SHOW FULL MODULES";
        Operation operation = this.parse("SHOW FULL MODULES", SqlDialect.DEFAULT);
        assert (operation instanceof ShowModulesOperation);
        ShowModulesOperation showModulesOperation = (ShowModulesOperation)operation;
        Assert.assertTrue((boolean)showModulesOperation.requireFull());
        Assert.assertEquals((Object)"SHOW FULL MODULES", (Object)showModulesOperation.asSummaryString());
    }

    @Test
    public void testShowFunctions() {
        String sql1 = "SHOW FUNCTIONS";
        this.assertShowFunctions("SHOW FUNCTIONS", "SHOW FUNCTIONS", ShowFunctionsOperation.FunctionScope.ALL);
        String sql2 = "SHOW USER FUNCTIONS";
        this.assertShowFunctions("SHOW USER FUNCTIONS", "SHOW USER FUNCTIONS", ShowFunctionsOperation.FunctionScope.USER);
    }

    @Test
    public void testCreateTable() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar)\n  PARTITIONED BY (a, d)\n  with (\n    'connector' = 'kafka', \n    'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar)\n  PARTITIONED BY (a, d)\n  with (\n    'connector' = 'kafka', \n    'kafka.topic' = 'log.test'\n)\n", planner, parser);
        assert (operation instanceof CreateTableOperation);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        Assert.assertEquals(Arrays.asList("a", "d"), (Object)catalogTable.getPartitionKeys());
        Assert.assertArrayEquals((Object[])catalogTable.getSchema().getFieldNames(), (Object[])new String[]{"a", "b", "c", "d"});
        Assert.assertArrayEquals((Object[])catalogTable.getSchema().getFieldDataTypes(), (Object[])new DataType[]{DataTypes.BIGINT(), DataTypes.VARCHAR((int)Integer.MAX_VALUE), DataTypes.INT(), DataTypes.VARCHAR((int)Integer.MAX_VALUE)});
    }

    @Test
    public void testCreateTableWithPrimaryKey() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 primary key(a, b) not enforced\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 primary key(a, b) not enforced\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n", planner, parser);
        assert (operation instanceof CreateTableOperation);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        TableSchema tableSchema = catalogTable.getSchema();
        Assert.assertThat((Object)tableSchema.getPrimaryKey().map(UniqueConstraint::asSummaryString).orElse("fakeVal"), (Matcher)CoreMatchers.is((Object)"CONSTRAINT ct1 PRIMARY KEY (a, b)"));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])tableSchema.getFieldNames());
        Assert.assertArrayEquals((Object[])new DataType[]{(DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.STRING().notNull(), DataTypes.INT(), DataTypes.STRING()}, (Object[])tableSchema.getFieldDataTypes());
    }

    @Test
    public void testCreateTableWithPrimaryKeyEnforced() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 primary key(a, b)\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Flink doesn't support ENFORCED mode for PRIMARY KEY constraint. ENFORCED/NOT ENFORCED  controls if the constraint checks are performed on the incoming/outgoing data. Flink does not own the data therefore the only supported mode is the NOT ENFORCED mode");
        this.parse("CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 primary key(a, b)\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n", planner, parser);
    }

    @Test
    public void testCreateTableWithUniqueKey() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 unique (a, b) not enforced\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("UNIQUE constraint is not supported yet");
        this.parse("CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 unique (a, b) not enforced\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n", planner, parser);
    }

    @Test
    public void testPrimaryKeyOnGeneratedColumn() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Could not create a PRIMARY KEY with column 'c' at line 5, column 34.\nA PRIMARY KEY constraint must be declared on physical columns.");
        String sql2 = "CREATE TABLE tbl1 (\n  a bigint not null,\n  b varchar not null,\n  c as 2 * (a + 1),\n  constraint ct1 primary key (b, c) not enforced) with (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n";
        this.parseAndConvert("CREATE TABLE tbl1 (\n  a bigint not null,\n  b varchar not null,\n  c as 2 * (a + 1),\n  constraint ct1 primary key (b, c) not enforced) with (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n");
    }

    @Test
    public void testPrimaryKeyNonExistentColumn() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Primary key column 'd' is not defined in the schema at line 5, column 34");
        String sql2 = "CREATE TABLE tbl1 (\n  a bigint not null,\n  b varchar not null,\n  c as 2 * (a + 1),\n  constraint ct1 primary key (b, d) not enforced) with (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n";
        this.parseAndConvert("CREATE TABLE tbl1 (\n  a bigint not null,\n  b varchar not null,\n  c as 2 * (a + 1),\n  constraint ct1 primary key (b, d) not enforced) with (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n");
    }

    @Test
    public void testCreateTableWithMinusInOptionKey() {
        String sql = "create table source_table(\n  a int,\n  b bigint,\n  c varchar\n) with (\n  'a-B-c-d124' = 'Ab',\n  'a.b-c-d.e-f.g' = 'ada',\n  'a.b-c-d.e-f1231.g' = 'ada',\n  'a.b-c-d.*' = 'adad')\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse("create table source_table(\n  a int,\n  b bigint,\n  c varchar\n) with (\n  'a-B-c-d124' = 'Ab',\n  'a.b-c-d.e-f.g' = 'ada',\n  'a.b-c-d.e-f1231.g' = 'ada',\n  'a.b-c-d.*' = 'adad')\n");
        assert (node instanceof SqlCreateTable);
        Operation operation = (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
        assert (operation instanceof CreateTableOperation);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        Map<String, String> options = catalogTable.getOptions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        TreeMap<String, String> sortedProperties = new TreeMap<String, String>(options);
        String expected = "{a-B-c-d124=Ab, a.b-c-d.*=adad, a.b-c-d.e-f.g=ada, a.b-c-d.e-f1231.g=ada}";
        Assert.assertEquals((Object)"{a-B-c-d124=Ab, a.b-c-d.*=adad, a.b-c-d.e-f.g=ada, a.b-c-d.e-f1231.g=ada}", (Object)((Object)sortedProperties).toString());
    }

    @Test
    public void testExplainWithSelect() {
        String sql = "explain select * from t1";
        this.checkExplainSql("explain select * from t1");
    }

    @Test
    public void testExplainWithInsert() {
        String sql = "explain insert into t2 select * from t1";
        this.checkExplainSql("explain insert into t2 select * from t1");
    }

    @Test
    public void testExplainWithUnion() {
        String sql = "explain select * from t1 union select * from t2";
        this.checkExplainSql("explain select * from t1 union select * from t2");
    }

    @Test
    public void testExplainWithExplainDetails() {
        String sql = "explain changelog_mode, estimated_cost, json_execution_plan select * from t1";
        this.checkExplainSql(sql);
    }

    private void checkExplainSql(String sql) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        assert (node instanceof SqlRichExplain);
        Operation operation = (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
        assert (operation instanceof ExplainOperation);
    }

    @Test
    public void testCreateTableWithWatermark() throws FunctionAlreadyExistException, DatabaseNotExistException {
        CatalogFunctionImpl cf = new CatalogFunctionImpl(JavaUserDefinedScalarFunctions.JavaFunc5.class.getName());
        this.catalog.createFunction(ObjectPath.fromString((String)"default.myfunc"), (CatalogFunction)cf, true);
        String sql = "create table source_table(\n  a int,\n  b bigint,\n  c timestamp(3),\n  watermark for `c` as myfunc(c, 1) - interval '5' second\n) with (\n  'connector.type' = 'kafka')\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse("create table source_table(\n  a int,\n  b bigint,\n  c timestamp(3),\n  watermark for `c` as myfunc(c, 1) - interval '5' second\n) with (\n  'connector.type' = 'kafka')\n");
        assert (node instanceof SqlCreateTable);
        Operation operation = (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
        assert (operation instanceof CreateTableOperation);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        Map properties = catalogTable.toProperties();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("schema.0.name", "a");
        expected.put("schema.0.data-type", "INT");
        expected.put("schema.1.name", "b");
        expected.put("schema.1.data-type", "BIGINT");
        expected.put("schema.2.name", "c");
        expected.put("schema.2.data-type", "TIMESTAMP(3)");
        expected.put("schema.watermark.0.rowtime", "c");
        expected.put("schema.watermark.0.strategy.expr", "`builtin`.`default`.`myfunc`(`c`, 1) - INTERVAL '5' SECOND");
        expected.put("schema.watermark.0.strategy.data-type", "TIMESTAMP(3)");
        expected.put("connector.type", "kafka");
        Assert.assertEquals(expected, (Object)properties);
    }

    @Test
    public void testBasicCreateTableLike() {
        HashMap<String, String> sourceProperties = new HashMap<String, String>();
        sourceProperties.put("format.type", "json");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build(), null, Collections.emptyList(), sourceProperties);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nPARTITIONED BY (a, f0)\nwith (\n  'connector.type' = 'kafka')\nlike sourceTable";
        Operation operation = this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nPARTITIONED BY (a, f0)\nwith (\n  'connector.type' = 'kafka')\nlike sourceTable");
        Assert.assertThat((Object)operation, OperationMatchers.isCreateTableOperation(OperationMatchers.withSchema(org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).column("a", (AbstractDataType)DataTypes.INT()).watermark("f1", "`f1` - INTERVAL '5' SECOND").build()), OperationMatchers.withOptions(OperationMatchers.entry("connector.type", "kafka"), OperationMatchers.entry("format.type", "json")), OperationMatchers.partitionedBy("a", "f0")));
    }

    @Test
    public void testCreateTableLikeWithFullPath() {
        HashMap<String, String> sourceProperties = new HashMap<String, String>();
        sourceProperties.put("connector.type", "kafka");
        sourceProperties.put("format.type", "json");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build(), null, Collections.emptyList(), sourceProperties);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table mytable like `builtin`.`default`.sourceTable";
        Operation operation = this.parseAndConvert("create table mytable like `builtin`.`default`.sourceTable");
        Assert.assertThat((Object)operation, OperationMatchers.isCreateTableOperation(OperationMatchers.withSchema(org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build()), OperationMatchers.withOptions(OperationMatchers.entry("connector.type", "kafka"), OperationMatchers.entry("format.type", "json"))));
    }

    @Test
    public void testMergingCreateTableLike() {
        HashMap<String, String> sourceProperties = new HashMap<String, String>();
        sourceProperties.put("format.type", "json");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).columnByExpression("f2", "`f0` + 12345").watermark("f1", "`f1` - interval '1' second").build(), null, Arrays.asList("f0", "f1"), sourceProperties);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nPARTITIONED BY (a, f0)\nwith (\n  'connector.type' = 'kafka')\nlike sourceTable (\n   EXCLUDING GENERATED\n   EXCLUDING PARTITIONS\n   OVERWRITING OPTIONS\n   OVERWRITING WATERMARKS)";
        Operation operation = this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nPARTITIONED BY (a, f0)\nwith (\n  'connector.type' = 'kafka')\nlike sourceTable (\n   EXCLUDING GENERATED\n   EXCLUDING PARTITIONS\n   OVERWRITING OPTIONS\n   OVERWRITING WATERMARKS)");
        Assert.assertThat((Object)operation, OperationMatchers.isCreateTableOperation(OperationMatchers.withSchema(org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).column("a", (AbstractDataType)DataTypes.INT()).watermark("f1", "`f1` - INTERVAL '5' SECOND").build()), OperationMatchers.withOptions(OperationMatchers.entry("connector.type", "kafka"), OperationMatchers.entry("format.type", "json")), OperationMatchers.partitionedBy("a", "f0")));
    }

    @Test
    public void testCreateTableInvalidPartition() {
        String sql = "create table derivedTable(\n  a int\n)\nPARTITIONED BY (f3)";
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Partition column 'f3' not defined in the table schema. Available columns: ['a']");
        this.parseAndConvert("create table derivedTable(\n  a int\n)\nPARTITIONED BY (f3)");
    }

    @Test
    public void testCreateTableLikeInvalidPartition() {
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).build(), null, Collections.emptyList(), Collections.emptyMap());
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int\n)\nPARTITIONED BY (f3)\nlike sourceTable";
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Partition column 'f3' not defined in the table schema. Available columns: ['f0', 'a']");
        this.parseAndConvert("create table derivedTable(\n  a int\n)\nPARTITIONED BY (f3)\nlike sourceTable");
    }

    @Test
    public void testCreateTableInvalidWatermark() {
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)";
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("The rowtime attribute field 'f1' is not defined in the table schema, at line 3, column 17\nAvailable fields: ['a']");
        this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)");
    }

    @Test
    public void testCreateTableLikeInvalidWatermark() {
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).build(), null, Collections.emptyList(), Collections.emptyMap());
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nlike sourceTable";
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("The rowtime attribute field 'f1' is not defined in the table schema, at line 3, column 17\nAvailable fields: ['f0', 'a']");
        this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nlike sourceTable");
    }

    @Test
    public void testCreateTableLikeNestedWatermark() {
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"tmstmp", (DataType)DataTypes.TIMESTAMP((int)3))})).build(), null, Collections.emptyList(), Collections.emptyMap());
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1.t as f1.t - interval '5' second\n)\nlike sourceTable";
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("The rowtime attribute field 'f1.t' is not defined in the table schema, at line 3, column 20\nNested field 't' was not found in a composite type: ROW<`tmstmp` TIMESTAMP(3)>.");
        this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1.t as f1.t - interval '5' second\n)\nlike sourceTable");
    }

    @Test
    public void testSqlInsertWithStaticPartition() {
        String sql = "insert into t1 partition(a=1) select b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("insert into t1 partition(a=1) select b, c, d from t2", planner, parser);
        assert (operation instanceof CatalogSinkModifyOperation);
        CatalogSinkModifyOperation sinkModifyOperation = (CatalogSinkModifyOperation)operation;
        HashMap<String, String> expectedStaticPartitions = new HashMap<String, String>();
        expectedStaticPartitions.put("a", "1");
        Assert.assertEquals(expectedStaticPartitions, (Object)sinkModifyOperation.getStaticPartitions());
    }

    @Test
    public void testSqlInsertWithDynamicTableOptions() {
        String sql = "insert into t1 /*+ OPTIONS('k1'='v1', 'k2'='v2') */\nselect a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("insert into t1 /*+ OPTIONS('k1'='v1', 'k2'='v2') */\nselect a, b, c, d from t2", planner, parser);
        assert (operation instanceof CatalogSinkModifyOperation);
        CatalogSinkModifyOperation sinkModifyOperation = (CatalogSinkModifyOperation)operation;
        Map dynamicOptions = sinkModifyOperation.getDynamicOptions();
        Assert.assertNotNull((Object)dynamicOptions);
        Assert.assertThat((Object)dynamicOptions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)dynamicOptions.toString(), (Matcher)CoreMatchers.is((Object)"{k1=v1, k2=v2}"));
    }

    @Test
    public void testDynamicTableWithInvalidOptions() {
        String sql = "select * from t1 /*+ OPTIONS('opt1', 'opt2') */";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        this.thrown.expect(AssertionError.class);
        this.thrown.expectMessage("Hint [OPTIONS] only support non empty key value options");
        this.parse("select * from t1 /*+ OPTIONS('opt1', 'opt2') */", planner, parser);
    }

    @Test
    public void testCreateTableWithFullDataTypes() {
        List<TestItem> testItems = Arrays.asList(SqlToOperationConverterTest.createTestItem("CHAR", DataTypes.CHAR((int)1)), SqlToOperationConverterTest.createTestItem("CHAR NOT NULL", DataTypes.CHAR((int)1).notNull()), SqlToOperationConverterTest.createTestItem("CHAR NULL", DataTypes.CHAR((int)1)), SqlToOperationConverterTest.createTestItem("CHAR(33)", DataTypes.CHAR((int)33)), SqlToOperationConverterTest.createTestItem("VARCHAR", DataTypes.STRING()), SqlToOperationConverterTest.createTestItem("VARCHAR(33)", DataTypes.VARCHAR((int)33)), SqlToOperationConverterTest.createTestItem("STRING", DataTypes.STRING()), SqlToOperationConverterTest.createTestItem("BOOLEAN", DataTypes.BOOLEAN()), SqlToOperationConverterTest.createTestItem("BINARY", DataTypes.BINARY((int)1)), SqlToOperationConverterTest.createTestItem("BINARY(33)", DataTypes.BINARY((int)33)), SqlToOperationConverterTest.createTestItem("VARBINARY", DataTypes.BYTES()), SqlToOperationConverterTest.createTestItem("VARBINARY(33)", DataTypes.VARBINARY((int)33)), SqlToOperationConverterTest.createTestItem("BYTES", DataTypes.BYTES()), SqlToOperationConverterTest.createTestItem("DECIMAL", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("DEC", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("NUMERIC", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("DECIMAL(10)", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("DEC(10)", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("NUMERIC(10)", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("DECIMAL(10, 3)", DataTypes.DECIMAL((int)10, (int)3)), SqlToOperationConverterTest.createTestItem("DEC(10, 3)", DataTypes.DECIMAL((int)10, (int)3)), SqlToOperationConverterTest.createTestItem("NUMERIC(10, 3)", DataTypes.DECIMAL((int)10, (int)3)), SqlToOperationConverterTest.createTestItem("TINYINT", DataTypes.TINYINT()), SqlToOperationConverterTest.createTestItem("SMALLINT", DataTypes.SMALLINT()), SqlToOperationConverterTest.createTestItem("INTEGER", DataTypes.INT()), SqlToOperationConverterTest.createTestItem("INT", DataTypes.INT()), SqlToOperationConverterTest.createTestItem("BIGINT", DataTypes.BIGINT()), SqlToOperationConverterTest.createTestItem("FLOAT", DataTypes.FLOAT()), SqlToOperationConverterTest.createTestItem("DOUBLE", DataTypes.DOUBLE()), SqlToOperationConverterTest.createTestItem("DOUBLE PRECISION", DataTypes.DOUBLE()), SqlToOperationConverterTest.createTestItem("DATE", DataTypes.DATE()), SqlToOperationConverterTest.createTestItem("TIME", DataTypes.TIME()), SqlToOperationConverterTest.createTestItem("TIME WITHOUT TIME ZONE", DataTypes.TIME()), SqlToOperationConverterTest.createTestItem("TIME(3)", DataTypes.TIME()), SqlToOperationConverterTest.createTestItem("TIME(3) WITHOUT TIME ZONE", DataTypes.TIME()), SqlToOperationConverterTest.createTestItem("TIMESTAMP", DataTypes.TIMESTAMP((int)6)), SqlToOperationConverterTest.createTestItem("TIMESTAMP WITHOUT TIME ZONE", DataTypes.TIMESTAMP((int)6)), SqlToOperationConverterTest.createTestItem("TIMESTAMP(3)", DataTypes.TIMESTAMP((int)3)), SqlToOperationConverterTest.createTestItem("TIMESTAMP(3) WITHOUT TIME ZONE", DataTypes.TIMESTAMP((int)3)), SqlToOperationConverterTest.createTestItem("TIMESTAMP WITH LOCAL TIME ZONE", DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)6)), SqlToOperationConverterTest.createTestItem("TIMESTAMP(3) WITH LOCAL TIME ZONE", DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)), SqlToOperationConverterTest.createTestItem("ARRAY<TIMESTAMP(3) WITH LOCAL TIME ZONE>", DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3))), SqlToOperationConverterTest.createTestItem("ARRAY<INT NOT NULL>", DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull()))), SqlToOperationConverterTest.createTestItem("INT ARRAY", DataTypes.ARRAY((DataType)DataTypes.INT())), SqlToOperationConverterTest.createTestItem("INT NOT NULL ARRAY", DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull()))), SqlToOperationConverterTest.createTestItem("INT ARRAY NOT NULL", DataTypes.ARRAY((DataType)DataTypes.INT()).notNull()), SqlToOperationConverterTest.createTestItem("MULTISET<INT NOT NULL>", DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().notNull()))), SqlToOperationConverterTest.createTestItem("INT MULTISET", DataTypes.MULTISET((DataType)DataTypes.INT())), SqlToOperationConverterTest.createTestItem("INT NOT NULL MULTISET", DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().notNull()))), SqlToOperationConverterTest.createTestItem("INT MULTISET NOT NULL", DataTypes.MULTISET((DataType)DataTypes.INT()).notNull()), SqlToOperationConverterTest.createTestItem("MAP<BIGINT, BOOLEAN>", DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)DataTypes.BOOLEAN())), SqlToOperationConverterTest.createTestItem("ROW<f0 INT NOT NULL, f1 BOOLEAN>", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})), SqlToOperationConverterTest.createTestItem("ROW(f0 INT NOT NULL, f1 BOOLEAN)", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})), SqlToOperationConverterTest.createTestItem("ROW<`f0` INT>", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())})), SqlToOperationConverterTest.createTestItem("ROW(`f0` INT)", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())})), SqlToOperationConverterTest.createTestItem("ROW<>", DataTypes.ROW()), SqlToOperationConverterTest.createTestItem("ROW()", DataTypes.ROW()), SqlToOperationConverterTest.createTestItem("ROW<f0 INT NOT NULL 'This is a comment.', f1 BOOLEAN 'This as well.'>", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})), SqlToOperationConverterTest.createTestItem("ARRAY<ROW<f0 INT, f1 BOOLEAN>>", DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())}))), SqlToOperationConverterTest.createTestItem("ROW<f0 INT, f1 BOOLEAN> MULTISET", DataTypes.MULTISET((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())}))), SqlToOperationConverterTest.createTestItem("MULTISET<ROW<f0 INT, f1 BOOLEAN>>", DataTypes.MULTISET((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())}))), SqlToOperationConverterTest.createTestItem("ROW<f0 Row<f00 INT, f01 BOOLEAN>, f1 INT ARRAY, f2 BOOLEAN MULTISET>", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f00", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f01", (DataType)DataTypes.BOOLEAN())})), DataTypes.FIELD((String)"f1", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.FIELD((String)"f2", (DataType)DataTypes.MULTISET((DataType)DataTypes.BOOLEAN()))})));
        StringBuilder buffer = new StringBuilder("create table t1(\n");
        for (int i = 0; i < testItems.size(); ++i) {
            buffer.append("f").append(i).append(" ").append(testItems.get(i).testExpr);
            if (i == testItems.size() - 1) {
                buffer.append(")");
                continue;
            }
            buffer.append(",\n");
        }
        String sql = buffer.toString();
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        assert (node instanceof SqlCreateTable);
        Operation operation = (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
        TableSchema schema = ((CreateTableOperation)operation).getCatalogTable().getSchema();
        Object[] expectedDataTypes = testItems.stream().map(item -> ((TestItem)item).expectedType).toArray();
        Assert.assertArrayEquals((Object[])expectedDataTypes, (Object[])schema.getFieldDataTypes());
    }

    @Test
    public void testCreateTableWithComputedColumn() {
        String sql = "CREATE TABLE tbl1 (\n  a int,\n  b varchar, \n  c as a - 1, \n  d as b || '$$', \n  e as my_udf1(a),  f as `default`.my_udf2(a) + 1,  g as builtin.`default`.my_udf3(a) || '##'\n)\n  with (\n    'connector' = 'kafka', \n    'kafka.topic' = 'log.test'\n)\n";
        this.functionCatalog.registerTempCatalogScalarFunction(ObjectIdentifier.of((String)"builtin", (String)"default", (String)"my_udf1"), (ScalarFunction)Func0$.MODULE$);
        this.functionCatalog.registerTempCatalogScalarFunction(ObjectIdentifier.of((String)"builtin", (String)"default", (String)"my_udf2"), (ScalarFunction)Func1$.MODULE$);
        this.functionCatalog.registerTempCatalogScalarFunction(ObjectIdentifier.of((String)"builtin", (String)"default", (String)"my_udf3"), (ScalarFunction)Func8$.MODULE$);
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("CREATE TABLE tbl1 (\n  a int,\n  b varchar, \n  c as a - 1, \n  d as b || '$$', \n  e as my_udf1(a),  f as `default`.my_udf2(a) + 1,  g as builtin.`default`.my_udf3(a) || '##'\n)\n  with (\n    'connector' = 'kafka', \n    'kafka.topic' = 'log.test'\n)\n", planner, this.getParserBySqlDialect(SqlDialect.DEFAULT));
        assert (operation instanceof CreateTableOperation);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g"}, (Object[])catalogTable.getSchema().getFieldNames());
        Assert.assertArrayEquals((Object[])new DataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.INT(), DataTypes.STRING(), (DataType)DataTypes.INT().notNull(), DataTypes.INT(), DataTypes.STRING()}, (Object[])catalogTable.getSchema().getFieldDataTypes());
        Object[] columnExpressions = (String[])catalogTable.getSchema().getTableColumns().stream().filter(TableColumn.ComputedColumn.class::isInstance).map(TableColumn.ComputedColumn.class::cast).map(TableColumn.ComputedColumn::getExpression).toArray(String[]::new);
        Object[] expected = new String[]{"`a` - 1", "`b` || '$$'", "`builtin`.`default`.`my_udf1`(`a`)", "`builtin`.`default`.`my_udf2`(`a`) + 1", "`builtin`.`default`.`my_udf3`(`a`) || '##'"};
        Assert.assertArrayEquals((Object[])expected, (Object[])columnExpressions);
    }

    @Test
    public void testCreateTableWithMetadataColumn() {
        String sql = "CREATE TABLE tbl1 (\n  a INT,\n  b STRING,\n  c INT METADATA,\n  d INT METADATA FROM 'other.key',\n  e INT METADATA VIRTUAL\n)\n  WITH (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("CREATE TABLE tbl1 (\n  a INT,\n  b STRING,\n  c INT METADATA,\n  d INT METADATA FROM 'other.key',\n  e INT METADATA VIRTUAL\n)\n  WITH (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n", planner, this.getParserBySqlDialect(SqlDialect.DEFAULT));
        assert (operation instanceof CreateTableOperation);
        CreateTableOperation op = (CreateTableOperation)operation;
        TableSchema actualSchema = op.getCatalogTable().getSchema();
        TableSchema expectedSchema = TableSchema.builder().add((TableColumn)TableColumn.physical((String)"a", (DataType)DataTypes.INT())).add((TableColumn)TableColumn.physical((String)"b", (DataType)DataTypes.STRING())).add((TableColumn)TableColumn.metadata((String)"c", (DataType)DataTypes.INT())).add((TableColumn)TableColumn.metadata((String)"d", (DataType)DataTypes.INT(), (String)"other.key")).add((TableColumn)TableColumn.metadata((String)"e", (DataType)DataTypes.INT(), (boolean)true)).build();
        Assert.assertEquals((Object)expectedSchema, (Object)actualSchema);
    }

    @Test
    public void testAlterTable() throws Exception {
        this.prepareTable(false);
        String[] renameTableSqls = new String[]{"alter table cat1.db1.tb1 rename to tb2", "alter table db1.tb1 rename to tb2", "alter table tb1 rename to cat1.db1.tb2"};
        ObjectIdentifier expectedIdentifier = ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tb1");
        ObjectIdentifier expectedNewIdentifier = ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tb2");
        for (int i = 0; i < renameTableSqls.length; ++i) {
            Operation operation = this.parse(renameTableSqls[i], SqlDialect.DEFAULT);
            assert (operation instanceof AlterTableRenameOperation);
            AlterTableRenameOperation alterTableRenameOperation = (AlterTableRenameOperation)operation;
            Assert.assertEquals((Object)expectedIdentifier, (Object)alterTableRenameOperation.getTableIdentifier());
            Assert.assertEquals((Object)expectedNewIdentifier, (Object)alterTableRenameOperation.getNewTableIdentifier());
        }
        Operation operation = this.parse("alter table cat1.db1.tb1 set ('k1' = 'v1', 'K2' = 'V2')", SqlDialect.DEFAULT);
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("k", "v");
        expectedOptions.put("k1", "v1");
        expectedOptions.put("K2", "V2");
        this.assertAlterTableOptions(operation, expectedIdentifier, expectedOptions);
        operation = this.parse("alter table cat1.db1.tb1 reset ('k')", SqlDialect.DEFAULT);
        this.assertAlterTableOptions(operation, expectedIdentifier, Collections.emptyMap());
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("ALTER TABLE RESET does not support empty key");
        this.parse("alter table cat1.db1.tb1 reset ()", SqlDialect.DEFAULT);
    }

    @Test
    public void testAlterTableAddPkConstraint() throws Exception {
        this.prepareTable(false);
        Operation operation = this.parse("alter table tb1 add constraint ct1 primary key(a, b) not enforced", SqlDialect.DEFAULT);
        assert (operation instanceof AlterTableAddConstraintOperation);
        AlterTableAddConstraintOperation addConstraintOperation = (AlterTableAddConstraintOperation)operation;
        Assert.assertThat((Object)addConstraintOperation.asSummaryString(), (Matcher)CoreMatchers.is((Object)"ALTER TABLE ADD CONSTRAINT: (identifier: [`cat1`.`db1`.`tb1`], constraintName: [ct1], columns: [a, b])"));
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Could not create a PRIMARY KEY 'ct1'. Column 'c' is nullable.");
        this.parse("alter table tb1 add constraint ct1 primary key(c) not enforced", SqlDialect.DEFAULT);
    }

    @Test
    public void testAlterTableAddPkConstraintEnforced() throws Exception {
        this.prepareTable(false);
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Flink doesn't support ENFORCED mode for PRIMARY KEY constraint. ENFORCED/NOT ENFORCED  controls if the constraint checks are performed on the incoming/outgoing data. Flink does not own the data therefore the only supported mode is the NOT ENFORCED mode");
        this.parse("alter table tb1 add constraint ct1 primary key(a, b)", SqlDialect.DEFAULT);
    }

    @Test
    public void testAlterTableAddUniqueConstraint() throws Exception {
        this.prepareTable(false);
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("UNIQUE constraint is not supported yet");
        this.parse("alter table tb1 add constraint ct1 unique(a, b) not enforced", SqlDialect.DEFAULT);
    }

    @Test
    public void testAlterTableAddUniqueConstraintEnforced() throws Exception {
        this.prepareTable(false);
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("UNIQUE constraint is not supported yet");
        this.parse("alter table tb1 add constraint ct1 unique(a, b)", SqlDialect.DEFAULT);
    }

    @Test
    public void testAlterTableDropConstraint() throws Exception {
        this.prepareTable(true);
        Operation operation = this.parse("alter table tb1 drop constraint ct1", SqlDialect.DEFAULT);
        assert (operation instanceof AlterTableDropConstraintOperation);
        AlterTableDropConstraintOperation dropConstraint = (AlterTableDropConstraintOperation)operation;
        Assert.assertThat((Object)dropConstraint.asSummaryString(), (Matcher)CoreMatchers.is((Object)"ALTER TABLE `cat1`.`db1`.`tb1` DROP CONSTRAINT ct1"));
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("CONSTRAINT [ct2] does not exist");
        this.parse("alter table tb1 drop constraint ct2", SqlDialect.DEFAULT);
    }

    @Test
    public void testCreateViewWithMatchRecognize() {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("connector", "values");
        prop.put("bounded", "true");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("id", DataTypes.INT().notNull()).column("measurement", DataTypes.BIGINT().notNull()).column("ts", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"tmstmp", (DataType)DataTypes.TIMESTAMP((int)3))})).build(), null, Collections.emptyList(), prop);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"events"), false);
        String sql = "CREATE TEMPORARY VIEW foo AS SELECT * FROM events MATCH_RECOGNIZE (    PARTITION BY id     ORDER BY ts ASC     MEASURES       next_step.measurement - this_step.measurement AS diff     AFTER MATCH SKIP TO NEXT ROW     PATTERN (this_step next_step)    DEFINE          this_step AS TRUE,         next_step AS TRUE)";
        Operation operation = this.parse("CREATE TEMPORARY VIEW foo AS SELECT * FROM events MATCH_RECOGNIZE (    PARTITION BY id     ORDER BY ts ASC     MEASURES       next_step.measurement - this_step.measurement AS diff     AFTER MATCH SKIP TO NEXT ROW     PATTERN (this_step next_step)    DEFINE          this_step AS TRUE,         next_step AS TRUE)", SqlDialect.DEFAULT);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.instanceOf(CreateViewOperation.class));
    }

    @Test
    public void testCreateViewWithDynamicTableOptions() {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("connector", "values");
        prop.put("bounded", "true");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).column("f1", (AbstractDataType)DataTypes.VARCHAR((int)20)).build(), null, Collections.emptyList(), prop);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceA"), false);
        String sql = "create view test_view as\nselect *\nfrom sourceA /*+ OPTIONS('changelog-mode'='I') */";
        Operation operation = this.parse("create view test_view as\nselect *\nfrom sourceA /*+ OPTIONS('changelog-mode'='I') */", SqlDialect.DEFAULT);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.instanceOf(CreateViewOperation.class));
    }

    @Test
    public void testBeginStatementSet() {
        String sql = "BEGIN STATEMENT SET";
        Operation operation = this.parse("BEGIN STATEMENT SET", SqlDialect.DEFAULT);
        assert (operation instanceof BeginStatementSetOperation);
        BeginStatementSetOperation beginStatementSetOperation = (BeginStatementSetOperation)operation;
        Assert.assertEquals((Object)"BEGIN STATEMENT SET", (Object)beginStatementSetOperation.asSummaryString());
    }

    @Test
    public void testEnd() {
        String sql = "END";
        Operation operation = this.parse("END", SqlDialect.DEFAULT);
        assert (operation instanceof EndStatementSetOperation);
        EndStatementSetOperation endStatementSetOperation = (EndStatementSetOperation)operation;
        Assert.assertEquals((Object)"END", (Object)endStatementSetOperation.asSummaryString());
    }

    @Test
    public void testSqlRichExplainWithSelect() {
        String sql = "explain plan for select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("explain plan for select a, b, c, d from t2", planner, parser);
        Assert.assertTrue((boolean)(operation instanceof ExplainOperation));
    }

    @Test
    public void testSqlRichExplainWithInsert() {
        String sql = "explain plan for insert into t1 select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("explain plan for insert into t1 select a, b, c, d from t2", planner, parser);
        Assert.assertTrue((boolean)(operation instanceof ExplainOperation));
    }

    @Test
    public void testAddJar() {
        Arrays.asList("./test.\njar", "file:///path/to/whatever", "../test-jar.jar", "/root/test.jar", "test\\ jar.jar", "oss://path/helloworld.go").forEach(jarPath -> {
            AddJarOperation operation = (AddJarOperation)this.parser.parse(String.format("ADD JAR '%s'", jarPath)).get(0);
            Assert.assertEquals((Object)jarPath, (Object)operation.getPath());
        });
    }

    @Test
    public void testRemoveJar() {
        Arrays.asList("./test.\njar", "file:///path/to/whatever", "../test-jar.jar", "/root/test.jar", "test\\ jar.jar", "oss://path/helloworld.go").forEach(jarPath -> {
            RemoveJarOperation operation = (RemoveJarOperation)this.parser.parse(String.format("REMOVE JAR '%s'", jarPath)).get(0);
            Assert.assertEquals((Object)jarPath, (Object)operation.getPath());
        });
    }

    @Test
    public void testShowJars() {
        String sql = "SHOW JARS";
        Operation operation = this.parse("SHOW JARS", SqlDialect.DEFAULT);
        assert (operation instanceof ShowJarsOperation);
        ShowJarsOperation showModulesOperation = (ShowJarsOperation)operation;
        Assert.assertEquals((Object)"SHOW JARS", (Object)showModulesOperation.asSummaryString());
    }

    @Test
    public void testSet() {
        Operation operation1 = this.parse("SET", SqlDialect.DEFAULT);
        Assert.assertTrue((boolean)(operation1 instanceof SetOperation));
        Assert.assertFalse((boolean)((SetOperation)operation1).getKey().isPresent());
        Assert.assertFalse((boolean)((SetOperation)operation1).getValue().isPresent());
        Operation operation2 = this.parse("SET 'test-key' = 'test-value'", SqlDialect.DEFAULT);
        Assert.assertTrue((boolean)(operation2 instanceof SetOperation));
        Assert.assertEquals((Object)"test-key", ((SetOperation)operation2).getKey().get());
        Assert.assertEquals((Object)"test-value", ((SetOperation)operation2).getValue().get());
    }

    @Test
    public void testReset() {
        Operation operation1 = this.parse("RESET", SqlDialect.DEFAULT);
        Assert.assertTrue((boolean)(operation1 instanceof ResetOperation));
        Assert.assertFalse((boolean)((ResetOperation)operation1).getKey().isPresent());
        Operation operation2 = this.parse("RESET 'test-key'", SqlDialect.DEFAULT);
        Assert.assertTrue((boolean)(operation2 instanceof ResetOperation));
        Assert.assertTrue((boolean)((ResetOperation)operation2).getKey().isPresent());
        Assert.assertEquals((Object)"test-key", ((ResetOperation)operation2).getKey().get());
    }

    private static TestItem createTestItem(Object ... args) {
        assert (args.length == 2);
        String testExpr = (String)args[0];
        TestItem testItem = TestItem.fromTestExpr(testExpr);
        if (args[1] instanceof String) {
            testItem.withExpectedError((String)args[1]);
        } else {
            testItem.withExpectedType(args[1]);
        }
        return testItem;
    }

    private void assertShowFunctions(String sql, String expectedSummary, ShowFunctionsOperation.FunctionScope expectedScope) {
        Operation operation = this.parse(sql, SqlDialect.DEFAULT);
        assert (operation instanceof ShowFunctionsOperation);
        ShowFunctionsOperation showFunctionsOperation = (ShowFunctionsOperation)operation;
        Assert.assertEquals((Object)expectedScope, (Object)showFunctionsOperation.getFunctionScope());
        Assert.assertEquals((Object)expectedSummary, (Object)showFunctionsOperation.asSummaryString());
    }

    private void assertAlterTableOptions(Operation operation, ObjectIdentifier expectedIdentifier, Map<String, String> expectedOptions) {
        assert (operation instanceof AlterTableOptionsOperation);
        AlterTableOptionsOperation alterTableOptionsOperation = (AlterTableOptionsOperation)operation;
        Assert.assertEquals((Object)expectedIdentifier, (Object)alterTableOptionsOperation.getTableIdentifier());
        Assert.assertEquals((long)expectedOptions.size(), (long)alterTableOptionsOperation.getCatalogTable().getOptions().size());
        Assert.assertEquals(expectedOptions, (Object)alterTableOptionsOperation.getCatalogTable().getOptions());
    }

    private Operation parse(String sql, FlinkPlannerImpl planner, CalciteParser parser) {
        SqlNode node = parser.parse(sql);
        return (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    private Operation parse(String sql, SqlDialect sqlDialect) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(sqlDialect);
        CalciteParser parser = this.getParserBySqlDialect(sqlDialect);
        SqlNode node = parser.parse(sql);
        return (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    private void prepareTable(boolean hasConstraint) throws Exception {
        GenericInMemoryCatalog catalog = new GenericInMemoryCatalog("default", "default");
        this.catalogManager.registerCatalog("cat1", (Catalog)catalog);
        catalog.createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), null), true);
        Schema.Builder builder = org.apache.flink.table.api.Schema.newBuilder().column("a", DataTypes.STRING().notNull()).column("b", DataTypes.BIGINT().notNull()).column("c", (AbstractDataType)DataTypes.BIGINT());
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)(hasConstraint ? builder.primaryKeyNamed("ct1", new String[]{"a", "b"}).build() : builder.build()), (String)"tb1", Collections.emptyList(), Collections.singletonMap("k", "v"));
        this.catalogManager.setCurrentCatalog("cat1");
        this.catalogManager.setCurrentDatabase("db1");
        catalog.createTable(new ObjectPath("db1", "tb1"), (CatalogBaseTable)catalogTable, true);
    }

    private FlinkPlannerImpl getPlannerBySqlDialect(SqlDialect sqlDialect) {
        this.tableConfig.setSqlDialect(sqlDialect);
        return this.plannerContext.createFlinkPlanner(this.catalogManager.getCurrentCatalog(), this.catalogManager.getCurrentDatabase());
    }

    private CalciteParser getParserBySqlDialect(SqlDialect sqlDialect) {
        this.tableConfig.setSqlDialect(sqlDialect);
        return this.plannerContext.createCalciteParser();
    }

    private Operation parseAndConvert(String sql) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        return (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    private static class TestItem {
        private final String testExpr;
        @Nullable
        private Object expectedType;
        @Nullable
        private String expectedError;

        private TestItem(String testExpr) {
            this.testExpr = testExpr;
        }

        static TestItem fromTestExpr(String testExpr) {
            return new TestItem(testExpr);
        }

        TestItem withExpectedType(Object expectedType) {
            this.expectedType = expectedType;
            return this;
        }

        TestItem withExpectedError(String expectedError) {
            this.expectedError = expectedError;
            return this;
        }

        public String toString() {
            return this.testExpr;
        }
    }
}

