/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.LegacySinkTest$;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001'\tqA*Z4bGf\u001c\u0016N\\6UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\tQAY1uG\"T!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013\u0005\u0011%\u0001\u0003M\u001f:;U#\u0001\u0012\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003O)\tQ\u0001^=qKNL!!\u000b\u0013\u0003\u0015\tKw-\u00138u)f\u0004X\r\u0003\u0004,\u0001\u0001\u0006IAI\u0001\u0006\u0019>su\t\t\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0003\rIe\nV\u000b\u0002_A\u00111\u0005M\u0005\u0003c\u0011\u0012q!\u00138u)f\u0004X\r\u0003\u00044\u0001\u0001\u0006IaL\u0001\u0005\u0013:#\u0006\u0005C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\tU$\u0018\u000e\\\u000b\u0002oA\u0011Q\u0003O\u0005\u0003sY\u0011!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"11\b\u0001Q\u0001\n]\nQ!\u001e;jY\u0002BQ!\u0010\u0001\u0005\u0002y\na\u0002^3tiNKgn\u001a7f'&t7\u000eF\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0011)f.\u001b;)\u0005q2\u0005CA$K\u001b\u0005A%BA%\u0011\u0003\u0015QWO\\5u\u0013\tY\u0005J\u0001\u0003UKN$\b\"B'\u0001\t\u0003q\u0014A\u0004;fgRlU\u000f\u001c;j'&t7n\u001d\u0015\u0003\u0019\u001aCQ\u0001\u0015\u0001\u0005\u0002y\na\u0002^3tiR\u000b'\r\\3IS:$8\u000f\u000b\u0002P\r\u0002")
public class LegacySinkTest
extends TableTestBase {
    private final BigIntType LONG = new BigIntType();
    private final IntType INT = new IntType();
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BigIntType LONG() {
        return this.LONG;
    }

    public IntType INT() {
        return this.INT;
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSingleSink() {
        Table table = this.util().tableEnv().sqlQuery("SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        TableSink<Row> sink = this.util().createCollectTableSink((String[])((Object[])new String[]{"a"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG()}));
        this.util().verifyRelPlanInsert(table, sink, "sink");
    }

    @Test
    public void testMultiSinks() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED(), true);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS sum_a, c FROM MyTable GROUP BY c");
        this.util().tableEnv().registerTable("table1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT SUM(sum_a) AS total_sum FROM table1");
        Table table3 = this.util().tableEnv().sqlQuery("SELECT MIN(sum_a) AS total_min FROM table1");
        TableSink<Row> sink1 = this.util().createCollectTableSink((String[])((Object[])new String[]{"total_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("sink1", sink1);
        stmtSet.addInsert("sink1", table2);
        TableSink<Row> sink2 = this.util().createCollectTableSink((String[])((Object[])new String[]{"total_min"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("sink2", sink2);
        stmtSet.addInsert("sink2", table3);
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testTableHints() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MyTable (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         |)\n       ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MySink (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'OPTIONS',\n         |  'path' = '/tmp/test'\n         |)\n       ")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("insert into MySink /*+ OPTIONS('path' = '/tmp1') */ select * from MyTable");
        stmtSet.addInsertSql("insert into MySink /*+ OPTIONS('path' = '/tmp2') */ select * from MyTable");
        this.util().verifyExecPlan(stmtSet);
    }

    public LegacySinkTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.LegacySinkTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

