/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.plan.batch.sql.PartitionableSourceTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001M\u0011q\u0003U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016$Vm\u001d;\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\"A1\u0004\u0001BC\u0002\u0013\u0005A$A\u000bt_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:\u0016\u0003u\u0001\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001e\u0003Y\u0019x.\u001e:dK\u001a+Go\u00195QCJ$\u0018\u000e^5p]N\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002!U\u001cXmQ1uC2|wMR5mi\u0016\u0014\b\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002#U\u001cXmQ1uC2|wMR5mi\u0016\u0014\b\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y9z\u0003CA\u0017\u0001\u001b\u0005\u0011\u0001\"B\u000e*\u0001\u0004i\u0002\"\u0002\u0014*\u0001\u0004i\u0002bB\u0019\u0001\u0005\u0004%IAM\u0001\u0005kRLG.F\u00014!\t)B'\u0003\u00026-\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0011\u00199\u0004\u0001)A\u0005g\u0005)Q\u000f^5mA!)\u0011\b\u0001C\u0001u\u0005)1/\u001a;vaR\t1\b\u0005\u0002\u001fy%\u0011Qh\b\u0002\u0005+:LG\u000f\u000b\u00029\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tE\u0001\u0006UVt\u0017\u000e^\u0005\u0003\t\u0006\u0013aAQ3g_J,\u0007\"\u0002$\u0001\t\u0003Q\u0014A\t;fgR\u001c\u0016.\u001c9mKB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,\u0017\u0007\u000b\u0002F\u0011B\u0011\u0001)S\u0005\u0003\u0015\u0006\u0013A\u0001V3ti\")A\n\u0001C\u0001u\u0005QC/Z:u!\u0006\u0014H/[1m!\u0006\u0014H/\u001b;j_:4\u0015.\u001a7e!J,G-[2bi\u0016\u0004Vo\u001d5E_^t\u0007FA&I\u0011\u0015y\u0005\u0001\"\u0001;\u0003m!Xm\u001d;XSRDW\u000b\u001a4B]\u00124\u0016N\u001d;vC2\u001cu\u000e\\;n]\"\u0012a\n\u0013\u0005\u0006%\u0002!\tAO\u0001\u001ai\u0016\u001cH/\u00168d_:4XM\u001d;fI\u0016C\bO]3tg&|g\u000e\u000b\u0002R\u0011\"\"\u0001!V.]!\t1\u0016,D\u0001X\u0015\tA\u0016)\u0001\u0004sk:tWM]\u0005\u00035^\u0013qAU;o/&$\b.A\u0003wC2,XmI\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001\u0017)A\u0004sk:tWM]:\n\u0005\t|&!\u0004)be\u0006lW\r^3sSj,GmB\u0003e\u0005!\u0005Q-A\fQCJ$\u0018\u000e^5p]\u0006\u0014G.Z*pkJ\u001cW\rV3tiB\u0011QF\u001a\u0004\u0006\u0003\tA\taZ\n\u0003M\"\u0004\"AH5\n\u0005)|\"AB!osJ+g\rC\u0003+M\u0012\u0005A\u000eF\u0001f\u0011\u0015qg\r\"\u0001p\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0002aB\u0019\u0011/^<\u000e\u0003IT!!M:\u000b\u0003Q\fAA[1wC&\u0011aO\u001d\u0002\u000b\u0007>dG.Z2uS>t\u0007c\u0001\u0010yu&\u0011\u0011p\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003=mL!\u0001`\u0010\u0003\u0007\u0005s\u0017\u0010\u000b\u0004n}\u0006-\u0011Q\u0002\t\u0004\u007f\u0006\u0015ab\u00010\u0002\u0002%\u0019\u00111A0\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\t9!!\u0003\u0003\u0015A\u000b'/Y7fi\u0016\u00148OC\u0002\u0002\u0004}\u000bAA\\1nK\u0006\u0012\u0011qB\u00010g>,(oY3GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8t{m\u0004T\u0010\f\u0011vg\u0016\u001c\u0015\r^1m_\u001e4\u0015\u000e\u001c;fevZ\u0018' ")
public class PartitionableSourceTest
extends TableTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;
    private final BatchTableTestUtil util;

    @Parameterized.Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceTest$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        String ddlTemp = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s'\n        |)\n        |")).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.util().tableEnv().executeSql(String.format(ddlTemp, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.util().tableEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.util().tableEnv().useCatalog("test_catalog");
            this.util().tableEnv().executeSql(String.format(ddlTemp, ""));
            ObjectPath mytablePath = ObjectPath.fromString((String)"test_database.MyTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionableSourceTest.$anonfun$setup$1(catalog, mytablePath, partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSimplePartitionFieldPredicate1() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE part1 = 'A'");
    }

    @Test
    public void testPartialPartitionFieldPredicatePushDown() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @Test
    public void testWithUdfAndVirtualColumn() {
        this.util().addFunction("MyUdf", Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @Test
    public void testUnconvertedExpression() {
        this.util().verifyExecPlan("select * from MyTable where trim(part1) = 'A' and part2 > 1");
    }

    public static final /* synthetic */ void $anonfun$setup$1(TestValuesCatalog catalog$1, ObjectPath mytablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(mytablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceTest(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

