/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.RankTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001'\tA!+\u00198l)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0011\u00191\u0003\u0001)A\u0005E\u0005)Q\u000f^5mA!)\u0001\u0006\u0001C\u0001S\u0005YB/Z:u%><h*^7cKJ<\u0016\u000e\u001e5pkR|%\u000fZ3s\u0005f$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0003(c]B\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003\u0015QWO\\5u\u0013\t14G\u0001\u0003UKN$\u0018\u0001C3ya\u0016\u001cG/\u001a3$\u0003e\u0002\"A\u000f\"\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u0013\u0003\u0019a$o\\8u}%\tQ&\u0003\u0002BY\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005A\u0011VO\u001c;j[\u0016,\u0005pY3qi&|gN\u0003\u0002BY!)a\t\u0001C\u0001S\u0005aB/Z:u%><h*^7cKJ<\u0016\u000e\u001e5Nk2$\u0018n\u0012:pkB\u001c\b\u0006B#2oaBQ!\u0013\u0001\u0005\u0002%\na\u0003^3tiJ\u000bgn[,ji\"|W\u000f^(sI\u0016\u0014()\u001f\u0015\u0005\u0011F:4jI\u0001M!\ti\u0005+D\u0001O\u0015\ty%\"A\u0002ba&L!!\u0015(\u0003'Y\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8\t\u000bM\u0003A\u0011A\u0015\u0002/Q,7\u000f\u001e*b].<\u0016\u000e\u001e5Nk2$\u0018n\u0012:pkB\u001c\b\u0006\u0002*2o-CQA\u0016\u0001\u0005\u0002%\n1\u0004^3ti\u0012+gn]3SC:\\w+\u001b;i_V$xJ\u001d3fe\nK\b\u0006B+2o-CQ!\u0017\u0001\u0005\u0002%\nA\u0004^3ti\u0012+gn]3SC:\\w+\u001b;i\u001bVdG/[$s_V\u00048\u000f\u000b\u0003Yc]Z\u0005\"\u0002/\u0001\t\u0003I\u0013!\t;fgR\u0014\u0016M\\6WC2,XMR5mi\u0016\u0014x+\u001b;i+B\u0004XM\u001d,bYV,\u0007FA.2\u0011\u0015y\u0006\u0001\"\u0001*\u0003q!Xm\u001d;SC:\\g+\u00197vK\u001aKG\u000e^3s/&$\bNU1oO\u0016D#AX\u0019\t\u000b\t\u0004A\u0011A\u0015\u0002;Q,7\u000f\u001e*b].4\u0016\r\\;f\r&dG/\u001a:XSRDW)];bYND#!Y\u0019\t\u000b\u0015\u0004A\u0011A\u0015\u0002-Q,7\u000f^,ji\"|W\u000f\u001e)beRLG/[8o\u0005fD#\u0001Z\u0019\t\u000b!\u0004A\u0011A\u0015\u0002OQ,7\u000f^'vYRL7+Y7f%\u0006t7NR;oGRLwN\\:XSRD7+Y7f\u000fJ|W\u000f\u001d\u0015\u0003OFBQa\u001b\u0001\u0005\u0002%\n1\u0005^3ti\u0012+\b\u000f\\5dCR,'+\u00198l\rVt7\r^5p]\u000e{G.^7o\u001d\u0006lW\r\u000b\u0002kc!)a\u000e\u0001C\u0001S\u0005AB/Z:u%\u0006t7NR;oGRLwN\\%o\u001b&$G\r\\3)\u00055\f\u0004\"B9\u0001\t\u0003I\u0013a\u0007;fgR\u001c%/Z1uKZKWm^,ji\"\u0014vn\u001e(v[\n,'\u000f\u000b\u0002qc!)A\u000f\u0001C\u0001S\u0005qB/Z:u%\u0006t7nV5uQ\u0006sw\u000e\u001e5feJ\u000bgn[!t\u0013:\u0004X\u000f\u001e\u0015\u0003gFBQa\u001e\u0001\u0005\u0002%\n1\u0005^3tiJ+G-\u001e8eC:$(+\u00198l\u001dVl'-\u001a:D_2,XN\u001c*f[>4X\r\u000b\u0002wc\u0001")
public class RankTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test(expected=RuntimeException.class)
    public void testRowNumberWithoutOrderBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT ROW_NUMBER() over (partition by a) FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=RuntimeException.class)
    public void testRowNumberWithMultiGroups() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT ROW_NUMBER() over (partition by a order by b) as a,\n        |       ROW_NUMBER() over (partition by b) as b\n        |       FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=ValidationException.class)
    public void testRankWithoutOrderBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT RANK() over (partition by a) FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=ValidationException.class)
    public void testRankWithMultiGroups() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT RANK() over (partition by a order by b) as a,\n        |       RANK() over (partition by b) as b\n        |       FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=ValidationException.class)
    public void testDenseRankWithoutOrderBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT dense_rank() over (partition by a) FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=ValidationException.class)
    public void testDenseRankWithMultiGroups() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT DENSE_RANK() over (partition by a order by b) as a,\n        |       DENSE_RANK() over (partition by b) as b\n        |       FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithUpperValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND a > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithRange() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b, c ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND rk > -2\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithEquals() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk = 2\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWithoutPartitionBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (ORDER BY a) rk FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithSameGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDuplicateRankFunctionColumnName() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rk"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.RankTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable2) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRankFunctionInMiddle() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, RANK() OVER (PARTITION BY a ORDER BY a) rk, b, c FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCreateViewWithRowNumber() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE test_source (\n        |  name STRING,\n        |  eat STRING,\n        |  age BIGINT\n        |) WITH (\n        |  'connector' = 'values',\n        |  'bounded' = 'true'\n        |)\n      ")).stripMargin());
        this.util().tableEnv().executeSql("create view view1 as select name, eat ,sum(age) as cnt\nfrom test_source group by name, eat");
        this.util().tableEnv().executeSql("create view view2 as\nselect *, ROW_NUMBER() OVER (PARTITION BY name ORDER BY cnt DESC) as row_num\nfrom view1");
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |create table sink (\n         |  name varchar,\n         |  eat varchar,\n         |  cnt bigint\n         |)\n         |with(\n         |  'connector' = 'print'\n         |)\n         |")).stripMargin());
        this.util().verifyExecPlanInsert("insert into sink select name, eat, cnt\nfrom view2 where row_num <= 3");
    }

    @Test
    public void testRankWithAnotherRankAsInput() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT CAST(rna AS INT) AS rn1, CAST(rnb AS INT) AS rn2 FROM (\n        |  SELECT *, row_number() over (partition by a order by b desc) AS rnb\n        |  FROM (\n        |    SELECT *, row_number() over (partition by a, c order by b desc) AS rna\n        |    FROM MyTable\n        |  )\n        |  WHERE rna <= 100\n        |)\n        |WHERE rnb <= 200\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRedundantRankNumberColumnRemove() {
        this.util().addDataStream("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "uri")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "reqcount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "start_time")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "bucket_id"))}), new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.RankTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  CONCAT('http://txmov2.a.yximgs.com', uri) AS url,\n        |  reqcount AS download_count,\n        |  start_time AS `timestamp`\n        |FROM\n        |  (\n        |    SELECT\n        |      uri,\n        |      reqcount,\n        |      rownum_2,\n        |      start_time\n        |    FROM\n        |      (\n        |        SELECT\n        |          uri,\n        |          reqcount,\n        |          start_time,\n        |          RANK() OVER (\n        |            PARTITION BY start_time\n        |            ORDER BY\n        |              reqcount DESC\n        |          ) AS rownum_2\n        |        FROM\n        |          (\n        |            SELECT\n        |            uri,\n        |            reqcount,\n        |            start_time,\n        |            RANK() OVER (\n        |                PARTITION BY start_time, bucket_id\n        |                ORDER BY\n        |                reqcount DESC\n        |            ) AS rownum_1\n        |            FROM MyTable1\n        |          )\n        |        WHERE\n        |          rownum_1 <= 100000\n        |      )\n        |    WHERE\n        |      rownum_2 <= 100000\n        |  )\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public RankTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.RankTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

