/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.SortLimitTest$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortRule$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001'\ti1k\u001c:u\u0019&l\u0017\u000e\u001e+fgRT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0013\u0001B;uS2,\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002;Q,7\u000f\u001e(p]J\u000bgnZ3T_J$x+\u001b;i_V$xJ\u001a4tKR$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'N\u0007\u0002g)\u0011A\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003mM\u0012A\u0001V3ti\")\u0001\b\u0001C\u0001S\u0005QB/Z:u\u001d>t'+\u00198hKN{'\u000f^,ji\"d\u0015.\\5ua!\u0012q'\r\u0005\u0006w\u0001!\t!K\u0001\u001fi\u0016\u001cHOT8o%\u0006tw-Z*peR|e\u000e\\=XSRDwJ\u001a4tKRD#AO\u0019\t\u000by\u0002A\u0011A\u0015\u0002AQ,7\u000f\u001e(p]\u0016\u0014\u0016M\\4f'>\u0014HoV5uQ>3gm]3u\u0019&l\u0017\u000e\u001e\u0015\u0003{EBQ!\u0011\u0001\u0005\u0002%\n\u0011\u0005^3ti:{g.\u001a*b]\u001e,7k\u001c:u/&$\bn\u00144gg\u0016$H*[7jiBB#\u0001Q\u0019\t\u000b\u0011\u0003A\u0011A\u0015\u00029Q,7\u000f\u001e*b]\u001e,7k\u001c:u\u001f:<\u0016\u000e\u001e5pkR|eMZ:fi\"\u00121)\r\u0005\u0006\u000f\u0002!\t!K\u0001\u001ai\u0016\u001cHOU1oO\u0016\u001cvN\u001d;P]^KG\u000f\u001b'j[&$\b\u0007\u000b\u0002Gc!)!\n\u0001C\u0001S\u0005YB/Z:u%\u0006tw-Z*peR|e\u000e\\=XSRDwJ\u001a4tKRD#!S\u0019\t\u000b5\u0003A\u0011A\u0015\u00029Q,7\u000f\u001e*b]\u001e,7k\u001c:u/&$\bn\u00144gg\u0016$H*[7ji\"\u0012A*\r\u0005\u0006!\u0002!\t!K\u0001\u001ei\u0016\u001cHOU1oO\u0016\u001cvN\u001d;XSRDwJ\u001a4tKRd\u0015.\\5ua!\u0012q*\r")
public class SortLimitTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testNonRangeSortWithoutOffset() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), false);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC LIMIT 5");
    }

    @Test
    public void testNonRangeSortWithLimit0() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), false);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC LIMIT 0");
    }

    @Test
    public void testNonRangeSortOnlyWithOffset() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), false);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC OFFSET 10 ROWS");
    }

    @Test
    public void testNoneRangeSortWithOffsetLimit() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), false);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC, b LIMIT 10 OFFSET 1");
    }

    @Test
    public void testNoneRangeSortWithOffsetLimit0() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), false);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC, b LIMIT 0 OFFSET 1");
    }

    @Test
    public void testRangeSortOnWithoutOffset() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), true);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC LIMIT 5");
    }

    @Test
    public void testRangeSortOnWithLimit0() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), true);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC LIMIT 0");
    }

    @Test
    public void testRangeSortOnlyWithOffset() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), true);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC OFFSET 10 ROWS");
    }

    @Test
    public void testRangeSortWithOffsetLimit() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), true);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC, b LIMIT 10 OFFSET 1");
    }

    @Test
    public void testRangeSortWithOffsetLimit0() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), true);
        this.util().verifyExecPlan("SELECT * FROM MyTable ORDER BY a DESC, b LIMIT 0 OFFSET 1");
    }

    public SortLimitTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.SortLimitTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableEnv().getConfig().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_SORT_DEFAULT_LIMIT, 200);
    }
}

