/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.plan.batch.sql.TableScanTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001'\tiA+\u00192mKN\u001b\u0017M\u001c+fgRT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0013\u0001B;uS2,\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\r\t,gm\u001c:f)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012!\u00026v]&$\u0018B\u0001\u001c4\u0005\u0019\u0011UMZ8sK\")\u0001\b\u0001C\u0001S\u0005IB/Z:u\u0019\u0016<\u0017mY=UC\ndWmU8ve\u000e,7kY1oQ\t9$\b\u0005\u00023w%\u0011Ah\r\u0002\u0005)\u0016\u001cH\u000fC\u0003?\u0001\u0011\u0005\u0011&\u0001\tuKN$H\t\u0012'UC\ndWmU2b]\"\u0012QH\u000f\u0005\u0006\u0003\u0002!\t!K\u0001\u001ai\u0016\u001cHoU2b]>sWK\u001c2pk:$W\rZ*pkJ\u001cW\r\u000b\u0002Au!)A\t\u0001C\u0001S\u0005IB/Z:u'\u000e\fgn\u00148DQ\u0006tw-\u001a7pON{WO]2fQ\t\u0019%\bC\u0003H\u0001\u0011\u0005\u0011&\u0001\fuKN$8kY1o\u001f:,\u0006o]3siN{WO]2fQ\t1%\bC\u0003K\u0001\u0011\u0005\u0011&A\ruKN$H\t\u0012'XSRD7i\\7qkR,GmQ8mk6t\u0007FA%;\u0011\u0015i\u0005\u0001\"\u0001*\u0003\t\"Xm\u001d;E\t2;\u0016\u000e\u001e5XCR,'/\\1sW\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\u0012AJ\u000f\u0005\u0006!\u0002!\t!K\u0001\u0014i\u0016\u001cH\u000f\u0012#M/&$\b\u000e\u0015:pGRLW.\u001a\u0015\u0003\u001fjBQa\u0015\u0001\u0005\u0002%\n!\u0005^3tiR\u000b'\r\\3Ba&\u001c6-\u00198XSRD7i\\7qkR,GmQ8mk6t\u0007F\u0001*;\u0011\u00151\u0006\u0001\"\u0001*\u0003u!Xm\u001d;UC\ndW-\u00119j'\u000e\fgnV5uQ^\u000bG/\u001a:nCJ\\\u0007FA+;\u0011\u0015I\u0006\u0001\"\u0001*\u0003]!Xm\u001d;UC\ndW-\u00119j'\u000e\fgnV5uQ\u0012#E\n\u000b\u0002Yu!)A\f\u0001C\u0001S\u0005\u0011C/Z:u)\u0006\u0014G.Z!qSN\u001b\u0017M\\,ji\"$V-\u001c9pe\u0006\u0014\u0018\u0010V1cY\u0016D#a\u0017\u001e")
public class TableScanTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().tableEnv().registerFunction("my_udf", (ScalarFunction)Func0$.MODULE$);
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |create table computed_column_t(\n         |  a int,\n         |  b varchar,\n         |  c as a + 1,\n         |  d as to_timestamp(b),\n         |  e as my_udf(a)\n         |) with (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         |)\n       ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |create table c_watermark_t(\n         |  a int,\n         |  b varchar,\n         |  c as a + 1,\n         |  d as to_timestamp(b),\n         |  e as my_udf(a),\n         |  WATERMARK FOR d AS d - INTERVAL '0.001' SECOND\n         |) with (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         |)\n       ")).stripMargin());
    }

    @Test
    public void testLegacyTableSourceScan() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.TableScanTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT * FROM MyTable");
    }

    @Test
    public void testDDLTableScan() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE src (\n        |  ts TIMESTAMP(3),\n        |  a INT,\n        |  b DOUBLE,\n        |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n        |) WITH (\n        |  'connector' = 'values',\n        |  'bounded' = 'true'\n        |)\n      ")).stripMargin());
        this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1");
    }

    @Test
    public void testScanOnUnboundedSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE src (\n        |  ts TIMESTAMP(3),\n        |  a INT,\n        |  b DOUBLE,\n        |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n        |) WITH (\n        |  'connector' = 'values',\n        |  'bounded' = 'false'\n        |)\n      ")).stripMargin());
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Querying an unbounded table 'default_catalog.default_database.src' in batch mode is not allowed. The table source is unbounded.");
        this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1");
    }

    @Test
    public void testScanOnChangelogSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE src (\n        |  ts TIMESTAMP(3),\n        |  a INT,\n        |  b DOUBLE\n        |) WITH (\n        |  'connector' = 'values',\n        |  'bounded' = 'true',\n        |  'changelog-mode' = 'I,UA,UB'\n        |)\n      ")).stripMargin());
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Querying a table in batch mode is currently only possible for INSERT-only table sources. But the source for table 'default_catalog.default_database.src' produces other changelog messages than just INSERT.");
        this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1");
    }

    @Test
    public void testScanOnUpsertSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE src (\n        |  id STRING,\n        |  a INT,\n        |  b DOUBLE,\n        |  PRIMARY KEY (id) NOT ENFORCED\n        |) WITH (\n        |  'connector' = 'values',\n        |  'bounded' = 'true',\n        |  'changelog-mode' = 'UA,D'\n        |)\n      ")).stripMargin());
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Querying a table in batch mode is currently only possible for INSERT-only table sources. But the source for table 'default_catalog.default_database.src' produces other changelog messages than just INSERT.");
        this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1");
    }

    @Test
    public void testDDLWithComputedColumn() {
        this.util().verifyExecPlan("SELECT * FROM computed_column_t");
    }

    @Test
    public void testDDLWithWatermarkComputedColumn() {
        this.util().verifyExecPlan("SELECT * FROM c_watermark_t");
    }

    @Test
    public void testDDLWithProctime() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |create table proctime_t (\n        | a int,\n        | b varchar,\n        | c as a + 1,\n        | d as to_timestamp(b),\n        | e as my_udf(a),\n        | ptime as proctime()\n        |) with (\n        |  'connector' = 'values',\n        |  'bounded' = 'true'\n        |)\n      ")).stripMargin());
        this.util().verifyExecPlan("SELECT * FROM proctime_t");
    }

    @Test
    public void testTableApiScanWithComputedColumn() {
        this.util().verifyExecPlan(this.util().tableEnv().from("computed_column_t"));
    }

    @Test
    public void testTableApiScanWithWatermark() {
        this.util().verifyExecPlan(this.util().tableEnv().from("c_watermark_t"));
    }

    @Test
    public void testTableApiScanWithDDL() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |create table t1(\n         |  a int,\n         |  b varchar\n         |) with (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         |)\n       ")).stripMargin());
        this.util().verifyExecPlan(this.util().tableEnv().from("t1"));
    }

    @Test
    public void testTableApiScanWithTemporaryTable() {
        this.util().tableEnv().createTemporaryTable("t1", TableDescriptor.forConnector((String)"datagen").schema(Schema.newBuilder().column("word", (AbstractDataType)DataTypes.STRING()).build()).option("number-of-rows", "1").build());
        this.util().verifyExecPlan(this.util().tableEnv().from("t1"));
    }
}

