/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001U\u0011\u0001c\u0012:pkBLgnZ*fiN$Vm\u001d;\u000b\u0005\r!\u0011aA1hO*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0011\u0017\r^2i\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011DC\u0001\u0006kRLGn]\u0005\u00037a\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u001d\u0011\u0003A1A\u0005\n\r\nA!\u001e;jYV\tA\u0005\u0005\u0002\u0018K%\u0011a\u0005\u0007\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u0004)\u0001\u0001\u0006I\u0001J\u0001\u0006kRLG\u000e\t\u0005\u0006U\u0001!\taK\u0001\u0011i\u0016\u001cHo\u0012:pkBLgnZ*fiN$\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG\u000f\u000b\u0002*gA\u0011AgN\u0007\u0002k)\u0011aGE\u0001\u0006UVt\u0017\u000e^\u0005\u0003qU\u0012A\u0001V3ti\")!\b\u0001C\u0001W\u0005\tB/Z:u\u000fJ|W\u000f]5oON+Go\u001d\u001a)\u0005e\u001a\u0004\"B\u001f\u0001\t\u0003Y\u0013!\u0005;fgR<%o\\;qS:<7+\u001a;tg!\u0012Ah\r\u0005\u0006\u0001\u0002!\taK\u0001#i\u0016\u001cHo\u0012:pkBLgnZ*fiN|U\u000f\u001e9viNtU\u000f\u001c7bE&d\u0017\u000e^=)\u0005}\u001a\u0004\"B\"\u0001\t\u0003Y\u0013\u0001\u0003;fgR\u001cUOY3)\u0005\t\u001b\u0004\"\u0002$\u0001\t\u0003Y\u0013A\u0003;fgR\u0014v\u000e\u001c7va\"\u0012Qi\r\u0005\u0006\u0013\u0002!\taK\u0001 i\u0016\u001cHo\u0012:pkBLgnZ*fiN<\u0016\u000e\u001e5P]\u0016<%o\\;qS:<\u0007F\u0001%4\u0011\u0015a\u0005\u0001\"\u0001,\u0003U!Xm\u001d;CCNL7m\u0012:pkBLgnZ*fiND#aS\u001a\t\u000b=\u0003A\u0011A\u0016\u00029Q,7\u000f^$s_V\u0004\u0018N\\4TKR\u001cxJ\\#yaJ,7o]5p]\"\u0012aj\r\u0005\u0006%\u0002!\taK\u0001\u000fi\u0016\u001cHoU5na2,7)\u001e2fQ\t\t6\u0007C\u0003V\u0001\u0011\u00051&A\nuKN$(k\u001c7mkB|e.M\"pYVlg\u000e\u000b\u0002Ug!)\u0001\f\u0001C\u0001W\u0005\u0019B/Z:u%>dG.\u001e9P]J\u001au\u000e\\;n]\"\u0012qk\r\u0005\u00067\u0002!\taK\u0001\u001ci\u0016\u001cHOU8mYV\u0004xJ\\\"pYVlgnV5uQ:+H\u000e\\:)\u0005i\u001b\u0004\"\u00020\u0001\t\u0003Y\u0013!\u0006;fgR\u0014v\u000e\u001c7vaBcWo](sI\u0016\u0014()\u001f\u0015\u0003;NBQ!\u0019\u0001\u0005\u0002-\n!\u0004^3tiJ{G\u000e\\;q\u0007\u0006\u0014H/Z:jC:\u0004&o\u001c3vGRD#\u0001Y\u001a\t\u000b\u0011\u0004A\u0011A\u0016\u0002gQ,7\u000f\u001e*pY2,\boQ1si\u0016\u001c\u0018.\u00198Qe>$Wo\u0019;PM^KG\u000f\u001b+va2,w+\u001b;i\u000bb\u0004(/Z:tS>t\u0007FA24\u0011\u00159\u0007\u0001\"\u0001,\u0003Q!Xm\u001d;S_2dW\u000f],ji\"D\u0015M^5oO\"\u0012am\r\u0005\u0006U\u0002!\taK\u0001\u0014i\u0016\u001cHoQ;cK\u0006sG\rR5ti&t7\r\u001e\u0015\u0003SNBQ!\u001c\u0001\u0005\u0002-\nq\u0002^3ti\u000e+(-Z!oI*{\u0017N\u001c\u0015\u0003YNBQ\u0001\u001d\u0001\u0005\u0002-\n\u0001\u0006^3ti\u001e\u0013x.\u001e9j]\u001eLenU3mK\u000e$8\t\\1vg\u0016|em\u0012:pkB\u0014\u00150U;fefD#a\\\u001a\t\u000bM\u0004A\u0011A\u0016\u0002KQ,7\u000f^$s_V\u0004\u0018N\\4J]N+G.Z2u\u00072\fWo]3PM\u000e+(-Z)vKJL\bF\u0001:4\u0011\u00151\b\u0001\"\u0001,\u0003m\"Xm\u001d;He>,\b/\u001b8h\u000fJ|W\u000f]0jI\u001e\u0013x.\u001e9j]\u001e|\u0016\u000eZ%o'\u0016dWm\u0019;DY\u0006,8/Z(g\u000fJ|W\u000f\u001d\"z#V,'/\u001f\u0015\u0003kNBQ!\u001f\u0001\u0005\u0002-\n\u0001\t^3ti\u001e\u0013x.\u001e9j]\u001e\f5mY3qiNlU\u000f\u001c;ja2,\u0017I]4v[\u0016tGo]$jm\u0016\u001c8+Y7f%\u0016\u001cX\u000f\u001c;Bg\u001e\u0013x.\u001e9j]\u001e|\u0016\u000e\u001a\u0015\u0003qNBQ\u0001 \u0001\u0005\u0002-\n1\u0004^3ti\u001e\u0013x.\u001e9j]\u001eLen\u0014:eKJ\u0014\u0015p\u00117bkN,\u0007FA>4\u0011\u0015y\b\u0001\"\u0001,\u0003\t\"Xm\u001d;EkBd\u0017nY1uK\u0006\u0013x-^7f]R$vn\u0012:pkBLgnZ0jI\"\u0012ap\r\u0005\u0007\u0003\u000b\u0001A\u0011A\u0016\u0002OQ,7\u000f^$s_V\u0004\u0018N\\4J]N+G.Z2u\u00072\fWo]3PMJ{G\u000e\\;q#V,'/\u001f\u0015\u0004\u0003\u0007\u0019\u0004BBA\u0006\u0001\u0011\u00051&\u0001\u0012uKN$xI]8va&twm\u0012:pkBLgnZ0jI\u0006sGm\u0012:pkB|\u0016\u000e\u001a\u0015\u0004\u0003\u0013\u0019\u0004BBA\t\u0001\u0011\u00051&\u0001\u000fuKN$\u0018\t\u001c7po\u0016C\bO]3tg&|g.\u00138S_2dW\u000f]\u0019)\u0007\u0005=1\u0007\u0003\u0004\u0002\u0018\u0001!\taK\u0001\u001bi\u0016\u001cH/\u00117m_^,\u0005\u0010\u001d:fgNLwN\\%o\u0007V\u0014W-\r\u0015\u0004\u0003+\u0019\u0004BBA\u000f\u0001\u0011\u00051&\u0001\u000fuKN$\u0018\t\u001c7po\u0016C\bO]3tg&|g.\u00138S_2dW\u000f\u001d\u001a)\u0007\u0005m1\u0007\u0003\u0004\u0002$\u0001!\taK\u0001\u001bi\u0016\u001cH/\u00117m_^,\u0005\u0010\u001d:fgNLwN\\%o\u0007V\u0014WM\r\u0015\u0004\u0003C\u0019\u0004BBA\u0015\u0001\u0011\u00051&\u0001\u000fuKN$\u0018\t\u001c7po\u0016C\bO]3tg&|g.\u00138S_2dW\u000f]\u001a)\u0007\u0005\u001d2\u0007\u0003\u0004\u00020\u0001!\taK\u0001\u0010i\u0016\u001cHoQ!M\u0007&#V)\r\u001d3i!\u001a\u0011QF\u001a\t\r\u0005U\u0002\u0001\"\u0001,\u0003A!Xm\u001d;Ge>l'\t\\8hgB|G\u000fK\u0002\u00024MBa!a\u000f\u0001\t\u0003Y\u0013A\u0006;fgR\u001cUOY3Bg\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:)\u0007\u0005e2\u0007\u0003\u0004\u0002B\u0001!\taK\u0001\u0019i\u0016\u001cHOU8mYV\u0004\u0018i]$s_V\u0004\u0018N\\4TKR\u001c\bfAA g!9\u0011q\t\u0001\u0005\u0002\u0005%\u0013a\u0005<fe&4\u0017\u0010\u00157b]&#WM\u001c;jG\u0006dG#\u0002\u0017\u0002L\u0005\u0015\u0004\u0002CA'\u0003\u000b\u0002\r!a\u0014\u0002\tM\fH.\r\t\u0005\u0003#\nyF\u0004\u0003\u0002T\u0005m\u0003cAA+]5\u0011\u0011q\u000b\u0006\u0004\u00033\"\u0012A\u0002\u001fs_>$h(C\u0002\u0002^9\na\u0001\u0015:fI\u00164\u0017\u0002BA1\u0003G\u0012aa\u0015;sS:<'bAA/]!A\u0011qMA#\u0001\u0004\ty%\u0001\u0003tc2\u0014\u0004")
public class GroupingSetsTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingSets() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c, avg(a) AS a, GROUP_ID() AS g FROM MyTable\n        |GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSets2() {
        this.util().verifyExecPlan("SELECT b, c, AVG(a) AS a FROM MyTable GROUP BY GROUPING SETS (b, c, ())");
    }

    @Test
    public void testGroupingSets3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid,\n        |    COUNT(*) AS cnt\n        |FROM MyTable\n        |     GROUP BY GROUPING SETS (b, c, ())\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsOutputsNullability() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |create table t1(\n         |  a int,\n         |  b varchar,\n         |  c varchar not null,\n         |  d bigint\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/to/my/path1',\n         |  'format' = 'testcsv'\n         |)\n      ")).stripMargin();
        this.util().tableEnv().executeSql(sourceDDL);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        | a,\n        | b,\n        | coalesce(c, 'empty'),\n        | avg(d)\n        |FROM t1\n        |GROUP BY GROUPING SETS ((a, b), (a, b, c))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCube() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) as gid\n        |FROM MyTable\n        |     GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithOneGrouping() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno,\n        |    AVG(age) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(deptno) AS gb,\n        |    GROUPING_ID(deptno) AS gib\n        |FROM emps GROUP BY GROUPING SETS (deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBasicGroupingSets() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno))");
    }

    @Test
    public void testGroupingSetsOnExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno + 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleCube() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testRollupOn1Column() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno)");
    }

    @Test
    public void testRollupOn2Column() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT gender, deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupOnColumnWithNulls() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender)");
    }

    @Test
    public void testRollupPlusOrderBy() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender) ORDER BY c DESC");
    }

    @Test
    public void testRollupCartesianProduct() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno), ROLLUP(gender)");
    }

    @Test
    public void testRollupCartesianProductOfWithTupleWithExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno / 2 + 1 AS half1, COUNT(*) AS c FROM emp\n        |GROUP BY ROLLUP(deptno / 2, gender), ROLLUP(substring(ename FROM 1 FOR 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupWithHaving() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) HAVING COUNT(*) > 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAndDistinct() {
        this.util().verifyExecPlan("SELECT DISTINCT COUNT(*) FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testCubeAndJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT e.deptno, e.gender,\n        |    MIN(e.ename) AS min_name\n        |FROM emp AS e JOIN dept AS d USING (deptno)\n        |    GROUP BY CUBE(e.deptno, d.deptno, e.gender)\n        |    HAVING COUNT(*) > 2 OR gender = 'M' AND e.deptno = 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfGroupByQuery() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c, GROUPING(deptno) AS g FROM emp GROUP BY deptno");
    }

    @Test
    public void testGroupingInSelectClauseOfCubeQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job,\n        |    COUNT(*) AS c,\n        |    GROUPING(deptno) AS d,\n        |    GROUPING(job) j,\n        |    GROUPING(deptno, job) AS x\n        |FROM scott_emp GROUP BY CUBE(deptno, job)\n        |\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGroup_idGrouping_idInSelectClauseOfGroupByQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) as c,\n        |    GROUPING(deptno) AS g,\n        |    GROUP_ID() AS gid,\n        |    GROUPING_ID(deptno) AS gd,\n        |    GROUPING_ID(gender) AS gg,\n        |    GROUPING_ID(gender, deptno) AS ggd,\n        |    GROUPING_ID(deptno, gender) AS gdg\n        |FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingAcceptsMultipleArgumentsGivesSameResultAsGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c,\n        |    GROUPING(deptno) AS gd,\n        |    GROUPING_ID(deptno) AS gid,\n        |    GROUPING(deptno, gender, deptno) AS gdgd,\n        |    GROUPING_ID(deptno, gender, deptno) AS gidgd\n        |FROM emp\n        |    GROUP BY ROLLUP(deptno, gender)\n        |    HAVING GROUPING(deptno) <= GROUPING_ID(deptno, gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInOrderByClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) ORDER BY GROUPING(deptno), c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDuplicateArgumentToGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING_ID(deptno, gender, deptno),\n        |    COUNT(*) AS c\n        |FROM emp WHERE deptno = 10\n        |    GROUP BY ROLLUP(gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfRollupQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c, deptno, GROUPING(deptno) AS g FROM emp GROUP BY ROLLUP(deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGrouping_idAndGroup_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING(deptno) gd,\n        |    GROUPING(gender) gg,\n        |    GROUPING_ID(deptno, gender) dg,\n        |    GROUPING_ID(gender, deptno) gd,\n        |    GROUP_ID() gid,\n        |    COUNT(*) c\n        |FROM emp\n        |    GROUP BY CUBE(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, deptno + 1 - 1 AS d0, COUNT(*) AS c\n        |FROM emp GROUP BY ROLLUP (deptno + 1)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY CUBE(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY ROLLUP(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube2() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY CUBE(1)");
    }

    @Test
    public void testAllowExpressionInRollup3() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(1)");
    }

    @Test
    public void testCALCITE1824() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, GROUP_ID() AS g, COUNT(*) AS c\n        |FROM scott_emp GROUP BY GROUPING SETS (deptno, (), ())\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testFromBlogspot() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job, empno, ename, SUM(sal) sumsal,\n        |    CASE GROUPING_ID(deptno, job, empno)\n        |    WHEN 0 THEN CAST('grouped by deptno,job,empno,ename' as varchar)\n        |    WHEN 1 THEN CAST('grouped by deptno,job' as varchar)\n        |    WHEN 3 THEN CAST('grouped by deptno' as varchar)\n        |    WHEN 7 THEN CAST('grouped by ()' as varchar)\n        |    END gr_text\n        |from scott_emp\n        |    GROUP BY ROLLUP(deptno, job, (empno,ename))\n        |    ORDER BY deptno, job, empno\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAsGroupingSets() {
        String cubeQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), (c), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(cubeQuery, groupingSetsQuery);
        this.util().verifyExecPlan(cubeQuery);
    }

    @Test
    public void testRollupAsGroupingSets() {
        String rollupQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(rollupQuery, groupingSetsQuery);
        this.util().verifyExecPlan(rollupQuery);
    }

    public void verifyPlanIdentical(String sql1, String sql2) {
        Table table1 = this.util().tableEnv().sqlQuery(sql1);
        Table table2 = this.util().tableEnv().sqlQuery(sql2);
        RelNode optimized1 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table1));
        RelNode optimized2 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table2));
        Assert.assertEquals((Object)FlinkRelOptUtil$.MODULE$.toString(optimized1, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()), (Object)FlinkRelOptUtil$.MODULE$.toString(optimized2, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
    }

    public GroupingSetsTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender"))}), new CaseClassTypeInfo<Tuple3<String, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("dept", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "dname"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emps", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "city")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empid")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "slacker")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "manager")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "joinedat"))}), new CaseClassTypeInfo<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> unused = new ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(this, fieldSerializers){

                    public Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date> createInstance(Object[] fields) {
                        return new Tuple10((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)((String)fields[4]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[5])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[6])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[7])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[8])), (Object)((Date)fields[9]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("scott_emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "job")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "mgr")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "hiredate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "sal")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "comm")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno"))}), new CaseClassTypeInfo<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple8<Object, String, String, Object, Date, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple8((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Date)fields[4]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[6])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[7])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

