/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.calcite.Expand;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalExpand;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalRank;
import org.apache.flink.table.planner.plan.nodes.calcite.Rank;
import org.apache.flink.table.planner.plan.nodes.common.CommonCalc;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalHashAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalLocalHashAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalLookupJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalGroupAggregateBase;
import org.apache.flink.table.planner.plan.utils.ExpandUtil$;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001#\tqb\t\\5oWJ+G.\u00143D_2,XN\\+oSF,XM\\3tgR+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0007$mS:\\'+\u001a7NI\"\u000bg\u000e\u001a7feR+7\u000f\u001e\"bg\u0016DQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001\"B\u000e\u0001\t\u0003a\u0012a\b;fgR\f%/Z\"pYVlgn]+oSF,Xm\u00148UC\ndWmU2b]R\tQ\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0003V]&$\bF\u0001\u000e%!\t)\u0003&D\u0001'\u0015\t9c\"A\u0003kk:LG/\u0003\u0002*M\t!A+Z:u\u0011\u0015Y\u0003\u0001\"\u0001\u001d\u0003q!Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>sg+\u00197vKND#A\u000b\u0013\t\u000b9\u0002A\u0011\u0001\u000f\u0002;Q,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:\u0004&o\u001c6fGRD#!\f\u0013\t\u000bE\u0002A\u0011\u0001\u000f\u00029Q,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:4\u0015\u000e\u001c;fe\"\u0012\u0001\u0007\n\u0005\u0006i\u0001!\t\u0001H\u0001\u001bi\u0016\u001cH/\u0011:f\u0007>dW/\u001c8t+:L\u0017/^3P]\u000e\u000bGn\u0019\u0015\u0003g\u0011BQa\u000e\u0001\u0005\u0002q\tA\u0004^3ti\u0006\u0013XmQ8mk6t7/\u00168jcV,wJ\\#ya\u0006tG\r\u000b\u00027I!)!\b\u0001C\u00019\u0005qB/Z:u\u0003J,7i\u001c7v[:\u001cXK\\5rk\u0016|e.\u0012=dQ\u0006tw-\u001a\u0015\u0003s\u0011BQ!\u0010\u0001\u0005\u0002q\t!\u0004^3ti\u0006\u0013XmQ8mk6t7/\u00168jcV,wJ\u001c*b].D#\u0001\u0010\u0013\t\u000b\u0001\u0003A\u0011\u0001\u000f\u0002?Q,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u0007>,h\u000e^(o'>\u0014H\u000f\u000b\u0002@I!)1\t\u0001C\u00019\u0005\u0001D/Z:u\u0003J,7i\u001c7v[:\u001cXK\\5rk\u0016\u001cu.\u001e8u\u001f:\u001cFO]3b[\u0016CXm\u0019#fIV\u0004H.[2bi\u0016D#A\u0011\u0013\t\u000b\u0019\u0003A\u0011\u0001\u000f\u0002oQ,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u0007>,h\u000e^(o'R\u0014X-Y7Fq\u0016\u001c7\t[1oO\u0016dwn\u001a(pe6\fG.\u001b>fQ\t)E\u0005C\u0003J\u0001\u0011\u0005A$A\u001buKN$\u0018I]3D_2,XN\\:V]&\fX/Z\"pk:$xJ\\*ue\u0016\fW.\u0012=fG\u0012\u0013x\u000e]+qI\u0006$XMQ3g_J,\u0007F\u0001%%\u0011\u0015a\u0005\u0001\"\u0001\u001d\u0003}!Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>s\u0017iZ4sK\u001e\fG/\u001a\u0015\u0003\u0017\u0012BQa\u0014\u0001\u0005\u0002q\t\u0001\u0006^3ti\u0006\u0013XmQ8mk6t7/\u00168jcV,wJ\u001c\"bi\u000eDW\t_3d\u0003\u001e<'/Z4bi\u0016D#A\u0014\u0013\t\u000bI\u0003A\u0011\u0001\u000f\u0002SQ,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:\u001cFO]3b[\u0016CXmY!hOJ,w-\u0019;fQ\t\tF\u0005C\u0003V\u0001\u0011\u0005A$A\u0010uKN$\u0018I]3D_2,XN\\:V]&\fX/Z(o/&tGm\\<BO\u001eD#\u0001\u0016\u0013\t\u000ba\u0003A\u0011\u0001\u000f\u0002;Q,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:|e/\u001a:BO\u001eD#a\u0016\u0013\t\u000bm\u0003A\u0011\u0001\u000f\u00025Q,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:Tu.\u001b8)\u0005i#\u0003\"\u00020\u0001\t\u0003a\u0012\u0001\t;fgR\f%/Z\"pYVlgn]+oSF,Xm\u00148M_>\\W\u000f\u001d&pS:D#!\u0018\u0013\t\u000b\u0005\u0004A\u0011\u0001\u000f\u00027Q,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:,f.[8oQ\t\u0001G\u0005C\u0003e\u0001\u0011\u0005A$A\u0010uKN$\u0018I]3D_2,XN\\:V]&\fX/Z(o\u0013:$XM]:fGRD#a\u0019\u0013\t\u000b\u001d\u0004A\u0011\u0001\u000f\u00027Q,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:l\u0015N\\;tQ\t1G\u0005C\u0003k\u0001\u0011\u0005A$A\u0010uKN$x)\u001a;D_2,XN\u001c(vY2\u001cu.\u001e8u\u001f:$UMZ1vYRD#!\u001b\u0013\t\u000b5\u0004A\u0011\u0001\u000f\u0002MQ,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:$\u0016M\u00197f'>,(oY3UC\ndW\r\u000b\u0002mI!)\u0001\u000f\u0001C\u00019\u0005\u0001D/Z:u\u0003J,7i\u001c7v[:\u001cXK\\5rk\u0016|e\u000eV1cY\u0016\u0004\u0016M\u001d;jC2d\u0017\u0010\u0015:pU\u0016\u001cG/\u001a3LKfD#a\u001c\u0013\t\u000bM\u0004A\u0011\u0001\u000f\u0002eQ,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:$\u0018M\u00197f'>,(oY3UC\ndWMT8o\u0017\u0016Lhj\u001c8LKfD#A\u001d\u0013")
public class FlinkRelMdColumnUniquenessTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testAreColumnsUniqueOnTableScan() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentFlinkLogicalScan(), this.studentBatchScan(), this.studentStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnTableScan$1(this, scan);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.empLogicalScan(), this.empFlinkLogicalScan(), this.empBatchScan(), this.empStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnTableScan$3(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnValues() {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{3}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{4}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{7}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.emptyValues().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.emptyValues(), ImmutableBitSet.of((int[])new int[]{idx})))));
    }

    @Test
    public void testAreColumnsUniqueOnProject() {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{2})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{3})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{4})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{5})));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{7})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{8})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{9})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{10})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{11})));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{2, 3})));
        this.relBuilder().push((RelNode)this.studentLogicalScan());
        .colon.colon exprs = new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().cast((RexNode)this.relBuilder().field(0), SqlTypeName.BIGINT), (List)new .colon.colon((Object)this.relBuilder().field(1), (List)new .colon.colon((Object)this.relBuilder().cast((RexNode)this.relBuilder().field(1), SqlTypeName.VARCHAR), (List)Nil$.MODULE$))));
        RelNode project = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)exprs)).build();
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{1})));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{1}), true)));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{3})));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{1, 2}), true)));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{1, 3}), true)));
    }

    @Test
    public void testAreColumnsUniqueOnFilter() {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of())));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.logicalFilter().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    @Test
    public void testAreColumnsUniqueOnCalc() {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{2})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{3})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{4})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{5})));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{7})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{8})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{9})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{10})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{11})));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{2, 3})));
    }

    @Test
    public void testAreColumnsUniqueOnExpand() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Expand[]{this.logicalExpand(), this.flinkLogicalExpand(), this.batchExpand(), this.streamExpand()})).foreach((Function1 & Serializable & scala.Serializable)expand -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnExpand$1(this, expand);
            return BoxedUnit.UNIT;
        });
        java.util.List expandProjects = ExpandUtil$.MODULE$.createExpandProjects(this.studentLogicalScan().getCluster().getRexBuilder(), this.studentLogicalScan().getRowType(), ImmutableBitSet.of((int[])new int[]{0, 3, 5}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{0, 3, 5}), (Object)ImmutableBitSet.of((int[])new int[]{3, 5}), (Object)ImmutableBitSet.of((int[])new int[]{3})), (Integer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.class)));
        LogicalExpand logicalExpand2 = new LogicalExpand(this.cluster(), this.studentLogicalScan().getTraitSet(), (RelNode)this.studentLogicalScan(), expandProjects, 7);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), logicalExpand2.getRowType().getFieldCount() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)logicalExpand2, ImmutableBitSet.of((int[])new int[]{idx, 7})))));
    }

    @Test
    public void testAreColumnsUniqueOnExchange() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchExchange(), this.streamExchange()})).foreach((Function1 & Serializable & scala.Serializable)exchange -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnExchange$1(this, exchange);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnRank() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalRank(), this.flinkLogicalRank(), this.batchLocalRank(), this.batchGlobalRank(), this.streamRank(), this.logicalRankWithVariableRange(), this.flinkLogicalRankWithVariableRange(), this.streamRankWithVariableRange()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnRank$1(this, rank);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRowNumber(), this.flinkLogicalRowNumber(), this.streamRowNumber()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnRank$3(this, rank);
            return BoxedUnit.UNIT;
        });
        LogicalRank rowNumber = new LogicalRank(this.cluster(), this.logicalTraits(), (RelNode)this.studentLogicalScan(), ImmutableBitSet.of((int[])new int[]{6}), RelCollations.of((int)4), RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(3L, 6L), (RelDataTypeField)new RelDataTypeFieldImpl("rn", 7, this.longType()), true);
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), rowNumber.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{0, 7}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{1, 7}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{6, 7}))));
    }

    @Test
    public void testAreColumnsUniqueCountOnSort() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSort(), this.flinkLogicalSort(), this.batchSort(), this.streamSort(), this.logicalLimit(), this.flinkLogicalLimit(), this.batchLimit(), this.batchLocalLimit(), this.batchGlobalLimit(), this.streamLimit(), this.logicalSortLimit(), this.flinkLogicalSortLimit(), this.batchSortLimit(), this.batchLocalSortLimit(), this.batchGlobalSortLimit(), this.streamSortLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueCountOnSort$1(this, sort);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueCountOnStreamExecDeduplicate() {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
    }

    @Test
    public void testAreColumnsUniqueCountOnStreamExecChangelogNormalize() {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{1, 0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    @Test
    public void testAreColumnsUniqueCountOnStreamExecDropUpdateBefore() {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of())));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    @Test
    public void testAreColumnsUniqueOnAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Aggregate[]{this.logicalAgg(), this.flinkLogicalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Aggregate[]{this.logicalAggWithAuxGroup(), this.flinkLogicalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnAggregate$3(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnBatchExecAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new BatchPhysicalHashAggregate[]{this.batchGlobalAggWithLocal(), this.batchGlobalAggWithoutLocal()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnBatchExecAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new BatchPhysicalHashAggregate[]{this.batchGlobalAggWithLocalWithAuxGroup(), this.batchGlobalAggWithoutLocalWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnBatchExecAggregate$3(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new BatchPhysicalLocalHashAggregate[]{this.batchLocalAgg(), this.batchLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnBatchExecAggregate$5(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnStreamExecAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StreamPhysicalGroupAggregateBase[]{this.streamGlobalAggWithLocal(), this.streamGlobalAggWithoutLocal()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnStreamExecAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.streamLocalAgg().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamLocalAgg(), ImmutableBitSet.of((int[])new int[]{idx}))));
    }

    @Test
    public void testAreColumnsUniqueOnWindowAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg(), this.flinkLogicalWindowAgg(), this.batchGlobalWindowAggWithLocalAgg(), this.batchGlobalWindowAggWithoutLocalAgg(), this.streamWindowAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnWindowAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 1, 3})));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg2(), this.flinkLogicalWindowAgg2(), this.batchGlobalWindowAggWithLocalAgg2(), this.batchGlobalWindowAggWithoutLocalAgg2(), this.streamWindowAgg2()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnWindowAgg$2(this, agg);
            return BoxedUnit.UNIT;
        });
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAgg2(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAgg2(), ImmutableBitSet.of((int[])new int[]{0, 2})));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAggWithAuxGroup(), this.flinkLogicalWindowAggWithAuxGroup(), this.batchGlobalWindowAggWithLocalAggWithAuxGroup(), this.batchGlobalWindowAggWithoutLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnWindowAgg$3(this, agg);
            return BoxedUnit.UNIT;
        });
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 3})));
    }

    @Test
    public void testAreColumnsUniqueOnOverAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonCalc[]{this.flinkLogicalOverAgg(), this.batchOverAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnOverAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{3}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{4}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{5})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{6})));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{7})));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0, 7}))));
        Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{5, 7})));
    }

    @Test
    public void testAreColumnsUniqueOnJoin() {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 5, 6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 5, 6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 5, 6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 5, 6}))));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSemiJoinOnUniqueKeys(), this.logicalSemiJoinNotOnUniqueKeys(), this.logicalSemiJoinOnDisjointKeys(), this.logicalAntiJoinOnUniqueKeys(), this.logicalAntiJoinNotOnUniqueKeys(), this.logicalAntiJoinOnDisjointKeys()})).foreach((Function1 & Serializable & scala.Serializable)join -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnJoin$1(this, join);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnLookupJoin() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonPhysicalLookupJoin[]{this.batchLookupJoin(), this.streamLookupJoin()})).foreach((Function1 & Serializable & scala.Serializable)join -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnLookupJoin$1(this, join);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnUnion() {
        int fieldCnt = this.logicalUnionAll().getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalUnionAll(), ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalUnionAll(), ImmutableBitSet.range((int)fieldCnt))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalUnion(), ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalUnion(), ImmutableBitSet.range((int)fieldCnt))));
    }

    @Test
    public void testAreColumnsUniqueOnIntersect() {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.range((int)this.logicalIntersect().getRowType().getFieldCount()))));
    }

    @Test
    public void testAreColumnsUniqueOnMinus() {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.range((int)this.logicalMinus().getRowType().getFieldCount()))));
        RelNode logicalMinus2 = this.relBuilder().scan(new String[]{"MyTable2"}).scan(new String[]{"MyTable1"}).minus(false).build();
        Assert.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{0})));
        Assert.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{1})));
        Assert.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{2})));
        Assert.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{1, 2})));
        Assert.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assert.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{1, 2})));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.range((int)logicalMinus2.getRowType().getFieldCount()))));
    }

    @Test
    public void testGetColumnNullCountOnDefault() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.testRel().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.testRel(), ImmutableBitSet.of((int[])new int[]{idx}))));
    }

    @Test
    public void testAreColumnsUniqueOnTableSourceTable() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.tableSourceTableLogicalScan(), this.tableSourceTableFlinkLogicalScan(), this.tableSourceTableBatchScan(), this.tableSourceTableStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnTableSourceTable$1(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnTablePartiallyProjectedKey() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.tablePartiallyProjectedKeyLogicalScan(), this.tablePartiallyProjectedKeyFlinkLogicalScan(), this.tablePartiallyProjectedKeyBatchScan(), this.tablePartiallyProjectedKeyStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnTablePartiallyProjectedKey$1(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOntableSourceTableNonKeyNonKey() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.tableSourceTableNonKeyLogicalScan(), this.tableSourceTableNonKeyFlinkLogicalScan(), this.tableSourceTableNonKeyBatchScan(), this.tableSourceTableNonKeyStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOntableSourceTableNonKeyNonKey$1(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnTableScan$1(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of())));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), scan.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnTableScan$3(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), scan.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{idx}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnExpand$1(FlinkRelMdColumnUniquenessTest $this, Expand expand) {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)expand, ImmutableBitSet.of())));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), expand.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)expand, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)expand, ImmutableBitSet.of((int[])new int[]{0, 7}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), expand.getRowType().getFieldCount() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)expand, ImmutableBitSet.of((int[])new int[]{idx, 7})))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnExchange$1(FlinkRelMdColumnUniquenessTest $this, RelNode exchange) {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of())));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), exchange.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnRank$1(FlinkRelMdColumnUniquenessTest $this, RelNode rank) {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), rank.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnRank$3(FlinkRelMdColumnUniquenessTest $this, Rank rank) {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0}))));
        int rankFunColumn = rank.getRowType().getFieldCount() - 1;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), rankFunColumn).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{rankFunColumn}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0, rankFunColumn}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{1, rankFunColumn}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{2, rankFunColumn}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueCountOnSort$1(FlinkRelMdColumnUniquenessTest $this, RelNode sort) {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of())));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), sort.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnAggregate$1(FlinkRelMdColumnUniquenessTest $this, Aggregate agg) {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnAggregate$3(FlinkRelMdColumnUniquenessTest $this, Aggregate agg) {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnBatchExecAggregate$1(FlinkRelMdColumnUniquenessTest $this, BatchPhysicalHashAggregate agg) {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnBatchExecAggregate$3(FlinkRelMdColumnUniquenessTest $this, BatchPhysicalHashAggregate agg) {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnBatchExecAggregate$5(FlinkRelMdColumnUniquenessTest $this, BatchPhysicalLocalHashAggregate agg) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), agg.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnStreamExecAggregate$1(FlinkRelMdColumnUniquenessTest $this, StreamPhysicalGroupAggregateBase agg) {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnWindowAgg$1(FlinkRelMdColumnUniquenessTest $this, SingleRel agg) {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 3}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 4}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 5}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4, 5, 6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2, 3}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnWindowAgg$2(FlinkRelMdColumnUniquenessTest $this, SingleRel agg) {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 4}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 3}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnWindowAgg$3(FlinkRelMdColumnUniquenessTest $this, SingleRel agg) {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 4}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 6}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3, 4, 5, 6}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 3}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnOverAgg$1(FlinkRelMdColumnUniquenessTest $this, CommonCalc agg) {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{4}))));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{6})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{7})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{8})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{9})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{10})));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 10}))));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5, 10})));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnJoin$1(FlinkRelMdColumnUniquenessTest $this, RelNode join) {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{0}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{2}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{3}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{4}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{0, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnLookupJoin$1(FlinkRelMdColumnUniquenessTest $this, CommonPhysicalLookupJoin join) {
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of())));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{0})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{1})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{2})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{3})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{4})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{5})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{6})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{7})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{8})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{9})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{1, 2})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{0, 7})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{1, 7})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{0, 8})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{7, 8})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{8, 9})));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnTableSourceTable$1(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assert.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnTablePartiallyProjectedKey$1(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3})));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOntableSourceTableNonKeyNonKey$1(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        Assert.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3})));
    }
}

