/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexWindowBoundJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexWindowBoundJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.junit.Assert;
import org.junit.Test;

public class RexWindowBoundSerdeTest {
    @Test
    public void testSerde() throws JsonProcessingException {
        SerdeContext serdeCtx = new SerdeContext((FlinkContext)new FlinkContextImpl(false, TableConfig.getDefault(), null, null, null), Thread.currentThread().getContextClassLoader(), FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectMapper mapper = JsonSerdeUtil.createObjectMapper((SerdeContext)serdeCtx);
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new RexWindowBoundJsonSerializer());
        module.addDeserializer(RexWindowBound.class, (JsonDeserializer)new RexWindowBoundJsonDeserializer());
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addSerializer((JsonSerializer)new RelDataTypeJsonSerializer());
        module.addDeserializer(RelDataType.class, (JsonDeserializer)new RelDataTypeJsonDeserializer());
        mapper.registerModule((Module)module);
        Assert.assertEquals((Object)RexWindowBounds.CURRENT_ROW, (Object)mapper.readValue(mapper.writeValueAsString((Object)RexWindowBounds.CURRENT_ROW), RexWindowBound.class));
        Assert.assertEquals((Object)RexWindowBounds.UNBOUNDED_FOLLOWING, (Object)mapper.readValue(mapper.writeValueAsString((Object)RexWindowBounds.UNBOUNDED_FOLLOWING), RexWindowBound.class));
        Assert.assertEquals((Object)RexWindowBounds.UNBOUNDED_PRECEDING, (Object)mapper.readValue(mapper.writeValueAsString((Object)RexWindowBounds.UNBOUNDED_PRECEDING), RexWindowBound.class));
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)FlinkTypeFactory.INSTANCE());
        RexWindowBound windowBound = RexWindowBounds.following((RexNode)builder.makeLiteral("test"));
        Assert.assertEquals((Object)windowBound, (Object)mapper.readValue(mapper.writeValueAsString((Object)windowBound), RexWindowBound.class));
        windowBound = RexWindowBounds.preceding((RexNode)builder.makeLiteral("test"));
        Assert.assertEquals((Object)windowBound, (Object)mapper.readValue(mapper.writeValueAsString((Object)windowBound), RexWindowBound.class));
    }
}

