/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.utils.ReflectionsUtil;
import org.junit.Assert;
import org.junit.Test;

public class JsonSerdeCoverageTest {
    private static final List<String> UNSUPPORTED_JSON_SERDE_CLASSES = Arrays.asList("StreamExecDataStreamScan", "StreamExecLegacyTableSourceScan", "StreamExecLegacySink", "StreamExecGroupTableAggregate", "StreamExecPythonGroupTableAggregate", "StreamExecSort", "StreamExecMultipleInput");

    @Test
    public void testStreamExecNodeJsonSerdeCoverage() {
        Set subClasses = ReflectionsUtil.scanSubClasses((String)"org.apache.flink", StreamExecNode.class);
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String> classesWithoutJsonCreator = new ArrayList<String>();
        ArrayList<String> classesWithJsonCreatorInUnsupportedList = new ArrayList<String>();
        for (Class clazz : subClasses) {
            String className = clazz.getSimpleName();
            classes.add(className);
            boolean hasJsonCreator = JsonSerdeUtil.hasJsonCreatorAnnotation((Class)clazz);
            if (hasJsonCreator && UNSUPPORTED_JSON_SERDE_CLASSES.contains(className)) {
                classesWithJsonCreatorInUnsupportedList.add(className);
            }
            if (hasJsonCreator || UNSUPPORTED_JSON_SERDE_CLASSES.contains(className)) continue;
            classesWithoutJsonCreator.add(className);
        }
        Assert.assertTrue((String)String.format("%s do not support json serialization/deserialization, please refer the implementation of the other StreamExecNodes.", String.join((CharSequence)",", classesWithoutJsonCreator)), (boolean)classesWithoutJsonCreator.isEmpty());
        Assert.assertTrue((String)String.format("%s have support json serialization/deserialization, but still in UNSUPPORTED_JSON_SERDE_CLASSES list. please move them from UNSUPPORTED_JSON_SERDE_CLASSES.", String.join((CharSequence)",", classesWithJsonCreatorInUnsupportedList)), (boolean)classesWithJsonCreatorInUnsupportedList.isEmpty());
        List notExistingClasses = UNSUPPORTED_JSON_SERDE_CLASSES.stream().filter(c -> !classes.contains(c)).collect(Collectors.toList());
        Assert.assertTrue((String)String.format("%s do not exist any more, please remove them from UNSUPPORTED_JSON_SERDE_CLASSES.", String.join((CharSequence)",", notExistingClasses)), (boolean)notExistingClasses.isEmpty());
    }
}

