/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001'\tI2)\u00197d%\u0006t7\u000e\u0016:b]N\u0004xn]3Sk2,G+Z:u\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nQa]3ukB$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'N\u0007\u0002g)\u0011A\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003mM\u0012aAQ3g_J,\u0007\"\u0002\u001d\u0001\t\u0003I\u0013A\u0005;fgR\u0004&/\u001e8f\u001fJ$WM]&fsND#a\u000e\u001e\u0011\u0005IZ\u0014B\u0001\u001f4\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011A\u0015\u0002-Q,7\u000f\u001e)sk:,\u0007+\u0019:uSRLwN\\&fsND#!\u0010\u001e\t\u000b\u0005\u0003A\u0011A\u0015\u0002'Q,7\u000f\u001e)sk:,WK\\5rk\u0016\\U-_:)\u0005\u0001S\u0004\"\u0002#\u0001\t\u0003I\u0013\u0001\u0005;fgRtu\u000e\u001e+sC:\u001c\bo\\:fQ\t\u0019%\bC\u0003H\u0001\u0011\u0005\u0011&A\nuKN$\bK];oKJ\u000bgn\u001b(v[\n,'\u000f\u000b\u0002Gu!)!\n\u0001C\u0001S\u0005)B/Z:u!J|'.Z2u%\u0006t7NT;nE\u0016\u0014\bFA%;\u0011\u0015i\u0005\u0001\"\u0001*\u0003a!Xm\u001d;Ue&4\u0018.\u00197DC2\u001c\u0017j\u001d*f[>4X\r\u001a\u0015\u0003\u0019jBQ\u0001\u0015\u0001\u0005\u0002%\n\u0011\u0005^3tiB+8\u000f[\"bY\u000e<\u0016\u000e\u001e5D_:$\u0017\u000e^5p]&sGo\u001c*b].D#a\u0014\u001e\t\u000bM\u0003A\u0011A\u0015\u0002-Q,7\u000f\u001e)sk:,WK\\;tK\u0012\u0004&o\u001c6fGRD#A\u0015\u001e")
public class CalcRankTransposeRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRuleTest$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "category")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shopId")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price"))}), new CaseClassTypeInfo<Tuple3<String, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRuleTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testPruneOrderKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPrunePartitionKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneUniqueKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT category, max_price, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY category ORDER BY max_price ASC) as rank_num\n        |  FROM (\n        |     SELECT category, shopId, max(price) as max_price, min(price) as min_price\n        |     FROM T\n        |     GROUP BY category, shopId\n        |  ))\n        |WHERE rank_num <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testNotTranspose() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT category, max_price, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY category ORDER BY max_price ASC) as rank_num\n        |  FROM (\n        |     SELECT category, shopId, max(price) as max_price\n        |     FROM T\n        |     GROUP BY category, shopId\n        |  ))\n        |WHERE rank_num <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneRankNumber() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, rowtime FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testProjectRankNumber() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n      |SELECT rank_num, rowtime, a, rank_num, a, rank_num FROM (\n      |  SELECT *,\n      |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n      |  FROM MyTable)\n      |WHERE  rank_num <= 2\n    ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTrivialCalcIsRemoved() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n      |SELECT a, rowtime, rank_num FROM (\n      |  SELECT *,\n      |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n      |  FROM MyTable)\n      |WHERE  rank_num <= 2\n    ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPushCalcWithConditionIntoRank() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, c FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE  rank_num <= 2 AND a > 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneUnusedProject() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT category, shopId, max_price, rank_num\n        |FROM (\n        |  SELECT category, shopId, max_price,\n        |      ROW_NUMBER() OVER (PARTITION BY category ORDER BY max_price ASC) as rank_num\n        |  FROM (\n        |     SELECT category, shopId, max(price) as max_price, min(price) as min_price\n        |     FROM T\n        |     GROUP BY category, shopId\n        |  ))\n        |WHERE rank_num <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }
}

