/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalAggregate$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalExpand$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacySink$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacyTableSourceScan$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalValues$;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkGroupProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.FlinkBatchRuleSets$;
import org.apache.flink.table.planner.plan.rules.logical.AggregateReduceGroupingRule$;
import org.apache.flink.table.planner.plan.rules.logical.DecomposeGroupingSetsRule$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateExpandDistinctAggregatesRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateRemoveRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateRemoveRuleTest$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRule$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001M\u0011AD\u00127j].\fum\u001a:fO\u0006$XMU3n_Z,'+\u001e7f)\u0016\u001cHO\u0003\u0002\u0004\t\u00059An\\4jG\u0006d'BA\u0003\u0007\u0003\u0015\u0011X\u000f\\3t\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u0004'\u0001\u0001\u0006IAI\u0001\u0006kRLG\u000e\t\u0005\u0006Q\u0001!\t!K\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5uQ\t9\u0013\u0007\u0005\u00023k5\t1G\u0003\u00025!\u0005)!.\u001e8ji&\u0011ag\r\u0002\u0007\u0005\u00164wN]3\t\u000ba\u0002A\u0011A\u0015\u0002CQ,7\u000f^!hOJ+Wn\u001c<f?\u001e\u0013x.\u001e9LKfL5OT8u+:L\u0017/^3)\u0005]R\u0004C\u0001\u001a<\u0013\ta4G\u0001\u0003UKN$\b\"\u0002 \u0001\t\u0003I\u0013\u0001\b;fgR\fum\u001a*f[>4XmX,ji\"|W\u000f\u001e$jYR,'/\r\u0015\u0003{iBQ!\u0011\u0001\u0005\u0002%\nA\u0004^3ti\u0006;wMU3n_Z,wlV5uQ>,HOR5mi\u0016\u0014(\u0007\u000b\u0002Au!)A\t\u0001C\u0001S\u0005iB/Z:u\u0003\u001e<'+Z7pm\u0016|v+\u001b;i_V$xI]8va\nK\u0018\u0007\u000b\u0002Du!)q\t\u0001C\u0001S\u0005iB/Z:u\u0003\u001e<'+Z7pm\u0016|v+\u001b;i_V$xI]8va\nK(\u0007\u000b\u0002Gu!)!\n\u0001C\u0001S\u0005iB/Z:u\u0003\u001e<'+Z7pm\u0016|v+\u001b;i_V$xI]8va\nK8\u0007\u000b\u0002Ju!)Q\n\u0001C\u0001S\u0005iB/Z:u\u0003\u001e<'+Z7pm\u0016|v+\u001b;i_V$xI]8va\nKH\u0007\u000b\u0002Mu!)\u0001\u000b\u0001C\u0001S\u0005aB/Z:u\u0003\u001e<'+Z7pm\u0016|v+\u001b;i_V$\u0018iZ4DC2d\u0007FA(;\u0011\u0015\u0019\u0006\u0001\"\u0001*\u0003a!Xm\u001d;BO\u001e\u0014V-\\8wK~;\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003%jBQA\u0016\u0001\u0005\u0002%\n1\u0003^3ti\u0006;wMU3n_Z,wlQ8v]RD#!\u0016\u001e\t\u000be\u0003A\u0011A\u0015\u0002/Q,7\u000f^!hOJ+Wn\u001c<f?\u000e{WO\u001c;Ti\u0006\u0014\bF\u0001-;\u0011\u0015a\u0006\u0001\"\u0001*\u0003a!Xm\u001d;BO\u001e\u0014V-\\8wK~;%o\\;q'\u0016$8/\r\u0015\u00037jBQa\u0018\u0001\u0005\u0002%\n\u0001\u0004^3ti\u0006;wMU3n_Z,wl\u0012:pkB\u001cV\r^:3Q\tq&\bC\u0003c\u0001\u0011\u0005\u0011&\u0001\u000buKN$\u0018iZ4SK6|g/Z0S_2dW\u000f\u001d\u0015\u0003CjBQ!\u001a\u0001\u0005\u0002%\n!\u0003^3ti\u0006;wMU3n_Z,wlQ;cK\"\u0012AM\u000f\u0005\u0006Q\u0002!\t!K\u0001!i\u0016\u001cH/Q4h%\u0016lwN^3`'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<\u0017\u0007\u000b\u0002hu!)1\u000e\u0001C\u0001S\u0005\u0001C/Z:u\u0003\u001e<'+Z7pm\u0016|6+\u001b8hY\u0016$\u0015n\u001d;j]\u000e$\u0018iZ43Q\tQ'\bC\u0003o\u0001\u0011\u0005\u0011&A\u001auKN$\u0018iZ4SK6|g/Z0TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hc!\u0012QN\u000f\u0005\u0006c\u0002!\t!K\u00014i\u0016\u001cH/Q4h%\u0016lwN^3`'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<wlV5uQ:{g\u000eR5ti&t7\r^!hOJB#\u0001\u001d\u001e\t\u000bQ\u0004A\u0011A\u0015\u0002gQ,7\u000f^!hOJ+Wn\u001c<f?NKgn\u001a7f\t&\u001cH/\u001b8di\u0006;wmX,ji\"tuN\u001c#jgRLgn\u0019;BO\u001e\u001c\u0004FA:;\u0011\u00159\b\u0001\"\u0001*\u0003M\"Xm\u001d;BO\u001e\u0014V-\\8wK~\u001b\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ0XSRDgj\u001c8ESN$\u0018N\\2u\u0003\u001e<G\u0007\u000b\u0002wu!)!\u0010\u0001C\u0001S\u0005\u0001C/Z:u\u0003\u001e<'+Z7pm\u0016|V*\u001e7uS\u0012K7\u000f^5oGR\fumZ:2Q\tI(\bC\u0003~\u0001\u0011\u0005\u0011&\u0001\u0011uKN$\u0018iZ4SK6|g/Z0Nk2$\u0018\u000eR5ti&t7\r^!hON\u0014\u0004F\u0001?;\u0011\u0019\t\t\u0001\u0001C\u0001S\u0005\u0001C/Z:u\u0003\u001e<'+Z7pm\u0016|V*\u001e7uS\u0012K7\u000f^5oGR\fumZ:4Q\ty(\b\u0003\u0004\u0002\b\u0001!\t!K\u00014i\u0016\u001cH/Q4h%\u0016lwN^3`\u001bVdG/\u001b#jgRLgn\u0019;BO\u001e\u001cxlV5uQ:{g\u000eR5ti&t7\r^!hOFB3!!\u0002;\u0001")
public class FlinkAggregateRemoveRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("subquery_rewrite", (FlinkOptimizeProgram)FlinkGroupProgramBuilder$.MODULE$.newBuilder().addProgram((FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(FlinkBatchRuleSets$.MODULE$.SEMI_JOIN_RULES()).build(), "rewrite sub-queries to semi/anti join").build());
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, FlinkAggregateExpandDistinctAggregatesRule.INSTANCE, CoreRules.FILTER_CALC_MERGE, CoreRules.PROJECT_CALC_MERGE, CoreRules.FILTER_TO_CALC, CoreRules.PROJECT_TO_CALC, FlinkCalcMergeRule$.MODULE$.INSTANCE(), FlinkAggregateRemoveRule.INSTANCE, DecomposeGroupingSetsRule$.MODULE$.INSTANCE(), AggregateReduceGroupingRule$.MODULE$.INSTANCE(), FlinkLogicalAggregate$.MODULE$.BATCH_CONVERTER(), FlinkLogicalCalc$.MODULE$.CONVERTER(), FlinkLogicalJoin$.MODULE$.CONVERTER(), FlinkLogicalValues$.MODULE$.CONVERTER(), FlinkLogicalExpand$.MODULE$.CONVERTER(), FlinkLogicalLegacyTableSourceScan$.MODULE$.CONVERTER(), FlinkLogicalLegacySink$.MODULE$.CONVERTER()})).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{FlinkConventions$.MODULE$.LOGICAL()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateRemoveRuleTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING()}), (String[])((Object[])new String[]{"a", "b", "c"}), FlinkStatistic$.MODULE$.builder().uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a"))).build());
        this.util().addTableSource("MyTable3", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"a", "b", "c", "d"}), FlinkStatistic$.MODULE$.builder().uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a"))).build());
    }

    @Test
    public void testAggRemove_GroupKeyIsNotUnique() {
        this.util().verifyRelPlan("SELECT a, MAX(c) from MyTable1 GROUP BY a");
    }

    @Test
    public void testAggRemove_WithoutFilter1() {
        this.util().verifyRelPlan("SELECT a, b + 1, c, s FROM (SELECT a, MIN(b) AS b, SUM(b) AS s, MAX(c) AS c FROM MyTable2 GROUP BY a)");
    }

    @Test
    public void testAggRemove_WithoutFilter2() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_WithoutGroupBy1() {
        this.util().verifyRelPlan("SELECT MAX(a), SUM(b), MIN(c) FROM MyTable2");
    }

    @Test
    public void testAggRemove_WithoutGroupBy2() {
        this.util().verifyRelPlan("SELECT MAX(a), SUM(b), MIN(c) FROM (VALUES (1, 2, 3)) T(a, b, c)");
    }

    @Test
    public void testAggRemove_WithoutGroupBy3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable2 WHERE EXISTS (SELECT SUM(a) FROM MyTable1 WHERE 1=2)");
    }

    @Test
    public void testAggRemove_WithoutGroupBy4() {
        this.util().verifyRelPlan("SELECT SUM(a) FROM (SELECT a FROM MyTable2 WHERE 1=2)");
    }

    @Test
    public void testAggRemove_WithoutAggCall() {
        this.util().verifyRelPlan("SELECT a, b FROM MyTable2 GROUP BY a, b");
    }

    @Test
    public void testAggRemove_WithFilter() {
        this.util().verifyRelPlan("SELECT a, MIN(c) FILTER (WHERE b > 0), MAX(b) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_Count() {
        this.util().verifyRelPlan("SELECT a, COUNT(c) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_CountStar() {
        this.util().verifyRelPlan("SELECT a, COUNT(*) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_GroupSets1() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable3 GROUP BY GROUPING SETS((a, c), (a, d))");
    }

    @Test
    public void testAggRemove_GroupSets2() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable3 GROUP BY GROUPING SETS((a, c), (a), ())");
    }

    @Test
    public void testAggRemove_Rollup() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable3 GROUP BY ROLLUP(a, c, d)");
    }

    @Test
    public void testAggRemove_Cube() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable3 GROUP BY CUBE(a, c, d)");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg1() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg2() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable2 GROUP BY a, b");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg_WithNonDistinctAgg1() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT b), SUM(b) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg_WithNonDistinctAgg2() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT b), SUM(b) FROM MyTable2 GROUP BY a, c");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg_WithNonDistinctAgg3() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c), SUM(b) FROM MyTable3 GROUP BY a");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg_WithNonDistinctAgg4() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c), SUM(b) FROM MyTable3 GROUP BY a, d");
    }

    @Test
    public void testAggRemove_MultiDistinctAggs1() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT b), SUM(DISTINCT b) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_MultiDistinctAggs2() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c), SUM(DISTINCT b) FROM MyTable3 GROUP BY a, d");
    }

    @Test
    public void testAggRemove_MultiDistinctAggs3() {
        this.util().verifyRelPlan("SELECT a, SUM(DISTINCT b), MAX(DISTINCT b), MIN(DISTINCT c) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_MultiDistinctAggs_WithNonDistinctAgg1() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c), SUM(b) FROM MyTable3 GROUP BY a, d");
    }
}

