/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001'\t\u0011R*\u0019;dQJ+7m\\4oSj,G+Z:u\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\u0012\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\r\t,gm\u001c:f)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012!\u00026v]&$\u0018B\u0001\u001c4\u0005\u0019\u0011UMZ8sK\")\u0001\b\u0001C\u0001S\u0005qB/Z:u\u001b\u0006$8\r\u001b*fG><g.\u001b>f\u001f:\u0014vn\u001e;j[\u0016dEK\u0017\u0015\u0003oi\u0002\"AM\u001e\n\u0005q\u001a$\u0001\u0002+fgRDQA\u0010\u0001\u0005\u0002%\n\u0001\u0003^3ti\u000e\u000b7oY1eK6\u000bGo\u00195)\u0005uR\u0004")
public class MatchRecognizeTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE Ticker (\n        | `symbol` STRING,\n        | `ts_ltz` TIMESTAMP_LTZ(3),\n        | `price` INT,\n        | `tax` INT,\n        | WATERMARK FOR `ts_ltz` AS `ts_ltz` - INTERVAL '1' SECOND\n        |) WITH (\n        | 'connector' = 'values'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME() as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCascadeMatch() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM (\n         |  SELECT\n         |    symbol,\n         |    matchRowtime,\n         |    price,\n         |    TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |  FROM Ticker\n         |  MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME() as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, matchRowtime, price, TUMBLE(matchRowtime, interval '3' second)\n         |)\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY matchRowtime\n         |  MEASURES\n         |    A.price as dPrice,\n         |    A.matchRowtime as matchRowtime\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.matchRowtime >= (CURRENT_TIMESTAMP - INTERVAL '1' day)\n         |)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

