/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001'\t\u00192k\\;sG\u0016<\u0016\r^3s[\u0006\u00148\u000eV3ti*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0019\u0019HO]3b[*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0013\u0001B;uS2,\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r\u0019\u0002\u0001\u0015!\u0003#\u0003\u0015)H/\u001b7!\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0015\u0019X\r^;q)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012!\u00026v]&$\u0018B\u0001\u001c4\u0005\u0019\u0011UMZ8sK\")\u0001\b\u0001C\u0001S\u0005YB/Z:u'&l\u0007\u000f\\3XCR,'/\\1sWB+8\u000f\u001b#po:D#a\u000e\u001e\u0011\u0005IZ\u0014B\u0001\u001f4\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011A\u0015\u0002[Q,7\u000f^,bi\u0016\u0014X.\u0019:l\u001f:\u001cu.\u001c9vi\u0016$7i\u001c7v[:,\u0005p\u00197vI\u0016$'k\\<US6,'\u0007\u000b\u0002>u!)\u0011\t\u0001C\u0001S\u0005aC/Z:u/\u0006$XM]7be.|enQ8naV$X\rZ\"pYVlg.\u0012=dYV,GMU8x)&lW-\r\u0015\u0003\u0001jBQ\u0001\u0012\u0001\u0005\u0002%\nA\u0006^3ti^\u000bG/\u001a:nCJ\\wJ\u001c(fgR,GMU8x/&$\bNT3ti\u0016$\u0007K]8kK\u000e$\u0018n\u001c8)\u0005\rS\u0004\"B$\u0001\t\u0003I\u0013\u0001\u0006;fgR<\u0016\r^3s[\u0006\u00148nV5uQV#g\r\u000b\u0002Gu!)!\n\u0001C\u0001S\u0005IB/Z:u/\u0006$XM]7be.<\u0016\u000e\u001e5NKR\fG-\u0019;bQ\tI%\bC\u0003N\u0001\u0011\u0005\u0011&\u0001\u0010uKN$x+\u0019;fe6\f'o[(o)&lWm\u001d;b[BdEO_\"pY\"\u0012AJ\u000f\u0005\u0006!\u0002!\t!K\u0001+i\u0016\u001cHoV1uKJl\u0017M]6P]\u000e+(O]3oiJ{w\u000fV5nKN$\u0018-\u001c9Gk:\u001cG/[8oQ\ty%\bC\u0003T\u0001\u0011\u0005\u0011&A\u0013uKN$\bK]8kK\u000e$HK]1ogB|7/Z,bi\u0016\u0014X.\u0019:l\u0003N\u001c\u0018n\u001a8fe\"\u0012!K\u000f")
public class SourceWatermarkTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE VirtualTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   d AS c + INTERVAL '5' SECOND,\n         |   WATERMARK FOR d AS d - INTERVAL '5' SECOND\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true'\n         | )\n         ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE NestedTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c ROW<name STRING, d ROW<e STRING, f TIMESTAMP(3)>>,\n         |   g AS c.d.f,\n         |   WATERMARK FOR g AS g - INTERVAL '5' SECOND\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'nested-projection-supported' = 'true',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true'\n         | )\n         ")).stripMargin());
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        this.util().tableEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE Table UdfTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c timestamp(3),\n         |   d as func(c, a),\n         |   WATERMARK FOR c as func(func(d, a), a)\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true'\n         | )\n         ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE MyTable(\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   originTime BIGINT METADATA,\n         |   rowtime AS TO_TIMESTAMP(FROM_UNIXTIME(originTime/1000), 'yyyy-MM-dd HH:mm:ss'),\n         |   WATERMARK FOR rowtime AS rowtime\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true',\n         |   'readable-metadata' = 'originTime:BIGINT'\n         | )\n         ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE MyLtzTable(\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   originTime BIGINT METADATA,\n         |   rowtime AS TO_TIMESTAMP_LTZ(originTime, 3),\n         |   WATERMARK FOR rowtime AS rowtime\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true',\n         |   'readable-metadata' = 'originTime:BIGINT'\n         | )\n         ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE timeTestTable(\n         |   a INT,\n         |   b BIGINT,\n         |   rowtime AS TO_TIMESTAMP_LTZ(b, 0),\n         |   WATERMARK FOR rowtime AS rowtime\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true'\n         | )\n         ")).stripMargin());
    }

    @Test
    public void testSimpleWatermarkPushDown() {
        this.util().verifyExecPlan("SELECT a, b, c FROM VirtualTable");
    }

    @Test
    public void testWatermarkOnComputedColumnExcludedRowTime2() {
        this.util().verifyExecPlan("SELECT a, b, SECOND(d) FROM VirtualTable");
    }

    @Test
    public void testWatermarkOnComputedColumnExcluedRowTime1() {
        this.util().verifyExecPlan("SELECT a, b FROM VirtualTable WHERE b > 10");
    }

    @Test
    public void testWatermarkOnNestedRowWithNestedProjection() {
        this.util().verifyExecPlan("select c.e, c.d from NestedTable");
    }

    @Test
    public void testWatermarkWithUdf() {
        this.util().verifyExecPlan("SELECT a - b FROM UdfTable");
    }

    @Test
    public void testWatermarkWithMetadata() {
        this.util().verifyExecPlan("SELECT a, b FROM MyTable");
    }

    @Test
    public void testWatermarkOnTimestampLtzCol() {
        this.util().verifyExecPlan("SELECT a, b FROM MyLtzTable");
    }

    @Test
    public void testWatermarkOnCurrentRowTimestampFunction() {
        this.util().verifyExecPlan("SELECT * FROM timeTestTable");
    }

    @Test
    public void testProjectTransposeWatermarkAssigner() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TEMPORARY TABLE `t1` (\n         |  `a`  VARCHAR,\n         |  `b`  VARCHAR,\n         |  `c`  VARCHAR,\n         |  `d`  INT,\n         |  `t`  TIMESTAMP(3),\n         |  `ts` AS `t`,\n         |  WATERMARK FOR `ts` AS `ts`  - INTERVAL '10' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'enable-watermark-push-down' = 'true',\n         |  'bounded' = 'false',\n         |  'disable-lookup' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(sourceDDL);
        this.util().verifyExecPlan("SELECT a, b, ts FROM t1");
    }
}

