/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001'\t9r+\u001b8e_^$\u0016M\u00197f\rVt7\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0007uKN$H+^7cY\u0016$fK\u0012\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5uQ\t9\u0013\u0007\u0005\u00023k5\t1G\u0003\u00025!\u0005)!.\u001e8ji&\u0011ag\r\u0002\u0005)\u0016\u001cH\u000fC\u00039\u0001\u0011\u0005\u0011&A\u000buKN$H+^7cY\u0016$fK\u0012)s_\u000e$\u0018.\\3)\u0005]\n\u0004\"B\u001e\u0001\t\u0003I\u0013A\u0003;fgRDu\u000e\u001d+W\r\"\u0012!(\r\u0005\u0006}\u0001!\t!K\u0001\u0010i\u0016\u001cHoQ;nk2\fG/\u001a+W\r\"\u0012Q(\r\u0005\u0006\u0003\u0002!\t!K\u0001\u001di\u0016\u001cHoV5oI><xJ\u001c(p]RKW.Z!uiJL'-\u001e;fQ\t\u0001\u0015\u0007C\u0003E\u0001\u0011\u0005\u0011&A\ruKN$8i\u001c8gY&\u001cG/\u001b8h\r&,G\u000e\u001a(b[\u0016\u001c\bFA\"2\u0011\u00159\u0005\u0001\"\u0001*\u0003=!Xm\u001d;V]N,\b\u000f]8si\u0016$\u0007F\u0001$2\u0011\u0015Q\u0005\u0001\"\u0001*\u0003]!Xm\u001d;Uk6\u0014G.\u001a+W\r^KG\u000f[(gMN,G\u000f\u000b\u0002Jc!)Q\n\u0001C\u0001S\u0005yB/Z:u)Vl'\r\\3U-\u001a;\u0016\u000e\u001e5OK\u001e\fG/\u001b<f\u001f\u001a47/\u001a;)\u00051\u000b\u0004\"\u0002)\u0001\t\u0003I\u0013\u0001\u0006;fgRDu\u000e\u001d+W\r^KG\u000f[(gMN,G\u000f\u000b\u0002Pc!)1\u000b\u0001C\u0001S\u0005aB/Z:u\u0011>\u0004HK\u0016$XSRDg*Z4bi&4Xm\u00144gg\u0016$\bF\u0001*2\u0011\u00151\u0006\u0001\"\u0001*\u0003e!Xm\u001d;Dk6,H.\u0019;f)Z3u+\u001b;i\u001f\u001a47/\u001a;)\u0005U\u000b\u0004\"B-\u0001\t\u0003I\u0013!\t;fgR\u001cU/\\;mCR,GK\u0016$XSRDg*Z4bi&4Xm\u00144gg\u0016$\bF\u0001-2\u0001")
public class WindowTableFunctionTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTumbleTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowOnNonTimeAttribute() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW v1 AS\n        |SELECT *, LOCALTIMESTAMP AS cur_time\n        |FROM MyTable\n        |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | TUMBLE(TABLE v1, DESCRIPTOR(cur_time), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.thrown().expectMessage("requires the timecol is a time attribute type, but is TIMESTAMP(3)");
        this.thrown().expect(ValidationException.class);
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testConflictingFieldNames() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW v1 AS\n        |SELECT *, rowtime AS window_start\n        |FROM MyTable\n        |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | TUMBLE(TABLE v1, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.thrown().expectMessage("Column 'window_start' is ambiguous");
        this.thrown().expect(ValidationException.class);
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testUnsupported() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.thrown().expectMessage("Currently Flink doesn't support individual window table-valued function TUMBLE(time_col=[rowtime], size=[15 min]).\n Please use window table-valued function with the following computations:\n1. aggregate using window_start and window_end as group keys.\n2. topN using window_start and window_end as partition key.\n3. join with join condition contains window starts equality of input tables and window ends equality of input tables.\n");
        this.thrown().expect(TableException.class);
        this.util().verifyExplain(sql);
    }

    @Test
    public void testTumbleTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE, INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE, INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  HOP(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  HOP(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  CUMULATE(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  CUMULATE(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    public WindowTableFunctionTest() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n       |CREATE TABLE MyTable (\n       |  a INT,\n       |  b BIGINT,\n       |  c STRING,\n       |  d DECIMAL(10, 3),\n       |  rowtime TIMESTAMP(3),\n       |  proctime as PROCTIME(),\n       |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n       |) with (\n       |  'connector' = 'values'\n       |)\n       |")).stripMargin());
    }
}

