/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.GroupWindowTest$;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001U\u0011qb\u0012:pkB<\u0016N\u001c3poR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!Y4h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\rM$(/Z1n\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011DC\u0001\u0006kRLGn]\u0005\u00037a\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u001d\u0011\u0003A1A\u0005\n\r\nA!\u001e;jYV\tA\u0005\u0005\u0002\u0018K%\u0011a\u0005\u0007\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007Q\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b)\u0002A\u0011A\u0016\u00021Q,7\u000f\u001e+v[\ndWmV5oI><hj\\(gMN,G\u000fF\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0011)f.\u001b;)\t%\u001a\u0014H\u000f\t\u0003i]j\u0011!\u000e\u0006\u0003mI\tQA[;oSRL!\u0001O\u001b\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\n1\b\u0005\u0002=\u007f5\tQH\u0003\u0002?\u0019\u0005\u0019\u0011\r]5\n\u0005\u0001k$A\u0004+bE2,W\t_2faRLwN\u001c\u0005\u0006\u0005\u0002!\taK\u0001\u0016i\u0016\u001cH\u000fS8q/&tGm\\<O_>3gm]3uQ\u0011\t5'\u000f\u001e\t\u000b\u0015\u0003A\u0011A\u0016\u00023Q,7\u000f^*fgNLwN\\,j]\u0012|wOT8PM\u001a\u001cX\r\u001e\u0015\u0005\tNJ$\bC\u0003I\u0001\u0011\u00051&\u0001\fuKN$h+\u0019:jC\ndWmV5oI><8+\u001b>fQ\u001195'\u000f\u001e\t\u000b-\u0003A\u0011A\u0016\u00025Q,7\u000f^,j]\u0012|w/\u00163BO\u001eLeN^1mS\u0012\f%oZ:)\t)\u001b\u0014(T\u0012\u0002\u001dB\u0011AhT\u0005\u0003!v\u00121CV1mS\u0012\fG/[8o\u000bb\u001cW\r\u001d;j_:DQA\u0015\u0001\u0005\u0002-\n!\u0004^3ti^Kg\u000eZ8x\u0003\u001e<w+\u001b;i\u000fJ|W\u000f]*fiNDC!U\u001a:)\u000e\nQ\u000b\u0005\u0002W76\tqK\u0003\u0002Y3\u0006!A.\u00198h\u0015\u0005Q\u0016\u0001\u00026bm\u0006L!\u0001X,\u0003\u001d\u0005\u001b8/\u001a:uS>tWI\u001d:pe\")a\f\u0001C\u0001W\u0005yB/Z:u/&tGm\\<Xe>twmV5oI><\b+\u0019:b[\u0016$XM]\u0019)\u0005u\u001b\u0004\"B1\u0001\t\u0003Y\u0013a\b;fgR<\u0016N\u001c3po^\u0013xN\\4XS:$wn\u001e)be\u0006lW\r^3se!\u0012\u0001m\r\u0005\u0006I\u0002!\taK\u0001\u0010i\u0016\u001cH/\u00138uKJ4\u0018\r\u001c#bs\"\u00121m\r\u0005\u0006O\u0002!\taK\u0001\u0013i\u0016\u001cH\u000fV;nE2,g)\u001e8di&|g\u000e\u000b\u0002gg!)!\u000e\u0001C\u0001W\u0005YB/Z:u/&tGm\\<He>,\bOQ=P]\u000e{gn\u001d;b]RD#![\u001a\t\u000b5\u0004A\u0011A\u0016\u0002=Q,7\u000f\u001e+v[\nd\u0017N\\4XS:$wn^,ji\"\u0004&o\\2uS6,\u0007F\u000174\u0011\u0015\u0001\b\u0001\"\u0001,\u0003M!Xm\u001d;Nk2$\u0018\u000eS8q/&tGm\\<tQ\ty7\u0007C\u0003t\u0001\u0011\u00051&A\fuKN$X*\u001e7uS\"{\u0007oV5oI><8OS8j]\"\u0012!o\r\u0005\u0006m\u0002!\taK\u0001\u0014i\u0016\u001cH\u000fS8qa&twMR;oGRLwN\u001c\u0015\u0003kNBQ!\u001f\u0001\u0005\u0002-\n\u0011\u0004^3ti\"{\u0007oV5oI><x+\u001b;i!J|7\r^5nK\"\u0012\u0001p\r\u0005\u0006y\u0002!\taK\u0001\u0014i\u0016\u001cHoU3tg&|gNR;oGRLwN\u001c\u0015\u0003wNBQa \u0001\u0005\u0002-\nQ\u0004^3tiN+7o]5p]^Kg\u000eZ8x/&$\b\u000e\u0015:pGRLW.\u001a\u0015\u0003}NBa!!\u0002\u0001\t\u0003Y\u0013!\t;fgR,\u0005\u0010\u001d:fgNLwN\\(o/&tGm\\<Bkb4UO\\2uS>t\u0007fAA\u0002g!1\u00111\u0002\u0001\u0005\u0002-\n\u0011\u0005^3ti6+H\u000e^5XS:$wn^*rY^KG\u000f[!hOJ,w-\u0019;j_:D3!!\u00034\u0011\u0019\t\t\u0002\u0001C\u0001W\u00051B/Z:u)Vl'\r\\3Gk:Len\u0012:pkB\u0014\u0015\u0010K\u0002\u0002\u0010MBa!a\u0006\u0001\t\u0003Y\u0013!\u0007;fgR$V/\u001c2mK\u001a+hNT8u\u0013:<%o\\;q\u0005fD3!!\u00064\u0011\u0019\ti\u0002\u0001C\u0001W\u00051C/Z:u)Vl'\r\\3Gk:\fe\u000e\u001a*fOVd\u0017M]!hO\u001a+h.\u00138He>,\bOQ=)\u0007\u0005m1\u0007\u0003\u0004\u0002$\u0001!\taK\u00016i\u0016\u001cHOU3hk2\f'/Q4h\rVt\u0017J\\$s_V\u0004()_!oIR+XN\u00197f\rVt\u0017I\u001c3O_RLen\u0012:pkB\u0014\u0015\u0010K\u0002\u0002\"MBa!!\u000b\u0001\t\u0003Y\u0013\u0001\b;fgR$UmY8na>\u001c\u0018M\u00197f\u0003\u001e<g)\u001e8di&|gn\u001d\u0015\u0004\u0003O\u0019\u0004BBA\u0018\u0001\u0011\u00051&\u0001\u0013uKN$X\t\u001f9sKN\u001c\u0018n\u001c8P]^Kg\u000eZ8x\u0011\u00064\u0018N\\4Gk:\u001cG/[8oQ\r\tic\r\u0005\u0007\u0003k\u0001A\u0011A\u0016\u0002GQ,7\u000f\u001e*fiV\u0014h\u000eV=qK&sg-\u001a:f]\u000e,gi\u001c:XS:$wn^!hO\"\u001a\u00111G\u001a\t\r\u0005m\u0002\u0001\"\u0001,\u0003\u001d\"Xm\u001d;XS:$wn^!hOJ,w-\u0019;f/&$\b\u000eR5gM\u0016\u0014XM\u001c;XS:$wn^:)\u0007\u0005e2\u0007\u0003\u0004\u0002B\u0001!\taK\u0001 i\u0016\u001cHoV5oI><\u0018iZ4sK\u001e\fG/Z,ji\"d\u0015\r^3GSJ,\u0007fAA g!1\u0011q\t\u0001\u0005\u0002-\nA\u0005^3ti^Kg\u000eZ8x\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5BY2|w\u000fT1uK:,7o\u001d\u0015\u0004\u0003\u000b\u001a\u0004BBA'\u0001\u0011\u00051&A\u0016uKN$x+\u001b8e_^\fum\u001a:fO\u0006$XmV5uQ&sg/\u00197jI\u0006cGn\\<MCR,g.Z:tQ\r\tYe\r\u0005\u0007\u0003'\u0002A\u0011A\u0016\u0002QQ,7\u000f^,j]\u0012|w/Q4he\u0016<\u0017\r^3XSRD\u0017\t\u001c7po2\u000bG/\u001a8fgN|e\u000e\\=)\u0007\u0005E3\u0007\u0003\u0004\u0002Z\u0001!\taK\u0001#i\u0016\u001cHoV5oI><\u0018iZ4sK\u001e\fG/Z(o%\u0016$(/Y2u'R\u0014X-Y7)\u0007\u0005]3\u0007\u0003\u0004\u0002`\u0001!\taK\u0001\"i\u0016\u001cHoV5oI><\u0018iZ4sK\u001e\fG/Z(o+B\u001cXM\u001d;T_V\u00148-\u001a\u0015\u0004\u0003;\u001a\u0004")
public class GroupWindowTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test(expected=TableException.class)
    public void testTumbleWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '2' HOUR, TIME '10:00:00')";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=TableException.class)
    public void testHopWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY HOP(proctime, INTERVAL '1' HOUR, INTERVAL '2' HOUR, TIME '10:00:00')";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=TableException.class)
    public void testSessionWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY SESSION(proctime, INTERVAL '2' HOUR, TIME '10:00:00')";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=TableException.class)
    public void testVariableWindowSize() {
        String sql = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, c * INTERVAL '1' MINUTE)";
        this.util().verifyExecPlan(sql);
    }

    @Test(expected=ValidationException.class)
    public void testWindowUdAggInvalidArgs() {
        String sqlQuery = "SELECT SUM(a) AS sumA, weightedAvg(a, b) AS wAvg FROM MyTable GROUP BY TUMBLE(proctime(), INTERVAL '2' HOUR, TIME '10:00:00')";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=AssertionError.class)
    public void testWindowAggWithGroupSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n      |SELECT COUNT(*),\n      |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE\n      |FROM MyTable\n      |    GROUP BY rollup(TUMBLE(rowtime, INTERVAL '15' MINUTE), b)\n    ")).stripMargin();
        this.util().verifyRelPlanNotExpected(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TUMBLE(rowtime"}));
    }

    @Test
    public void testWindowWrongWindowParameter1() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '1' MONTH)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindowWrongWindowParameter2() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '2-10' YEAR TO MONTH)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testIntervalDay() {
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '35' DAY)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTumbleFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    weightedAvg(c, a) AS wAvg,\n        |    TUMBLE_START(rowtime, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowGroupByOnConstant() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    weightedAvg(c, a) AS wAvg,\n        |    TUMBLE_START(rowtime, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY 'a', TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumblingWindowWithProctime() {
        String sql = "select sum(a), max(b) from MyTable1 group by TUMBLE(c, INTERVAL '1' SECOND)";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultiHopWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR),\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR),\n        |   count(*),\n        |   sum(c)\n        |FROM MyTable\n        |GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR)\n        |UNION ALL\n        |SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY),\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY),\n        |   count(*),\n        |   sum(c)\n        |FROM MyTable\n        |GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultiHopWindowsJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        | (SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR) as hs1,\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR) as he1,\n        |   count(*) as c1,\n        |   sum(c) as s1\n        | FROM MyTable\n        | GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR)) t1\n        |JOIN\n        | (SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY) as hs2,\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY) as he2,\n        |   count(*) as c2,\n        |   sum(c) as s2\n        | FROM MyTable\n        | GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY)) t2 ON t1.he1 = t2.he2\n        |WHERE t1.s1 IS NOT NULL\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testHoppingFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    weightedAvg(c, a) AS wAvg,\n        |    HOP_START(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR),\n        |    HOP_END(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR)\n        |FROM MyTable\n        |    GROUP BY HOP(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testHopWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable1\n         |group by HOP(c, INTERVAL '1' SECOND, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSessionFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*), weightedAvg(c, a) AS wAvg,\n        |    SESSION_START(proctime, INTERVAL '15' MINUTE),\n        |    SESSION_END(proctime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY SESSION(proctime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSessionWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable1\n         |group by SESSION(c, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testExpressionOnWindowAuxFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE\n        |FROM MyTable\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultiWindowSqlWithAggregation() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  TUMBLE_ROWTIME(zzzzz, INTERVAL '0.004' SECOND),\n        |  TUMBLE_END(zzzzz, INTERVAL '0.004' SECOND),\n        |  COUNT(`a`) AS `a`\n        |FROM (\n        |  SELECT\n        |    COUNT(`a`) AS `a`,\n        |    TUMBLE_ROWTIME(rowtime, INTERVAL '0.002' SECOND) AS `zzzzz`\n        |  FROM MyTable\n        |  GROUP BY TUMBLE(rowtime, INTERVAL '0.002' SECOND)\n        |)\n        |GROUP BY TUMBLE(zzzzz, INTERVAL '0.004' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleFunInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)\n        |     ) AS t1\n        | GROUP BY b, ping_start\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleFunNotInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1\n        |GROUP BY b\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleFunAndRegularAggFunInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c, count(*) d,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1\n        |GROUP BY b, d, ping_start\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRegularAggFunInGroupByAndTumbleFunAndNotInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c, count(*) d,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1\n        |GROUP BY b, d\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testDecomposableAggFunctions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    VAR_POP(c),\n        |    VAR_SAMP(c),\n        |    STDDEV_POP(c),\n        |    STDDEV_SAMP(c),\n        |    TUMBLE_START(rowtime, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testExpressionOnWindowHavingFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    HOP_START(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        | FROM MyTable\n        |     GROUP BY HOP(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        |     HAVING SUM(a) > 0 AND\n        |         QUARTER(HOP_START(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)) = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testReturnTypeInferenceForWindowAgg() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  SUM(correct) AS s,\n        |  AVG(correct) AS a,\n        |  TUMBLE_START(rowtime, INTERVAL '15' MINUTE) AS wStart\n        |FROM (\n        |  SELECT CASE a\n        |      WHEN 1 THEN 1\n        |      ELSE 99\n        |    END AS correct, rowtime\n        |  FROM MyTable\n        |)\n        |GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowAggregateWithDifferentWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n      |WITH window_1h AS (\n      |    SELECT 1\n      |    FROM MyTable\n      |    GROUP BY HOP(`rowtime`, INTERVAL '1' HOUR, INTERVAL '1' HOUR)\n      |),\n      |\n      |window_2h AS (\n      |    SELECT 1\n      |    FROM MyTable\n      |    GROUP BY HOP(`rowtime`, INTERVAL '1' HOUR, INTERVAL '2' HOUR)\n      |)\n      |\n      |(SELECT * FROM window_1h)\n      |UNION ALL\n      |(SELECT * FROM window_2h)\n      |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowAggregateWithLateFire() {
        this.util().conf().getConfiguration().setBoolean(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), true);
        this.util().conf().getConfiguration().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofSeconds(5L));
        this.util().conf().setIdleStateRetentionTime(Time.hours((long)1L), Time.hours((long)2L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateWithAllowLateness() {
        this.util().conf().getConfiguration().setBoolean(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), true);
        this.util().conf().getConfiguration().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofSeconds(5L));
        this.util().conf().getConfiguration().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS(), (Object)Duration.ofHours(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateWithInvalidAllowLateness() {
        this.util().conf().getConfiguration().setBoolean(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), true);
        this.util().conf().getConfiguration().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofSeconds(5L));
        this.util().conf().getConfiguration().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS(), (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Allow-lateness [1000ms] should not be smaller than Late-fire delay [5000ms] when enable late-fire emit strategy.");
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateWithAllowLatenessOnly() {
        this.util().conf().setIdleStateRetentionTime(Time.hours((long)1L), Time.hours((long)2L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateOnRetractStream() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM  (\n        | SELECT a, b, c, rowtime\n        | FROM (\n        |   SELECT *,\n        |   ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rowNum\n        |   FROM MyTable\n        | )\n        | WHERE rowNum = 1\n        |)\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateOnUpsertSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE src (\n        |  ts AS PROCTIME(),\n        |  a INT,\n        |  b DOUBLE,\n        |  PRIMARY KEY (a) NOT ENFORCED\n        |) WITH (\n        |  'connector' = 'values',\n        |  'changelog-mode' = 'UA,D'\n        |)\n      ")).stripMargin());
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '10' SECOND), COUNT(*)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '10' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    public GroupWindowTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.GroupWindowTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n       |create table MyTable1 (\n       |  a int,\n       |  b bigint,\n       |  c as proctime()\n       |) with (\n       |  'connector' = 'COLLECTION'\n       |)\n       |")).stripMargin());
    }
}

