/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$;
import org.apache.flink.table.planner.plan.stream.sql.join.TestInvalidTemporalTable$;
import org.apache.flink.table.planner.plan.stream.sql.join.TestTemporalTable$;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionResultType;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001U\u0011a\u0002T8pWV\u0004(j\\5o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\rM$(/Z1n\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003EaWmZ1dsR\u000b'\r\\3T_V\u00148-\u001a\t\u0003;\u0015J!A\n\u0010\u0003\u000f\t{w\u000e\\3b]\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"\u0001\u0002\t\u000b\r:\u0003\u0019\u0001\u0013\t\u000f9\u0002!\u0019!C\u0005_\u0005!Q\u000f^5m+\u0005\u0001\u0004CA\f2\u0013\t\u0011\u0004DA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000e\u0003\u00045\u0001\u0001\u0006I\u0001M\u0001\u0006kRLG\u000e\t\u0005\u0006m\u0001!\taN\u0001\u0007E\u00164wN]3\u0015\u0003a\u0002\"!H\u001d\n\u0005ir\"\u0001B+oSRD#!\u000e\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0012\u0012!\u00026v]&$\u0018BA!?\u0005\u0019\u0011UMZ8sK\")1\t\u0001C\u0001o\u0005\u0001C/Z:u\u0015>Lg.\u00138wC2LGMS8j]R+W\u000e]8sC2$\u0016M\u00197fQ\t\u0011U\t\u0005\u0002>\r&\u0011qI\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003J\u0001\u0011\u0005q'\u0001\u0012uKN$hj\u001c;ESN$\u0018N\\2u\rJ|W.\u00138K_&t7i\u001c8eSRLwN\u001c\u0015\u0003\u0011\u0016CQ\u0001\u0014\u0001\u0005\u0002]\na\u0004^3ti&sg/\u00197jI2{wn[;q)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8)\u0005-+\u0005\"B(\u0001\t\u00039\u0014a\u0007;fgRTu.\u001b8P]\u0012KgMZ3sK:$8*Z=UsB,7\u000f\u000b\u0002O\u000b\")!\u000b\u0001C\u0001o\u0005)B/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,\u0007FA)F\u0011\u0015)\u0006\u0001\"\u00018\u0003e!Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\u0005Q+\u0005\"\u0002-\u0001\t\u00039\u0014\u0001\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"tUm\u001d;fIF+XM]=)\u0005]+\u0005\"B.\u0001\t\u00039\u0014a\u000b;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"\u0004&o\u001c6fGRLwN\u001c)vg\"$un\u001e8)\u0005i+\u0005\"\u00020\u0001\t\u00039\u0014a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"4\u0015\u000e\u001c;feB+8\u000f\u001b#po:D#!X#\t\u000b\u0005\u0004A\u0011A\u001c\u0002KQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f[\"bY\u000e\u0004Vo\u001d5E_^t\u0007F\u00011F\u0011\u0015!\u0007\u0001\"\u00018\u0003%\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5Nk2$\u0018.\u00138eKb\u001cu\u000e\\;n]\"\u00121-\u0012\u0005\u0006O\u0002!\taN\u0001\u001bi\u0016\u001cH/\u0011<pS\u0012\fum\u001a:fO\u0006$X\rU;tQ\u0012{wO\u001c\u0015\u0003M\u0016CQA\u001b\u0001\u0005\u0002]\na\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQR\u0013X/Z\"p]\u0012LG/[8oQ\tIW\tC\u0003n\u0001\u0011\u0005q'A\u001buKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDg)\u001e8di&|g.\u00118e\u0007>t7\u000f^1oi\u000e{g\u000eZ5uS>t\u0007F\u00017F\u0011\u0015\u0001\b\u0001\"\u00018\u0003i\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5Nk2$\u0018NR;oGRLwN\\!oI\u000e{gn\u001d;b]R\u001cuN\u001c3ji&|g\u000e\u000b\u0002p\u000b\")1\u000f\u0001C\u0001o\u00051D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\rVt7\r^5p]\u0006sGMU3gKJ,gnY3D_:$\u0017\u000e^5p]\"\u0012!/\u0012\u0005\u0006m\u0002!\taN\u0001(i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b.\u00163g\u000bF,\u0018\r\u001c$jYR,'\u000f\u000b\u0002v\u000b\")\u0011\u0010\u0001C\u0001o\u00059C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007>l\u0007/\u001e;fI\u000e{G.^7oQ\tAX\tC\u0003}\u0001\u0011\u0005q'\u0001\u001auKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7i\\7qkR,GmQ8mk6t\u0017I\u001c3QkNDGi\\<oQ\tYX\tC\u0003\u0000\u0001\u0011\u0005q'A\u001buKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDW*\u001e7uS\u000e{g\u000eZ5uS>twJ\\*b[\u0016$\u0015.\u001c$jK2$\u0007F\u0001@F\u0011\u0019\t)\u0001\u0001C\u0001o\u0005QC/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007\u0006\u001cHo\u00148M_>\\W\u000f\u001d+bE2,\u0007fAA\u0002\u000b\"1\u00111\u0002\u0001\u0005\u0002]\nq\u0007^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ&sG/\u001a:pa\u0016\u0014\u0018M\u00197f\u0007\u0006\u001cHo\u00148M_>\\W\u000f\u001d+bE2,\u0007fAA\u0005\u000b\"9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0011!E2sK\u0006$X\rT8pWV\u0004H+\u00192mKR)\u0001(!\u0006\u00020!A\u0011qCA\b\u0001\u0004\tI\"A\u0005uC\ndWMT1nKB!\u00111DA\u0015\u001d\u0011\ti\"!\n\u0011\u0007\u0005}a$\u0004\u0002\u0002\")\u0019\u00111\u0005\u000b\u0002\rq\u0012xn\u001c;?\u0013\r\t9CH\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001db\u0004\u0003\u0005\u00022\u0005=\u0001\u0019AA\u001a\u00039awn\\6va\u001a+hn\u0019;j_:\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sa\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\u0011\ti$a\u000e\u0003'U\u001bXM\u001d#fM&tW\r\u001a$v]\u000e$\u0018n\u001c8\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\u0005)R\r\u001f9fGR,\u0005pY3qi&|g\u000e\u00165s_^tGc\u0002\u001d\u0002F\u0005\u001d\u00131\n\u0005\b\u000b\u0005}\u0002\u0019AA\r\u0011!\tI%a\u0010A\u0002\u0005e\u0011aB7fgN\fw-\u001a\u0005\u000b\u0003\u001b\ny\u0004%AA\u0002\u0005=\u0013!B2mCjT\b\u0007BA)\u00037\u0002b!a\u0007\u0002T\u0005]\u0013\u0002BA+\u0003[\u0011Qa\u00117bgN\u0004B!!\u0017\u0002\\1\u0001A\u0001DA/\u0003\u0017\n\t\u0011!A\u0003\u0002\u0005}#aA0%cE!\u0011\u0011MA4!\ri\u00121M\u0005\u0004\u0003Kr\"a\u0002(pi\"Lgn\u001a\t\u0005\u0003S\n\u0019H\u0004\u0003\u0002l\u0005=d\u0002BA\u0010\u0003[J\u0011aH\u0005\u0004\u0003cr\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003k\n9HA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011\u000f\u0010\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~\u0005Ab/\u001a:jMf$&/\u00198tY\u0006$\u0018n\u001c8Tk\u000e\u001cWm]:\u0015\u0007a\ny\bC\u0004\u0006\u0003s\u0002\r!!\u0007\t\u0013\u0005\r\u0005!%A\u0005\n\u0005\u0015\u0015aH3ya\u0016\u001cG/\u0012=dKB$\u0018n\u001c8UQJ|wO\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0011\u0019\u0005\u0003\u0013\u000bi\t\u0005\u0004\u0002\u001c\u0005M\u00131\u0012\t\u0005\u00033\ni\t\u0002\u0007\u0002^\u0005\u0005\u0015\u0011!A\u0001\u0006\u0003\ty\u0006K\u0004\u0001\u0003#\u000bi*a(\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&?\u0003\u0019\u0011XO\u001c8fe&!\u00111TAK\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!!)\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KS1!a*?\u0003\u001d\u0011XO\u001c8feNLA!a+\u0002&\ni\u0001+\u0019:b[\u0016$XM]5{K\u0012<q!a,\u0003\u0011\u0003\t\t,\u0001\bM_>\\W\u000f\u001d&pS:$Vm\u001d;\u0011\u0007-\n\u0019L\u0002\u0004\u0002\u0005!\u0005\u0011QW\n\u0006\u0003g\u000b9\f\b\t\u0004;\u0005e\u0016bAA^=\t1\u0011I\\=SK\u001aDq\u0001KAZ\t\u0003\ty\f\u0006\u0002\u00022\"A\u00111YAZ\t\u0003\t)-\u0001\u0006qCJ\fW.\u001a;feN$\"!a2\u0011\r\u0005%\u0017\u0011[Ak\u001b\t\tYMC\u0002/\u0003\u001bT!!a4\u0002\t)\fg/Y\u0005\u0005\u0003'\fYM\u0001\u0006D_2dWm\u0019;j_:\u0004R!HAl\u00037L1!!7\u001f\u0005\u0015\t%O]1z!\u0011\ti.a9\u000e\u0005\u0005}'\u0002BAq\u0003\u001b\fA\u0001\\1oO&!\u0011Q]Ap\u0005\u0019y%M[3di\"B\u0011\u0011YAu\u0003o\fI\u0010\u0005\u0003\u0002l\u0006Eh\u0002BAR\u0003[LA!a<\u0002&\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!a=\u0002v\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005=\u0018QU\u0001\u0005]\u0006lW-\t\u0002\u0002|\u0006)B*Z4bGf$\u0016M\u00197f'>,(oY3>wBj\bBCA\u0000\u0003g\u000b\t\u0011\"\u0003\u0003\u0002\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u000e")
public class LookupJoinTest
extends TableTestBase
implements scala.Serializable {
    private final boolean legacyTableSource;
    private final StreamTableTestUtil util;

    @Parameterized.Parameters(name="LegacyTableSource={0}")
    public static Collection<Object[]> parameters() {
        return LookupJoinTest$.MODULE$.parameters();
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("nonTemporal", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        if (this.legacyTableSource) {
            TestTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), "LookupTable", TestTemporalTable$.MODULE$.createTemporaryTable$default$3());
        } else {
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE LookupTable (\n          |  `id` INT,\n          |  `name` STRING,\n          |  `age` INT\n          |) WITH (\n          |  'connector' = 'values'\n          |)\n          |")).stripMargin());
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE LookupTableWithComputedColumn (\n          |  `id` INT,\n          |  `name` STRING,\n          |  `age` INT,\n          |  `nominal_age` as age + 1\n          |) WITH (\n          |  'connector' = 'values',\n          |  'bounded' = 'true'\n          |)\n          |")).stripMargin());
        }
    }

    @Test
    public void testJoinInvalidJoinTemporalTable() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T JOIN LookupTable T.proctime AS D ON T.a = D.id", "SQL parse failed", SqlParserException.class);
        this.expectExceptionThrown("SELECT * FROM LookupTable FOR SYSTEM_TIME AS OF TIMESTAMP '2017-08-09 14:36:11'", "Temporal table can only be used in temporal join and only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.\nQuerying a temporal table using 'FOR SYSTEM TIME AS OF' syntax with a constant timestamp '2017-08-09 14:36:11' is not supported yet", AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T RIGHT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id", "Correlate has invalid join type RIGHT", AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a + 1 = D.id + 2", "Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable].", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF PROCTIME() AS D ON T.a = D.id", "Temporal table can only be used in temporal join and only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.\nQuerying a temporal table using 'FOR SYSTEM TIME AS OF' syntax with an expression call 'PROCTIME()' is not supported yet.", AssertionError.class);
    }

    @Test
    public void testNotDistinctFromInJoinCondition() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a IS NOT  DISTINCT FROM D.id", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id OR (T.a IS NULL AND D.id IS NULL)", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
    }

    @Test
    public void testInvalidLookupTableFunction() {
        if (this.legacyTableSource) {
            return;
        }
        this.util().addDataStream("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.createLookupTable("LookupTable1", (UserDefinedFunction)new InvalidTableFunctionResultType());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable1 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "output class can simply be a Row or RowData class", ValidationException.class);
        this.createLookupTable("LookupTable2", (UserDefinedFunction)new InvalidTableFunctionEvalSignature());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable2 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature' for function 'default_catalog.default_database.LookupTable2' that matches the following signature:\nvoid eval(java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable3", (UserDefinedFunction)new TableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable3 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable4", (UserDefinedFunction)new TableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable4 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable5", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable5 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable6", (UserDefinedFunction)new AsyncTableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable6 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable7", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature1());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable7 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1' for function 'default_catalog.default_database.LookupTable7' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable8", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature2());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable8 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2' for function 'default_catalog.default_database.LookupTable8' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, java.lang.String, java.time.LocalDateTime)", ValidationException.class);
        this.createLookupTable("LookupTable9", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable9 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable10", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature3());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable10 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3' for function 'default_catalog.default_database.LookupTable10' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
    }

    @Test
    public void testJoinOnDifferentKeyTypes() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("implicit type conversion between VARCHAR(2147483647) and INTEGER is not supported on join's condition now");
        this.util().verifyExecPlan("SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.b = D.id");
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithNestedQuery() {
        String sql = "SELECT * FROM (SELECT a, b, proctime FROM MyTable WHERE c > 1000) AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T.*, D.id\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFilterPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithCalcPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE cast(D.name as bigint) > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiIndexColumn() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10 AND D.name = 'AAA'\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidAggregatePushDown() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proc\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         |SELECT T.* FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proc AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (").append(sql2).append(") AS T\n         |GROUP BY b\n      ").toString())).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithTrueCondition() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable]");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON true\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @Test
    public void testJoinTemporalTableWithFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id + 1 AND T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFunctionAndReferenceCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND T.b = concat(D.name, '!')\n        |WHERE D.name LIKE 'Jack%'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithUdfEqualFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name\n        |FROM\n        |  MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |WHERE CONCAT('Hello-', D.name) = 'Hello-Jark'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id and D.nominal_age > 12\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiConditionOnSameDimField() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id and CAST(T.c as INT) = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithCastOnLookupTable() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE LookupTable2 (\n        |  `id` decimal(38, 18),\n        |  `name` STRING,\n        |  `age` INT\n        |) WITH (\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MyTable.b, LookupTable2.id\n        |FROM MyTable\n        |LEFT JOIN LookupTable2 FOR SYSTEM_TIME AS OF MyTable.`proctime`\n        |ON MyTable.a = CAST(LookupTable2.`id` as INT)\n        |")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable2]");
        this.verifyTranslationSuccess(sql);
    }

    @Test
    public void testJoinTemporalTableWithInteroperableCastOnLookupTable() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE LookupTable2 (\n        |  `id` INT,\n        |  `name` char(10),\n        |  `age` INT\n        |) WITH (\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MyTable.b, LookupTable2.id\n        |FROM MyTable\n        |LEFT JOIN LookupTable2 FOR SYSTEM_TIME AS OF MyTable.`proctime`\n        |ON MyTable.b = CAST(LookupTable2.`name` as String)\n        |")).stripMargin();
        this.verifyTranslationSuccess(sql);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLookupTable(String tableName, UserDefinedFunction lookupFunction) {
        if (this.legacyTableSource) {
            UserDefinedFunction userDefinedFunction = lookupFunction;
            if (userDefinedFunction instanceof TableFunction) {
                TableFunction tableFunction = (TableFunction)userDefinedFunction;
                TestInvalidTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), tableName, tableFunction);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!(userDefinedFunction instanceof AsyncTableFunction)) throw new MatchError((Object)userDefinedFunction);
                AsyncTableFunction asyncTableFunction = (AsyncTableFunction)userDefinedFunction;
                TestInvalidTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), tableName, asyncTableFunction);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(267).append("\n           |CREATE TABLE ").append(tableName).append(" (\n           |  `id` INT,\n           |  `name` STRING,\n           |  `age` INT,\n           |  `ts` TIMESTAMP(3)\n           |) WITH (\n           |  'connector' = 'values',\n           |  'lookup-function-class' = '").append(lookupFunction.getClass().getName()).append("'\n           |)\n           |").toString())).stripMargin());
        }
    }

    private void expectExceptionThrown(String sql, String message, Class<? extends Throwable> clazz) {
        try {
            this.verifyTranslationSuccess(sql);
            Assert.fail((String)new StringBuilder(40).append("Expected a ").append(clazz).append(", but no exception is thrown.").toString());
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)clazz.isAssignableFrom(e.getClass()));
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsMessage((String)message));
        }
    }

    private Class<? extends Throwable> expectExceptionThrown$default$3() {
        return ValidationException.class;
    }

    private void verifyTranslationSuccess(String sql) {
        this.util().tableEnv().sqlQuery(sql).explain(new ExplainDetail[0]);
    }

    public LookupJoinTest(boolean legacyTableSource) {
        this.legacyTableSource = legacyTableSource;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
    }
}

