/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.table.planner.plan.utils.ReflectionsUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReflectionsUtilTest {
    @Parameterized.Parameter
    public boolean includingInterface;
    @Parameterized.Parameter(value=1)
    public boolean includingAbstractClass;

    @Test
    public void testScanSubClasses() {
        Set actual = ReflectionsUtil.scanSubClasses((String)ReflectionsUtilTest.class.getPackage().getName(), TestInterface.class, (boolean)this.includingInterface, (boolean)this.includingAbstractClass);
        HashSet<Class<TestAbstractClass>> expected = new HashSet<Class<TestAbstractClass>>();
        expected.add(TestClass1.class);
        expected.add(TestClass2.class);
        expected.add(TestClass3.class);
        if (this.includingInterface) {
            expected.add(TestSubInterface.class);
        }
        if (this.includingAbstractClass) {
            expected.add(TestAbstractClass.class);
        }
        Assert.assertEquals(expected, (Object)actual);
    }

    @Parameterized.Parameters(name="includingInterface={0}, includingAbstractClass={1}")
    public static Object[][] testData() {
        return new Object[][]{{false, false}, {true, false}, {false, true}, {true, true}};
    }

    public static class TestClass3
    extends TestAbstractClass {
    }

    public static class TestClass2
    implements TestSubInterface {
    }

    public static class TestClass1
    implements TestInterface {
    }

    public static abstract class TestAbstractClass
    implements TestSubInterface {
    }

    public static interface TestSubInterface
    extends TestInterface {
    }

    public static interface TestInterface {
    }
}

