/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.Serializable;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.MultipleInputITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u0001M\u00111#T;mi&\u0004H.Z%oaV$\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011!Y\u0002A!A!\u0002\u0013a\u0012aC:ik\u001a4G.Z'pI\u0016\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\r\r|W.\\8o\u0015\t\tC\"A\u0002ba&L!a\t\u0010\u0003!\t\u000bGo\u00195TQV4g\r\\3N_\u0012,\u0007\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\b\u0006\u0002(SA\u0011\u0001\u0006A\u0007\u0002\u0005!)1\u0004\na\u00019!)1\u0006\u0001C!Y\u00051!-\u001a4pe\u0016$\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0005+:LG\u000f\u000b\u0002+iA\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003sY\u0012aAQ3g_J,\u0007\"B\u001e\u0001\t\u0003a\u0013A\u0006;fgR\u0014\u0015m]5d\u001bVdG/\u001b9mK&s\u0007/\u001e;)\u0005ij\u0004CA\u001b?\u0013\tydG\u0001\u0003UKN$\b\"B!\u0001\t\u0003a\u0013A\u0006;fgRl\u0015M\\=Nk2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f^:)\u0005\u0001k\u0004\"\u0002#\u0001\t\u0003a\u0013A\u0006;fgRTu.\u001b8XSRD\u0017iZ4BgB\u0013xNY3)\u0005\rk\u0004\"B$\u0001\t\u0003a\u0013\u0001\u0007;fgRtu\u000e\u0015:j_JLG/_\"p]N$(/Y5oi\"\u0012a)\u0010\u0005\u0006\u0015\u0002!\t\u0001L\u0001\u0012i\u0016\u001cHOU3mCR,G-\u00138qkR\u001c\bFA%>\u0011\u0015i\u0005\u0001\"\u0001-\u0003a!Xm\u001d;SK2\fG/\u001a3J]B,Ho],ji\"\fum\u001a\u0015\u0003\u0019vBQ\u0001\u0015\u0001\u0005\u00021\na\u0005^3ti\u0012+\u0017\r\u001a7pG.\u001c\u0015-^:fI\nKX\t_2iC:<W-\u00138B]\u000e,7\u000f^8sQ\tyU\bC\u0003T\u0001\u0011\u0005A&\u0001\fuKN$X*\u0019=TkB\u0004xN\u001d;fI&s\u0007/\u001e;tQ\t\u0011V\bC\u0003W\u0001\u0011\u0005q+\u0001\rdQ\u0016\u001c7.T;mi&\u0004H.Z%oaV$(+Z:vYR$\"!\f-\t\u000b\r)\u0006\u0019A-\u0011\u0005i\u000bgBA.`!\tav&D\u0001^\u0015\tq&#\u0001\u0004=e>|GOP\u0005\u0003A>\na\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001m\f\u0015\u0005\u0001\u0015\\G\u000e\u0005\u0002gS6\tqM\u0003\u0002im\u00051!/\u001e8oKJL!A[4\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\nQ\u000e\u0005\u0002oc6\tqN\u0003\u0002qm\u00059!/\u001e8oKJ\u001c\u0018B\u0001:p\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e)AO\u0001E\u0001k\u0006\u0019R*\u001e7uSBdW-\u00138qkRLEkQ1tKB\u0011\u0001F\u001e\u0004\u0006\u0003\tA\ta^\n\u0003mb\u0004\"AL=\n\u0005i|#AB!osJ+g\rC\u0003&m\u0012\u0005A\u0010F\u0001v\u0011\u0015qh\u000f\"\u0001\u0000\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0003\u0003\u0003\u0001BALA\u00029%\u0019\u0011QA\u0018\u0003\u000b\u0005\u0013(/Y=)\u000fu\fI!a\t\u0002&A!\u00111BA\u000f\u001d\u0011\ti!!\u0007\u000f\t\u0005=\u0011q\u0003\b\u0005\u0003#\t)BD\u0002]\u0003'I\u0011!E\u0005\u0003oAI!\u0001\u001d\u001c\n\u0007\u0005mq.A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0003?\t\tC\u0001\u0006QCJ\fW.\u001a;feNT1!a\u0007p\u0003\u0011q\u0017-\\3\"\u0005\u0005\u001d\u0012\u0001E:ik\u001a4G.Z'pI\u0016T\u0004e\u001f\u0019~\u0011\u001d\tYC\u001eC\u0001\u0003[\t!cZ3oKJ\fG/\u001a*b]\u0012|W\u000eR1uCR\u0011\u0011q\u0006\t\u0007\u0003c\tY$!\u0011\u000f\t\u0005M\u0012q\u0007\b\u00049\u0006U\u0012\"\u0001\u0019\n\u0007\u0005er&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0012q\b\u0002\u0004'\u0016\f(bAA\u001d_A!\u00111IA%\u001b\t\t)EC\u0002\u0002H1\tQ\u0001^=qKNLA!a\u0013\u0002F\t\u0019!k\\<\t\u0015\u0005=c\u000f#b\u0001\n\u0003\t\t&A\u0004s_^$\u0016\u0010]3\u0016\u0005\u0005M\u0003\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\nif\u0004X-\u001e;jYNT1!!\u0018!\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0014q\u000b\u0002\f%><H+\u001f9f\u0013:4w\u000e\u0003\u0006\u0002fYD)\u0019!C\u0001\u0003O\n\u0011B\\;mY\u0006\u0014G.Z:\u0016\u0005\u0005%\u0004#\u0002\u0018\u0002\u0004\u0005-\u0004c\u0001\u0018\u0002n%\u0019\u0011qN\u0018\u0003\u000f\t{w\u000e\\3b]\"Q\u00111\u000f<\t\u0006\u0004%\t!!\u001e\u0002\u000b\u0011\fG/\u0019-\u0016\u0005\u0005=\u0002BCA=m\"\u0015\r\u0011\"\u0001\u0002v\u0005)A-\u0019;b3\"Q\u0011Q\u0010<\t\u0006\u0004%\t!!\u001e\u0002\u000b\u0011\fG/\u0019.\t\u0015\u0005\u0005e\u000f#b\u0001\n\u0003\t)(A\u0003eCR\fG\u000b")
public class MultipleInputITCase
extends BatchTestBase {
    private final BatchShuffleMode shuffleMode;

    public static Seq<Row> dataT() {
        return MultipleInputITCase$.MODULE$.dataT();
    }

    public static Seq<Row> dataZ() {
        return MultipleInputITCase$.MODULE$.dataZ();
    }

    public static Seq<Row> dataY() {
        return MultipleInputITCase$.MODULE$.dataY();
    }

    public static Seq<Row> dataX() {
        return MultipleInputITCase$.MODULE$.dataX();
    }

    public static boolean[] nullables() {
        return MultipleInputITCase$.MODULE$.nullables();
    }

    public static RowTypeInfo rowType() {
        return MultipleInputITCase$.MODULE$.rowType();
    }

    public static Seq<Row> generateRandomData() {
        return MultipleInputITCase$.MODULE$.generateRandomData();
    }

    @Parameterized.Parameters(name="shuffleMode: {0}")
    public static BatchShuffleMode[] parameters() {
        return MultipleInputITCase$.MODULE$.parameters();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("x", MultipleInputITCase$.MODULE$.dataX(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nx", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("y", MultipleInputITCase$.MODULE$.dataY(), MultipleInputITCase$.MODULE$.rowType(), "d, e, f, ny", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("z", MultipleInputITCase$.MODULE$.dataZ(), MultipleInputITCase$.MODULE$.rowType(), "g, h, i, nz", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("t", MultipleInputITCase$.MODULE$.dataT(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nt", MultipleInputITCase$.MODULE$.nullables());
        this.tEnv().getConfig().getConfiguration().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)this.shuffleMode);
    }

    @Test
    public void testBasicMultipleInput() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @Test
    public void testManyMultipleInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin());
    }

    @Test
    public void testJoinWithAggAsProbe() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  LEFT JOIN\n        |  (SELECT d, SUM(a) AS sm FROM T GROUP BY d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @Test
    public void testNoPriorityConstraint() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testRelatedInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT x.a AS a, x.b AS b FROM x))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testRelatedInputsWithAgg() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT COUNT(x.a) AS a, x.b AS b FROM x GROUP BY x.b))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testDeadlockCausedByExchangeInAncestor() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin());
    }

    @Test
    public void testMaxSupportedInputs() {
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "test"}))}));
        boolean[] nullables = new boolean[]{true, true};
        this.registerCollection("left_table", data, rowType, "a, b", nullables);
        this.registerCollection("right_table", data, rowType, "c, d", nullables);
        int numJoins = 62;
        scala.collection.mutable.StringBuilder sql = new scala.collection.mutable.StringBuilder("SELECT t0.a, t0.b");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(10).append(", t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c, t").append(BoxesRunTime.unboxToInt((Object)i)).append(".d").toString()));
        sql.append(" from left_table as t0");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(53).append(" left join right_table as t").append(BoxesRunTime.unboxToInt((Object)i)).append(" on t0.a = t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c and t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c = 1").toString()));
        this.checkMultipleInputResult(sql.toString());
    }

    public void checkMultipleInputResult(String sql) {
        this.tEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, false);
        Seq<Row> expected = this.executeQuery(sql);
        this.tEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, true);
        this.checkResult(sql, expected, this.checkResult$default$3());
    }

    public MultipleInputITCase(BatchShuffleMode shuffleMode) {
        this.shuffleMode = shuffleMode;
    }
}

