/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.PartitionableSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.utils.TestUserClassLoaderJar;
import org.apache.flink.types.Row;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001M\u0011\u0011\u0004U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0015\u0011\u0017\r^2i\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u0011m\u0001!Q1A\u0005\u0002q\tQc]8ve\u000e,g)\u001a;dQB\u000b'\u000f^5uS>t7/F\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0017g>,(oY3GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8tA!Aa\u0005\u0001BC\u0002\u0013\u0005A$\u0001\tvg\u0016\u001c\u0015\r^1m_\u001e4\u0015\u000e\u001c;fe\"A\u0001\u0006\u0001B\u0001B\u0003%Q$A\tvg\u0016\u001c\u0015\r^1m_\u001e4\u0015\u000e\u001c;fe\u0002BQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017/_A\u0011Q\u0006A\u0007\u0002\u0005!)1$\u000ba\u0001;!)a%\u000ba\u0001;!)\u0011\u0007\u0001C!e\u00051!-\u001a4pe\u0016$\u0012a\r\t\u0003=QJ!!N\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u0003a]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\t\u0002\u000b),h.\u001b;\n\u0005qJ$A\u0002\"fM>\u0014X\rC\u0003?\u0001\u0011\u0005!'\u0001\u0012uKN$8+[7qY\u0016\u0004\u0016M\u001d;ji&|gNR5fY\u0012\u0004&/\u001a3jG\u0006$X-\r\u0015\u0003{\u0001\u0003\"\u0001O!\n\u0005\tK$\u0001\u0002+fgRDQ\u0001\u0012\u0001\u0005\u0002I\n!\u0006^3tiB\u000b'\u000f^5bYB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,\u0007+^:i\t><h\u000e\u000b\u0002D\u0001\")q\t\u0001C\u0001e\u0005IB/Z:u+:\u001cwN\u001c<feR,G-\u0012=qe\u0016\u001c8/[8oQ\t1\u0005\tC\u0003K\u0001\u0011\u0005!'A\u0013uKN$\b+\u0019:uSRLwN\u001c)sk:,'oQ8na&dWm\u00117bgNdu.\u00193fe\"\u0012\u0011\n\u0011\u0015\u0005\u00015\u001bF\u000b\u0005\u0002O#6\tqJ\u0003\u0002Qs\u00051!/\u001e8oKJL!AU(\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\nQ\u000b\u0005\u0002W36\tqK\u0003\u0002Ys\u00059!/\u001e8oKJ\u001c\u0018B\u0001.X\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e)AL\u0001E\u0001;\u0006I\u0002+\u0019:uSRLwN\\1cY\u0016\u001cv.\u001e:dK&#6)Y:f!\ticLB\u0003\u0002\u0005!\u0005ql\u0005\u0002_AB\u0011a$Y\u0005\u0003E~\u0011a!\u00118z%\u00164\u0007\"\u0002\u0016_\t\u0003!G#A/\t\u000b\u0019tF\u0011A4\u0002\u0015A\f'/Y7fi\u0016\u00148\u000fF\u0001i!\rIg\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\u0005kRLGNC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=T'AC\"pY2,7\r^5p]B\u0019a$]:\n\u0005I|\"!B!se\u0006L\bC\u0001\u0010u\u0013\t)xDA\u0002B]fDC!Z<\u007f\u007fB\u0011\u0001p\u001f\b\u0003-fL!A_,\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\taXP\u0001\u0006QCJ\fW.\u001a;feNT!A_,\u0002\t9\fW.Z\u0011\u0003\u0003\u0003\tqf]8ve\u000e,g)\u001a;dQB\u000b'\u000f^5uS>t7/P>1{2\u0002So]3DCR\fGn\\4GS2$XM]\u001f|cu\u0004")
public class PartitionableSourceITCase
extends BatchTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;

    @Parameterized.Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceITCase$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.env().setParallelism(1);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Vivi", "C", BoxesRunTime.boxToInteger((int)1)}))}));
        String myTableDataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddlTemp = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(376).append("\n        |CREATE TABLE MyTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'data-id' = '").append(myTableDataId).append("',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s'\n        |)\n        |").toString())).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.tEnv().executeSql(String.format(ddlTemp, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.tEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.tEnv().useCatalog("test_catalog");
            this.tEnv().executeSql(String.format(ddlTemp, ""));
            ObjectPath mytablePath = ObjectPath.fromString((String)"test_database.MyTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionableSourceITCase.$anonfun$before$1(catalog, mytablePath, partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSimplePartitionFieldPredicate1() {
        this.checkResult("SELECT * FROM MyTable WHERE part1 = 'A'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPartialPartitionFieldPredicatePushDown() {
        this.checkResult("SELECT * FROM MyTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUnconvertedExpression() {
        this.checkResult("select * from MyTable where trim(part1) = 'A' and part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPartitionPrunerCompileClassLoader() {
        String udfJavaCode = new StringOps(Predef$.MODULE$.augmentString("\n         |public class TrimUDF extends org.apache.flink.table.functions.ScalarFunction {\n         |   public String eval(String str) {\n         |     return str.trim();\n         |   }\n         |}\n         |")).stripMargin();
        File tmpDir = BatchAbstractTestBase.TEMPORARY_FOLDER.newFolder();
        File udfJarFile = TestUserClassLoaderJar.createJarFile(tmpDir, "flink-test-udf.jar", "TrimUDF", udfJavaCode);
        List<URL> jars = Collections.singletonList(udfJarFile.toURI().toURL());
        URLClassLoader cl = ClientUtils.buildUserCodeClassLoader(jars, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader(), (Configuration)new Configuration());
        try (TemporaryClassLoaderContext ctx = TemporaryClassLoaderContext.of((ClassLoader)cl);){
            this.tEnv().executeSql("create temporary function trimUDF as 'TrimUDF'");
            this.checkResult("select * from MyTable where trimUDF(part1) = 'A' and part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$before$1(TestValuesCatalog catalog$1, ObjectPath mytablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(mytablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceITCase(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
    }
}

