/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.File;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestLegacyFilterableTableSource$;
import org.apache.flink.types.Row;
import org.apache.flink.util.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001'\t\tB+\u00192mKN{WO]2f\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!)\u0001\u0005\u0001C!C\u00051!-\u001a4pe\u0016$\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000f\u000b\u0002 SA\u0011!&L\u0007\u0002W)\u0011A\u0006E\u0001\u0006UVt\u0017\u000e^\u0005\u0003]-\u0012aAQ3g_J,\u0007\"\u0002\u0019\u0001\t\u0003\t\u0013!\u0005;fgR\u001c\u0016.\u001c9mKB\u0013xN[3di\"\u0012qF\r\t\u0003UMJ!\u0001N\u0016\u0003\tQ+7\u000f\u001e\u0005\u0006m\u0001!\t!I\u0001\u001ei\u0016\u001cHoU5na2,\u0007K]8kK\u000e$x+\u001b;i!J|7\rV5nK\"\u0012QG\r\u0005\u0006s\u0001!\t!I\u0001\u001bi\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQ>,H/\u00138qkR\u0014VM\u001a\u0015\u0003qIBQ\u0001\u0010\u0001\u0005\u0002\u0005\n\u0011\u0003^3ti:+7\u000f^3e!J|'.Z2uQ\tY$\u0007C\u0003@\u0001\u0011\u0005\u0011%A\ruKN$h*Z:uK\u0012\u0004&o\u001c6fGR<\u0016\u000e\u001e5Ji\u0016l\u0007F\u0001 3\u0011\u0015\u0011\u0005\u0001\"\u0001\"\u0003u!Xm\u001d;UC\ndWmU8ve\u000e,w+\u001b;i\r&dG/\u001a:bE2,\u0007FA!3\u0011\u0015)\u0005\u0001\"\u0001\"\u0003\u0015\"Xm\u001d;UC\ndWmU8ve\u000e,w+\u001b;i\rVt7\r^5p]\u001aKG\u000e^3sC\ndW\r\u000b\u0002Ee!)\u0001\n\u0001C\u0001C\u0005)B/Z:u\u0013:\u0004X\u000f\u001e$pe6\fGoU8ve\u000e,\u0007FA$3\u0011\u0015Y\u0005\u0001\"\u0001\"\u0003Q!Xm\u001d;ECR\f7\u000b\u001e:fC6\u001cv.\u001e:dK\"\u0012!J\r\u0005\u0006\u001d\u0002!\t!I\u0001\u0011i\u0016\u001cH/\u00117m\t\u0006$\u0018\rV=qKND#!\u0014\u001a\t\u000bE\u0003A\u0011A\u0011\u0002%Q,7\u000f^*pkJ\u001cW\r\u0015:pm&$WM\u001d\u0015\u0003!JBQ\u0001\u0016\u0001\u0005\u0002\u0005\nQ\u0002^3tiR\u000b'\r\\3IS:$\bFA*3\u0011\u00159\u0006\u0001\"\u0001\"\u0003\u0019\"Xm\u001d;UC\ndW\rS5oi^KG\u000f\u001b'pO&\u001c\u0017\r\u001c+bE2,7kY1o%\u0016,8/\u001a\u0015\u0003-J\u0002")
public class TableSourceITCase
extends BatchTestBase {
    @Override
    @Before
    public void before() {
        super.before();
        this.env().setParallelism(1);
        String myTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(228).append("\n        |CREATE TABLE MyTable (\n        |  `a` INT,\n        |  `b` BIGINT,\n        |  `c` STRING\n        |) WITH (\n        |  'connector' = 'values',\n        |  'data-id' = '").append(myTableDataId).append("',\n        |  'bounded' = 'true'\n        |)\n        |").toString())).stripMargin());
        String filterableTableDataId = TestValuesTableFactory.registerData(TestLegacyFilterableTableSource$.MODULE$.defaultRows());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(319).append("\n         |CREATE TABLE FilterableTable (\n         |  name STRING,\n         |  id BIGINT,\n         |  amount INT,\n         |  price DOUBLE\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(filterableTableDataId).append("',\n         |  'filterable-fields' = 'amount',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin());
        String nestedTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.deepNestedRow());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(588).append("\n         |CREATE TABLE NestedTable (\n         |  id BIGINT,\n         |  deepNested ROW<\n         |     nested1 ROW<name STRING, `value.` INT>,\n         |     `nested2.` ROW<num INT, flag BOOLEAN>>,\n         |  nested ROW<name STRING, `value` INT>,\n         |  name STRING,\n         |  nestedItem ROW<deepArray ROW<`value` INT> ARRAY, deepMap MAP<STRING, INT>>,\n         |  lower_name AS LOWER(name)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'true',\n         |  'data-id' = '").append(nestedTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin());
    }

    @Test
    public void testSimpleProject() {
        this.checkResult("SELECT a, c FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSimpleProjectWithProcTime() {
        this.checkResult("SELECT a, c, CHAR_LENGTH(DATE_FORMAT(PROCTIME(), 'yyyy-MM-dd HH:mm')) FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi", BoxesRunTime.boxToInteger((int)16)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello", BoxesRunTime.boxToInteger((int)16)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world", BoxesRunTime.boxToInteger((int)16)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testProjectWithoutInputRef() {
        this.checkResult("SELECT COUNT(*) FROM MyTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testNestedProject() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.`nested2.`.flag AS nestedFlag,\n        |    deepNested.`nested2.`.num + deepNested.nested1.`value.` AS nestedNum,\n        |    lower_name\n        |FROM NestedTable\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Sarah", BoxesRunTime.boxToInteger((int)10000), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)1100), "mary"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Rob", BoxesRunTime.boxToInteger((int)20000), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)2200), "bob"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Mike", BoxesRunTime.boxToInteger((int)30000), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)3300), "liz"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testNestedProjectWithItem() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT nestedItem.deepArray[nestedItem.deepMap['Monday']] FROM  NestedTable\n        |")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithFilterable() {
        this.checkResult("SELECT id, amount, name FROM FilterableTable WHERE amount > 4 AND price < 9", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5), "Record_5"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), "Record_6"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)7), "Record_7"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)8), "Record_8"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableSourceWithFunctionFilterable() {
        this.checkResult("SELECT id, amount, name FROM FilterableTable WHERE amount > 4 AND price < 9 AND upper(name) = 'RECORD_5'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5), "Record_5"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testInputFormatSource() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(295).append("\n         |CREATE TABLE MyInputFormatTable (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true',\n         |  'runtime-source' = 'InputFormat'\n         |)\n         |").toString())).stripMargin());
        this.checkResult("SELECT a, c FROM MyInputFormatTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testDataStreamSource() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(293).append("\n         |CREATE TABLE MyDataStreamTable (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true',\n         |  'runtime-source' = 'DataStream'\n         |)\n         |").toString())).stripMargin());
        this.checkResult("SELECT a, c FROM MyDataStreamTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testAllDataTypes() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.fullDataTypesData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(662).append("\n         |CREATE TABLE T (\n         |  `a` BOOLEAN,\n         |  `b` TINYINT,\n         |  `c` SMALLINT,\n         |  `d` INT,\n         |  `e` BIGINT,\n         |  `f` FLOAT,\n         |  `g` DOUBLE,\n         |  `h` DECIMAL(5, 2),\n         |  `i` VARCHAR(5),\n         |  `j` CHAR(5),\n         |  `k` DATE,\n         |  `l` TIME(0),\n         |  `m` TIMESTAMP(9),\n         |  `n` TIMESTAMP(9) WITH LOCAL TIME ZONE,\n         |  `o` ARRAY<BIGINT>,\n         |  `p` ROW<f1 BIGINT, f2 STRING, f3 DOUBLE>,\n         |  `q` MAP<STRING, INT>\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin());
        this.checkResult("SELECT * FROM T", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)127), BoxesRunTime.boxToInteger((int)Short.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), "-1.123", "-1.123", "5.10", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "1969-01-01", "00:00:00.123", "1969-01-01T00:00:00.123456789", "1969-01-01T00:00:00.123456789Z", "[1, 2, 3]", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "2.3"})), "{k1=1}"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)-128), BoxesRunTime.boxToInteger((int)Short.MIN_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), "3.4", "3.4", "6.10", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)12), "1970-09-30", "01:01:01.123", "1970-09-30T01:01:01.123456", "1970-09-30T01:01:01.123456Z", "[4, 5]", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "b", "4.56"})), "{k2=2, k4=4}"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), "0.12", "0.12", "7.10", BoxesRunTime.boxToInteger((int)123), BoxesRunTime.boxToInteger((int)123), "1990-12-24", "08:10:24.123", "1990-12-24T08:10:24.123", "1990-12-24T08:10:24.123Z", "[6, null, 7]", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "7.86"})), "{k3=null}"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)123), BoxesRunTime.boxToInteger((int)1234), "1.2345", "1.2345", "8.12", BoxesRunTime.boxToInteger((int)1234), BoxesRunTime.boxToInteger((int)1234), "2020-05-01", "23:23:23", "2020-05-01T23:23:23", "2020-05-01T23:23:23Z", "[8]", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "c", null})), "{null=3}"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSourceProvider() {
        File file = BatchAbstractTestBase.TEMPORARY_FOLDER.newFile();
        file.delete();
        file.createNewFile();
        FileUtils.writeFileUtf8((File)file, (String)"1\n5\n6");
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(171).append("\n         |CREATE TABLE MyFileSourceTable (\n         |  `a` STRING\n         |) WITH (\n         |  'connector' = 'test-file',\n         |  'path' = '").append(file.toURI()).append("'\n         |)\n         |").toString())).stripMargin());
        this.checkResult("SELECT a FROM MyFileSourceTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"5"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"6"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testTableHint() {
        String resultPath = BatchAbstractTestBase.TEMPORARY_FOLDER.newFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(237).append("\n         |CREATE TABLE MySink (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'filesystem',\n         |  'format' = 'testcsv',\n         |  'path' = '").append(resultPath).append("'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable\n        |  /*+ OPTIONS('source.num-element-to-skip'='1') */\n        |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable\n        |  /*+ OPTIONS('source.num-element-to-skip'='2') */\n        |")).stripMargin());
        stmtSet.execute().await();
        Seq<String> result = TableTestUtil$.MODULE$.readFromFile(resultPath);
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,2,Hello", "3,2,Hello world", "3,2,Hello world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)result.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testTableHintWithLogicalTableScanReuse() {
        this.tEnv().getConfig().getConfiguration().setBoolean(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED(), true);
        String resultPath = BatchAbstractTestBase.TEMPORARY_FOLDER.newFolder().getAbsolutePath();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(237).append("\n         |CREATE TABLE MySink (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'filesystem',\n         |  'format' = 'testcsv',\n         |  'path' = '").append(resultPath).append("'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink\n        |select a,b,c from MyTable /*+ OPTIONS('source.num-element-to-skip'='0') */\n        |union all\n        |select a,b,c from MyTable /*+ OPTIONS('source.num-element-to-skip'='1') */\n        |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable\n        |  /*+ OPTIONS('source.num-element-to-skip'='2') */\n        |")).stripMargin());
        stmtSet.execute().await();
        Seq<String> result = TableTestUtil$.MODULE$.readFromFile(resultPath);
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "2,2,Hello", "2,2,Hello", "3,2,Hello world", "3,2,Hello world", "3,2,Hello world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)result.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

