/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.join.InnerJoinITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001U\u0011q\"\u00138oKJTu.\u001b8J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0011\u0017\r^2i\u0015\tI!\"A\u0004sk:$\u0018.\\3\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u001b9\tQ\u0001^1cY\u0016T!a\u0004\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u0005)Q\u000f^5mg&\u00111\u0004\u0007\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0001#\u001a=qK\u000e$X\r\u001a&pS:$\u0016\u0010]3\u0011\u0005}9dB\u0001\u00116\u001d\t\tCG\u0004\u0002#g9\u00111E\r\b\u0003IEr!!\n\u0019\u000f\u0005\u0019zcBA\u0014/\u001d\tASF\u0004\u0002*Y5\t!F\u0003\u0002,)\u00051AH]8pizJ\u0011aE\u0005\u0003#II!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!A\u000e\u0002\u0002\u0011){\u0017N\u001c+za\u0016L!\u0001O\u001d\u0003\u0011){\u0017N\u001c+za\u0016T!A\u000e\u0002\t\u000bm\u0002A\u0011\u0001\u001f\u0002\rqJg.\u001b;?)\tit\b\u0005\u0002?\u00015\t!\u0001C\u0003\u001eu\u0001\u0007a\u0004\u0003\u0005B\u0001!\u0015\r\u0011\"\u0003C\u0003=i\u00170\u00169qKJ\u001c\u0015m]3ECR\fW#A\"\u0011\u0007\u0011K5*D\u0001F\u0015\t1u)\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u0016\u00131aU3r!\tau*D\u0001N\u0015\tqe\"A\u0003usB,7/\u0003\u0002Q\u001b\n\u0019!k\\<\t\u0011I\u0003\u0001R1A\u0005\n\t\u000bq\"\\=M_^,'oQ1tK\u0012\u000bG/\u0019\u0005\t)\u0002A)\u0019!C\u0005\u0005\u0006YQ.\u001f+fgR$\u0015\r^12\u0011!1\u0006\u0001#b\u0001\n\u0013\u0011\u0015aC7z)\u0016\u001cH\u000fR1uCJBQ\u0001\u0017\u0001\u0005Be\u000baAY3g_J,G#\u0001.\u0011\u0005mcV\"A$\n\u0005u;%\u0001B+oSRD#aV0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t\u0014\u0012!\u00026v]&$\u0018B\u00013b\u0005\u0019\u0011UMZ8sK\")a\r\u0001C\u00013\u0006\u0011B/Z:u\u001f:,W*\u0019;dQB+'OU8xQ\t)\u0007\u000e\u0005\u0002aS&\u0011!.\u0019\u0002\u0005)\u0016\u001cH\u000fC\u0003m\u0001\u0011\u0005\u0011,A\nuKN$X*\u001e7uSBdW-T1uG\",7\u000f\u000b\u0002lQ\")q\u000e\u0001C\u00013\u0006iA/Z:u\u001d>l\u0015\r^2iKND#A\u001c5\t\u000bI\u0004A\u0011A-\u0002!Q,7\u000f\u001e#fG&l\u0017\r\\!t\u0017\u0016L\bFA9i\u0011\u0015)\b\u0001\"\u0001Z\u0003=!Xm\u001d;CS\u001e4uN]*qS2d\u0007F\u0001;i\u0011\u0015A\b\u0001\"\u0001Z\u0003q!Xm\u001d;T_J$X*\u001a:hK*{\u0017N\\(viB,Ho\u0014:eKJD#a\u001e5)\r\u0001Y\u00181AA\u0003!\tax0D\u0001~\u0015\tq\u0018-\u0001\u0004sk:tWM]\u0005\u0004\u0003\u0003i(a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b\t\u0017a\u0002:v]:,'o]\u0005\u0005\u0003#\tYAA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\b\u0003+\u0011\u0001\u0012AA\f\u0003=IeN\\3s\u0015>Lg.\u0013+DCN,\u0007c\u0001 \u0002\u001a\u00191\u0011A\u0001E\u0001\u00037\u0019B!!\u0007\u0002\u001eA\u00191,a\b\n\u0007\u0005\u0005rI\u0001\u0004B]f\u0014VM\u001a\u0005\bw\u0005eA\u0011AA\u0013)\t\t9\u0002\u0003\u0005\u0002*\u0005eA\u0011AA\u0016\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003[\u0001b!a\f\u0002:\u0005uRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003o\tAA[1wC&!\u00111HA\u0019\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\u0019\u0005\u0003\u007f\tI\u0005E\u0003\\\u0003\u0003\n)%C\u0002\u0002D\u001d\u0013Q!\u0011:sCf\u0004B!a\u0012\u0002J1\u0001A\u0001DA&\u0003O\t\t\u0011!A\u0003\u0002\u00055#aA0%cE!\u0011qJA+!\rY\u0016\u0011K\u0005\u0004\u0003':%a\u0002(pi\"Lgn\u001a\t\u00047\u0006]\u0013bAA-\u000f\n\u0019\u0011I\\=)\u0011\u0005\u001d\u0012QLA6\u0003[\u0002B!a\u0018\u0002f9!\u0011\u0011BA1\u0013\u0011\t\u0019'a\u0003\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\t9'!\u001b\u0003\u0015A\u000b'/Y7fi\u0016\u00148O\u0003\u0003\u0002d\u0005-\u0011\u0001\u00028b[\u0016\f#!a\u001c\u0002\u0007m\u0004T\u0010")
public class InnerJoinITCase
extends BatchTestBase {
    private Seq<Row> myUpperCaseData;
    private Seq<Row> myLowerCaseData;
    private Seq<Row> myTestData1;
    private Seq<Row> myTestData2;
    private final Enumeration.Value expectedJoinType;
    private volatile byte bitmap$0;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return InnerJoinITCase$.MODULE$.parameters();
    }

    private Seq<Row> myUpperCaseData$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.myUpperCaseData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "A"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "B"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "C"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "D"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "E"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "F"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "G"}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.myUpperCaseData;
    }

    private Seq<Row> myUpperCaseData() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.myUpperCaseData$lzycompute() : this.myUpperCaseData;
    }

    private Seq<Row> myLowerCaseData$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.myLowerCaseData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "d"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "e"}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.myLowerCaseData;
    }

    private Seq<Row> myLowerCaseData() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.myLowerCaseData$lzycompute() : this.myLowerCaseData;
    }

    private Seq<Row> myTestData1$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.myTestData1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.myTestData1;
    }

    private Seq<Row> myTestData1() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.myTestData1$lzycompute() : this.myTestData1;
    }

    private Seq<Row> myTestData2$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.myTestData2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.myTestData2;
    }

    private Seq<Row> myTestData2() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.myTestData2$lzycompute() : this.myTestData2;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("myUpperCaseData", this.myUpperCaseData(), TestData$.MODULE$.INT_STRING(), "N, L", new boolean[]{true, true});
        this.registerCollection("myLowerCaseData", this.myLowerCaseData(), TestData$.MODULE$.INT_STRING(), "n, l", new boolean[]{true, true});
        this.registerCollection("myTestData1", this.myTestData1(), TestData$.MODULE$.INT_INT(), "a, b", new boolean[]{true, true});
        this.registerCollection("myTestData2", this.myTestData2(), TestData$.MODULE$.INT_INT(), "a, b", new boolean[]{true, true});
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType);
    }

    @Test
    public void testOneMatchPerRow() {
        this.checkResult("SELECT * FROM myUpperCaseData u, myLowerCaseData l WHERE u.N = l.n", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "A", BoxesRunTime.boxToInteger((int)1), "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "B", BoxesRunTime.boxToInteger((int)2), "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "C", BoxesRunTime.boxToInteger((int)3), "c"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "D", BoxesRunTime.boxToInteger((int)4), "d"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testMultipleMatches() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.checkResult("SELECT * FROM myTestData1 A, myTestData2 B WHERE A.a = B.a and A.a = 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Test
    public void testNoMatches() {
        this.checkResult("SELECT * FROM myTestData1 A, myTestData2 B WHERE A.a = B.a and A.a = 1 and B.a = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testDecimalAsKey() {
        RowTypeInfo DEC_INT = new RowTypeInfo(new TypeInformation[]{BigDecimalTypeInfo.of((int)9, (int)0), BasicTypeInfo.INT_TYPE_INFO});
        this.registerCollection("leftTable", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(0), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(2), BoxesRunTime.boxToInteger((int)2)}))}))), (TypeInformation<Row>)DEC_INT, "a, b");
        this.registerCollection("rightTable", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(0), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(1), BoxesRunTime.boxToInteger((int)1)}))}))), (TypeInformation<Row>)DEC_INT, "c, d");
        this.checkResult("SELECT * FROM leftTable, rightTable WHERE a = c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testBigForSpill() {
        this.conf().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, 1);
        Seq bigData = (Seq)Random$.MODULE$.shuffle((TraversableOnce)((SeqLike)((SeqLike)TestData$.MODULE$.bigIntStringData().union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.registerCollection("bigData1", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "a, b");
        this.registerCollection("bigData2", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "c, d");
        this.checkResult("SELECT a, b FROM bigData1, bigData2 WHERE a = c", (Seq<Row>)((Seq)TestData$.MODULE$.bigIntStringData().flatMap((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.fill(16, (Function0 & Serializable & scala.Serializable)() -> row), Seq$.MODULE$.canBuildFrom())), this.checkResult$default$3());
    }

    @Test
    public void testSortMergeJoinOutputOrder() {
        block0: {
            Enumeration.Value value = this.expectedJoinType;
            Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            this.conf().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, 1);
            this.env().getConfig().setParallelism(1);
            Seq bigData = (Seq)Random$.MODULE$.shuffle((TraversableOnce)((SeqLike)((SeqLike)TestData$.MODULE$.bigIntStringData().union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            this.registerCollection("bigData1", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "a, b");
            this.registerCollection("bigData2", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "c, d");
            this.checkResult("SELECT a, b FROM bigData1, bigData2 WHERE a = c", (Seq<Row>)((Seq)TestData$.MODULE$.bigIntStringData().flatMap((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.fill(16, (Function0 & Serializable & scala.Serializable)() -> row), Seq$.MODULE$.canBuildFrom())), true);
        }
    }

    public InnerJoinITCase(Enumeration.Value expectedJoinType) {
        this.expectedJoinType = expectedJoinType;
    }
}

