/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.util.Optional;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import scala.Predef$;
import scala.Symbol;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001I\u0011q\u0002V1cY\u0016\u001c\u0016N\\6J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tQ\u0001^1cY\u0016T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\u0004\u0017)\u0011A\"D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003\u0015)H/\u001b7t\u0013\tARCA\u0007CCR\u001c\u0007\u000eV3ti\n\u000b7/\u001a\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\tAQa\b\u0001\u0005\u0002\u0001\na\"^:fg2+w-Y2z%><8/F\u0001\"!\t\u0011C%D\u0001$\u0015\t1\"\"\u0003\u0002&G\t\tB*Z4bGf\u0014vn\u001e*fg>,(oY3)\u0005y9\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0010\u0003\u0015QWO\\5u\u0013\ta\u0013F\u0001\u0003Sk2,\u0007b\u0002\u0018\u0001\u0001\u0004%\taL\u0001\f?\u0016D\b/Z2uK\u0012,\u00050F\u00011!\t\tD'D\u00013\u0015\t\u0019\u0014&A\u0003sk2,7/\u0003\u00026e\t\tR\t\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8\t\u000f]\u0002\u0001\u0019!C\u0001q\u0005yq,\u001a=qK\u000e$X\rZ#y?\u0012*\u0017\u000f\u0006\u0002:\u007fA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t!QK\\5u\u0011\u001d\u0001e'!AA\u0002A\n1\u0001\u001f\u00132\u0011\u0019\u0011\u0005\u0001)Q\u0005a\u0005aq,\u001a=qK\u000e$X\rZ#yA!)A\t\u0001C\u0001_\u0005QQ\r\u001f9fGR,G-\u0012=)\u0005\r;\u0003\"B$\u0001\t\u0003A\u0015A\t;fgR$UmY5nC2|enT;uaV$hi\u001c:nCR$\u0016M\u00197f'&t7\u000eF\u0001:Q\t1%\n\u0005\u0002)\u0017&\u0011A*\u000b\u0002\u0005)\u0016\u001cH\u000fC\u0003O\u0001\u0011\u0005\u0001*\u0001\u0012uKN$H)Z2j[\u0006dwJ\\*j].4UO\\2uS>tG+\u00192mKNKgn\u001b\u0015\u0003\u001b*CQ!\u0015\u0001\u0005\u0002!\u000bq\u0002^3tiNKgn[,ji\"\\U-\u001f\u0015\u0003!*CQ\u0001\u0016\u0001\u0005\u0002!\u000b!\u0003^3tiNKgn[,ji\"|W\u000f^&fs\"\u00121K\u0013\u0005\u0006/\u0002!\t\u0001S\u0001\u0014i\u0016\u001cHOT8u\u001dVdG.\u00128g_J\u001cWM\u001d\u0015\u0003-*CQA\u0017\u0001\u0005\u0002!\u000bQ\u0004^3ti\u0012\u000bG/Y*ue\u0016\fWNT8u\u001dVdG.\u00128g_J\u001cWM\u001d\u0015\u00033*CQ!\u0018\u0001\u0005\u0002y\u000b\u0001$\u001b8oKJ$Vm\u001d;O_RtU\u000f\u001c7F]\u001a|'oY3s)\tIt\fC\u0003a9\u0002\u0007\u0011-\u0001\u0005qe>4\u0018\u000eZ3s!\t\u0011\u0017N\u0004\u0002dOB\u0011AmO\u0007\u0002K*\u0011a-E\u0001\u0007yI|w\u000e\u001e \n\u0005!\\\u0014A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001[\u001e\t\u000b5\u0004A\u0011\u0001%\u0002MQ,7\u000f^*j].<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\u0006sGmQ8naV$X\rZ\"pYVlg\u000e\u000b\u0002m\u0015\")\u0001\u000f\u0001C\u0001\u0011\u0006\tB/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;)\u0005=T\u0005\"B:\u0001\t\u0003A\u0015A\t;fgR\u0004\u0016M\u001d;jC2Len]3si^KG\u000f\u001b(pi:+H\u000e\\\"pYVlg\u000e\u000b\u0002s\u0015\")a\u000f\u0001C\u0001\u0011\u0006yC/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;XSRD\u0007+\u0019:uSRLwN\\!oI\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\u0012QO\u0013\u0005\u0006s\u0002!\t\u0001S\u0001-i\u0016\u001cHOR;mY&s7/\u001a:u/&$\b\u000eU1si&$\u0018n\u001c8B]\u0012\u001cu.\u001c9vi\u0016$7i\u001c7v[:D#\u0001\u001f&\t\u000bq\u0004A\u0011\u0001%\u0002oQ,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQ\u0012Kh.Y7jGB\u000b'\u000f^5uS>t\u0017I\u001c3D_6\u0004X\u000f^3e\u0007>dW/\u001c82Q\tY(\nC\u0003\u0000\u0001\u0011\u0005\u0001*A\u001cuKN$\b+\u0019:uS\u0006d\u0017J\\:feR<\u0016\u000e\u001e5Es:\fW.[2QCJ$\u0018\u000e^5p]\u0006sGmQ8naV$X\rZ\"pYVlgN\r\u0015\u0003}*Ca!!\u0002\u0001\t\u0003A\u0015\u0001\b;fgR\u0004\u0016M\u001d;jC2Len]3si^KG\u000f\u001b*f_J$WM\u001d\u0015\u0004\u0003\u0007Q\u0005BBA\u0006\u0001\u0011\u0005\u0001*A\u0018uKN$\b+\u0019:uS\u0006d\u0017J\\:feR<\u0016\u000e\u001e5Es:\fW.[2B]\u0012\u001cF/\u0019;jGB\u000b'\u000f^5uS>t\u0017\u0007K\u0002\u0002\n)Ca!!\u0005\u0001\t\u0003A\u0015a\f;fgR\u0004\u0016M\u001d;jC2Len]3si^KG\u000f\u001b#z]\u0006l\u0017nY!oIN#\u0018\r^5d!\u0006\u0014H/\u001b;j_:\u0014\u0004fAA\b\u0015\"1\u0011q\u0003\u0001\u0005\u0002!\u000bq\u0006^3tiB\u000b'\u000f^5bY&s7/\u001a:u/&$\b\u000eR=oC6L7-\u00118e'R\fG/[2QCJ$\u0018\u000e^5p]NB3!!\u0006K\u0001")
public class TableSinkITCase
extends BatchTestBase {
    private ExpectedException _expectedEx = ExpectedException.none();

    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    public ExpectedException _expectedEx() {
        return this._expectedEx;
    }

    public void _expectedEx_$eq(ExpectedException x$1) {
        this._expectedEx = x$1;
    }

    @Rule
    public ExpectedException expectedEx() {
        return this._expectedEx();
    }

    @Test
    public void testDecimalOnOutputFormatTableSink() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE sink (\n         |  `c` VARCHAR(5),\n         |  `b` DECIMAL(10, 0),\n         |  `d` CHAR(5)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true',\n         |  'runtime-sink' = 'OutputFormat'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("MyTable").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("sink").await();
        java.util.List<String> result = TestValuesTableFactory.getResults("sink");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalOnSinkFunctionTableSink() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE sink (\n         |  `c` VARCHAR(5),\n         |  `b` DECIMAL(10, 0),\n         |  `d` CHAR(5)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("MyTable").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("sink").await();
        java.util.List<String> result = TestValuesTableFactory.getResults("sink");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkWithKey() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` DOUBLE,\n         |  PRIMARY KEY (a) NOT ENFORCED\n         |) WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        .colon.colon expected = new .colon.colon((Object)"1,0.1", (List)new .colon.colon((Object)"2,0.4", (List)new .colon.colon((Object)"3,1.0", (List)new .colon.colon((Object)"4,2.2", (List)new .colon.colon((Object)"5,3.9", (List)Nil$.MODULE$)))));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkWithoutKey() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` DOUBLE\n         |) WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        .colon.colon expected = new .colon.colon((Object)"1,0.1", (List)new .colon.colon((Object)"2,0.4", (List)new .colon.colon((Object)"3,1.0", (List)new .colon.colon((Object)"4,2.2", (List)new .colon.colon((Object)"5,3.9", (List)Nil$.MODULE$)))));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNotNullEnforcer() {
        this.innerTestNotNullEnforcer("SinkFunction");
    }

    @Test
    public void testDataStreamNotNullEnforcer() {
        this.innerTestNotNullEnforcer("DataStream");
    }

    public void innerTestNotNullEnforcer(String provider) {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.nullData4());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(248).append("\n         |CREATE TABLE nullable_src (\n         |  category STRING,\n         |  shopId INT,\n         |  num INT\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(272).append("\n         |CREATE TABLE not_null_sink (\n         |  category STRING,\n         |  shopId INT,\n         |  num INT NOT NULL\n         |) WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true',\n         |  'runtime-sink' = '").append(provider).append("'\n         |)\n         |").toString())).stripMargin());
        try {
            this.tEnv().executeSql("INSERT INTO not_null_sink SELECT * FROM nullable_src").await();
            Assert.fail((String)"Execution should fail.");
        }
        catch (Throwable t) {
            Optional exception = ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)"Column 'num' is NOT NULL, however, a null value is being written into it. You can set job configuration 'table.exec.sink.not-null-enforcer'='drop' to suppress this exception and drop such records silently.");
            Assert.assertTrue((boolean)exception.isPresent());
        }
        this.tEnv().getConfig().getConfiguration().setString("table.exec.sink.not-null-enforcer", "drop");
        this.tEnv().executeSql("INSERT INTO not_null_sink SELECT * FROM nullable_src").await();
        java.util.List<String> result = TestValuesTableFactory.getResults("not_null_sink");
        .colon.colon expected = new .colon.colon((Object)"book,1,12", (List)new .colon.colon((Object)"book,4,11", (List)new .colon.colon((Object)"fruit,3,44", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkWithPartitionAndComputedColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` AS `a` + 1,\n         |  `c` STRING,\n         |  `d` INT,\n         |  `e` DOUBLE\n         |)\n         |PARTITIONED BY (`c`, `d`)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink PARTITION(`c`='2021', `d`=1)\n         |SELECT x, sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"1,2021,1,0.1", (List)new .colon.colon((Object)"2,2021,1,0.4", (List)new .colon.colon((Object)"3,2021,1,1.0", (List)new .colon.colon((Object)"4,2021,1,2.2", (List)new .colon.colon((Object)"5,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsert() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` DOUBLE\n         |)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink (b)\n         |SELECT sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,0.1", (List)new .colon.colon((Object)"null,0.4", (List)new .colon.colon((Object)"null,1.0", (List)new .colon.colon((Object)"null,2.2", (List)new .colon.colon((Object)"null,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithNotNullColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT NOT NULL,\n         |  `b` DOUBLE\n         |)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.expectedEx().expect(ValidationException.class);
        this.expectedEx().expectMessage("Column 'a' has no default value and does not allow NULLs");
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink (b)\n         |SELECT sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
    }

    @Test
    public void testPartialInsertWithPartitionAndComputedColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` AS `a` + 1,\n         |  `c` STRING,\n         |  `d` INT,\n         |  `e` DOUBLE\n         |)\n         |PARTITIONED BY (`c`, `d`)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink PARTITION(`c`='2021', `d`=1) (e)\n         |SELECT sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testFullInsertWithPartitionAndComputedColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` AS `a` + 1,\n         |  `c` STRING,\n         |  `d` INT,\n         |  `e` DOUBLE\n         |)\n         |PARTITIONED BY (`c`, `d`)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink PARTITION(`c`='2021', `d`=1) (a, e)\n         |SELECT x, sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"1,2021,1,0.1", (List)new .colon.colon((Object)"2,2021,1,0.4", (List)new .colon.colon((Object)"3,2021,1,1.0", (List)new .colon.colon((Object)"4,2021,1,2.2", (List)new .colon.colon((Object)"5,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicPartitionAndComputedColumn1() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` AS `a` + 1,\n         |  `c` STRING,\n         |  `d` INT,\n         |  `e` DOUBLE\n         |)\n         |PARTITIONED BY (`c`, `d`)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink (e)\n         |SELECT sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,null,null,0.1", (List)new .colon.colon((Object)"null,null,null,0.4", (List)new .colon.colon((Object)"null,null,null,1.0", (List)new .colon.colon((Object)"null,null,null,2.2", (List)new .colon.colon((Object)"null,null,null,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicPartitionAndComputedColumn2() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` AS `a` + 1,\n         |  `c` STRING,\n         |  `d` INT,\n         |  `e` DOUBLE\n         |)\n         |PARTITIONED BY (`c`, `d`)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink (c, d, e)\n         |SELECT '2021', 1, sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithReorder() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` AS `a` + 1,\n         |  `c` STRING,\n         |  `d` INT,\n         |  `e` DOUBLE\n         |)\n         |PARTITIONED BY (`c`, `d`)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink (e, d, c)\n         |SELECT sum(y), 1, '2021' FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicAndStaticPartition1() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` AS `a` + 1,\n         |  `c` STRING,\n         |  `d` INT,\n         |  `e` DOUBLE\n         |)\n         |PARTITIONED BY (`c`, `d`)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink PARTITION(`c`='2021') (d, e)\n         |SELECT 1, sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,1,0.1", (List)new .colon.colon((Object)"null,2021,1,0.4", (List)new .colon.colon((Object)"null,2021,1,1.0", (List)new .colon.colon((Object)"null,2021,1,2.2", (List)new .colon.colon((Object)"null,2021,1,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicAndStaticPartition2() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` AS `a` + 1,\n         |  `c` STRING,\n         |  `d` INT,\n         |  `e` DOUBLE\n         |)\n         |PARTITIONED BY (`c`, `d`)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink PARTITION(`c`='2021') (e)\n         |SELECT sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
        .colon.colon expected = new .colon.colon((Object)"null,2021,null,0.1", (List)new .colon.colon((Object)"null,2021,null,0.4", (List)new .colon.colon((Object)"null,2021,null,1.0", (List)new .colon.colon((Object)"null,2021,null,2.2", (List)new .colon.colon((Object)"null,2021,null,3.9", (List)Nil$.MODULE$)))));
        java.util.List<String> result = TestValuesTableFactory.getResults("testSink");
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialInsertWithDynamicAndStaticPartition3() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE testSink (\n         |  `a` INT,\n         |  `b` AS `a` + 1,\n         |  `c` STRING,\n         |  `d` INT,\n         |  `e` DOUBLE\n         |)\n         |PARTITIONED BY (`c`, `d`)\n         |WITH (\n         |  'connector' = 'values',\n         |  'sink-insert-only' = 'true'\n         |)\n         |")).stripMargin());
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "x, y", TestData$.MODULE$.nullableOfSimpleData2());
        this.expectedEx().expect(ValidationException.class);
        this.expectedEx().expectMessage("Target column 'e' is assigned more than once");
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO testSink PARTITION(`c`='2021') (e, e)\n         |SELECT 1, sum(y) FROM MyTable GROUP BY x\n         |")).stripMargin()).await();
    }
}

