/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.filesystem.FileSystemConnectorOptions;
import org.apache.flink.table.planner.runtime.stream.FiniteTestSource;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b!B\u0001\u0003\u0003\u0003\t\"!\u0007$t'R\u0014X-Y7j]\u001e\u001c\u0016N\\6J)\u000e\u000b7/\u001a\"bg\u0016T!a\u0001\u0003\u0002\rM$(/Z1n\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0001 \u00039!\u0018.\\3pkR\u0004VM\u001d+fgR,\u0012\u0001\t\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nQA];mKNT!!\n\b\u0002\u000b),h.\u001b;\n\u0005\u001d\u0012#a\u0002+j[\u0016|W\u000f\u001e\u0015\u0003;%\u0002\"AK\u0016\u000e\u0003\u0011J!\u0001\f\u0013\u0003\tI+H.\u001a\u0005\n]\u0001\u0001\r\u00111A\u0005\u0012=\n!B]3tk2$\b+\u0019;i+\u0005\u0001\u0004CA\u0019;\u001d\t\u0011\u0004\b\u0005\u00024m5\tAG\u0003\u00026!\u00051AH]8pizR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011H\u000e\u0005\n}\u0001\u0001\r\u00111A\u0005\u0012}\naB]3tk2$\b+\u0019;i?\u0012*\u0017\u000f\u0006\u0002A\tB\u0011\u0011IQ\u0007\u0002m%\u00111I\u000e\u0002\u0005+:LG\u000fC\u0004F{\u0005\u0005\t\u0019\u0001\u0019\u0002\u0007a$\u0013\u0007C\u0005H\u0001\u0001\u0007\t\u0011)Q\u0005a\u0005Y!/Z:vYR\u0004\u0016\r\u001e5!\u0011\u001dI\u0005A1A\u0005\n)\u000bA\u0001Z1uCV\t1\nE\u0002M\u001fFk\u0011!\u0014\u0006\u0003\u001dZ\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0001VJA\u0002TKF\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u0006\u0002\u000bQL\b/Z:\n\u0005Y\u001b&a\u0001*po\"1\u0001\f\u0001Q\u0001\n-\u000bQ\u0001Z1uC\u0002BQA\u0017\u0001\u0005Bm\u000baAY3g_J,G#\u0001!)\u0005ek\u0006C\u0001\u0016_\u0013\tyFE\u0001\u0004CK\u001a|'/\u001a\u0005\u0006C\u0002!\tAY\u0001\u0015C\u0012$\u0017\u000e^5p]\u0006d\u0007K]8qKJ$\u0018.Z:\u0015\u0003\r\u00042!\u001131\u0013\t)gGA\u0003BeJ\f\u0017\u0010C\u0003h\u0001\u0011\u00051,A\u0006uKN$hj\u001c8QCJ$\bF\u00014j!\tQ#.\u0003\u0002lI\t!A+Z:u\u0011\u0015i\u0007\u0001\"\u0001\\\u0003!!Xm\u001d;QCJ$\bF\u00017j\u0011\u0015\u0001\b\u0001\"\u0003r\u0003\u0011!Xm\u001d;\u0015\u0007\u0001\u0013x\u000fC\u0003t_\u0002\u0007A/A\u0005qCJ$\u0018\u000e^5p]B\u0011\u0011)^\u0005\u0003mZ\u0012qAQ8pY\u0016\fg\u000eC\u0004y_B\u0005\t\u0019\u0001\u0019\u0002\rA|G.[2z\u0011\u0015Q\b\u0001\"\u0001\\\u0003M!Xm\u001d;NKR\f7\u000f^8sKB{G.[2zQ\tI\u0018\u000eC\u0003~\u0001\u0011\u0005a0A\u0003dQ\u0016\u001c7\u000e\u0006\u0003A\u007f\u0006\r\u0001BBA\u0001y\u0002\u0007\u0001'\u0001\u0005tc2\fV/\u001a:z\u0011\u0019\t)\u0001 a\u0001\u0017\u0006qQ\r\u001f9fGR,GMU3tk2$\b\"CA\u0005\u0001E\u0005I\u0011BA\u0006\u00039!Xm\u001d;%I\u00164\u0017-\u001e7uII*\"!!\u0004+\u0007A\nya\u000b\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C;oG\",7m[3e\u0015\r\tYBN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0010\u0003+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public abstract class FsStreamingSinkITCaseBase
extends StreamingTestBase {
    private String resultPath;
    private final Seq<Row> data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{1, "a", "b", "2020-05-03", "7"}), Row.of((Object[])new Object[]{2, "p", "q", "2020-05-03", "8"}), Row.of((Object[])new Object[]{3, "x", "y", "2020-05-03", "9"}), Row.of((Object[])new Object[]{4, "x", "y", "2020-05-03", "10"}), Row.of((Object[])new Object[]{5, "x", "y", "2020-05-03", "11"})}));

    @Rule
    public Timeout timeoutPerTest() {
        return Timeout.seconds((long)240L);
    }

    public String resultPath() {
        return this.resultPath;
    }

    public void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private Seq<Row> data() {
        return this.data;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.resultPath_$eq(this.tempFolder().newFolder().toURI().toString());
        this.env().setParallelism(1);
        this.env().enableCheckpointing(100L);
        org.apache.flink.streaming.api.scala.DataStream stream = new org.apache.flink.streaming.api.scala.DataStream((DataStream)this.env().getJavaEnv().addSource((SourceFunction)new FiniteTestSource((Iterable<Row>)this.data()), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING})));
        this.tEnv().createTemporaryView("my_table", stream, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Expressions.$((String)"a"), Expressions.$((String)"b"), Expressions.$((String)"c"), Expressions.$((String)"d"), Expressions.$((String)"e")}));
    }

    public String[] additionalProperties() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    @Test
    public void testNonPart() {
        this.test(false, this.test$default$2());
    }

    @Test
    public void testPart() {
        this.test(true, this.test$default$2());
        File basePath = new File(new URI(this.resultPath()).getPath(), "d=2020-05-03");
        Assert.assertEquals((long)5L, (long)basePath.list().length);
        Assert.assertTrue((boolean)new File(new File(basePath, "e=7"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=8"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=9"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=10"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=11"), "_MY_SUCCESS").exists());
    }

    private void test(boolean partition, String policy) {
        char dollar = '$';
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(546).append("\n                 |create table sink_table (\n                 |  a int,\n                 |  b string,\n                 |  c string,\n                 |  d string,\n                 |  e string\n                 |)\n                 |").append((Object)(partition ? "partitioned by (d, e)" : "")).append("\n                 |with (\n                 |  'connector' = 'filesystem',\n                 |  'path' = '").append(this.resultPath()).append("',\n                 |  '").append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_PATTERN.key()).append("' =\n                 |      '").append(dollar).append("d ").append(dollar).append("e:00:00',\n                 |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_DELAY.key()).append("' = '1h',\n                 |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_KIND.key()).append("' = '").append(policy).append("',\n                 |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_SUCCESS_FILE_NAME.key()).append("' = '_MY_SUCCESS',\n                 |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.additionalProperties())).mkString(",\n")).append("\n                 |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        this.tEnv().sqlQuery("select * from my_table").executeInsert("sink_table").await();
        this.check("select * from sink_table", this.data());
    }

    private String test$default$2() {
        return "success-file";
    }

    @Test
    public void testMetastorePolicy() {
        this.thrown().expectMessage("Can not configure a 'metastore' partition commit policy for a file system table. You can only configure 'metastore' partition commit policy for a hive table.");
        this.test(true, "metastore");
    }

    public void check(String sqlQuery, Seq<Row> expectedResult) {
        CloseableIterator iter = this.tEnv().sqlQuery(sqlQuery).execute().collect();
        List result = CollectionUtil.iteratorToList((Iterator)iter);
        iter.close();
        Assert.assertEquals((Object)((SeqLike)expectedResult.map((Function1 & Serializable & scala.Serializable)x$1 -> TestSinkUtil$.MODULE$.rowToString((Row)x$1, TestSinkUtil$.MODULE$.rowToString$default$2()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$), (Object)((SeqLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).map((Function1 & Serializable & scala.Serializable)x$2 -> TestSinkUtil$.MODULE$.rowToString((Row)x$2, TestSinkUtil$.MODULE$.rowToString$default$2()), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
    }
}

