/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.rules.physical.stream.IncrementalAggregateRule;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;

public class IncrementalAggregateJsonPlanITCase
extends JsonPlanTestBase {
    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.tableEnv.getConfig().getConfiguration().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.TWO_PHASE.name());
        this.tableEnv.getConfig().getConfiguration().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)true);
        this.tableEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)true);
        this.tableEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(10L));
        this.tableEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)5L);
        this.tableEnv.getConfig().getConfiguration().set(IncrementalAggregateRule.TABLE_OPTIMIZER_INCREMENTAL_AGG_ENABLED(), (Object)true);
    }

    @Test
    public void testIncrementalAggregate() throws IOException, ExecutionException, InterruptedException {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.smallData3()), "a int", "b bigint", "c varchar");
        this.createTestNonInsertOnlyValuesSinkTable("MySink", "b bigint", "a bigint", "primary key (b) not enforced");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink select b, count(distinct a) as a from MyTable group by b");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        List<String> result = TestValuesTableFactory.getResults("MySink");
        this.assertResult(Arrays.asList("+I[1, 1]", "+I[2, 2]"), result);
    }
}

