/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.table.runtime.functions.SqlDateTimeUtils;
import org.apache.flink.types.Row;
import org.junit.Test;

public class TableSourceJsonPlanITCase
extends JsonPlanTestBase {
    @Test
    public void testProjectPushDown() throws Exception {
        List<String> data = Arrays.asList("1,1,hi", "2,1,hello", "3,2,hello world");
        this.createTestCsvSourceTable("MyTable", data, "a bigint", "b int not null", "c varchar");
        File sinkPath = this.createTestCsvSinkTable("MySink", "a bigint", "b int");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink select a, b from MyTable");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        this.assertResult(Arrays.asList("1,1", "2,1", "3,2"), sinkPath);
    }

    @Test
    public void testReadingMetadata() throws Exception {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.smallData3()), new String[]{"a int", "b bigint", "m varchar metadata"}, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("readable-metadata", "m:STRING");
            }
        });
        File sinkPath = this.createTestCsvSinkTable("MySink", "a bigint", "m varchar");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink select a, m from MyTable");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        this.assertResult(Arrays.asList("1,Hi", "2,Hello", "3,Hello world"), sinkPath);
    }

    @Test
    public void testFilterPushDown() throws Exception {
        List<String> data = Arrays.asList("1,1,hi", "2,1,hello", "3,2,hello world");
        this.createTestCsvSourceTable("MyTable", data, "a bigint", "b int not null", "c varchar");
        File sinkPath = this.createTestCsvSinkTable("MySink", "a bigint", "b int", "c varchar");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink select * from MyTable where a > 1");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        this.assertResult(Arrays.asList("2,1,hello", "3,2,hello world"), sinkPath);
    }

    @Test
    public void testPartitionPushDown() throws Exception {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.smallData3()), new String[]{"a int", "p bigint", "c varchar"}, "p", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("partition-list", "p:1;p:2");
            }
        });
        File sinkPath = this.createTestCsvSinkTable("MySink", "a int", "p bigint", "c varchar");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink select * from MyTable where p = 2");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        this.assertResult(Arrays.asList("2,2,Hello", "3,2,Hello world"), sinkPath);
    }

    @Test
    public void testWatermarkPushDown() throws Exception {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.data3WithTimestamp()), new String[]{"a int", "b bigint", "c varchar", "ts timestamp(3)", "watermark for ts as ts - interval '5' second"}, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("enable-watermark-push-down", "true");
            }
        });
        File sinkPath = this.createTestCsvSinkTable("MySink", "a int", "b bigint", "ts timestamp(3)");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink select a, b, ts from MyTable where b = 3");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        this.assertResult(Arrays.asList("4,3," + SqlDateTimeUtils.unixTimestampToLocalDateTime((long)4000L), "5,3," + SqlDateTimeUtils.unixTimestampToLocalDateTime((long)5000L), "6,3," + SqlDateTimeUtils.unixTimestampToLocalDateTime((long)6000L)), sinkPath);
    }

    @Test
    public void testPushDowns() throws Exception {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.data3WithTimestamp()), new String[]{"a int", "b bigint", "c varchar", "ts timestamp(3)", "watermark for ts as ts - interval '5' second"}, "b", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("readable-metadata", "a:INT");
                this.put("filterable-fields", "a");
                this.put("enable-watermark-push-down", "true");
                this.put("partition-list", "b:1;b:2;b:3;b:4;b:5;b:6");
            }
        });
        File sinkPath = this.createTestCsvSinkTable("MySink", "a int", "ts timestamp(3)");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink select a, ts from MyTable where b = 3 and a > 4");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        this.assertResult(Arrays.asList("5," + SqlDateTimeUtils.unixTimestampToLocalDateTime((long)5000L), "6," + SqlDateTimeUtils.unixTimestampToLocalDateTime((long)6000L)), sinkPath);
    }
}

