/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001'\t)2k\\;sG\u0016<\u0016\r^3s[\u0006\u00148.\u0013+DCN,'BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\t\t2\u000b\u001e:fC6Lgn\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011\u0001\t\u0003\t\u0013AD;tKNdUmZ1dsJ{wo]\u000b\u0002EA\u00111%J\u0007\u0002I)\u0011qCC\u0005\u0003M\u0011\u0012\u0011\u0003T3hC\u000eL(k\\<SKN|WO]2fQ\ty\u0002\u0006\u0005\u0002*Y5\t!F\u0003\u0002,!\u0005)!.\u001e8ji&\u0011QF\u000b\u0002\u0005%VdW\rC\u00030\u0001\u0011\u0005\u0001'A\u000euKN$8+[7qY\u0016<\u0016\r^3s[\u0006\u00148\u000eU;tQ\u0012{wO\u001c\u000b\u0002cA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t!QK\\5uQ\tq\u0003\b\u0005\u0002*s%\u0011!H\u000b\u0002\u0005)\u0016\u001cH\u000fC\u0003=\u0001\u0011\u0005\u0001'A\u0015uKN$8+[7qY\u0016<\u0016\r^3s[\u0006\u00148n\u00148US6,7\u000f^1na2#(\u0010U;tQ\u0012{wO\u001c\u0015\u0003waBQa\u0010\u0001\u0005\u0002A\n!\u0004^3ti^\u000bG/\u001a:nCJ\\w+\u001b;i\u001d\u0016\u001cH/\u001a3S_^D#A\u0010\u001d\t\u000b\t\u0003A\u0011\u0001\u0019\u0002=Q,7\u000f^,bi\u0016\u0014X.\u0019:l/&$\b.T;mi&Le\u000e];u+\u00124\u0007FA!9\u0011\u0015)\u0005\u0001\"\u00011\u0003e!Xm\u001d;XCR,'/\\1sW^KG\u000f['fi\u0006$\u0017\r^1)\u0005\u0011C\u0004")
public class SourceWatermarkITCase
extends StreamingTestBase {
    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testSimpleWatermarkPushDown() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(445).append("\n         | CREATE Table VirtualTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   d as c - INTERVAL '5' second,\n         |   WATERMARK FOR d as d + INTERVAL '5' second\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-11-21T19:00:05.230", "2020-11-21T21:00:05.230"}));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,2020-11-21T19:00:05.230", "2,3,2020-11-21T21:00:05.230"}));
        String query = "SELECT a, b, c FROM VirtualTable";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("VirtualTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assert.assertEquals((Object)expectedWatermarkOutput, (Object)actualWatermark);
        Assert.assertEquals((Object)expectedData.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleWatermarkOnTimestampLtzPushDown() {
        ZoneId zoneId = ZoneId.of("Asia/Shanghai");
        this.tEnv().getConfig().setLocalTimeZone(zoneId);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23").atZone(zoneId).toInstant()})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23").atZone(zoneId).toInstant()}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(450).append("\n         | CREATE Table VirtualTable1 (\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP_LTZ(3),\n         |   d as c - INTERVAL '5' second,\n         |   WATERMARK FOR d as d + INTERVAL '5' second\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-11-21T19:00:05.230", "2020-11-21T21:00:05.230"}));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,2020-11-21T11:00:05.230Z", "2,3,2020-11-21T13:00:05.230Z"}));
        String query = "SELECT a, b, c FROM VirtualTable1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("VirtualTable1")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> LocalDateTime.ofInstant(Instant.ofEpochMilli(x.getTimestamp()), zoneId).toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assert.assertEquals((Object)expectedWatermarkOutput, (Object)actualWatermark);
        Assert.assertEquals((Object)expectedData.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWatermarkWithNestedRow() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)0L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"h1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"h2", null}))}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i2", LocalDateTime.parse("2020-11-21T19:00:05.23")}))}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"j1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"j2", LocalDateTime.parse("2020-11-21T21:00:05.23")}))}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)4L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"k1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"k2", null}))}))}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(463).append("\n         | CREATE Table NestedTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c ROW<name STRING, d ROW<e STRING, f TIMESTAMP(3)>>,\n         |   g as c.d.f,\n         |   WATERMARK FOR g as g - INTERVAL '5' second\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TimestampData.fromEpochMillis((long)Long.MIN_VALUE).toString(), "2020-11-21T19:00:00.230", "2020-11-21T21:00:00.230", "2020-11-21T21:00:00.230"}));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,0,h2,null", "1,2,i2,2020-11-21T19:00:05.230", "2,3,j2,2020-11-21T21:00:05.230", "3,4,k2,null"}));
        String query = "SELECT a, b, c.d FROM NestedTable";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("NestedTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assert.assertEquals((Object)expectedWatermarkOutput, (Object)actualWatermark);
        Assert.assertEquals((Object)expectedData.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWatermarkWithMultiInputUdf() {
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(424).append("\n         | CREATE Table UdfTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c timestamp(3),\n         |   d as func(c, a),\n         |   WATERMARK FOR c as func(func(d, a), a)\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-11-21T19:00:02.230", "2020-11-21T20:59:59.230"}));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2000,3,2020-11-21T21:00:03.230"}));
        String query = "SELECT a, b, d FROM UdfTable WHERE b > 2";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("UdfTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assert.assertEquals((Object)expectedWatermarkOutput, (Object)actualWatermark);
        Assert.assertEquals((Object)expectedData.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWatermarkWithMetadata() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)Timestamp.valueOf("2020-11-21 19:00:05.23").toInstant().toEpochMilli())})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)Timestamp.valueOf("2020-11-21 21:00:05.23").toInstant().toEpochMilli())}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(538).append("\n        | CREATE TABLE MetadataTable(\n        |   a INT,\n        |   b BIGINT,\n        |   originTime BIGINT METADATA,\n        |   rowtime AS TO_TIMESTAMP(FROM_UNIXTIME(originTime/1000), 'yyyy-MM-dd HH:mm:ss'),\n        |   WATERMARK FOR rowtime AS rowtime\n        | ) WITH (\n        |   'connector' = 'values',\n        |   'enable-watermark-push-down' = 'true',\n        |   'bounded' = 'false',\n        |   'disable-lookup' = 'true',\n        |   'readable-metadata' = 'originTime:BIGINT',\n        |   'data-id' = '").append(dataId).append("'\n        | )\n        |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        .colon.colon expectedWatermarkOutput = new .colon.colon((Object)"2020-11-21T19:00:05", (List)new .colon.colon((Object)"2020-11-21T21:00:05", (List)Nil$.MODULE$));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1"}));
        String query = "SELECT a FROM MetadataTable WHERE b > 2";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("MetadataTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assert.assertEquals((Object)expectedWatermarkOutput, (Object)actualWatermark);
        Assert.assertEquals((Object)expectedData.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }
}

