/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Collections;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.utils.JavaPojos;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.StringSink;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001'\ta2\u000b\u001e:fC6$\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG/\u0013+DCN,'BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\t\t2\u000b\u001e:fC6Lgn\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011\u0001\t\u0003\t\u0013A\b;fgR$v.\u00119qK:$7\u000b\u001e:fC6<\u0016\u000e\u001e5Q_*|G+\u001f9f)\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#\u0001B+oSRD#aH\u0015\u0011\u0005)jS\"A\u0016\u000b\u00051\u0002\u0012!\u00026v]&$\u0018B\u0001\u0018,\u0005\u0011!Vm\u001d;\t\u000bA\u0002A\u0011A\u0011\u0002;Q,7\u000f\u001e+p\u0003B\u0004XM\u001c3TiJ,\u0017-\\,ji\"\u0014\u0016m\u001e+za\u0016D#aL\u0015\t\u000bM\u0002A\u0011A\u0011\u0002?Q,7\u000f\u001e+p%\u0016$(/Y2u'R\u0014X-Y7XSRD\u0007k\u001c6p)f\u0004X\r\u000b\u00023S!)a\u0007\u0001C\u0001C\u0005QB/Z:u%\u0016$(/Y2u\u001bN<w+\u001b;i!>Tw\u000eV=qK\"\u0012Q'\u000b")
public class StreamTableEnvironmentITCase
extends StreamingTestBase {
    @Test
    public void testToAppendStreamWithPojoType() {
        DataStream orderA = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JavaPojos.Order[]{new JavaPojos.Order(Predef$.MODULE$.long2Long(1L), new JavaPojos.ProductItem("beer", Predef$.MODULE$.long2Long(10L)), 3), new JavaPojos.Order(Predef$.MODULE$.long2Long(1L), new JavaPojos.ProductItem("diaper", Predef$.MODULE$.long2Long(11L)), 4), new JavaPojos.Order(Predef$.MODULE$.long2Long(3L), new JavaPojos.ProductItem("rubber", Predef$.MODULE$.long2Long(12L)), 2)})), TypeExtractor.createTypeInfo(JavaPojos.Order.class));
        DataStream orderB = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JavaPojos.Order[]{new JavaPojos.Order(Predef$.MODULE$.long2Long(2L), new JavaPojos.ProductItem("pen", Predef$.MODULE$.long2Long(13L)), 3), new JavaPojos.Order(Predef$.MODULE$.long2Long(2L), new JavaPojos.ProductItem("rubber", Predef$.MODULE$.long2Long(12L)), 3), new JavaPojos.Order(Predef$.MODULE$.long2Long(4L), new JavaPojos.ProductItem("beer", Predef$.MODULE$.long2Long(10L)), 1)})), TypeExtractor.createTypeInfo(JavaPojos.Order.class));
        Table tableA = this.tEnv().fromDataStream(orderA, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "user")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "product")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))}));
        this.tEnv().createTemporaryView("OrderB", orderB, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "user")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "product")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))}));
        Table result = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(119).append("\n         |SELECT * FROM ").append(tableA).append(" WHERE amount > 2\n         |UNION ALL\n         |SELECT * FROM OrderB WHERE amount < 2\n        ").toString())).stripMargin());
        StringSink sink = new StringSink();
        package$.MODULE$.tableConversions(result).toAppendStream(TypeExtractor.createTypeInfo(JavaPojos.Order.class)).addSink(sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"Order{user=1, product='Product{name='beer', id=10}', amount=3}", (List)new .colon.colon((Object)"Order{user=1, product='Product{name='diaper', id=11}', amount=4}", (List)new .colon.colon((Object)"Order{user=4, product='Product{name='beer', id=10}', amount=1}", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testToAppendStreamWithRawType() {
        DataStream devices = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JavaPojos.Device[]{new JavaPojos.Device(Predef$.MODULE$.long2Long(1L), "device1", Collections.singletonMap("A", Predef$.MODULE$.long2Long(10L))), new JavaPojos.Device(Predef$.MODULE$.long2Long(2L), "device2", Collections.emptyMap()), new JavaPojos.Device(Predef$.MODULE$.long2Long(3L), "device3", Collections.singletonMap("B", Predef$.MODULE$.long2Long(20L)))})), TypeExtractor.createTypeInfo(JavaPojos.Device.class));
        this.tEnv().createTemporaryView("devices", devices, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deviceId")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deviceName")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "metrics"))}));
        Table result = this.tEnv().sqlQuery("SELECT * FROM devices WHERE deviceId >= 2");
        StringSink sink = new StringSink();
        package$.MODULE$.tableConversions(result).toAppendStream(TypeExtractor.createTypeInfo(JavaPojos.Device.class)).addSink(sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"Device{deviceId=2, deviceName='device2', metrics={}}", (List)new .colon.colon((Object)"Device{deviceId=3, deviceName='device3', metrics={B=20}}", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testToRetractStreamWithPojoType() {
        DataStream persons = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JavaPojos.Person[]{new JavaPojos.Person("bob", 1), new JavaPojos.Person("Liz", 2), new JavaPojos.Person("Jack", 3)})), TypeExtractor.createTypeInfo(JavaPojos.Person.class));
        this.tEnv().createTemporaryView("person", persons);
        StringSink sink = new StringSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("select name, age from person")).toRetractStream(TypeExtractor.createTypeInfo(JavaPojos.Person.class)).addSink(sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"(true,Person{name='bob', age=1})", (List)new .colon.colon((Object)"(true,Person{name='Liz', age=2})", (List)new .colon.colon((Object)"(true,Person{name='Jack', age=3})", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRetractMsgWithPojoType() {
        DataStream orders = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JavaPojos.Order[]{new JavaPojos.Order(Predef$.MODULE$.long2Long(1L), new JavaPojos.ProductItem("beer", Predef$.MODULE$.long2Long(10L)), 1), new JavaPojos.Order(Predef$.MODULE$.long2Long(1L), new JavaPojos.ProductItem("beer", Predef$.MODULE$.long2Long(10L)), 2)})), TypeExtractor.createTypeInfo(JavaPojos.Order.class));
        Table table = this.tEnv().fromDataStream(orders, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "user")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "product")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))}));
        StringSink sink = new StringSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("|SELECT user, product, sum(amount) as amount\n                      |FROM ").append(table).append("\n                      |GROUP BY user, product\n                      |").toString())).stripMargin())).toRetractStream(TypeExtractor.createTypeInfo(JavaPojos.Order.class)).addSink(sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"(true,Order{user=1, product='Product{name='beer', id=10}', amount=1})", (List)new .colon.colon((Object)"(false,Order{user=1, product='Product{name='beer', id=10}', amount=1})", (List)new .colon.colon((Object)"(true,Order{user=1, product='Product{name='beer', id=10}', amount=3})", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$));
    }
}

