/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.TestPreserveWMTableSource;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime$;
import org.apache.flink.table.planner.utils.WithoutTimeAttributesTableSource$;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001'\tyA+\u00192mKN\u001b\u0017M\\%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011\u0011c\u0015;sK\u0006l\u0017N\\4UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003!\u0001\u0011\u0005\u0011%A\u0012uKN$H+\u00192mKN{WO]2f/&$\bn\\;u)&lW-\u0011;ue&\u0014W\u000f^3\u0015\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012A!\u00168ji\"\u0012q$\u000b\t\u0003U5j\u0011a\u000b\u0006\u0003YA\tQA[;oSRL!AL\u0016\u0003\tQ+7\u000f\u001e\u0005\u0006a\u0001!\t!I\u0001\u0018i\u0016\u001cH\u000f\u0015:pGRLW.\u001a+bE2,7k\\;sG\u0016D#aL\u0015\t\u000bM\u0002A\u0011A\u0011\u0002QQ,7\u000f\u001e*poRLW.\u001a+bE2,7k\\;sG\u0016<\u0016\u000e\u001e5GS\u0016dGMU3NCB\u0004\u0018N\\4)\u0005IJ\u0003\"\u0002\u001c\u0001\t\u0003\t\u0013\u0001\u000b;fgR\u0014vn\u001e;j[\u0016$\u0016M\u00197f'>,(oY3Qe\u0016\u001cXM\u001d<f/\u0006$XM]7be.\u001c\bFA\u001b*\u0001")
public class TableScanITCase
extends StreamingTestBase {
    @Test
    public void testTableSourceWithoutTimeAttribute() {
        String tableName = "MyTable";
        WithoutTimeAttributesTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), tableName);
        String sqlQuery = new StringBuilder(14).append("SELECT * from ").append(tableName).toString();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1,1", "Bob,2,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProctimeTableSource() {
        String tableName = "MyTable";
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary", "Peter", "Bob", "Liz"}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"name", "ptime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.LOCAL_DATE_TIME()}));
        TypeInformation returnType = Types.STRING();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(false, schema, returnType, data, null, "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal(tableName, tableSource);
        String sqlQuery = new StringBuilder(17).append("SELECT name FROM ").append(tableName).toString();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary", "Peter", "Bob", "Liz"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeTableSourceWithFieldReMapping() {
        String tableName = "MyTable";
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)11L), "Mary"}), Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)12L), "Peter"}), Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)13L), "Bob"}), Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToLong((long)14L), "Liz"})}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"key", "rowtime", "payload"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        TypeInformation returnType = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()});
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)"f0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ts"), (Object)"f1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"payload"), (Object)"f2")}));
        boolean x$1 = false;
        TableSchema x$2 = schema;
        TypeInformation x$3 = returnType;
        Seq x$4 = data;
        String x$5 = "rowtime";
        Map x$6 = mapping;
        String x$7 = "ts";
        String x$8 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(x$1, x$2, x$3, x$4, x$5, x$8, (Map<String, String>)x$6, x$7);
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal(tableName, tableSource);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(205).append("\n         |SELECT\n         |  CAST(TUMBLE_START(rowtime, INTERVAL '0.005' SECOND) AS VARCHAR),\n         |  COUNT(payload)\n         |FROM ").append(tableName).append("\n         |GROUP BY TUMBLE(rowtime, INTERVAL '0.005' SECOND)\n       ").toString())).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.010,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeTableSourcePreserveWatermarks() {
        String tableName = "MyTable";
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)1L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)Row.of((Object[])new Object[]{new Integer(1), new Long(5L), "A"}))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)Row.of((Object[])new Object[]{new Integer(2), new Long(1L), "B"}))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)10L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)8L), (Object)Row.of((Object[])new Object[]{new Integer(6), new Long(8L), "C"}))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)20L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)21L), (Object)Row.of((Object[])new Object[]{new Integer(6), new Long(21L), "D"}))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)30L))}));
        String[] fieldNames = (String[])((Object[])new String[]{"id", "rtime", "name"});
        TableSchema schema = new TableSchema(fieldNames, (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), fieldNames);
        TestPreserveWMTableSource tableSource = new TestPreserveWMTableSource(schema, rowType, data, "rtime");
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal(tableName, tableSource);
        String sqlQuery = new StringBuilder(21).append("SELECT id, name FROM ").append(tableName).toString();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).process((ProcessFunction)new ProcessFunction<Row, Row>(null){

            public void processElement(Row value, ProcessFunction.Context ctx, Collector<Row> out) {
                Row res = new Row(3);
                res.setField(0, value.getField(0));
                res.setField(1, value.getField(1));
                res.setField(2, (Object)BoxesRunTime.boxToLong((long)ctx.timerService().currentWatermark()));
                out.collect((Object)res);
            }
        }, TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,A,1", "2,B,1", "6,C,10", "6,D,20"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }
}

