/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.table.StringWithTimestampRetractSink;
import org.apache.flink.table.planner.runtime.stream.table.StringWithTimestampSink;
import org.apache.flink.table.planner.runtime.stream.table.TableToDataStreamITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0003%\t9B+\u00192mKR{G)\u0019;b'R\u0014X-Y7J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tQ\u0001^1cY\u0016T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0007-Q!\u0001D\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\r\u0005)Q\u000f^5mg&\u0011\u0001$\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u0003\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0015\"Xm\u001d;ICN\u0014vn\u001e;j[\u00164%o\\7UC\ndW\rV8BaB,g\u000eZ*ue\u0016\fW\u000eF\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0011)f.\u001b;)\u0005yA\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u0010\u0003\u0015QWO\\5u\u0013\ti#F\u0001\u0003UKN$\b\"B\u0018\u0001\t\u0003\u0001\u0013A\n;fgRD\u0015m\u001d*poRLW.\u001a$s_6$\u0016M\u00197f)>\u0014V\r\u001e:bGR\u001cFO]3b[\"\u0012a\u0006\u000b\u0005\u0006e\u0001!\t\u0001I\u00012i\u0016\u001cH\u000fS1t%><H/[7f\rJ|W\u000eR1uCN#(/Z1n)>$\u0016M\u00197f\u0005\u0006\u001c7\u000eR1uCN#(/Z1nQ\t\t\u0004\u0006C\u00036\u0001\u0011\u0005\u0001%A\u0014uKN$\b*Y:S_^$\u0018.\\3Ge>lG+\u00192mKR{W\t\u001f;fe:\fGnU=ti\u0016l\u0007F\u0001\u001b)\u0011\u0015A\u0004\u0001\"\u0001!\u0003\u001d\"Xm\u001d;Ge>lG+\u00192mKR{\u0017\t\u001d9f]\u0012\u001cFO]3b[^KG\u000f\u001b)s_\u000e$\u0018.\\3)\u0005]B\u0003\"B\u001e\u0001\t\u0003\u0001\u0013A\u000e;fgRD\u0015m\u001d$s_6$\u0015\r^1TiJ,\u0017-\u001c+p)\u0006\u0014G.\u001a\"bG.$\u0015\r^1TiJ,\u0017-\\,ji\"\u0004&o\\2uS6,\u0007F\u0001\u001e)\u0011\u0015q\u0004\u0001\"\u0003@\u00035awnY1m\t\u0006$X\rV5nKR\u0011\u0001\t\u0013\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA\u0001^5nK*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u00055aunY1m\t\u0006$X\rV5nK\")\u0011*\u0010a\u0001\u0015\u0006YQ\r]8dQN+7m\u001c8e!\t\u00113*\u0003\u0002MG\t!Aj\u001c8h\u0001")
public final class TableToDataStreamITCase
extends StreamingTestBase {
    @Test
    public void testHasRowtimeFromTableToAppendStream() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(1L), "A"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(2L), "B"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(3L), "C"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(4L), "D"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(7L), "E"})), (List)Nil$.MODULE$)))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(242).append("\n         |CREATE TABLE src (\n         |  ts TIMESTAMP(3),\n         |  a STRING,\n         |  WATERMARK FOR ts AS ts - INTERVAL '0.005' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sourceDDL);
        DataStream dataStream = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT a, ts FROM src")).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        .colon.colon expected = new .colon.colon((Object)"+I[A, 1970-01-01T00:00:01], 1000", (List)new .colon.colon((Object)"+I[B, 1970-01-01T00:00:02], 2000", (List)new .colon.colon((Object)"+I[C, 1970-01-01T00:00:03], 3000", (List)new .colon.colon((Object)"+I[D, 1970-01-01T00:00:04], 4000", (List)new .colon.colon((Object)"+I[E, 1970-01-01T00:00:07], 7000", (List)Nil$.MODULE$)))));
        StringWithTimestampSink sink = new StringWithTimestampSink();
        dataStream.addSink(sink);
        this.env().execute("TableToAppendStream");
        Assert.assertEquals((Object)expected, (Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testHasRowtimeFromTableToRetractStream() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(1L), "A"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(2L), "A"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(3L), "C"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(4L), "D"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(7L), "E"})), (List)Nil$.MODULE$)))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(242).append("\n         |CREATE TABLE src (\n         |  ts TIMESTAMP(3),\n         |  a STRING,\n         |  WATERMARK FOR ts AS ts - INTERVAL '0.005' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sourceDDL);
        DataStream dataStream = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, ts\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY ts DESC) as rowNum\n        |  FROM src\n        |)\n        |WHERE rowNum = 1\n      ")).stripMargin())).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        StringWithTimestampRetractSink sink = new StringWithTimestampRetractSink();
        dataStream.addSink(sink);
        this.env().execute("TableToRetractStream");
        .colon.colon expected = new .colon.colon((Object)"A,1970-01-01T00:00:02,2000", (List)new .colon.colon((Object)"C,1970-01-01T00:00:03,3000", (List)new .colon.colon((Object)"D,1970-01-01T00:00:04,4000", (List)new .colon.colon((Object)"E,1970-01-01T00:00:07,7000", (List)Nil$.MODULE$))));
        Assert.assertEquals((Object)expected, (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
        .colon.colon expectedRetract = new .colon.colon((Object)"(true,A,1970-01-01T00:00:01,1000)", (List)new .colon.colon((Object)"(false,A,1970-01-01T00:00:01,1000)", (List)new .colon.colon((Object)"(true,A,1970-01-01T00:00:02,2000)", (List)new .colon.colon((Object)"(true,C,1970-01-01T00:00:03,3000)", (List)new .colon.colon((Object)"(true,D,1970-01-01T00:00:04,4000)", (List)new .colon.colon((Object)"(true,E,1970-01-01T00:00:07,7000)", (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expectedRetract.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testHasRowtimeFromDataStreamToTableBackDataStream() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"A"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"B"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"C"), new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)"D"), new Tuple2((Object)BoxesRunTime.boxToLong((long)7L), (Object)"E")}));
        DataStream ds1 = this.env().fromCollection(data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.TableToDataStreamITCase$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)TableToDataStreamITCase.$anonfun$testHasRowtimeFromDataStreamToTableBackDataStream$1(x$1)));
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        this.tEnv().registerTable("t1", table);
        DataStream ds2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT CONCAT(a, '_'), ts, rowtime\n        | FROM t1\n      ")).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        .colon.colon expected = new .colon.colon((Object)"+I[A_, 1, 1970-01-01T00:00:01], 1000", (List)new .colon.colon((Object)"+I[B_, 2, 1970-01-01T00:00:02], 2000", (List)new .colon.colon((Object)"+I[C_, 3, 1970-01-01T00:00:03], 3000", (List)new .colon.colon((Object)"+I[D_, 4, 1970-01-01T00:00:04], 4000", (List)new .colon.colon((Object)"+I[E_, 7, 1970-01-01T00:00:07], 7000", (List)Nil$.MODULE$)))));
        StringWithTimestampSink sink = new StringWithTimestampSink();
        ds2.addSink(sink);
        this.env().execute("DataStreamToTableBackDataStream");
        Assert.assertEquals((Object)expected, (Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testHasRowtimeFromTableToExternalSystem() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.001", this.localDateTime(1L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.002", this.localDateTime(2L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.003", this.localDateTime(3L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.004", this.localDateTime(4L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.007", this.localDateTime(7L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.008", this.localDateTime(8L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.016", this.localDateTime(16L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)4.0)})), (List)Nil$.MODULE$)))))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(288).append("\n         |CREATE TABLE src (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE,\n         |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("'\n         |)\n      ").toString())).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(236).append("\n         |CREATE TABLE sink (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE\n         |) WITH (\n         |  'connector' = 'values',\n         |  'table-sink-class' = '").append(TestValuesTableFactory.TestSinkContextTableSink.class.getName()).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sourceDDL);
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql("INSERT INTO sink SELECT * FROM src").await();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1000, 2000, 3000, 4000, 7000, 8000, 16000}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.Int$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.TestSinkContextTableSink.ROWTIMES).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
        String sinkDDL2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n         |CREATE TABLE sink2 (\n         |  window_rowtime TIMESTAMP(3),\n         |  b DOUBLE\n         |) WITH (\n         |  'connector' = 'values',\n         |  'table-sink-class' = '").append(TestValuesTableFactory.TestSinkContextTableSink.class.getName()).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sinkDDL2);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink2\n        |SELECT\n        |  TUMBLE_ROWTIME(ts, INTERVAL '5' SECOND),\n        |  SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '5' SECOND)\n        |")).stripMargin()).await();
        List expected2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4999, 9999, 19999}));
        Assert.assertEquals((Object)expected2.sorted((Ordering)Ordering.Int$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.TestSinkContextTableSink.ROWTIMES).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
    }

    @Test
    public void testFromTableToAppendStreamWithProctime() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(1L), "A"})), (List)Nil$.MODULE$);
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n         |CREATE TABLE src (\n         |  ts TIMESTAMP(3),\n         |  a STRING,\n         |  proctime as PROCTIME()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sourceDDL);
        DataStream dataStream = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT a, ts, proctime FROM src")).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        String expected = "Row(a: String, ts: LocalDateTime, proctime: Instant)";
        Assert.assertEquals((Object)expected, (Object)dataStream.dataType().toString());
    }

    @Test
    public void testHasFromDataStreamToTableBackDataStreamWithProctime() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"A")}));
        DataStream ds1 = this.env().fromCollection(data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.TableToDataStreamITCase$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)TableToDataStreamITCase.$anonfun$testHasFromDataStreamToTableBackDataStreamWithProctime$1(x$2)));
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        this.tEnv().registerTable("t1", table);
        DataStream ds2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT CONCAT(a, '_'), ts, proctime\n        | FROM t1\n      ")).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        String expected = "Row(EXPR$0: String, ts: Long, proctime: Instant)";
        Assert.assertEquals((Object)expected, (Object)ds2.dataType().toString());
    }

    private LocalDateTime localDateTime(long epochSecond) {
        return LocalDateTime.ofEpochSecond(epochSecond, 0, ZoneOffset.UTC);
    }

    public static final /* synthetic */ long $anonfun$testHasRowtimeFromDataStreamToTableBackDataStream$1(Tuple2 x$1) {
        return x$1._1$mcJ$sp() * 1000L;
    }

    public static final /* synthetic */ long $anonfun$testHasFromDataStreamToTableBackDataStreamWithProctime$1(Tuple2 x$2) {
        return x$2._1$mcJ$sp() * 1000L;
    }
}

