/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

public abstract class JsonPlanTestBase
extends AbstractTestBase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    protected TableEnvironmentInternal tableEnv;

    @Before
    public void setup() throws Exception {
        this.tableEnv = (TableEnvironmentInternal)TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
    }

    @After
    public void after() {
        TestValuesTableFactory.clearAllData();
    }

    protected TableResult executeSqlWithJsonPlanVerified(String sql) {
        return this.tableEnv.executeJsonPlan(this.tableEnv.getJsonPlan(sql));
    }

    protected void createTestValuesSourceTable(String tableName, List<Row> data, String ... fieldNameAndTypes) {
        this.createTestValuesSourceTable(tableName, data, fieldNameAndTypes, new HashMap<String, String>());
    }

    protected void createTestValuesSourceTable(String tableName, List<Row> data, String[] fieldNameAndTypes, Map<String, String> extraProperties) {
        this.createTestValuesSourceTable(tableName, data, fieldNameAndTypes, null, extraProperties);
    }

    protected void createTestValuesSourceTable(String tableName, List<Row> data, String[] fieldNameAndTypes, @Nullable String partitionFields, Map<String, String> extraProperties) {
        Preconditions.checkArgument((fieldNameAndTypes.length > 0 ? 1 : 0) != 0);
        String partitionedBy = StringUtils.isNullOrWhitespaceOnly((String)partitionFields) ? "" : "\n partitioned by (" + partitionFields + ") \n";
        String dataId = TestValuesTableFactory.registerData(data);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connector", "values");
        properties.put("data-id", dataId);
        properties.put("bounded", "true");
        properties.put("disable-lookup", "true");
        properties.putAll(extraProperties);
        String ddl = String.format("CREATE TABLE %s (\n%s\n) %s with (\n%s)", tableName, String.join((CharSequence)",\n", fieldNameAndTypes), partitionedBy, properties.entrySet().stream().map(e -> String.format("'%s'='%s'", e.getKey(), e.getValue())).collect(Collectors.joining(",\n")));
        this.tableEnv.executeSql(ddl);
    }

    protected void createTestValuesSinkTable(String tableName, String ... fieldNameAndTypes) {
        this.createTestValuesSinkTable(tableName, fieldNameAndTypes, new HashMap<String, String>());
    }

    protected void createTestNonInsertOnlyValuesSinkTable(String tableName, String ... fieldNameAndTypes) {
        this.createTestValuesSinkTable(tableName, fieldNameAndTypes, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("sink-insert-only", "false");
            }
        });
    }

    protected void createTestValuesSinkTable(String tableName, String[] fieldNameAndTypes, Map<String, String> extraProperties) {
        this.createTestValuesSinkTable(tableName, fieldNameAndTypes, null, extraProperties);
    }

    protected void createTestValuesSinkTable(String tableName, String[] fieldNameAndTypes, @Nullable String partitionFields, Map<String, String> extraProperties) {
        Preconditions.checkArgument((fieldNameAndTypes.length > 0 ? 1 : 0) != 0);
        String partitionedBy = StringUtils.isNullOrWhitespaceOnly((String)partitionFields) ? "" : "\n partitioned by (" + partitionFields + ") \n";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connector", "values");
        properties.putAll(extraProperties);
        String ddl = String.format("CREATE TABLE %s (\n%s\n) %s with (\n%s)", tableName, String.join((CharSequence)",\n", fieldNameAndTypes), partitionedBy, properties.entrySet().stream().map(e -> String.format("'%s'='%s'", e.getKey(), e.getValue())).collect(Collectors.joining(",\n")));
        this.tableEnv.executeSql(ddl);
    }

    protected void createTestCsvSourceTable(String tableName, List<String> data, String ... fieldNameAndTypes) throws IOException {
        Preconditions.checkArgument((fieldNameAndTypes.length > 0 ? 1 : 0) != 0);
        File sourceFile = TEMPORARY_FOLDER.newFile();
        Collections.shuffle(data);
        Files.write(sourceFile.toPath(), String.join((CharSequence)"\n", data).getBytes(), new OpenOption[0]);
        String ddl = String.format("CREATE TABLE %s (\n%s\n) with (\n  'connector' = 'filesystem',\n  'path' = '%s',\n  'format' = 'testcsv')", tableName, String.join((CharSequence)",\n", fieldNameAndTypes), sourceFile.getAbsolutePath());
        this.tableEnv.executeSql(ddl);
    }

    protected File createTestCsvSinkTable(String tableName, String ... fieldNameAndTypes) throws IOException {
        return this.createTestCsvSinkTable(tableName, fieldNameAndTypes, (String)null);
    }

    protected File createTestCsvSinkTable(String tableName, String[] fieldNameAndTypes, @Nullable String partitionFields) throws IOException {
        Preconditions.checkArgument((fieldNameAndTypes.length > 0 ? 1 : 0) != 0);
        String partitionedBy = StringUtils.isNullOrWhitespaceOnly((String)partitionFields) ? "" : "\n partitioned by (" + partitionFields + ") \n";
        File sinkPath = TEMPORARY_FOLDER.newFolder();
        String ddl = String.format("CREATE TABLE %s (\n%s\n) %s with (\n  'connector' = 'filesystem',\n  'path' = '%s',\n  'format' = 'testcsv')", tableName, String.join((CharSequence)",\n", fieldNameAndTypes), partitionedBy, sinkPath.getAbsolutePath());
        this.tableEnv.executeSql(ddl);
        return sinkPath;
    }

    protected void assertResult(List<String> expected, File resultFile) throws IOException {
        List<String> actual = this.readLines(resultFile);
        this.assertResult(expected, actual);
    }

    protected void assertResult(List<String> expected, List<String> actual) {
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, actual);
    }

    protected List<String> readLines(File path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : (File[])Preconditions.checkNotNull((Object)path.listFiles())) {
            if (file.isHidden()) continue;
            if (file.isFile()) {
                String value = new String(Files.readAllBytes(file.toPath()));
                result.addAll(Arrays.asList(value.split("\n")));
                continue;
            }
            result.addAll(this.readLines(file));
        }
        return result;
    }
}

