/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.graph.GlobalStreamExchangeMode;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.utils.StreamExchangeModeUtils;
import org.junit.Assert;
import org.junit.Test;

public class StreamExchangeModeUtilsTest {
    @Test
    public void testBatchStreamExchangeMode() {
        Configuration configuration = new Configuration();
        Assert.assertEquals((Object)StreamExchangeMode.BATCH, (Object)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null));
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_BLOCKING);
        Assert.assertEquals((Object)StreamExchangeMode.BATCH, (Object)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null));
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_PIPELINED);
        Assert.assertEquals((Object)StreamExchangeMode.UNDEFINED, (Object)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null));
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_PIPELINED);
        Assert.assertEquals((Object)StreamExchangeMode.BATCH, (Object)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, (StreamExchangeMode)StreamExchangeMode.BATCH));
    }

    @Test
    public void testBatchStreamExchangeModeLegacyPrecedence() {
        Configuration configuration = new Configuration();
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_PIPELINED);
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, GlobalStreamExchangeMode.ALL_EDGES_BLOCKING.toString());
        Assert.assertEquals((Object)StreamExchangeMode.BATCH, (Object)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null));
    }

    @Test
    public void testLegacyShuffleMode() {
        Configuration configuration = new Configuration();
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, GlobalStreamExchangeMode.ALL_EDGES_BLOCKING.toString());
        Assert.assertEquals((Object)GlobalStreamExchangeMode.ALL_EDGES_BLOCKING, StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, GlobalStreamExchangeMode.FORWARD_EDGES_PIPELINED.toString());
        Assert.assertEquals((Object)GlobalStreamExchangeMode.FORWARD_EDGES_PIPELINED, StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, GlobalStreamExchangeMode.POINTWISE_EDGES_PIPELINED.toString());
        Assert.assertEquals((Object)GlobalStreamExchangeMode.POINTWISE_EDGES_PIPELINED, StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, GlobalStreamExchangeMode.ALL_EDGES_PIPELINED.toString());
        Assert.assertEquals((Object)GlobalStreamExchangeMode.ALL_EDGES_PIPELINED, StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, "batch");
        Assert.assertEquals((Object)GlobalStreamExchangeMode.ALL_EDGES_BLOCKING, StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, "pipelined");
        Assert.assertEquals((Object)GlobalStreamExchangeMode.ALL_EDGES_PIPELINED, StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, "Forward_edges_PIPELINED");
        Assert.assertEquals((Object)GlobalStreamExchangeMode.FORWARD_EDGES_PIPELINED, StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLegacyShuffleMode() {
        Configuration configuration = new Configuration();
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, "invalid-value");
        StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration);
    }
}

