/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.operations.DataStreamQueryOperation;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction0;

public final class TableTestUtil$ {
    public static TableTestUtil$ MODULE$;
    private final EnvironmentSettings STREAM_SETTING;
    private final EnvironmentSettings BATCH_SETTING;

    static {
        new TableTestUtil$();
    }

    public Option<CatalogManager> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public EnvironmentSettings STREAM_SETTING() {
        return this.STREAM_SETTING;
    }

    public EnvironmentSettings BATCH_SETTING() {
        return this.BATCH_SETTING;
    }

    public RelNode toRelNode(Table table) {
        return ((PlannerBase)((TableEnvironmentImpl)((TableImpl)table).getTableEnvironment()).getPlanner()).getRelBuilder().queryOperation(table.getQueryOperation()).build();
    }

    public <T> void createTemporaryView(TableEnvironment tEnv, String name, DataStream<T> dataStream, Option<Expression[]> fields, Option<boolean[]> fieldNullables, Option<FlinkStatistic> statistic) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
        StreamExecutionEnvironment execEnv = planner.getExecEnv();
        TypeInformation streamType = dataStream.getType();
        FieldInfoUtils.TypeInfoSchema typeInfoSchema = (FieldInfoUtils.TypeInfoSchema)fields.map((Function1 & Serializable & scala.Serializable)f -> {
            void var3_3;
            FieldInfoUtils.TypeInfoSchema fieldsInfo = FieldInfoUtils.getFieldsInfo((TypeInformation)streamType, (Expression[])f);
            if (fieldsInfo.isRowtimeDefined() && execEnv.getStreamTimeCharacteristic() != TimeCharacteristic.EventTime) {
                throw new ValidationException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s", execEnv.getStreamTimeCharacteristic()));
            }
            return var3_3;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> FieldInfoUtils.getFieldsInfo((TypeInformation)streamType));
        int fieldCnt = typeInfoSchema.getFieldTypes().length;
        DataStreamQueryOperation dataStreamQueryOperation = new DataStreamQueryOperation(ObjectIdentifier.of((String)tEnv.getCurrentCatalog(), (String)tEnv.getCurrentDatabase(), (String)name), dataStream, typeInfoSchema.getIndices(), typeInfoSchema.toResolvedSchema(), (boolean[])fieldNullables.getOrElse((Function0 & Serializable & scala.Serializable)() -> (boolean[])Array$.MODULE$.fill(fieldCnt, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, ClassTag$.MODULE$.Boolean())), (FlinkStatistic)statistic.getOrElse((Function0 & Serializable & scala.Serializable)() -> FlinkStatistic$.MODULE$.UNKNOWN()));
        Table table = this.createTable(tEnv, (QueryOperation)dataStreamQueryOperation);
        tEnv.registerTable(name, table);
    }

    public <T> Option<Expression[]> createTemporaryView$default$4() {
        return None$.MODULE$;
    }

    public <T> Option<boolean[]> createTemporaryView$default$5() {
        return None$.MODULE$;
    }

    public <T> Option<FlinkStatistic> createTemporaryView$default$6() {
        return None$.MODULE$;
    }

    public Table createTable(TableEnvironment tEnv, QueryOperation queryOperation) {
        Method method;
        TableEnvironment tableEnvironment = tEnv;
        boolean bl = tableEnvironment instanceof StreamTableEnvironmentImpl ? true : tableEnvironment instanceof org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
        if (bl) {
            method = tEnv.getClass().getSuperclass().getDeclaredMethod("createTable", QueryOperation.class);
        } else if (tableEnvironment instanceof TableEnvironmentImpl) {
            TableEnvironmentImpl tableEnvironmentImpl = (TableEnvironmentImpl)tableEnvironment;
            method = tableEnvironmentImpl.getClass().getDeclaredMethod("createTable", QueryOperation.class);
        } else {
            throw new TableException(new StringBuilder(19).append("Unsupported class: ").append(tEnv.getClass().getCanonicalName()).toString());
        }
        Method createTableMethod = method;
        createTableMethod.setAccessible(true);
        return (Table)createTableMethod.invoke((Object)tEnv, queryOperation);
    }

    public String readFromResource(String path) {
        String basePath = this.getClass().getResource("/").getFile();
        String fullPath = path.startsWith("/") ? new StringBuilder(0).append(basePath).append(path.substring(1)).toString() : new StringBuilder(0).append(basePath).append(path).toString();
        BufferedSource source = Source$.MODULE$.fromFile(fullPath, Codec$.MODULE$.fallbackSystemCodec());
        String str = source.mkString();
        source.close();
        return str;
    }

    public Seq<String> readFromFile(String path) {
        File file = new File(path);
        return file.isDirectory() ? (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).foldLeft((Object)Seq$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(lines, p) -> (Seq)lines.$plus$plus(MODULE$.readFromFile(p.getAbsolutePath()), Seq$.MODULE$.canBuildFrom())) : (file.isHidden() ? (Seq)Seq$.MODULE$.empty() : JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(Files.readAllLines(Paths.get(file.toURI()))).toSeq());
    }

    public String getFormattedJson(String json) throws IOException {
        JsonParser parser = new ObjectMapper().getFactory().createParser(json);
        JsonNode jsonNode = (JsonNode)parser.readValueAsTree();
        return jsonNode.toString();
    }

    public String getPrettyJson(String json) throws IOException {
        JsonParser parser = new ObjectMapper().getFactory().createParser(json);
        JsonNode jsonNode = (JsonNode)parser.readValueAsTree();
        return jsonNode.toPrettyString();
    }

    public String replaceStageId(String s) {
        return s.replaceAll("\\r\\n", "\n").replaceAll("Stage \\d+", "");
    }

    public String replaceStreamNodeId(String s) {
        return s.replaceAll("\"id\" : \\d+", "\"id\" : ").trim();
    }

    public String replaceExecNodeId(String s) {
        return s.replaceAll("\"id\"\\s*:\\s*\\d+", "\"id\": 0").replaceAll("\"source\"\\s*:\\s*\\d+", "\"source\": 0").replaceAll("\"target\"\\s*:\\s*\\d+", "\"target\": 0");
    }

    public String replaceFlinkVersion(String s) {
        return s.replaceAll("\"flinkVersion\":\"[\\w.-]*\"", "\"flinkVersion\":\"\"");
    }

    private TableTestUtil$() {
        MODULE$ = this;
        this.STREAM_SETTING = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.BATCH_SETTING = EnvironmentSettings.newInstance().inBatchMode().build();
    }
}

