/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.descriptors.Schema;
import org.apache.flink.table.sinks.CsvBatchTableSinkFactory;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;

public final class TestTableSourceSinks$ {
    public static TestTableSourceSinks$ MODULE$;
    private String getPersonCsvPath;
    private String getOrdersCsvPath;
    private String getRatesCsvPath;
    private volatile byte bitmap$0;

    static {
        new TestTableSourceSinks$();
    }

    public void createPersonCsvTemporaryTable(TableEnvironment tEnv, String tableName) {
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(467).append("\n         |CREATE TEMPORARY TABLE ").append(tableName).append(" (\n         |  first STRING,\n         |  id INT,\n         |  score DOUBLE,\n         |  last STRING\n         |) WITH (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(this.getPersonCsvPath()).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = '#',\n         |  'format.line-delimiter' = '$',\n         |  'format.ignore-first-line' = 'true',\n         |  'format.comment-prefix' = '%'\n         |)\n         |").toString())).stripMargin());
    }

    public void createOrdersCsvTemporaryTable(TableEnvironment tEnv, String tableName) {
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(345).append("\n        |CREATE TEMPORARY TABLE ").append(tableName).append(" (\n        |  amount BIGINT,\n        |  currency STRING,\n        |  ts BIGINT\n        |) WITH (\n        |  'connector.type' = 'filesystem',\n        |  'connector.path' = '").append(this.getOrdersCsvPath()).append("',\n        |  'format.type' = 'csv',\n        |  'format.field-delimiter' = ',',\n        |  'format.line-delimiter' = '$'\n        |)\n        |").toString())).stripMargin());
    }

    public void createRatesCsvTemporaryTable(TableEnvironment tEnv, String tableName) {
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n        |CREATE TEMPORARY TABLE ").append(tableName).append(" (\n        |  currency STRING,\n        |  rate BIGINT\n        |) WITH (\n        |  'connector.type' = 'filesystem',\n        |  'connector.path' = '").append(this.getRatesCsvPath()).append("',\n        |  'format.type' = 'csv',\n        |  'format.field-delimiter' = ',',\n        |  'format.line-delimiter' = '$'\n        |)\n        |").toString())).stripMargin());
    }

    public String createCsvTemporarySinkTable(TableEnvironment tEnv, TableSchema schema, String tableName, int numFiles) {
        File tempFile = File.createTempFile("csv-test", null);
        tempFile.deleteOnExit();
        String path = tempFile.getAbsolutePath();
        Map sinkOptions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connector.type"), (Object)"filesystem"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connector.path"), (Object)path), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format.type"), (Object)"csv"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format.write-mode"), (Object)"OVERWRITE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format.num-files"), (Object)((Object)BoxesRunTime.boxToInteger((int)numFiles)).toString())}));
        JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap(sinkOptions).putAll(new Schema().schema(schema).toProperties());
        StreamTableSink sink = new CsvBatchTableSinkFactory().createStreamTableSink(JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap(sinkOptions));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal(tableName, (TableSink)sink);
        return path;
    }

    public int createCsvTemporarySinkTable$default$4() {
        return 1;
    }

    private String getPersonCsvPath$lzycompute() {
        TestTableSourceSinks$ testTableSourceSinks$ = this;
        synchronized (testTableSourceSinks$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"First#Id#Score#Last", "Mike#1#12.3#Smith", "Bob#2#45.6#Taylor", "Sam#3#7.89#Miller", "Peter#4#0.12#Smith", "% Just a comment", "Liz#5#34.5#Williams", "Sally#6#6.78#Miller", "Alice#7#90.1#Smith", "Kelly#8#2.34#Williams"}));
                this.getPersonCsvPath = this.writeToTempFile(csvRecords.mkString("$"), "csv-test", "tmp", this.writeToTempFile$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.getPersonCsvPath;
    }

    public String getPersonCsvPath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.getPersonCsvPath$lzycompute() : this.getPersonCsvPath;
    }

    private String getOrdersCsvPath$lzycompute() {
        TestTableSourceSinks$ testTableSourceSinks$ = this;
        synchronized (testTableSourceSinks$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,Euro,2", "1,US Dollar,3", "50,Yen,4", "3,Euro,5", "5,US Dollar,6"}));
                this.getOrdersCsvPath = this.writeToTempFile(csvRecords.mkString("$"), "csv-order-test", "tmp", this.writeToTempFile$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.getOrdersCsvPath;
    }

    public String getOrdersCsvPath() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.getOrdersCsvPath$lzycompute() : this.getOrdersCsvPath;
    }

    private String getRatesCsvPath$lzycompute() {
        TestTableSourceSinks$ testTableSourceSinks$ = this;
        synchronized (testTableSourceSinks$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"US Dollar,102", "Yen,1", "Euro,119", "RMB,702"}));
                this.getRatesCsvPath = this.writeToTempFile(csvRecords.mkString("$"), "csv-rate-test", "tmp", this.writeToTempFile$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.getRatesCsvPath;
    }

    public String getRatesCsvPath() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.getRatesCsvPath$lzycompute() : this.getRatesCsvPath;
    }

    private String writeToTempFile(String contents, String filePrefix, String fileSuffix, String charset) {
        File tempFile = File.createTempFile(filePrefix, fileSuffix);
        tempFile.deleteOnExit();
        OutputStreamWriter tmpWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), charset);
        tmpWriter.write(contents);
        tmpWriter.close();
        return tempFile.getAbsolutePath();
    }

    private String writeToTempFile$default$4() {
        return "UTF-8";
    }

    private TestTableSourceSinks$() {
        MODULE$ = this;
    }
}

