/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u001f\t\u0019B+Z:uS:<7\u000b^1uK6,g\u000e^*fi*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001\u0002\u0004\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!A.\u00198h\u0015\u0005)\u0012\u0001\u00026bm\u0006L!a\u0006\n\u0003\r=\u0013'.Z2u!\tIB$D\u0001\u001b\u0015\tYb!A\u0002ba&L!!\b\u000e\u0003\u0019M#\u0018\r^3nK:$8+\u001a;\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\nA\u0001^#omB\u0011\u0011EI\u0007\u0002\u0005%\u00111E\u0001\u0002\u0018)\u0016\u001cH/\u001b8h)\u0006\u0014G.Z#om&\u0014xN\\7f]RDQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDCA\u0014)!\t\t\u0003\u0001C\u0003 I\u0001\u0007\u0001\u0005C\u0004+\u0001\t\u0007I\u0011B\u0016\u0002\u0015=\u0004XM]1uS>t7/F\u0001-!\ri\u0003GM\u0007\u0002])\u0011q\u0006F\u0001\u0005kRLG.\u0003\u00022]\t!A*[:u!\t\u0019T'D\u00015\u0015\tQc!\u0003\u00027i\tyQj\u001c3jMf|\u0005/\u001a:bi&|g\u000e\u0003\u00049\u0001\u0001\u0006I\u0001L\u0001\f_B,'/\u0019;j_:\u001c\b\u0005C\u0003;\u0001\u0011\u00051&A\u0007hKR|\u0005/\u001a:bi&|gn\u001d\u0005\u0006y\u0001!\t%P\u0001\rC\u0012$\u0017J\\:feR\u001c\u0016\u000f\u001c\u000b\u00031yBQaP\u001eA\u0002\u0001\u000b\u0011b\u001d;bi\u0016lWM\u001c;\u0011\u0005\u0005SeB\u0001\"I!\t\u0019e)D\u0001E\u0015\t)e\"\u0001\u0004=e>|GO\u0010\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011JR\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002J\r\")a\n\u0001C!\u001f\u0006I\u0011\r\u001a3J]N,'\u000f\u001e\u000b\u00041A\u0013\u0006\"B)N\u0001\u0004\u0001\u0015A\u0003;be\u001e,G\u000fU1uQ\")q!\u0014a\u0001'B\u0011\u0011\u0004V\u0005\u0003+j\u0011Q\u0001V1cY\u0016DQA\u0014\u0001\u0005B]#B\u0001\u0007-Z5\")\u0011K\u0016a\u0001\u0001\")qA\u0016a\u0001'\")1L\u0016a\u00019\u0006IqN^3soJLG/\u001a\t\u0003;zk\u0011AR\u0005\u0003?\u001a\u0013qAQ8pY\u0016\fg\u000eC\u0003O\u0001\u0011\u0005\u0013\rF\u0002\u0019E\u001eDQa\u00191A\u0002\u0011\f!\u0002Z3tGJL\u0007\u000f^8s!\tIR-\u0003\u0002g5\tyA+\u00192mK\u0012+7o\u0019:jaR|'\u000fC\u0003\bA\u0002\u00071\u000bC\u0003O\u0001\u0011\u0005\u0013\u000e\u0006\u0003\u0019U2l\u0007\"B6i\u0001\u0004!\u0017\u0001\u0005;be\u001e,G\u000fR3tGJL\u0007\u000f^8s\u0011\u00159\u0001\u000e1\u0001T\u0011\u0015Y\u0006\u000e1\u0001]\u0011\u0015y\u0007\u0001\"\u0011q\u0003\u001d)\u0007\u0010\u001d7bS:$\"\u0001Q9\t\u000bIt\u0007\u0019A:\u0002\u0019\u0015DHO]1EKR\f\u0017\u000e\\:\u0011\u0007u#h/\u0003\u0002v\r\nQAH]3qK\u0006$X\r\u001a \u0011\u0005e9\u0018B\u0001=\u001b\u00055)\u0005\u0010\u001d7bS:$U\r^1jY\")!\u0010\u0001C!w\u00069Q\r_3dkR,G#\u0001?\u0011\u0005ei\u0018B\u0001@\u001b\u0005-!\u0016M\u00197f%\u0016\u001cX\u000f\u001c;")
public class TestingStatementSet
implements StatementSet {
    private final TestingTableEnvironment tEnv;
    private final List<ModifyOperation> operations;

    private List<ModifyOperation> operations() {
        return this.operations;
    }

    public List<ModifyOperation> getOperations() {
        return this.operations();
    }

    public StatementSet addInsertSql(String statement) {
        List operations = this.tEnv.getParser().parse(statement);
        if (operations.size() != 1) {
            throw new TableException("Only single statement is supported.");
        }
        Operation operation = (Operation)operations.get(0);
        if (!(operation instanceof ModifyOperation)) {
            throw new TableException("Only insert statement is supported now.");
        }
        ModifyOperation modifyOperation = (ModifyOperation)operation;
        boolean bl = this.operations().add(modifyOperation);
        return this;
    }

    public StatementSet addInsert(String targetPath, Table table) {
        return this.addInsert(targetPath, table, false);
    }

    public StatementSet addInsert(String targetPath, Table table, boolean overwrite) {
        UnresolvedIdentifier unresolvedIdentifier = this.tEnv.getParser().parseIdentifier(targetPath);
        ObjectIdentifier objectIdentifier = this.tEnv.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        this.operations().add((ModifyOperation)new CatalogSinkModifyOperation(objectIdentifier, table.getQueryOperation(), Collections.emptyMap(), overwrite, Collections.emptyMap()));
        return this;
    }

    public StatementSet addInsert(TableDescriptor descriptor, Table table) {
        throw new TableException("Not implemented");
    }

    public StatementSet addInsert(TableDescriptor targetDescriptor, Table table, boolean overwrite) {
        throw new TableException("Not implemented");
    }

    public String explain(Seq<ExplainDetail> extraDetails) {
        return this.tEnv.explainInternal(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.operations()).map((Function1 & Serializable & scala.Serializable)o -> o, Buffer$.MODULE$.canBuildFrom())), (ExplainDetail[])extraDetails.toArray(ClassTag$.MODULE$.apply(ExplainDetail.class)));
    }

    public TableResult execute() {
        TableResult tableResult;
        try {
            tableResult = this.tEnv.executeInternal(this.operations());
        }
        finally {
            this.operations().clear();
        }
        return tableResult;
    }

    public String explain(ExplainDetail[] extraDetails) {
        return this.explain((Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public TestingStatementSet(TestingTableEnvironment tEnv) {
        this.tEnv = tEnv;
        this.operations = new ArrayList<ModifyOperation>();
    }
}

