/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import scala.None$;
import scala.Option;
import scala.Some;

public final class TestingTableEnvironment$ {
    public static TestingTableEnvironment$ MODULE$;

    static {
        new TestingTableEnvironment$();
    }

    public TestingTableEnvironment create(EnvironmentSettings settings, Option<CatalogManager> catalogManager, TableConfig tableConfig) {
        CatalogManager catalogManager2;
        tableConfig.addConfiguration(settings.toConfiguration());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ModuleManager moduleManager = new ModuleManager();
        Option<CatalogManager> option = catalogManager;
        if (option instanceof Some) {
            CatalogManager c;
            Some some = (Some)option;
            catalogManager2 = c = (CatalogManager)some.value();
        } else {
            catalogManager2 = CatalogManager.newBuilder().classLoader(classLoader).config((ReadableConfig)tableConfig.getConfiguration()).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).build();
        }
        CatalogManager catalogMgr = catalogManager2;
        FunctionCatalog functionCatalog = new FunctionCatalog(tableConfig, catalogMgr, moduleManager);
        ExecutorFactory executorFactory = (ExecutorFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, ExecutorFactory.class, (String)settings.getExecutor());
        Executor executor = executorFactory.create(tableConfig.getConfiguration());
        PlannerBase planner = (PlannerBase)PlannerFactoryUtil.createPlanner((String)settings.getPlanner(), (Executor)executor, (TableConfig)tableConfig, (CatalogManager)catalogMgr, (FunctionCatalog)functionCatalog);
        return new TestingTableEnvironment(catalogMgr, moduleManager, tableConfig, executor, functionCatalog, planner, settings.isStreamingMode(), classLoader);
    }

    public Option<CatalogManager> create$default$2() {
        return None$.MODULE$;
    }

    private TestingTableEnvironment$() {
        MODULE$ = this;
    }
}

